/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.xlc.core;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.cdt.core.language.settings.providers.ILanguageSettingsEditableProvider;
import org.eclipse.cdt.managedbuilder.language.settings.providers.AbstractLanguageSettingsOutputScanner;
import org.eclipse.cdt.managedbuilder.language.settings.providers.ToolchainBuiltinSpecsDetector;

public class XlcBuiltinSpecsDetector
extends ToolchainBuiltinSpecsDetector
implements ILanguageSettingsEditableProvider {
    private static final String XLC_TOOLCHAIN_ID = "cdt.managedbuild.toolchain.xlc.exe.debug";
    private static final Pattern OPTIONS_PATTERN = Pattern.compile("-[^\\s\"']*(\\s*((\".*?\")|('.*?')|([^-\\s][^\\s]+)))?");
    private static final int OPTION_GROUP = 0;
    private static final AbstractLanguageSettingsOutputScanner.AbstractOptionParser[] optionParsers = new AbstractLanguageSettingsOutputScanner.AbstractOptionParser[]{new AbstractLanguageSettingsOutputScanner.IncludePathOptionParser("-I\\s*([\"'])(.*)\\1", "$2", 7), new AbstractLanguageSettingsOutputScanner.IncludePathOptionParser("-I\\s*([^\\s\"']*)", "$1", 3), new AbstractLanguageSettingsOutputScanner.IncludePathOptionParser("-qc\\+\\+=\\s*([^\\s\"']*)", "$1", 3), new AbstractLanguageSettingsOutputScanner.MacroOptionParser("-D\\s*([\"'])([^=]*)(=(.*))?\\1", "$2", "$4", 3), new AbstractLanguageSettingsOutputScanner.MacroOptionParser("-D\\s*([^\\s=\"']*)=(\\\\([\"']))(.*?)\\2", "$1", "$3$4$3", 3), new AbstractLanguageSettingsOutputScanner.MacroOptionParser("-D\\s*([^\\s=\"']*)=([\"'])(.*?)\\2", "$1", "$3", 3), new AbstractLanguageSettingsOutputScanner.MacroOptionParser("-D\\s*([^\\s=\"']*)(=([^\\s\"']*))?", "$1", "$3", 3)};

    protected String getToolchainId() {
        return XLC_TOOLCHAIN_ID;
    }

    protected AbstractLanguageSettingsOutputScanner.AbstractOptionParser[] getOptionParsers() {
        return optionParsers;
    }

    protected List<String> parseOptions(String line) {
        ArrayList<String> options = new ArrayList<String>();
        Matcher optionMatcher = OPTIONS_PATTERN.matcher(line);
        while (optionMatcher.find()) {
            String option = optionMatcher.group(0);
            if (option == null) continue;
            options.add(option);
        }
        return options;
    }

    public XlcBuiltinSpecsDetector cloneShallow() throws CloneNotSupportedException {
        return (XlcBuiltinSpecsDetector)super.cloneShallow();
    }

    public XlcBuiltinSpecsDetector clone() throws CloneNotSupportedException {
        return (XlcBuiltinSpecsDetector)super.clone();
    }
}

