/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.text;

import org.eclipse.cdt.core.formatter.DefaultCodeFormatterConstants;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.internal.corext.util.CodeFormatterUtil;
import org.eclipse.cdt.internal.ui.text.CHeuristicScanner;
import org.eclipse.cdt.internal.ui.text.DocumentCharacterIterator;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.DefaultScope;
import org.eclipse.core.runtime.preferences.IPreferencesService;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;

public final class CIndenter {
    private final IDocument fDocument;
    private int fIndent;
    private int fExtraSpaces;
    private int fAlign;
    private int fPosition;
    private int fPreviousPos;
    private int fToken;
    private int fLine;
    private final CHeuristicScanner fScanner;
    private final CorePrefs fPrefs;

    public CIndenter(IDocument document, CHeuristicScanner scanner) {
        this(document, scanner, null);
    }

    public CIndenter(IDocument document, CHeuristicScanner scanner, ICProject project) {
        Assert.isNotNull((Object)document);
        Assert.isNotNull((Object)scanner);
        this.fDocument = document;
        this.fScanner = scanner;
        this.fPrefs = new CorePrefs(project);
    }

    public StringBuilder getReferenceIndentation(int offset) {
        return this.getReferenceIndentation(offset, false);
    }

    private StringBuilder getReferenceIndentation(int offset, boolean assumeOpeningBrace) {
        int unit = this.findReferencePosition(offset, assumeOpeningBrace ? 1 : this.peekToken(offset));
        if (unit == -1) {
            return null;
        }
        return this.getLeadingWhitespace(unit);
    }

    public StringBuilder computeIndentation(int offset) {
        return this.computeIndentation(offset, false);
    }

    public StringBuilder computeIndentation(int offset, boolean assumeOpeningBrace) {
        StringBuilder reference = this.getReferenceIndentation(offset, assumeOpeningBrace);
        if (this.fAlign != -1) {
            try {
                IRegion line = this.fDocument.getLineInformationOfOffset(this.fAlign);
                int lineOffset = line.getOffset();
                return this.createIndent(lineOffset, this.fAlign, false);
            }
            catch (BadLocationException badLocationException) {
                return null;
            }
        }
        if (reference == null) {
            return null;
        }
        return this.createReusingIndent(reference, this.fIndent, this.fExtraSpaces);
    }

    public StringBuilder computeContinuationLineIndentation(int offset) throws BadLocationException {
        StringBuilder reference = this.getLeadingWhitespace(offset);
        IRegion line = this.fDocument.getLineInformationOfOffset(offset);
        String string = this.fDocument.get(line.getOffset(), offset - line.getOffset());
        if (string.trim().isEmpty()) {
            return reference;
        }
        return this.createReusingIndent(reference, this.fPrefs.prefContinuationIndent, 0);
    }

    private int computeVisualLength(CharSequence indent) {
        int tabSize = this.fPrefs.prefTabSize;
        int length = 0;
        int i = 0;
        while (i < indent.length()) {
            char ch = indent.charAt(i);
            switch (ch) {
                case '\t': {
                    if (tabSize <= 0) break;
                    int reminder = length % tabSize;
                    length += tabSize - reminder;
                    break;
                }
                case ' ': {
                    ++length;
                }
            }
            ++i;
        }
        return length;
    }

    private StringBuilder stripExceedingChars(StringBuilder reference, int indentLength) {
        int tabSize = this.fPrefs.prefTabSize;
        int measured = 0;
        int chars = reference.length();
        int i = 0;
        while (measured < indentLength && i < chars) {
            char ch = reference.charAt(i);
            switch (ch) {
                case '\t': {
                    if (tabSize <= 0) break;
                    int reminder = measured % tabSize;
                    measured += tabSize - reminder;
                    break;
                }
                case ' ': {
                    ++measured;
                }
            }
            ++i;
        }
        int deleteFrom = measured > indentLength ? i - 1 : i;
        return reference.delete(deleteFrom, chars);
    }

    private StringBuilder getLeadingWhitespace(int offset) {
        StringBuilder indent = new StringBuilder();
        try {
            IRegion line = this.fDocument.getLineInformationOfOffset(offset);
            int lineOffset = line.getOffset();
            int nonWS = this.fScanner.findNonWhitespaceForwardInAnyPartition(lineOffset, lineOffset + line.getLength());
            indent.append(this.fDocument.get(lineOffset, nonWS - lineOffset));
            return indent;
        }
        catch (BadLocationException badLocationException) {
            return indent;
        }
    }

    private StringBuilder createIndent(int start, int indent, boolean convertSpaceRunsToTabs) {
        boolean convertTabs = this.fPrefs.prefUseTabs && convertSpaceRunsToTabs;
        int tabLen = this.fPrefs.prefTabSize;
        StringBuilder ret = new StringBuilder();
        try {
            int spaces = 0;
            while (start < indent) {
                char ch = this.fDocument.getChar(start);
                if (ch == '\t') {
                    ret.append('\t');
                    spaces = 0;
                } else if (convertTabs) {
                    if (++spaces == tabLen) {
                        ret.append('\t');
                        spaces = 0;
                    }
                } else {
                    ret.append(' ');
                }
                ++start;
            }
            while (spaces-- > 0) {
                ret.append(' ');
            }
        }
        catch (BadLocationException badLocationException) {}
        return ret;
    }

    public StringBuilder createReusingIndent(StringBuilder buffer, int additional, int extraSpaces) {
        int spaces;
        int tabs;
        int refLength = this.computeVisualLength(buffer);
        int addLength = this.fPrefs.prefIndentationSize * additional + extraSpaces;
        int totalLength = Math.max(0, refLength + addLength);
        int minLength = Math.min(totalLength, refLength);
        int tabSize = this.fPrefs.prefTabSize;
        int maxCopyLength = tabSize > 0 ? minLength - minLength % tabSize : minLength;
        this.stripExceedingChars(buffer, maxCopyLength);
        int missing = totalLength - maxCopyLength;
        if ("space".equals(this.fPrefs.prefTabChar)) {
            tabs = 0;
            spaces = missing;
        } else {
            tabs = tabSize > 0 ? missing / tabSize : 0;
            spaces = tabSize > 0 ? missing % tabSize : missing;
        }
        int i = 0;
        while (i < tabs) {
            buffer.append('\t');
            ++i;
        }
        i = 0;
        while (i < spaces) {
            buffer.append(' ');
            ++i;
        }
        return buffer;
    }

    public int getContinuationLineIndent() {
        return this.fPrefs.prefContinuationIndent;
    }

    public int findReferencePosition(int offset) {
        return this.findReferencePosition(offset, this.peekToken(offset));
    }

    private int peekToken(int offset) {
        if (offset < this.fDocument.getLength()) {
            try {
                IRegion line = this.fDocument.getLineInformationOfOffset(offset);
                int lineEnd = line.getOffset() + line.getLength();
                int next = this.fScanner.nextToken(offset, lineEnd);
                return next;
            }
            catch (BadLocationException badLocationException) {}
        }
        return -1;
    }

    private int peekSecondToken(int offset) {
        if (offset < this.fDocument.getLength()) {
            try {
                IRegion line = this.fDocument.getLineInformationOfOffset(offset);
                int lineEnd = line.getOffset() + line.getLength();
                this.fScanner.nextToken(offset, lineEnd);
                int next = this.fScanner.nextToken(this.fScanner.getPosition(), lineEnd);
                return next;
            }
            catch (BadLocationException badLocationException) {}
        }
        return -1;
    }

    public int findReferencePosition(int offset, int nextToken) {
        boolean danglingElse = false;
        boolean cancelIndent = false;
        int extraIndent = 0;
        MatchMode matchMode = MatchMode.REGULAR;
        if (offset < this.fDocument.getLength()) {
            try {
                IRegion line = this.fDocument.getLineInformationOfOffset(offset);
                int lineOffset = line.getOffset();
                int prevPos = Math.max(offset - 1, 0);
                boolean isFirstTokenOnLine = this.fDocument.get(lineOffset, prevPos + 1 - lineOffset).trim().length() == 0;
                int prevToken = this.fScanner.previousToken(prevPos, -2);
                boolean bracelessBlockStart = this.fScanner.isBracelessBlockStart(prevPos, -2);
                switch (nextToken) {
                    case 1014: {
                        danglingElse = true;
                        break;
                    }
                    case 1013: 
                    case 1022: {
                        if (isFirstTokenOnLine) {
                            matchMode = MatchMode.MATCH_CASE;
                        }
                        break;
                    }
                    case 1023: 
                    case 1024: 
                    case 1025: {
                        if (isFirstTokenOnLine && this.peekSecondToken(offset) != 2000) {
                            matchMode = MatchMode.MATCH_ACCESS_SPECIFIER;
                        }
                        break;
                    }
                    case 1: {
                        if (bracelessBlockStart) {
                            extraIndent = this.fPrefs.prefIndentBracesForBlocks ? 0 : -1;
                            break;
                        }
                        if (prevToken == 9 && !this.fPrefs.prefIndentBracesForBlocks) {
                            extraIndent = -1;
                            break;
                        }
                        if (!(prevToken != 12 && prevToken != 4 || this.fPrefs.prefIndentBracesForArrays)) {
                            cancelIndent = true;
                            break;
                        }
                        if ((prevToken == 6 || prevToken == 1036) && this.fPrefs.prefIndentBracesForMethods) {
                            extraIndent = 1;
                            break;
                        }
                        if (prevToken == 2000) {
                            if (this.fPrefs.prefIndentBracesForTypes) {
                                extraIndent = 1;
                            }
                            int pos = this.fPosition;
                            this.fPosition = offset;
                            if (this.matchTypeDeclaration() != -1) {
                                matchMode = MatchMode.MATCH_TYPE_DECLARATION;
                            }
                            this.fPosition = pos;
                        }
                        break;
                    }
                    case 2: {
                        if (isFirstTokenOnLine || prevToken != 1) {
                            matchMode = MatchMode.MATCH_BRACE;
                        }
                        break;
                    }
                    case 6: {
                        if (!isFirstTokenOnLine) break;
                        matchMode = MatchMode.MATCH_PAREN;
                    }
                    default: {
                        break;
                    }
                }
            }
            catch (BadLocationException badLocationException) {}
        } else {
            danglingElse = false;
        }
        int ref = this.findReferencePosition(offset, danglingElse, matchMode);
        if (cancelIndent) {
            this.fIndent = 0;
        } else if (extraIndent > 0) {
            this.fAlign = -1;
            this.fIndent += extraIndent;
        } else {
            this.fIndent += extraIndent;
        }
        return ref;
    }

    public int findReferencePosition(int offset, boolean danglingElse, MatchMode matchMode) {
        this.fIndent = 0;
        this.fExtraSpaces = 0;
        this.fAlign = -1;
        this.fPosition = offset;
        switch (matchMode) {
            case MATCH_BRACE: {
                if (this.skipScope(1, 2)) {
                    try {
                        int lineOffset = this.fDocument.getLineOffset(this.fLine);
                        if (lineOffset <= this.fPosition && this.fDocument.get(lineOffset, this.fPosition - lineOffset).trim().isEmpty()) {
                            return this.fPosition;
                        }
                    }
                    catch (BadLocationException badLocationException) {}
                    int pos = this.skipToStatementStart(true, true);
                    this.fIndent = 0;
                    return pos;
                }
                int pos = this.findReferencePosition(offset, danglingElse, MatchMode.REGULAR);
                --this.fIndent;
                return pos;
            }
            case MATCH_PAREN: {
                if (this.skipScope(5, 6)) {
                    return this.fPosition;
                }
                int pos = this.findReferencePosition(offset, danglingElse, MatchMode.REGULAR);
                --this.fIndent;
                return pos;
            }
            case MATCH_CASE: {
                return this.matchCaseAlignment();
            }
            case MATCH_ACCESS_SPECIFIER: {
                return this.matchAccessSpecifierAlignment();
            }
            case MATCH_TYPE_DECLARATION: {
                return this.matchTypeDeclaration();
            }
        }
        if (this.peekToken(offset) == 9) {
            int pos = this.fPosition;
            if (this.looksLikeTypeInheritanceDecl()) {
                this.fIndent = this.fPrefs.prefContinuationIndent;
                return this.fPosition;
            }
            this.fPosition = pos;
        }
        this.nextToken();
        while (this.fToken == 9 && this.isAccessSpecifier()) {
            this.nextToken();
        }
        int line = this.fLine;
        switch (this.fToken) {
            case 2: 
            case 14: {
                int pos = this.fPosition;
                if (!this.skipScope()) {
                    this.fPosition = pos;
                }
                return this.skipToStatementStart(danglingElse, false);
            }
            case 7: {
                return this.skipToStatementStart(danglingElse, false);
            }
            case 1: 
            case 3: 
            case 5: {
                return this.handleScopeIntroduction(Math.min(offset + 1, this.fDocument.getLength()), true);
            }
            case -1: {
                return -1;
            }
            case 12: {
                this.fIndent = this.fPrefs.prefAssignmentIndent;
                return this.fPosition;
            }
            case 9: {
                int pos = this.fPosition;
                if (this.looksLikeCaseStatement()) {
                    this.fIndent = this.fPrefs.prefCaseBlockIndent;
                    return pos;
                }
                this.fPosition = pos;
                if (this.looksLikeTypeInheritanceDecl()) {
                    this.fIndent = this.fPrefs.prefContinuationIndent;
                    return pos;
                }
                this.fPosition = pos;
                if (this.looksLikeConstructorInitializer()) {
                    this.fIndent = this.fPrefs.prefBlockIndent;
                    return pos;
                }
                this.fPosition = pos;
                if (this.isConditional()) {
                    this.fPosition = offset;
                    this.fLine = line;
                    return this.skipToPreviousListItemOrListStart();
                }
                this.fPosition = pos;
                return this.skipToPreviousListItemOrListStart();
            }
            case 10: {
                if (this.fPrefs.prefTernaryDeepAlign) {
                    this.setFirstElementAlignment(this.fPosition, offset + 1);
                } else {
                    this.fIndent = this.fPrefs.prefTernaryIndent;
                }
                return this.fPosition;
            }
            case 1010: 
            case 1014: 
            case 1017: {
                this.fIndent = this.fPrefs.prefSimpleIndent;
                return this.fPosition;
            }
            case 1012: {
                return this.skipToStatementStart(danglingElse, false);
            }
            case 1018: 
            case 1038: 
            case 1039: {
                this.fIndent = this.fPrefs.prefContinuationIndent;
                return this.fPosition;
            }
            case 1036: {
                this.nextToken();
                if (this.fToken != 6) {
                    return this.skipToPreviousListItemOrListStart();
                }
            }
            case 6: {
                if (this.skipScope(5, 6)) {
                    int scope = this.fPosition;
                    this.nextToken();
                    if (this.fToken == 109 || this.fToken == 1017 || this.fToken == 1011) {
                        this.fIndent = this.fPrefs.prefSimpleIndent;
                        return this.fPosition;
                    }
                    if (this.fToken == 1020) {
                        return this.fPosition;
                    }
                    this.fPosition = scope;
                    if (this.looksLikeMethodDecl()) {
                        return this.skipToStatementStart(danglingElse, false);
                    }
                    if (this.fToken == 1016) {
                        return this.skipToStatementStart(danglingElse, false);
                    }
                    this.fPosition = scope;
                    if (this.looksLikeAnonymousTypeDecl()) {
                        return this.skipToStatementStart(danglingElse, false);
                    }
                }
                this.fPosition = offset;
                this.fLine = line;
                return this.skipToPreviousListItemOrListStart();
            }
            case 11: {
                return this.skipToPreviousListItemOrListStart();
            }
        }
        return this.skipToPreviousListItemOrListStart();
    }

    private int matchTypeDeclaration() {
        do {
            this.nextToken();
        } while (this.fToken == 2000 || this.fToken == 11 || this.fToken == 9 || this.fToken == 1025 || this.fToken == 1024 || this.fToken == 1023);
        if (this.fToken == 1028 || this.fToken == 1029 || this.fToken == 1030) {
            int pos = this.fPosition;
            this.nextToken();
            if (this.fToken == 7 || this.fToken == -1) {
                return pos;
            }
            return -1;
        }
        return -1;
    }

    private boolean looksLikeCaseStatement() {
        this.nextToken();
        switch (this.fToken) {
            case 1013: {
                return true;
            }
            case 2000: {
                this.nextToken();
                while (this.skipQualifiers()) {
                    this.nextToken();
                }
                while (this.fToken == 16 || this.fToken == 22) {
                    this.nextToken();
                }
                if (this.fToken != 1013) break;
                return true;
            }
            case 8: {
                this.nextToken();
                if (this.fToken != 1013) break;
                return true;
            }
            case 1022: {
                return true;
            }
        }
        return false;
    }

    private boolean looksLikeTypeInheritanceDecl() {
        this.nextToken();
        switch (this.fToken) {
            case 2000: {
                this.nextToken();
                while (this.skipQualifiers()) {
                    this.nextToken();
                }
                switch (this.fToken) {
                    case 1028: 
                    case 1029: 
                    case 1030: {
                        return true;
                    }
                }
            }
        }
        return false;
    }

    private boolean looksLikeConstructorInitializer() {
        this.nextToken();
        if (this.fToken != 6) {
            return false;
        }
        if (!this.skipScope()) {
            return false;
        }
        this.nextToken();
        if (this.fToken == 1035) {
            this.nextToken();
            if (this.fToken != 6) {
                return false;
            }
            if (!this.skipScope()) {
                return false;
            }
            this.nextToken();
        }
        if (this.fToken != 2000) {
            return false;
        }
        this.nextToken();
        switch (this.fToken) {
            case 9: {
                this.nextToken();
                switch (this.fToken) {
                    case 9: 
                    case 1023: 
                    case 1024: 
                    case 1025: {
                        return true;
                    }
                }
                return false;
            }
            case 1: 
            case 2: 
            case 7: {
                return true;
            }
        }
        return false;
    }

    private boolean looksLikeEnumDeclaration() {
        int pos = this.fPosition;
        this.nextToken();
        if (this.fToken == 2000) {
            this.nextToken();
            while (this.skipQualifiers()) {
                this.nextToken();
            }
        }
        if (this.fToken == 1031) {
            this.fPosition = pos;
            return true;
        }
        this.fPosition = pos;
        return false;
    }

    private boolean isAccessSpecifier() {
        int pos = this.fPosition;
        int token = this.fToken;
        this.nextToken();
        switch (this.fToken) {
            case 1023: 
            case 1024: 
            case 1025: {
                return true;
            }
        }
        this.fToken = token;
        this.fPosition = pos;
        return false;
    }

    private int skipToStatementStart(boolean danglingElse, boolean isInBlock) {
        int mayBeMethodBody = 0;
        boolean isTypeBody = false;
        int startLine = this.fLine;
        while (true) {
            int prevToken = this.fToken;
            this.nextToken();
            if (isInBlock) {
                switch (this.fToken) {
                    case 109: 
                    case 1010: 
                    case 1011: 
                    case 1012: 
                    case 1014: 
                    case 1016: 
                    case 1017: {
                        this.fIndent += this.fPrefs.prefIndentBracesForBlocks ? 1 : 0;
                        return this.fPosition;
                    }
                    case 1028: 
                    case 1029: 
                    case 1030: {
                        isTypeBody = true;
                        break;
                    }
                    case 1020: {
                        this.fIndent = this.fPrefs.prefCaseIndent;
                        return this.fPosition;
                    }
                }
            }
            if (this.fToken == 7 && this.fLine == startLine) continue;
            block5 : switch (this.fToken) {
                case 5: {
                    if (this.peekToken() != 1011) break;
                    this.nextToken();
                    this.fIndent = this.fPrefs.prefContinuationIndent;
                    return this.fPosition;
                }
                case -1: 
                case 1: 
                case 7: {
                    if (isInBlock) {
                        this.fIndent = this.getBlockIndent(mayBeMethodBody == 2, isTypeBody);
                    }
                    return this.fPreviousPos;
                }
                case 9: {
                    int pos;
                    switch (prevToken) {
                        case 1023: 
                        case 1024: 
                        case 1025: 
                        case 1032: {
                            break block5;
                        }
                        default: {
                            pos = this.fPreviousPos;
                            if (this.isConditional()) break block5;
                            return pos;
                        }
                    }
                }
                case 2: {
                    int pos = this.fPreviousPos;
                    if (this.skipScope() && (this.looksLikeArrayInitializerIntro() || prevToken == 7)) break;
                    if (isInBlock) {
                        this.fIndent = this.getBlockIndent(mayBeMethodBody == 2, isTypeBody);
                    }
                    return pos;
                }
                case 6: {
                    if (isInBlock) {
                        mayBeMethodBody = 1;
                    }
                    int pos = this.fPreviousPos;
                    if (this.skipScope()) break;
                    return pos;
                }
                case 4: {
                    int pos = this.fPreviousPos;
                    if (this.skipScope()) break;
                    return pos;
                }
                case 109: {
                    if (!danglingElse) break;
                    return this.fPosition;
                }
                case 1014: {
                    int pos = this.fPosition;
                    if (this.skipNextIF()) break;
                    return pos;
                }
                case 1010: {
                    return this.fPosition;
                }
                case 1017: {
                    int pos = this.fPosition;
                    if (this.hasMatchingDo()) break;
                    this.fPosition = pos;
                    break;
                }
                case 2000: {
                    if (mayBeMethodBody != true) break;
                    mayBeMethodBody = 2;
                }
            }
        }
    }

    private int getBlockIndent(boolean isMethodBody, boolean isTypeBody) {
        if (isTypeBody) {
            return this.fPrefs.prefTypeIndent + this.fPrefs.prefAccessSpecifierIndent;
        }
        if (isMethodBody) {
            return this.fPrefs.prefMethodBodyIndent + (this.fPrefs.prefIndentBracesForMethods ? 1 : 0);
        }
        return this.fIndent;
    }

    private boolean isConditional() {
        block6: while (true) {
            int previous = this.fToken;
            this.nextToken();
            switch (this.fToken) {
                case 2000: {
                    if (previous != 2000) continue block6;
                    return false;
                }
                case 8: 
                case 16: 
                case 20: 
                case 22: {
                    continue block6;
                }
                case 10: {
                    return true;
                }
                case 1: 
                case 2: 
                case 7: 
                case 1013: 
                case 1022: 
                case 1023: 
                case 1024: 
                case 1025: 
                case 1028: 
                case 1029: 
                case 1030: {
                    return false;
                }
            }
            break;
        }
        return true;
    }

    private int matchCaseAlignment() {
        block6: while (true) {
            this.nextToken();
            switch (this.fToken) {
                case -1: 
                case 3: 
                case 5: {
                    return this.fPosition;
                }
                case 1020: {
                    this.fIndent = this.fPrefs.prefCaseIndent;
                    return this.fPosition;
                }
                case 1013: 
                case 1022: {
                    this.fIndent = 0;
                    return this.fPosition;
                }
                case 2: 
                case 4: 
                case 6: {
                    this.skipScope();
                    continue block6;
                }
            }
        }
    }

    private int matchAccessSpecifierAlignment() {
        block6: while (true) {
            this.nextToken();
            switch (this.fToken) {
                case -1: 
                case 3: 
                case 5: {
                    return this.fPosition;
                }
                case 1: {
                    int pos = this.fPosition;
                    int typeDeclPos = this.matchTypeDeclaration();
                    this.fIndent = this.fPrefs.prefAccessSpecifierIndent;
                    this.fExtraSpaces = this.fPrefs.prefAccessSpecifierExtraSpaces;
                    if (typeDeclPos != -1) {
                        return typeDeclPos;
                    }
                    return pos;
                }
                case 1023: 
                case 1024: 
                case 1025: {
                    this.fIndent = 0;
                    return this.fPosition;
                }
                case 2: 
                case 4: 
                case 6: {
                    this.skipScope();
                    continue block6;
                }
            }
        }
    }

    private int skipToPreviousListItemOrListStart() {
        int startLine = this.fLine;
        int startPosition = this.fPosition;
        int linesSkippedInsideScopes = 0;
        boolean continuationLineCandidate = this.fToken == 12 || this.fToken == 21 || this.fToken == 6;
        block16: while (true) {
            int previous = this.fToken;
            this.nextToken();
            if (this.fLine < startLine - linesSkippedInsideScopes) {
                try {
                    int lineOffset = this.fDocument.getLineOffset(startLine);
                    int bound = Math.min(this.fDocument.getLength(), startPosition + 1);
                    if ((this.fToken == 7 || this.fToken == 2 || this.fToken == 1 && !this.looksLikeArrayInitializerIntro() && !this.looksLikeEnumDeclaration()) && continuationLineCandidate) {
                        this.fIndent = this.fPrefs.prefContinuationIndent;
                    } else {
                        this.fAlign = this.fScanner.findNonWhitespaceForwardInAnyPartition(lineOffset, bound);
                        if (this.peekToken(this.fAlign) == 9) {
                            this.fAlign = this.fScanner.findNonWhitespaceForwardInAnyPartition(this.fAlign + 1, bound);
                        }
                    }
                }
                catch (BadLocationException badLocationException) {}
                return startPosition;
            }
            int line = this.fLine;
            switch (this.fToken) {
                case 6: {
                    continuationLineCandidate = true;
                }
                case 2: 
                case 4: {
                    this.skipScope();
                    linesSkippedInsideScopes = line - this.fLine;
                    continue block16;
                }
                case 1: 
                case 3: 
                case 5: {
                    return this.handleScopeIntroduction(startPosition + 1, false);
                }
                case 7: {
                    return this.fPosition;
                }
                case 10: {
                    if (this.fPrefs.prefTernaryDeepAlign) {
                        this.setFirstElementAlignment(this.fPosition - 1, this.fPosition + 1);
                    } else {
                        this.fIndent = this.fPrefs.prefTernaryIndent;
                    }
                    return this.fPosition;
                }
                case 12: 
                case 21: {
                    continuationLineCandidate = true;
                    continue block16;
                }
                case 1018: 
                case 1039: {
                    this.fIndent = this.fPrefs.prefContinuationIndent;
                    return this.fPosition;
                }
                case 1038: {
                    switch (previous) {
                        case 1028: 
                        case 1029: 
                        case 1030: 
                        case 1031: {
                            break;
                        }
                        default: {
                            this.fIndent = this.fPrefs.prefContinuationIndent;
                        }
                    }
                    return this.fPosition;
                }
                case -1: {
                    if (continuationLineCandidate) {
                        this.fIndent = this.fPrefs.prefContinuationIndent;
                    }
                    return 0;
                }
            }
        }
    }

    private boolean skipScope() {
        switch (this.fToken) {
            case 6: {
                return this.skipScope(5, 6);
            }
            case 4: {
                return this.skipScope(3, 4);
            }
            case 2: {
                return this.skipScope(1, 2);
            }
            case 14: {
                if (!this.fPrefs.prefHasTemplates) {
                    return false;
                }
                int storedPosition = this.fPosition;
                int storedToken = this.fToken;
                this.nextToken();
                switch (this.fToken) {
                    case 2000: {
                        this.fPosition = storedPosition;
                        if (!this.skipScope(13, 14)) break;
                        return true;
                    }
                    case 10: 
                    case 14: {
                        this.fPosition = storedPosition;
                        if (!this.skipScope(13, 14)) break;
                        return true;
                    }
                }
                this.fPosition = storedPosition;
                this.fToken = storedToken;
                return false;
            }
        }
        Assert.isTrue((boolean)false);
        return false;
    }

    private CharSequence getTokenContent() {
        return new DocumentCharacterIterator(this.fDocument, this.fPosition, this.fPreviousPos);
    }

    private int handleScopeIntroduction(int bound, boolean firstToken) {
        int pos = this.fPosition;
        switch (this.fToken) {
            case 5: {
                if (this.looksLikeMethodDecl()) {
                    if (firstToken ? this.fPrefs.prefMethodDeclFirstParameterDeepIndent : this.fPrefs.prefMethodDeclDeepIndent) {
                        return this.setFirstElementAlignment(pos, bound);
                    }
                    this.fIndent = this.fPrefs.prefMethodDeclIndent;
                    return pos;
                }
                this.fPosition = pos;
                if (this.looksLikeMethodCall()) {
                    if (firstToken ? this.fPrefs.prefMethodCallFirstParameterDeepIndent : this.fPrefs.prefMethodCallDeepIndent) {
                        return this.setFirstElementAlignment(pos, bound);
                    }
                    this.fIndent = this.fPrefs.prefMethodCallIndent;
                    return pos;
                }
                if (this.fPrefs.prefParenthesisDeepIndent) {
                    return this.setFirstElementAlignment(pos, bound);
                }
                this.fIndent = this.fPrefs.prefParenthesisIndent;
                return pos;
            }
            case 1: {
                boolean looksLikeArrayInitializerIntro = this.looksLikeArrayInitializerIntro();
                if (looksLikeArrayInitializerIntro) {
                    if (this.fPrefs.prefArrayDeepIndent) {
                        return this.setFirstElementAlignment(pos, bound);
                    }
                    this.fIndent = this.fPrefs.prefArrayIndent;
                } else {
                    int typeDeclPos;
                    this.fIndent = this.isNamespace() || this.isLinkageSpec() ? this.fPrefs.prefNamespaceBodyIndent : (this.looksLikeEnumDeclaration() ? this.fPrefs.prefTypeIndent : ((typeDeclPos = this.matchTypeDeclaration()) == -1 ? this.fPrefs.prefBlockIndent : this.fPrefs.prefAccessSpecifierIndent + this.fPrefs.prefTypeIndent));
                }
                if (!looksLikeArrayInitializerIntro) {
                    this.fPosition = pos;
                    return this.skipToStatementStart(true, true);
                }
                return pos;
            }
            case 3: {
                if (this.fPrefs.prefArrayDimensionsDeepIndent) {
                    return this.setFirstElementAlignment(pos, bound);
                }
                this.fIndent = this.fPrefs.prefBracketIndent;
                return pos;
            }
        }
        Assert.isTrue((boolean)false);
        return -1;
    }

    private int setFirstElementAlignment(int scopeIntroducerOffset, int bound) {
        int firstPossible = scopeIntroducerOffset + 1;
        this.fAlign = this.fScanner.findNonWhitespaceForwardInAnyPartition(firstPossible, bound);
        if (this.fAlign == -1) {
            this.fAlign = firstPossible;
        } else {
            try {
                IRegion lineRegion = this.fDocument.getLineInformationOfOffset(scopeIntroducerOffset);
                if (this.fAlign > lineRegion.getOffset() + lineRegion.getLength()) {
                    this.fAlign = firstPossible;
                }
            }
            catch (BadLocationException badLocationException) {}
        }
        return this.fAlign;
    }

    private boolean looksLikeArrayInitializerIntro() {
        int pos = this.fPosition;
        this.nextToken();
        switch (this.fToken) {
            case 12: {
                return true;
            }
            case 4: {
                return this.skipBrackets();
            }
            case 1: {
                if (this.looksLikeArrayInitializerIntro()) {
                    this.fPosition = pos;
                    return true;
                }
                return false;
            }
            case 11: {
                this.fPosition = pos;
                return true;
            }
        }
        this.fPosition = pos;
        return false;
    }

    private boolean isNamespace() {
        int pos = this.fPosition;
        this.nextToken();
        if (this.fToken == 1033) {
            this.fPosition = pos;
            return true;
        }
        if (this.fToken == 2000) {
            this.nextToken();
            if (this.fToken == 1033) {
                this.fPosition = pos;
                return true;
            }
        }
        this.fPosition = pos;
        return false;
    }

    private boolean isLinkageSpec() {
        int pos = this.fPosition;
        this.nextToken();
        if (this.fToken == 1037) {
            this.fPosition = pos;
            return true;
        }
        this.fPosition = pos;
        return false;
    }

    private boolean skipNextIF() {
        Assert.isTrue((this.fToken == 1014 ? 1 : 0) != 0);
        block6: while (true) {
            this.nextToken();
            switch (this.fToken) {
                case 2: 
                case 4: 
                case 6: {
                    this.skipScope();
                    continue block6;
                }
                case 109: {
                    return true;
                }
                case 1014: {
                    this.skipNextIF();
                    continue block6;
                }
                case -1: 
                case 1: 
                case 3: 
                case 5: {
                    return false;
                }
            }
        }
    }

    private boolean hasMatchingDo() {
        Assert.isTrue((this.fToken == 1017 ? 1 : 0) != 0);
        this.nextToken();
        switch (this.fToken) {
            case 2: {
                this.skipScope();
                this.skipToStatementStart(false, false);
                return this.fToken == 1010;
            }
            case 7: {
                this.skipToStatementStart(false, false);
                return this.fToken == 1010;
            }
        }
        return false;
    }

    private boolean skipPointerOperators() {
        String token;
        return this.fToken == 8 ? (token = this.getTokenContent().toString().trim()).length() == 1 && token.charAt(0) == '*' || token.charAt(0) == '&' : this.fToken == 1036;
    }

    private boolean skipBrackets() {
        if (this.fToken == 4) {
            this.nextToken();
            if (this.fToken == 3) {
                return true;
            }
        }
        return false;
    }

    private boolean skipQualifiers() {
        if (this.fToken == 20) {
            this.nextToken();
            if (this.fToken == 2000) {
                return true;
            }
        }
        return false;
    }

    private void nextToken() {
        this.nextToken(this.fPosition);
    }

    private void nextToken(int start) {
        this.fToken = this.fScanner.previousToken(start - 1, -2);
        this.fPreviousPos = start;
        this.fPosition = this.fScanner.getPosition() + 1;
        try {
            this.fLine = this.fDocument.getLineOfOffset(this.fPosition);
        }
        catch (BadLocationException badLocationException) {
            this.fLine = -1;
        }
    }

    private int peekToken() {
        return this.fScanner.previousToken(this.fPosition - 1, -2);
    }

    /*
     * Unable to fully structure code
     */
    private boolean looksLikeMethodDecl() {
        this.nextToken();
        switch (this.fToken) {
            case 2000: {
                pos = this.fPosition;
                this.nextToken();
                if (this.fToken == 17) {
                    return true;
                }
                if (!this.skipQualifiers()) ** GOTO lbl11
                return true;
lbl-1000:
                // 1 sources

                {
                    this.nextToken();
lbl11:
                    // 2 sources

                    ** while (this.skipBrackets())
                }
lbl12:
                // 2 sources

                while (this.skipPointerOperators()) {
                    this.nextToken();
                }
                block7 : switch (this.fToken) {
                    case 2000: {
                        return true;
                    }
                    case 2: 
                    case 7: {
                        this.fPosition = pos;
                        return true;
                    }
                    case 1: {
                        if (!this.fScanner.looksLikeCompositeTypeDefinitionBackward(this.fPosition, -2)) break;
                        this.fPosition = pos;
                        return true;
                    }
                    case 11: {
                        this.nextToken();
                        if (this.fToken != 6 || !this.skipScope()) break;
                        return this.looksLikeMethodDecl();
                    }
                    case 9: {
                        this.nextToken();
                        switch (this.fToken) {
                            case 1023: 
                            case 1024: 
                            case 1025: {
                                this.fPosition = pos;
                                return true;
                            }
                            case 6: {
                                if (!this.skipScope()) break block7;
                                pos = this.fPosition;
                                this.nextToken();
                                if (this.fToken == 1035) {
                                    this.nextToken();
                                    if (this.fToken != 6 || !this.skipScope()) {
                                        return false;
                                    }
                                } else {
                                    this.fPosition = pos;
                                }
                                return this.looksLikeMethodDecl();
                            }
                        }
                    }
                }
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 16: 
            case 18: 
            case 19: 
            case 21: 
            case 22: 
            case 1026: 
            case 1027: {
                this.nextToken();
                return this.fToken == 1034;
            }
            case 6: {
                this.nextToken();
                if (this.fToken != 5) {
                    return false;
                }
                this.nextToken();
                return this.fToken == 1034;
            }
            case 4: {
                this.nextToken();
                if (this.fToken != 3) {
                    return false;
                }
                this.nextToken();
                if (this.fToken == 1026 || this.fToken == 1027) {
                    this.nextToken();
                }
                return this.fToken == 1034;
            }
            case 8: {
                if (this.getTokenContent().length() == 1) {
                    this.nextToken();
                    if (this.fToken == 1034) {
                        return true;
                    }
                }
                if (this.getTokenContent().length() != 1) break;
                this.nextToken();
                if (this.fToken != 1034) break;
                return true;
            }
        }
        return false;
    }

    private boolean looksLikeAnonymousTypeDecl() {
        this.nextToken();
        if (this.fToken == 2000) {
            this.nextToken();
            while (this.fToken == 8) {
                this.nextToken();
                if (this.fToken != 2000) {
                    return false;
                }
                this.nextToken();
            }
            return this.fToken == 1026;
        }
        return false;
    }

    private boolean looksLikeMethodCall() {
        this.nextToken();
        if (this.fToken == 14) {
            if (!this.skipScope()) {
                return false;
            }
            this.nextToken();
        }
        return this.fToken == 2000;
    }

    private boolean skipScope(int openToken, int closeToken) {
        int depth = 1;
        while (true) {
            this.nextToken();
            if (this.fToken == closeToken) {
                ++depth;
                continue;
            }
            if (this.fToken == openToken) {
                if (--depth != 0) continue;
                return true;
            }
            if (this.fToken == -1) break;
        }
        return false;
    }

    private final class CorePrefs {
        final boolean prefUseTabs;
        final int prefTabSize;
        final int prefIndentationSize;
        final boolean prefArrayDimensionsDeepIndent;
        final int prefArrayIndent;
        final boolean prefArrayDeepIndent;
        final boolean prefTernaryDeepAlign;
        final int prefTernaryIndent;
        final int prefCaseIndent;
        final int prefCaseBlockIndent;
        final int prefAssignmentIndent;
        final int prefSimpleIndent;
        final int prefBracketIndent;
        final boolean prefMethodDeclDeepIndent;
        final boolean prefMethodDeclFirstParameterDeepIndent;
        final int prefMethodDeclIndent;
        final boolean prefMethodCallDeepIndent;
        final boolean prefMethodCallFirstParameterDeepIndent;
        final int prefMethodCallIndent;
        final boolean prefParenthesisDeepIndent;
        final int prefParenthesisIndent;
        final int prefBlockIndent;
        final int prefMethodBodyIndent;
        final int prefTypeIndent;
        final int prefAccessSpecifierIndent;
        final int prefAccessSpecifierExtraSpaces;
        final int prefNamespaceBodyIndent;
        final boolean prefIndentBracesForBlocks;
        final boolean prefIndentBracesForArrays;
        final boolean prefIndentBracesForMethods;
        final boolean prefIndentBracesForTypes;
        final int prefContinuationIndent;
        final boolean prefHasTemplates;
        final String prefTabChar;
        private final IPreferencesService preferenceService = Platform.getPreferencesService();
        private final IScopeContext[] preferenceContexts;
        private final ICProject fProject;

        private String getCoreFormatterOption(String key) {
            return this.getCoreFormatterOption(key, null);
        }

        private String getCoreFormatterOption(String key, String defaultValue) {
            return this.preferenceService.getString("org.eclipse.cdt.core", key, defaultValue, this.preferenceContexts);
        }

        private int getCoreFormatterOption(String key, int defaultValue) {
            return this.preferenceService.getInt("org.eclipse.cdt.core", key, defaultValue, this.preferenceContexts);
        }

        CorePrefs(ICProject project) {
            IScopeContext[] iScopeContextArray;
            if (project != null) {
                IScopeContext[] iScopeContextArray2 = new IScopeContext[3];
                iScopeContextArray2[0] = new ProjectScope(project.getProject());
                iScopeContextArray2[1] = InstanceScope.INSTANCE;
                iScopeContextArray = iScopeContextArray2;
                iScopeContextArray2[2] = DefaultScope.INSTANCE;
            } else {
                IScopeContext[] iScopeContextArray3 = new IScopeContext[2];
                iScopeContextArray3[0] = InstanceScope.INSTANCE;
                iScopeContextArray = iScopeContextArray3;
                iScopeContextArray3[1] = DefaultScope.INSTANCE;
            }
            this.preferenceContexts = iScopeContextArray;
            this.fProject = project;
            this.prefUseTabs = this.prefUseTabs();
            this.prefTabSize = this.prefTabSize();
            this.prefIndentationSize = this.prefIndentationSize();
            this.prefArrayDimensionsDeepIndent = this.prefArrayDimensionsDeepIndent();
            this.prefContinuationIndent = this.prefContinuationIndent();
            this.prefBlockIndent = this.prefBlockIndent();
            this.prefArrayIndent = this.prefArrayIndent();
            this.prefArrayDeepIndent = this.prefArrayDeepIndent();
            this.prefTernaryDeepAlign = false;
            this.prefTernaryIndent = this.prefContinuationIndent();
            this.prefCaseIndent = this.prefCaseIndent();
            this.prefCaseBlockIndent = this.prefCaseBlockIndent();
            this.prefAssignmentIndent = this.prefAssignmentIndent();
            this.prefIndentBracesForBlocks = this.prefIndentBracesForBlocks();
            this.prefSimpleIndent = this.prefSimpleIndent();
            this.prefBracketIndent = this.prefBracketIndent();
            this.prefMethodDeclDeepIndent = this.prefMethodDeclDeepIndent();
            this.prefMethodDeclFirstParameterDeepIndent = this.prefMethodDeclFirstParameterDeepIndent();
            this.prefMethodDeclIndent = this.prefMethodDeclIndent();
            this.prefMethodCallDeepIndent = this.prefMethodCallDeepIndent();
            this.prefMethodCallFirstParameterDeepIndent = this.prefMethodCallFirstParameterDeepIndent();
            this.prefMethodCallIndent = this.prefMethodCallIndent();
            this.prefParenthesisDeepIndent = this.prefParenthesisDeepIndent();
            this.prefParenthesisIndent = this.prefParenthesisIndent();
            this.prefMethodBodyIndent = this.prefMethodBodyIndent();
            this.prefTypeIndent = this.prefTypeIndent();
            this.prefAccessSpecifierIndent = this.prefAccessSpecifierIndent();
            this.prefAccessSpecifierExtraSpaces = this.prefAccessSpecifierExtraSpaces();
            this.prefNamespaceBodyIndent = this.prefNamespaceBodyIndent();
            this.prefIndentBracesForArrays = this.prefIndentBracesForArrays();
            this.prefIndentBracesForMethods = this.prefIndentBracesForMethods();
            this.prefIndentBracesForTypes = this.prefIndentBracesForTypes();
            this.prefHasTemplates = this.hasTemplates();
            this.prefTabChar = this.getCoreFormatterOption("org.eclipse.cdt.core.formatter.tabulation.char");
        }

        private boolean prefUseTabs() {
            return !"space".equals(this.getCoreFormatterOption("org.eclipse.cdt.core.formatter.tabulation.char"));
        }

        private int prefTabSize() {
            return CodeFormatterUtil.getTabWidth(this.fProject);
        }

        private int prefIndentationSize() {
            return CodeFormatterUtil.getIndentWidth(this.fProject);
        }

        private boolean prefArrayDimensionsDeepIndent() {
            return true;
        }

        private int prefArrayIndent() {
            String option = this.getCoreFormatterOption("org.eclipse.cdt.core.formatter.alignment_for_expressions_in_array_initializer");
            try {
                if (DefaultCodeFormatterConstants.getIndentStyle((String)option) == 2) {
                    return 1;
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {}
            return this.prefContinuationIndent();
        }

        private boolean prefArrayDeepIndent() {
            String option = this.getCoreFormatterOption("org.eclipse.cdt.core.formatter.alignment_for_expressions_in_array_initializer");
            try {
                return DefaultCodeFormatterConstants.getIndentStyle((String)option) == 1;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                return true;
            }
        }

        private int prefCaseIndent() {
            if ("true".equals(this.getCoreFormatterOption("org.eclipse.cdt.core.formatter.indent_switchstatements_compare_to_switch"))) {
                return 1;
            }
            return 0;
        }

        private int prefCaseBlockIndent() {
            if ("true".equals(this.getCoreFormatterOption("org.eclipse.cdt.core.formatter.indent_switchstatements_compare_to_cases"))) {
                return 1;
            }
            return 0;
        }

        private int prefAssignmentIndent() {
            return this.prefContinuationIndent();
        }

        private int prefSimpleIndent() {
            if (this.prefIndentBracesForBlocks() && this.prefBlockIndent() == 0) {
                return 1;
            }
            return this.prefBlockIndent();
        }

        private int prefBracketIndent() {
            return this.prefBlockIndent();
        }

        private boolean prefMethodDeclDeepIndent() {
            String option = this.getCoreFormatterOption("org.eclipse.cdt.core.formatter.alignment_for_parameters_in_method_declaration");
            try {
                int indentStyle = DefaultCodeFormatterConstants.getIndentStyle((String)option);
                return indentStyle == 1;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                return false;
            }
        }

        private boolean prefMethodDeclFirstParameterDeepIndent() {
            String option = this.getCoreFormatterOption("org.eclipse.cdt.core.formatter.alignment_for_parameters_in_method_declaration");
            try {
                int indentStyle = DefaultCodeFormatterConstants.getIndentStyle((String)option);
                int wrappingStyle = DefaultCodeFormatterConstants.getWrappingStyle((String)option);
                return indentStyle == 1 && (wrappingStyle == 2 || wrappingStyle == 3);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                return false;
            }
        }

        private int prefMethodDeclIndent() {
            block3: {
                String option = this.getCoreFormatterOption("org.eclipse.cdt.core.formatter.alignment_for_parameters_in_method_declaration");
                try {
                    if (DefaultCodeFormatterConstants.getIndentStyle((String)option) != 2) break block3;
                    return 1;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    return 1;
                }
            }
            return this.prefContinuationIndent();
        }

        private boolean prefMethodCallDeepIndent() {
            String option = this.getCoreFormatterOption("org.eclipse.cdt.core.formatter.alignment_for_arguments_in_method_invocation");
            try {
                int indentStyle = DefaultCodeFormatterConstants.getIndentStyle((String)option);
                return indentStyle == 1;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                return false;
            }
        }

        private boolean prefMethodCallFirstParameterDeepIndent() {
            String option = this.getCoreFormatterOption("org.eclipse.cdt.core.formatter.alignment_for_arguments_in_method_invocation");
            try {
                int indentStyle = DefaultCodeFormatterConstants.getIndentStyle((String)option);
                int wrappingStyle = DefaultCodeFormatterConstants.getWrappingStyle((String)option);
                return indentStyle == 1 && (wrappingStyle == 2 || wrappingStyle == 3);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                return false;
            }
        }

        private int prefMethodCallIndent() {
            block3: {
                String option = this.getCoreFormatterOption("org.eclipse.cdt.core.formatter.alignment_for_arguments_in_method_invocation");
                try {
                    if (DefaultCodeFormatterConstants.getIndentStyle((String)option) != 2) break block3;
                    return 1;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    return 1;
                }
            }
            return this.prefContinuationIndent();
        }

        private boolean prefParenthesisDeepIndent() {
            return false;
        }

        private int prefParenthesisIndent() {
            return this.prefContinuationIndent();
        }

        private int prefBlockIndent() {
            String option = this.getCoreFormatterOption("org.eclipse.cdt.core.formatter.indent_statements_compare_to_block");
            if ("false".equals(option)) {
                return 0;
            }
            return 1;
        }

        private int prefMethodBodyIndent() {
            if ("false".equals(this.getCoreFormatterOption("org.eclipse.cdt.core.formatter.indent_statements_compare_to_body"))) {
                return 0;
            }
            return 1;
        }

        private int prefTypeIndent() {
            String option = this.getCoreFormatterOption("org.eclipse.cdt.core.formatter.indent_body_declarations_compare_to_access_specifier");
            if ("false".equals(option)) {
                return 0;
            }
            return 1;
        }

        private int prefAccessSpecifierIndent() {
            if ("true".equals(this.getCoreFormatterOption("org.eclipse.cdt.core.formatter.indent_access_specifier_compare_to_type_header"))) {
                return 1;
            }
            return 0;
        }

        private int prefAccessSpecifierExtraSpaces() {
            return this.getCoreFormatterOption("org.eclipse.cdt.core.formatter.indent_access_specifier_extra_spaces", 0);
        }

        private int prefNamespaceBodyIndent() {
            if ("true".equals(this.getCoreFormatterOption("org.eclipse.cdt.core.formatter.indent_body_declarations_compare_to_namespace_header"))) {
                return this.prefBlockIndent();
            }
            return 0;
        }

        private boolean prefIndentBracesForBlocks() {
            return "next_line_shifted".equals(this.getCoreFormatterOption("org.eclipse.cdt.core.formatter.brace_position_for_block"));
        }

        private boolean prefIndentBracesForArrays() {
            return "next_line_shifted".equals(this.getCoreFormatterOption("org.eclipse.cdt.core.formatter.brace_position_for_array_initializer"));
        }

        private boolean prefIndentBracesForMethods() {
            return "next_line_shifted".equals(this.getCoreFormatterOption("org.eclipse.cdt.core.formatter.brace_position_for_method_declaration"));
        }

        private boolean prefIndentBracesForTypes() {
            return "next_line_shifted".equals(this.getCoreFormatterOption("org.eclipse.cdt.core.formatter.brace_position_for_type_declaration"));
        }

        private int prefContinuationIndent() {
            try {
                return Integer.parseInt(this.getCoreFormatterOption("org.eclipse.cdt.core.formatter.continuation_indentation"));
            }
            catch (NumberFormatException numberFormatException) {
                return 2;
            }
        }

        private boolean hasTemplates() {
            return true;
        }
    }

    public static enum MatchMode {
        REGULAR,
        MATCH_BRACE,
        MATCH_PAREN,
        MATCH_CASE,
        MATCH_ACCESS_SPECIFIER,
        MATCH_TYPE_DECLARATION;

    }
}

