/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw3d.geometry;

import org.eclipse.draw3d.geometry.IMatrix;
import org.eclipse.draw3d.geometry.IMatrix3f;
import org.eclipse.draw3d.geometry.IMatrix4f;
import org.eclipse.draw3d.geometry.IVector2f;
import org.eclipse.draw3d.geometry.IVector3f;
import org.eclipse.draw3d.geometry.IVector4f;
import org.eclipse.draw3d.geometry.Math3D;
import org.eclipse.draw3d.geometry.Math3DCache;
import org.eclipse.draw3d.geometry.Math3DMatrix4f;
import org.eclipse.draw3d.geometry.Matrix3f;
import org.eclipse.draw3d.geometry.Matrix3fImpl;
import org.eclipse.draw3d.geometry.Matrix4f;
import org.eclipse.draw3d.geometry.Matrix4fImpl;
import org.eclipse.draw3d.geometry.Vector2f;
import org.eclipse.draw3d.geometry.Vector2fImpl;
import org.eclipse.draw3d.geometry.Vector3f;
import org.eclipse.draw3d.geometry.Vector3fImpl;
import org.eclipse.draw3d.geometry.Vector4f;
import org.eclipse.draw3d.geometry.Vector4fImpl;

public class Math3DMatrixOps
extends Math3DMatrix4f {
    public static Matrix4f convert(IMatrix3f i_source, Matrix4f o_result) {
        Matrix4fImpl result = o_result != null ? Matrix4fImpl.cast(o_result) : new Matrix4fImpl();
        Matrix3fImpl m = Matrix3fImpl.cast(i_source);
        result.a11 = m.a11;
        result.a12 = m.a12;
        result.a13 = m.a13;
        result.a14 = 0.0f;
        result.a21 = m.a21;
        result.a22 = m.a22;
        result.a23 = m.a23;
        result.a24 = 0.0f;
        result.a31 = 0.0f;
        result.a32 = 0.0f;
        result.a33 = 1.0f;
        result.a34 = 0.0f;
        result.a41 = m.a31;
        result.a42 = m.a32;
        result.a43 = 0.0f;
        result.a44 = 1.0f;
        return result;
    }

    public static boolean equals(IMatrix i_left, IMatrix i_right, float epsilon) {
        if (i_left.size() != i_right.size()) {
            return false;
        }
        int iSize = i_left.size();
        float[] a = new float[iSize];
        float[] b = new float[iSize];
        i_left.toArrayRowMajor(a);
        i_right.toArrayRowMajor(b);
        return Math3DMatrixOps.equals(a, b, epsilon);
    }

    public static Vector3f getSphericalCoordinates(IVector3f i_vector, Vector3f o_result) {
        double theta;
        double phi;
        if (o_result == null) {
            o_result = new Vector3fImpl();
        }
        float x = i_vector.getX();
        float y = i_vector.getY();
        float z = i_vector.getZ();
        double rho = i_vector.length();
        if (rho == 0.0) {
            return null;
        }
        double s = Math.sqrt(x * x + y * y);
        if (s != 0.0) {
            phi = Math.acos((double)z / rho);
            theta = x >= 0.0f ? Math.asin((double)y / s) : Math.PI - Math.asin((double)y / s);
        } else {
            phi = 0.0;
            theta = 0.0;
        }
        o_result.set((float)rho, (float)phi, (float)theta);
        return o_result;
    }

    public static Matrix4f rotate(float angle, IVector3f i_rotationAxis, IMatrix4f i_matrix, Matrix4f o_result) {
        Matrix4fImpl result;
        Matrix4fImpl m = Matrix4fImpl.cast(i_matrix);
        Vector3fImpl axis = new Vector3fImpl();
        if (o_result == null || o_result == m) {
            result = new Matrix4fImpl();
            if (o_result == null) {
                o_result = result;
            }
        } else {
            result = Matrix4fImpl.cast(o_result);
        }
        Math3DMatrixOps.normalise(i_rotationAxis, axis);
        float s = (float)Math.sin(angle);
        float c = (float)Math.cos(angle);
        float t = 1.0f - c;
        float sx = s * axis.x;
        float sy = s * axis.y;
        float sz = s * axis.z;
        float tx = t * axis.x;
        float txy = tx * axis.y;
        float txz = tx * axis.z;
        float ty = t * axis.y;
        float tyz = ty * axis.z;
        float rm11 = tx * axis.x + c;
        float rm12 = txy + sz;
        float rm13 = txz - sy;
        float rm21 = txy - sz;
        float rm22 = ty * axis.y + c;
        float rm23 = tyz + sx;
        float rm31 = txz + sy;
        float rm32 = tyz - sx;
        float rm33 = t * axis.z * axis.z + c;
        result.a11 = m.a11 * rm11 + m.a21 * rm12 + m.a31 * rm13;
        result.a12 = m.a12 * rm11 + m.a22 * rm12 + m.a32 * rm13;
        result.a13 = m.a13 * rm11 + m.a23 * rm12 + m.a33 * rm13;
        result.a14 = m.a14 * rm11 + m.a24 * rm12 + m.a34 * rm13;
        result.a21 = m.a11 * rm21 + m.a21 * rm22 + m.a31 * rm23;
        result.a22 = m.a12 * rm21 + m.a22 * rm22 + m.a32 * rm23;
        result.a23 = m.a13 * rm21 + m.a23 * rm22 + m.a33 * rm23;
        result.a24 = m.a14 * rm21 + m.a24 * rm22 + m.a34 * rm23;
        result.a31 = m.a11 * rm31 + m.a21 * rm32 + m.a31 * rm33;
        result.a32 = m.a12 * rm31 + m.a22 * rm32 + m.a32 * rm33;
        result.a33 = m.a13 * rm31 + m.a23 * rm32 + m.a33 * rm33;
        result.a34 = m.a14 * rm31 + m.a24 * rm32 + m.a34 * rm33;
        result.a41 = m.a41;
        result.a42 = m.a42;
        result.a43 = m.a43;
        result.a44 = m.a44;
        if (o_result != result) {
            o_result.set(result);
        }
        return result;
    }

    public static Vector3f rotationMatrixToEulerAngles(IMatrix4f i_matrix, Vector3f o_result) {
        if (o_result == null) {
            o_result = new Vector3fImpl();
        }
        if (i_matrix.get(0, 1) > 0.998f) {
            o_result.setX(0.0f);
            o_result.setY((float)Math.atan2(i_matrix.get(2, 0), i_matrix.get(2, 2)));
            o_result.setZ(1.5707964f);
        } else if (i_matrix.get(0, 1) < -0.998f) {
            o_result.setX(0.0f);
            o_result.setY((float)Math.atan2(i_matrix.get(2, 0), i_matrix.get(2, 2)));
            o_result.setZ(-1.5707964f);
        } else {
            o_result.setX((float)Math.atan2(-i_matrix.get(2, 1), i_matrix.get(1, 1)));
            o_result.setY((float)Math.atan2(-i_matrix.get(0, 2), i_matrix.get(0, 0)));
            o_result.setZ((float)Math.asin(i_matrix.get(0, 1)));
        }
        return o_result;
    }

    public static Matrix4f rotate(IVector3f i_angles, IMatrix4f i_matrix, Matrix4f o_result) {
        float xAngle;
        float zAngle;
        Matrix4f result = o_result;
        if (result == null) {
            result = new Matrix4fImpl();
        }
        result.set(i_matrix);
        float yAngle = i_angles.getY();
        if (yAngle != 0.0f) {
            Math3D.rotate(yAngle, IVector3f.Y_AXIS, result, result);
        }
        if ((zAngle = i_angles.getZ()) != 0.0f) {
            Math3D.rotate(zAngle, IVector3f.Z_AXIS, result, result);
        }
        if ((xAngle = i_angles.getX()) != 0.0f) {
            Math3D.rotate(xAngle, IVector3f.X_AXIS, result, result);
        }
        return result;
    }

    public static Vector3f rotate(IVector3f i_angles, IVector3f i_source, Vector3f o_result) {
        if (o_result == null) {
            o_result = new Vector3fImpl();
        }
        Matrix4f rotationMatrix = Math3DCache.getMatrix4f();
        try {
            Math3D.rotate(i_angles, IMatrix4f.IDENTITY, rotationMatrix);
            Math3D.transform(i_source, (IMatrix4f)rotationMatrix, o_result);
        }
        catch (Throwable throwable) {
            Math3DCache.returnMatrix4f(rotationMatrix);
            throw throwable;
        }
        Math3DCache.returnMatrix4f(rotationMatrix);
        return o_result;
    }

    public static Matrix3f scale(IVector2f i_scaleVector2f, IMatrix3f i_matrix, Matrix3f o_result) {
        Matrix3fImpl result;
        Matrix3fImpl m = Matrix3fImpl.cast(i_matrix);
        Vector2fImpl v = Vector2fImpl.cast(i_scaleVector2f);
        if (o_result == null) {
            result = new Matrix3fImpl();
            o_result = result;
        } else {
            result = Matrix3fImpl.cast(o_result);
        }
        result.a11 = m.a11 * v.x;
        result.a12 = m.a12 * v.x;
        result.a13 = m.a13 * v.x;
        result.a21 = m.a21 * v.y;
        result.a22 = m.a22 * v.y;
        result.a23 = m.a23 * v.y;
        result.a31 = m.a31;
        result.a32 = m.a32;
        result.a33 = m.a33;
        if (o_result != result) {
            o_result.set(result);
        }
        return result;
    }

    public static Matrix4f scale(IVector3f i_scaleVector3f, IMatrix4f i_matrix, Matrix4f o_result) {
        Matrix4fImpl result;
        Matrix4fImpl m = Matrix4fImpl.cast(i_matrix);
        Vector3fImpl v = Vector3fImpl.cast(i_scaleVector3f);
        if (o_result == null) {
            result = new Matrix4fImpl();
            o_result = result;
        } else {
            result = Matrix4fImpl.cast(o_result);
        }
        result.a11 = m.a11 * v.x;
        result.a12 = m.a12 * v.x;
        result.a13 = m.a13 * v.x;
        result.a14 = m.a14 * v.x;
        result.a21 = m.a21 * v.y;
        result.a22 = m.a22 * v.y;
        result.a23 = m.a23 * v.y;
        result.a24 = m.a24 * v.y;
        result.a31 = m.a31 * v.z;
        result.a32 = m.a32 * v.z;
        result.a33 = m.a33 * v.z;
        result.a34 = m.a34 * v.z;
        result.a41 = m.a41;
        result.a42 = m.a42;
        result.a43 = m.a43;
        result.a44 = m.a44;
        if (o_result != result) {
            o_result.set(result);
        }
        return result;
    }

    public static Vector2f transform(IVector2f i_vector, IMatrix3f i_matrix, Vector2f o_result) {
        Vector2fImpl result;
        Matrix3fImpl m = Matrix3fImpl.cast(i_matrix);
        Vector2fImpl v = Vector2fImpl.cast(i_vector);
        if (o_result == v || o_result == null) {
            result = new Vector2fImpl();
            if (o_result == null) {
                o_result = result;
            }
        } else {
            result = Vector2fImpl.cast(o_result);
        }
        float w = m.a13 * v.x + m.a23 * v.y + m.a33;
        result.x = (m.a11 * v.x + m.a21 * v.y + m.a31) / w;
        result.y = (m.a12 * v.x + m.a22 * v.y + m.a32) / w;
        if (o_result != result) {
            o_result.set(result);
        }
        return o_result;
    }

    public static Vector3f transform(IVector3f i_vector, IMatrix3f i_matrix, Vector3f o_result) {
        Vector3fImpl result;
        Matrix3fImpl m = Matrix3fImpl.cast(i_matrix);
        Vector3fImpl v = Vector3fImpl.cast(i_vector);
        if (o_result == v || o_result == null) {
            result = new Vector3fImpl();
            if (o_result == null) {
                o_result = result;
            }
        } else {
            result = Vector3fImpl.cast(o_result);
        }
        result.x = m.a11 * v.x + m.a21 * v.y + m.a31 * v.z;
        result.y = m.a12 * v.x + m.a22 * v.y + m.a32 * v.z;
        result.z = m.a13 * v.x + m.a23 * v.y + m.a33 * v.z;
        if (o_result != result) {
            o_result.set(result);
        }
        return result;
    }

    public static Vector3f transform(IVector3f i_vector, IMatrix4f i_matrix, Vector3f o_result) {
        Vector3fImpl result;
        Matrix4fImpl m = Matrix4fImpl.cast(i_matrix);
        Vector3fImpl v = Vector3fImpl.cast(i_vector);
        if (o_result == v || o_result == null) {
            result = new Vector3fImpl();
            if (o_result == null) {
                o_result = result;
            }
        } else {
            result = Vector3fImpl.cast(o_result);
        }
        float w = m.a14 * v.x + m.a24 * v.y + m.a34 * v.z + m.a44;
        result.x = (m.a11 * v.x + m.a21 * v.y + m.a31 * v.z + m.a41) / w;
        result.y = (m.a12 * v.x + m.a22 * v.y + m.a32 * v.z + m.a42) / w;
        result.z = (m.a13 * v.x + m.a23 * v.y + m.a33 * v.z + m.a43) / w;
        if (o_result != result) {
            o_result.set(result);
        }
        return o_result;
    }

    public static Vector4f transform(IVector4f i_vector, IMatrix4f i_matrix, Vector4f o_result) {
        Vector4fImpl result;
        Matrix4fImpl m = Matrix4fImpl.cast(i_matrix);
        Vector4fImpl v = Vector4fImpl.cast(i_vector);
        if (o_result == v || o_result == null) {
            result = new Vector4fImpl();
            if (o_result == null) {
                o_result = result;
            }
        } else {
            result = Vector4fImpl.cast(o_result);
        }
        result.x = m.a11 * v.x + m.a21 * v.y + m.a31 * v.z + m.a41 * v.w;
        result.y = m.a12 * v.x + m.a22 * v.y + m.a32 * v.z + m.a42 * v.w;
        result.z = m.a13 * v.x + m.a23 * v.y + m.a33 * v.z + m.a43 * v.w;
        result.w = m.a14 * v.x + m.a24 * v.y + m.a34 * v.z + m.a44 * v.w;
        if (o_result != result) {
            o_result.set(result);
        }
        return o_result;
    }

    public static Matrix3f translate(IMatrix3f i_source, IVector2f i_vector, Matrix3f o_result) {
        Matrix3fImpl result;
        Matrix3fImpl m = Matrix3fImpl.cast(i_source);
        Vector2fImpl v = Vector2fImpl.cast(i_vector);
        if (o_result == null) {
            result = new Matrix3fImpl(m);
            o_result = result;
        } else {
            result = Matrix3fImpl.cast(o_result);
            result.set(m);
        }
        result.a31 += v.x;
        result.a32 += v.y;
        if (o_result != result) {
            o_result.set(result);
        }
        return result;
    }

    public static Matrix4f translate(IMatrix4f i_source, IVector3f i_vector, Matrix4f o_result) {
        Matrix4fImpl result;
        Matrix4fImpl m = Matrix4fImpl.cast(i_source);
        Vector3fImpl v = Vector3fImpl.cast(i_vector);
        if (o_result == null) {
            result = new Matrix4fImpl(m);
            o_result = result;
        } else {
            result = Matrix4fImpl.cast(o_result);
            result.set(m);
        }
        result.a41 += v.x;
        result.a42 += v.y;
        result.a43 += v.z;
        if (o_result != result) {
            o_result.set(result);
        }
        return result;
    }
}

