/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.osgi.services.remoteserviceadmin;

import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.ecf.core.IContainer;
import org.eclipse.ecf.osgi.services.remoteserviceadmin.AbstractHostContainerSelector;
import org.eclipse.ecf.osgi.services.remoteserviceadmin.IHostContainerSelector;
import org.eclipse.ecf.osgi.services.remoteserviceadmin.SelectContainerException;
import org.eclipse.ecf.remoteservice.IRemoteServiceContainer;
import org.osgi.framework.ServiceReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HostContainerSelector
extends AbstractHostContainerSelector
implements IHostContainerSelector {
    private boolean autoCreateContainer = false;

    public HostContainerSelector(String[] defaultConfigTypes, boolean autoCreateContainer) {
        super(defaultConfigTypes);
        this.autoCreateContainer = autoCreateContainer;
    }

    @Override
    public synchronized IRemoteServiceContainer[] selectHostContainers(ServiceReference serviceReference, Map<String, Object> overridingProperties, String[] serviceExportedInterfaces, String[] serviceExportedConfigs, String[] serviceIntents) throws SelectContainerException {
        Collection rsContainers = this.selectExistingHostContainers(serviceReference, overridingProperties, serviceExportedInterfaces, serviceExportedConfigs, serviceIntents);
        if (rsContainers.size() == 0 && this.autoCreateContainer) {
            rsContainers = this.createAndConfigureHostContainers(serviceReference, overridingProperties, serviceExportedInterfaces, serviceExportedConfigs, serviceIntents);
            Object target = overridingProperties.get("ecf.endpoint.connecttarget.id");
            if (target != null) {
                Iterator i = rsContainers.iterator();
                while (i.hasNext()) {
                    IContainer container = ((IRemoteServiceContainer)i.next()).getContainer();
                    try {
                        this.connectHostContainer(serviceReference, overridingProperties, container, target);
                    }
                    catch (Exception e) {
                        this.logException("doConnectContainer failure containerID=" + container.getID() + " target=" + target, e);
                    }
                }
            }
        }
        return rsContainers.toArray(new IRemoteServiceContainer[0]);
    }

    public void close() {
    }
}

