/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.core;

import java.io.IOException;
import java.util.Collection;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.revwalk.filter.RevFilter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RevUtils {
    private RevUtils() {
    }

    public static RevCommit getCommonAncestor(Repository repo, AnyObjectId commit1, AnyObjectId commit2) throws IOException {
        Assert.isNotNull((Object)repo);
        Assert.isNotNull((Object)commit1);
        Assert.isNotNull((Object)commit2);
        RevWalk rw = new RevWalk(repo);
        rw.setRevFilter(RevFilter.MERGE_BASE);
        RevCommit srcRev = rw.lookupCommit(commit1);
        RevCommit dstRev = rw.lookupCommit(commit2);
        rw.markStart(dstRev);
        rw.markStart(srcRev);
        RevCommit result = rw.next();
        return result != null ? result : null;
    }

    public static boolean isContainedInAnyRef(Repository repo, ObjectId commitId, Collection<Ref> refs) throws IOException {
        for (Ref ref : refs) {
            if (!commitId.equals((AnyObjectId)ref.getObjectId())) continue;
            return true;
        }
        RevWalk walk = new RevWalk(repo);
        try {
            RevCommit commit = walk.parseCommit((AnyObjectId)commitId);
            for (Ref ref : refs) {
                RevCommit refCommit = walk.parseCommit((AnyObjectId)ref.getObjectId());
                boolean contained = walk.isMergedInto(commit, refCommit);
                if (!contained) continue;
                return true;
            }
        }
        finally {
            walk.dispose();
        }
        return false;
    }
}

