/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.core.synchronize;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.egit.core.synchronize.GitCommitsModelDirectionException;
import org.eclipse.jgit.lib.AbbreviatedObjectId;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.MutableObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevFlag;
import org.eclipse.jgit.revwalk.RevFlagSet;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.treewalk.AbstractTreeIterator;
import org.eclipse.jgit.treewalk.EmptyTreeIterator;
import org.eclipse.jgit.treewalk.TreeWalk;
import org.eclipse.jgit.treewalk.filter.AndTreeFilter;
import org.eclipse.jgit.treewalk.filter.TreeFilter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GitCommitsModelCache {
    public static final int ADDITION = 1;
    public static final int DELETION = 2;
    public static final int CHANGE = 3;
    public static final int LEFT = 4;
    public static final int RIGHT = 8;
    static final AbbreviatedObjectId ZERO_ID = AbbreviatedObjectId.fromObjectId((AnyObjectId)ObjectId.zeroId());

    public static List<Commit> build(Repository repo, ObjectId srcId, ObjectId dstId, TreeFilter pathFilter) throws IOException {
        if (dstId.equals((AnyObjectId)srcId)) {
            return new ArrayList<Commit>(0);
        }
        RevWalk rw = new RevWalk(repo);
        RevFlag localFlag = rw.newFlag("local");
        RevFlag remoteFlag = rw.newFlag("remote");
        RevFlagSet allFlags = new RevFlagSet();
        allFlags.add(localFlag);
        allFlags.add(remoteFlag);
        rw.carry((Collection)allFlags);
        RevCommit srcCommit = rw.parseCommit((AnyObjectId)srcId);
        srcCommit.add(localFlag);
        rw.markStart(srcCommit);
        srcCommit = null;
        RevCommit dstCommit = rw.parseCommit((AnyObjectId)dstId);
        dstCommit.add(remoteFlag);
        rw.markStart(dstCommit);
        dstCommit = null;
        if (pathFilter != null) {
            rw.setTreeFilter(pathFilter);
        }
        ArrayList<Commit> result = new ArrayList<Commit>();
        for (RevCommit revCommit : rw) {
            RevCommit parentCommit;
            RevCommit actualCommit;
            if (revCommit.hasAll(allFlags)) break;
            Commit commit = new Commit();
            commit.shortMessage = revCommit.getShortMessage();
            commit.commitId = AbbreviatedObjectId.fromObjectId((AnyObjectId)revCommit);
            commit.authorName = revCommit.getAuthorIdent().getName();
            commit.committerName = revCommit.getCommitterIdent().getName();
            commit.commitDate = revCommit.getAuthorIdent().getWhen();
            if (revCommit.has(localFlag)) {
                actualCommit = revCommit;
                parentCommit = GitCommitsModelCache.getParentCommit(revCommit);
                commit.direction = 8;
            } else if (revCommit.has(remoteFlag)) {
                actualCommit = GitCommitsModelCache.getParentCommit(revCommit);
                parentCommit = revCommit;
                commit.direction = 4;
            } else {
                throw new GitCommitsModelDirectionException();
            }
            commit.children = GitCommitsModelCache.getChangedObjects(repo, actualCommit, parentCommit, pathFilter, commit.direction);
            if (commit.children == null) continue;
            result.add(commit);
        }
        rw.dispose();
        return result;
    }

    private static RevCommit getParentCommit(RevCommit commit) {
        if (commit.getParents().length > 0) {
            return commit.getParents()[0];
        }
        return null;
    }

    private static Map<String, Change> getChangedObjects(Repository repo, RevCommit parentCommit, RevCommit remoteCommit, TreeFilter pathFilter, int direction) throws IOException {
        TreeWalk tw = new TreeWalk(repo);
        GitCommitsModelCache.addTreeFilter(tw, parentCommit);
        GitCommitsModelCache.addTreeFilter(tw, remoteCommit);
        tw.setRecursive(true);
        if (pathFilter == null) {
            tw.setFilter(TreeFilter.ANY_DIFF);
        } else {
            tw.setFilter(AndTreeFilter.create((TreeFilter)TreeFilter.ANY_DIFF, (TreeFilter)pathFilter));
        }
        int localTreeId = direction == 4 ? 1 : 0;
        int remoteTreeId = direction == 4 ? 0 : 1;
        HashMap<String, Change> result = new HashMap<String, Change>();
        AbbreviatedObjectId actualCommit = GitCommitsModelCache.getAbbreviatedObjectId(parentCommit);
        AbbreviatedObjectId remoteCommitAbb = GitCommitsModelCache.getAbbreviatedObjectId(remoteCommit);
        MutableObjectId idBuf = new MutableObjectId();
        while (tw.next()) {
            Change change = new Change();
            change.commitId = actualCommit;
            change.remoteCommitId = remoteCommitAbb;
            change.name = tw.getNameString();
            tw.getObjectId(idBuf, localTreeId);
            change.objectId = AbbreviatedObjectId.fromObjectId((AnyObjectId)idBuf);
            tw.getObjectId(idBuf, remoteTreeId);
            change.remoteObjectId = AbbreviatedObjectId.fromObjectId((AnyObjectId)idBuf);
            GitCommitsModelCache.calculateAndSetChangeKind(direction, change);
            result.put(tw.getPathString(), change);
        }
        tw.release();
        return result.size() > 0 ? result : null;
    }

    private static void addTreeFilter(TreeWalk tw, RevCommit commit) throws IOException {
        if (commit != null) {
            tw.addTree((AnyObjectId)commit.getTree());
        } else {
            tw.addTree((AbstractTreeIterator)new EmptyTreeIterator());
        }
    }

    private static AbbreviatedObjectId getAbbreviatedObjectId(RevCommit commit) {
        if (commit != null) {
            return AbbreviatedObjectId.fromObjectId((AnyObjectId)commit);
        }
        return ZERO_ID;
    }

    static void calculateAndSetChangeKind(int direction, Change change) {
        if (ZERO_ID.equals((Object)change.objectId)) {
            change.objectId = null;
            change.kind = direction == 4 ? direction | 1 : direction | 2;
        } else if (ZERO_ID.equals((Object)change.remoteObjectId)) {
            change.remoteObjectId = null;
            change.kind = direction == 4 ? direction | 2 : direction | 1;
        } else {
            change.kind = direction | 3;
        }
    }

    public static class Change {
        int kind;
        String name;
        AbbreviatedObjectId objectId;
        AbbreviatedObjectId commitId;
        AbbreviatedObjectId remoteCommitId;
        AbbreviatedObjectId remoteObjectId;

        Change() {
        }

        public int getKind() {
            return this.kind;
        }

        public String getName() {
            return this.name;
        }

        public AbbreviatedObjectId getCommitId() {
            return this.commitId;
        }

        public AbbreviatedObjectId getRemoteCommitId() {
            return this.remoteCommitId;
        }

        public AbbreviatedObjectId getObjectId() {
            return this.objectId;
        }

        public AbbreviatedObjectId getRemoteObjectId() {
            return this.remoteObjectId;
        }

        public int hashCode() {
            int result = 1;
            result = 31 * result + (this.objectId == null ? 0 : this.objectId.hashCode());
            result = 31 * result + (this.remoteObjectId == null ? 0 : this.remoteObjectId.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Change other = (Change)obj;
            if (this.objectId == null ? other.objectId != null : !this.objectId.equals((Object)other.objectId)) {
                return false;
            }
            return !(this.remoteObjectId == null ? other.remoteObjectId != null : !this.remoteObjectId.equals((Object)other.remoteObjectId));
        }

        public String toString() {
            StringBuilder change = new StringBuilder("Change(");
            if ((this.kind & 4) != 0) {
                change.append("OUTGOING ");
            } else {
                change.append("INCOMING ");
            }
            if ((this.kind & 1) != 0) {
                change.append("ADDITION ");
            } else if ((this.kind & 2) != 0) {
                change.append("DELETION ");
            } else {
                change.append("CHANGE ");
            }
            change.append(this.name);
            change.append(";\n\tcurrent objectId: ");
            change.append(this.getObjectId(this.objectId));
            change.append(";\n\tparent objectId: ");
            change.append(this.getObjectId(this.remoteObjectId));
            change.append(";\n\tcurrent commit: ");
            change.append(this.getObjectId(this.commitId));
            change.append(";\n\tparent commit: ");
            change.append(this.remoteCommitId.toObjectId().getName());
            change.append("\n)");
            return change.toString();
        }

        private String getObjectId(AbbreviatedObjectId object) {
            if (object != null) {
                return object.toObjectId().getName();
            }
            return ObjectId.zeroId().getName();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Commit {
        private int direction;
        private String shortMessage;
        private AbbreviatedObjectId commitId;
        private Date commitDate;
        private String authorName;
        private String committerName;
        private Map<String, Change> children;

        private Commit() {
        }

        public int getDirection() {
            return this.direction;
        }

        public AbbreviatedObjectId getId() {
            return this.commitId;
        }

        public String getAuthorName() {
            return this.authorName;
        }

        public String getCommitterName() {
            return this.committerName;
        }

        public Date getCommitDate() {
            return this.commitDate;
        }

        public String getShortMessage() {
            return this.shortMessage;
        }

        public Map<String, Change> getChildren() {
            return this.children;
        }

        public void dispose() {
            this.children.clear();
        }
    }
}

