/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.actions;

import org.eclipse.compare.CompareEditorInput;
import org.eclipse.compare.CompareUI;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.egit.ui.Activator;
import org.eclipse.egit.ui.internal.actions.RepositoryActionHandler;
import org.eclipse.egit.ui.internal.merge.GitMergeEditorInput;
import org.eclipse.egit.ui.internal.merge.MergeModeDialog;
import org.eclipse.jgit.lib.Repository;

public class MergeToolActionHandler
extends RepositoryActionHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        GitMergeEditorInput input;
        int mergeMode = Activator.getDefault().getPreferenceStore().getInt("merge_mode");
        if (mergeMode == 0) {
            MergeModeDialog dlg = new MergeModeDialog(this.getShell(event));
            if (dlg.open() != 0) {
                return null;
            }
            input = new GitMergeEditorInput(dlg.useWorkspace(), this.getSelectedResources(event));
        } else {
            boolean useWorkspace = mergeMode == 1;
            input = new GitMergeEditorInput(useWorkspace, this.getSelectedResources(event));
        }
        CompareUI.openCompareEditor((CompareEditorInput)input);
        return null;
    }

    public boolean isEnabled() {
        Repository[] repos = this.getRepositoriesFor(this.getProjectsForSelectedResources());
        if (repos.length != 1) {
            return false;
        }
        switch (repos[0].getRepositoryState()) {
            case MERGING: 
            case CHERRY_PICKING: 
            case REBASING: 
            case REBASING_REBASING: 
            case REBASING_MERGE: 
            case REBASING_INTERACTIVE: {
                return true;
            }
        }
        return false;
    }
}

