/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.fetch;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.TreeSet;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.egit.core.op.CreateLocalBranchOperation;
import org.eclipse.egit.core.op.ListRemoteOperation;
import org.eclipse.egit.core.op.TagOperation;
import org.eclipse.egit.ui.Activator;
import org.eclipse.egit.ui.UIText;
import org.eclipse.egit.ui.UIUtils;
import org.eclipse.egit.ui.internal.branch.BranchOperationUI;
import org.eclipse.egit.ui.internal.fetch.FetchOperationUI;
import org.eclipse.jface.bindings.keys.KeyStroke;
import org.eclipse.jface.bindings.keys.ParseException;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.fieldassist.ContentProposalAdapter;
import org.eclipse.jface.fieldassist.IContentProposal;
import org.eclipse.jface.fieldassist.IContentProposalProvider;
import org.eclipse.jface.fieldassist.IControlContentAdapter;
import org.eclipse.jface.fieldassist.TextContentAdapter;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.Config;
import org.eclipse.jgit.lib.PersonIdent;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.TagBuilder;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevObject;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.transport.FetchResult;
import org.eclipse.jgit.transport.RefSpec;
import org.eclipse.jgit.transport.RemoteConfig;
import org.eclipse.jgit.transport.URIish;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FetchGerritChangePage
extends WizardPage {
    private static final String FETCH_GERRIT_CHANGE_PAGE_SECTION = "FetchGerritChangePage";
    private static final String LAST_URI_POSTFIX = ".lastUri";
    private final Repository repository;
    private final IDialogSettings settings;
    private final String lastUriKey;
    private Combo uriCombo;
    private List<Change> changeRefs;
    private Text refText;
    private Button createBranch;
    private Button createTag;
    private Button checkout;
    private Button dontCheckout;
    private Label tagTextlabel;
    private Text tagText;
    private Label branchTextlabel;
    private Text branchText;
    private String refName;
    private Composite warningAdditionalRefNotActive;
    private Button activateAdditionalRefs;

    public FetchGerritChangePage(Repository repository, String refName) {
        super(FetchGerritChangePage.class.getName());
        this.repository = repository;
        this.refName = refName;
        this.setTitle(NLS.bind((String)UIText.FetchGerritChangePage_PageTitle, (Object)Activator.getDefault().getRepositoryUtil().getRepositoryName(repository)));
        this.setMessage(UIText.FetchGerritChangePage_PageMessage);
        this.settings = this.getDialogSettings();
        this.lastUriKey = repository + LAST_URI_POSTFIX;
    }

    protected IDialogSettings getDialogSettings() {
        IDialogSettings s = Activator.getDefault().getDialogSettings();
        IDialogSettings section = s.getSection(FETCH_GERRIT_CHANGE_PAGE_SECTION);
        if (section == null) {
            section = s.addNewSection(FETCH_GERRIT_CHANGE_PAGE_SECTION);
        }
        return section;
    }

    public void createControl(Composite parent) {
        Composite main = new Composite(parent, 0);
        main.setLayout((Layout)new GridLayout(2, false));
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)main);
        new Label(main, 0).setText(UIText.FetchGerritChangePage_UriLabel);
        this.uriCombo = new Combo(main, 4);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.uriCombo);
        this.uriCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FetchGerritChangePage.this.changeRefs = null;
            }
        });
        new Label(main, 0).setText(UIText.FetchGerritChangePage_ChangeLabel);
        this.refText = new Text(main, 2048);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.refText);
        this.addRefContentProposalToText(this.refText);
        Group checkoutGroup = new Group(main, 16);
        checkoutGroup.setLayout((Layout)new GridLayout(2, false));
        GridDataFactory.fillDefaults().span(2, 1).grab(true, true).applyTo((Control)checkoutGroup);
        checkoutGroup.setText(UIText.FetchGerritChangePage_AfterFetchGroup);
        this.createBranch = new Button((Composite)checkoutGroup, 16);
        GridDataFactory.fillDefaults().span(2, 1).applyTo((Control)this.createBranch);
        this.createBranch.setText(UIText.FetchGerritChangePage_LocalBranchRadio);
        this.createBranch.setSelection(true);
        this.createBranch.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FetchGerritChangePage.this.checkPage();
            }
        });
        this.branchTextlabel = new Label((Composite)checkoutGroup, 0);
        GridDataFactory.defaultsFor((Control)this.branchTextlabel).exclude(false).applyTo((Control)this.branchTextlabel);
        this.branchTextlabel.setText(UIText.FetchGerritChangePage_BranchNameText);
        this.branchText = new Text((Composite)checkoutGroup, 2052);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.branchText);
        this.branchText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                FetchGerritChangePage.this.checkPage();
            }
        });
        this.createTag = new Button((Composite)checkoutGroup, 16);
        GridDataFactory.fillDefaults().span(2, 1).applyTo((Control)this.createTag);
        this.createTag.setText(UIText.FetchGerritChangePage_TagRadio);
        this.createTag.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FetchGerritChangePage.this.checkPage();
            }
        });
        this.tagTextlabel = new Label((Composite)checkoutGroup, 0);
        GridDataFactory.defaultsFor((Control)this.tagTextlabel).exclude(true).applyTo((Control)this.tagTextlabel);
        this.tagTextlabel.setText(UIText.FetchGerritChangePage_TagNameText);
        this.tagText = new Text((Composite)checkoutGroup, 2052);
        GridDataFactory.fillDefaults().exclude(true).grab(true, false).applyTo((Control)this.tagText);
        this.tagText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                FetchGerritChangePage.this.checkPage();
            }
        });
        this.checkout = new Button((Composite)checkoutGroup, 16);
        GridDataFactory.fillDefaults().span(2, 1).applyTo((Control)this.checkout);
        this.checkout.setText(UIText.FetchGerritChangePage_CheckoutRadio);
        this.checkout.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FetchGerritChangePage.this.checkPage();
            }
        });
        this.dontCheckout = new Button((Composite)checkoutGroup, 16);
        GridDataFactory.fillDefaults().span(2, 1).applyTo((Control)this.checkout);
        this.dontCheckout.setText(UIText.FetchGerritChangePage_UpdateRadio);
        this.dontCheckout.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FetchGerritChangePage.this.checkPage();
            }
        });
        this.warningAdditionalRefNotActive = new Composite(main, 0);
        GridDataFactory.fillDefaults().span(2, 1).grab(true, false).exclude(true).applyTo((Control)this.warningAdditionalRefNotActive);
        this.warningAdditionalRefNotActive.setLayout((Layout)new GridLayout(2, false));
        this.warningAdditionalRefNotActive.setVisible(false);
        this.activateAdditionalRefs = new Button(this.warningAdditionalRefNotActive, 32);
        this.activateAdditionalRefs.setText(UIText.FetchGerritChangePage_ActivateAdditionalRefsButton);
        this.activateAdditionalRefs.setToolTipText(UIText.FetchGerritChangePage_ActivateAdditionalRefsTooltip);
        this.refText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                Change change = Change.fromRef(FetchGerritChangePage.this.refText.getText());
                if (change != null) {
                    FetchGerritChangePage.this.branchText.setText(NLS.bind((String)UIText.FetchGerritChangePage_SuggestedRefNamePattern, (Object)change.getChangeNumber(), (Object)change.getPatchSetNumber()));
                    FetchGerritChangePage.this.tagText.setText(FetchGerritChangePage.this.branchText.getText());
                } else {
                    FetchGerritChangePage.this.branchText.setText("");
                    FetchGerritChangePage.this.tagText.setText("");
                }
                FetchGerritChangePage.this.checkPage();
            }
        });
        TreeSet<String> uris = new TreeSet<String>();
        try {
            for (RemoteConfig rc : RemoteConfig.getAllRemoteConfigs((Config)this.repository.getConfig())) {
                if (rc.getURIs().size() > 0) {
                    uris.add(((URIish)rc.getURIs().get(0)).toPrivateString());
                }
                for (URIish u : rc.getPushURIs()) {
                    uris.add(u.toPrivateString());
                }
            }
        }
        catch (URISyntaxException e) {
            Activator.handleError(e.getMessage(), e, false);
            this.setErrorMessage(e.getMessage());
        }
        for (String aUri : uris) {
            this.uriCombo.add(aUri);
        }
        this.selectLastUsedUri();
        this.refText.setFocus();
        Dialog.applyDialogFont((Control)main);
        this.setControl((Control)main);
        this.setPageComplete(false);
    }

    private void storeLastUsedUri(String uri) {
        this.settings.put(this.lastUriKey, uri.trim());
    }

    private void selectLastUsedUri() {
        int i;
        String lastUri = this.settings.get(this.lastUriKey);
        if (lastUri != null && (i = this.uriCombo.indexOf(lastUri)) != -1) {
            this.uriCombo.select(i);
            return;
        }
        this.uriCombo.select(0);
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible && this.refName != null) {
            this.refText.setText(this.refName);
        }
    }

    private void checkPage() {
        block11: {
            block10: {
                boolean createTagSelected;
                boolean createBranchSelected;
                block9: {
                    boolean emptyRefName;
                    block8: {
                        block7: {
                            createBranchSelected = this.createBranch.getSelection();
                            this.branchText.setEnabled(createBranchSelected);
                            this.branchText.setVisible(createBranchSelected);
                            this.branchTextlabel.setVisible(createBranchSelected);
                            GridData gd = (GridData)this.branchText.getLayoutData();
                            gd.exclude = !createBranchSelected;
                            gd = (GridData)this.branchTextlabel.getLayoutData();
                            gd.exclude = !createBranchSelected;
                            createTagSelected = this.createTag.getSelection();
                            this.tagText.setEnabled(createTagSelected);
                            this.tagText.setVisible(createTagSelected);
                            this.tagTextlabel.setVisible(createTagSelected);
                            gd = (GridData)this.tagText.getLayoutData();
                            gd.exclude = !createTagSelected;
                            gd = (GridData)this.tagTextlabel.getLayoutData();
                            gd.exclude = !createTagSelected;
                            this.branchText.getParent().layout(true);
                            boolean showActivateAdditionalRefs = false;
                            showActivateAdditionalRefs = (this.checkout.getSelection() || this.dontCheckout.getSelection()) && !Activator.getDefault().getPreferenceStore().getBoolean("resourcehistory_show_additionalrefs");
                            gd = (GridData)this.warningAdditionalRefNotActive.getLayoutData();
                            gd.exclude = !showActivateAdditionalRefs;
                            this.warningAdditionalRefNotActive.setVisible(showActivateAdditionalRefs);
                            this.warningAdditionalRefNotActive.getParent().layout(true);
                            this.setErrorMessage(null);
                            if (this.refText.getText().length() <= 0) break block7;
                            Change change = Change.fromRef(this.refText.getText());
                            if (change != null) break block8;
                            this.setErrorMessage(UIText.FetchGerritChangePage_MissingChangeMessage);
                            this.setPageComplete(this.getErrorMessage() == null);
                            return;
                        }
                        this.setErrorMessage(UIText.FetchGerritChangePage_MissingChangeMessage);
                        this.setPageComplete(this.getErrorMessage() == null);
                        return;
                    }
                    boolean bl = emptyRefName = createBranchSelected && this.branchText.getText().length() == 0 || createTagSelected && this.tagText.getText().length() == 0;
                    if (!emptyRefName) break block9;
                    this.setErrorMessage(UIText.FetchGerritChangePage_ProvideRefNameMessage);
                    this.setPageComplete(this.getErrorMessage() == null);
                    return;
                }
                try {
                    boolean existingRefName;
                    boolean bl = existingRefName = createBranchSelected && this.repository.getRef(this.branchText.getText()) != null || createTagSelected && this.repository.getRef(this.tagText.getText()) != null;
                    if (!existingRefName) break block10;
                    this.setErrorMessage(NLS.bind((String)UIText.FetchGerritChangePage_ExistingRefMessage, (Object)this.branchText.getText()));
                }
                catch (IOException iOException) {
                    try {}
                    catch (Throwable throwable) {
                        this.setPageComplete(this.getErrorMessage() == null);
                        throw throwable;
                    }
                    this.setPageComplete(this.getErrorMessage() == null);
                    break block11;
                }
                this.setPageComplete(this.getErrorMessage() == null);
                return;
            }
            this.setPageComplete(this.getErrorMessage() == null);
        }
    }

    private List<Change> getRefsForContentAssist() throws InvocationTargetException, InterruptedException {
        if (this.changeRefs == null) {
            final String uriText = this.uriCombo.getText();
            this.getWizard().getContainer().run(true, true, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    ListRemoteOperation listOp;
                    try {
                        listOp = new ListRemoteOperation(FetchGerritChangePage.this.repository, new URIish(uriText), Activator.getDefault().getPreferenceStore().getInt("remote_connection_timeout"));
                    }
                    catch (URISyntaxException e) {
                        throw new InvocationTargetException(e);
                    }
                    listOp.run(monitor);
                    FetchGerritChangePage.this.changeRefs = new ArrayList();
                    for (Ref ref : listOp.getRemoteRefs()) {
                        Change change = Change.fromRef(ref.getName());
                        if (change == null) continue;
                        FetchGerritChangePage.this.changeRefs.add(change);
                    }
                    Collections.sort(FetchGerritChangePage.this.changeRefs, new Comparator<Change>(){

                        @Override
                        public int compare(Change o1, Change o2) {
                            int changeDiff = o2.changeNumber.compareTo(o1.changeNumber);
                            if (changeDiff == 0) {
                                changeDiff = o2.getPatchSetNumber().compareTo(o1.getPatchSetNumber());
                            }
                            return changeDiff;
                        }
                    });
                }
            });
        }
        return this.changeRefs;
    }

    boolean doFetch() {
        try {
            final RefSpec spec = new RefSpec().setSource(this.refText.getText()).setDestination("FETCH_HEAD");
            final String uri = this.uriCombo.getText();
            final boolean doCheckout = this.checkout.getSelection();
            final boolean doCreateTag = this.createTag.getSelection();
            final boolean doCreateBranch = this.createBranch.getSelection();
            final boolean doActivateAdditionalRefs = (this.checkout.getSelection() || this.dontCheckout.getSelection()) && this.activateAdditionalRefs.getSelection();
            final String textForTag = this.tagText.getText();
            final String textForBranch = this.branchText.getText();
            this.getWizard().getContainer().run(true, true, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    int totalWork = 1;
                    if (doCheckout) {
                        ++totalWork;
                    }
                    if (doCreateTag || doCreateBranch) {
                        ++totalWork;
                    }
                    monitor.beginTask(UIText.FetchGerritChangePage_GetChangeTaskName, totalWork);
                    ArrayList<RefSpec> specs = new ArrayList<RefSpec>(1);
                    specs.add(spec);
                    int timeout = Activator.getDefault().getPreferenceStore().getInt("remote_connection_timeout");
                    try {
                        try {
                            String taskName = NLS.bind((String)UIText.FetchGerritChangePage_FetchingTaskName, (Object)spec.getSource());
                            monitor.setTaskName(taskName);
                            FetchResult fetchRes = new FetchOperationUI(FetchGerritChangePage.this.repository, new URIish(uri), specs, timeout, false).execute(monitor);
                            monitor.worked(1);
                            RevCommit commit = new RevWalk(FetchGerritChangePage.this.repository).parseCommit((AnyObjectId)fetchRes.getAdvertisedRef(spec.getSource()).getObjectId());
                            if (doCreateTag) {
                                monitor.setTaskName(UIText.FetchGerritChangePage_CreatingTagTaskName);
                                TagBuilder tag = new TagBuilder();
                                PersonIdent personIdent = new PersonIdent(FetchGerritChangePage.this.repository);
                                tag.setTag(textForTag);
                                tag.setTagger(personIdent);
                                tag.setMessage(NLS.bind((String)UIText.FetchGerritChangePage_GeneratedTagMessage, (Object)spec.getSource()));
                                tag.setObjectId((RevObject)commit);
                                new TagOperation(FetchGerritChangePage.this.repository, tag, false).execute(monitor);
                                monitor.worked(1);
                            }
                            if (doCreateBranch) {
                                monitor.setTaskName(UIText.FetchGerritChangePage_CreatingBranchTaskName);
                                CreateLocalBranchOperation bop = new CreateLocalBranchOperation(FetchGerritChangePage.this.repository, textForBranch, commit);
                                bop.execute(monitor);
                                new Git(FetchGerritChangePage.this.repository).checkout().setName(textForBranch).call();
                                monitor.worked(1);
                            }
                            if (doCheckout || doCreateTag) {
                                monitor.setTaskName(UIText.FetchGerritChangePage_CheckingOutTaskName);
                                BranchOperationUI.checkout(FetchGerritChangePage.this.repository, commit.name()).run(monitor);
                                monitor.worked(1);
                            }
                            if (doActivateAdditionalRefs) {
                                FetchGerritChangePage.this.getContainer().getShell().getDisplay().asyncExec(new Runnable(){

                                    public void run() {
                                        Activator.getDefault().getPreferenceStore().setValue("resourcehistory_show_additionalrefs", true);
                                    }
                                });
                            }
                            FetchGerritChangePage.this.storeLastUsedUri(uri);
                        }
                        catch (RuntimeException e) {
                            throw e;
                        }
                        catch (Exception e) {
                            throw new InvocationTargetException(e);
                        }
                    }
                    finally {
                        monitor.done();
                    }
                }
            });
        }
        catch (InvocationTargetException e) {
            Activator.handleError(e.getCause().getMessage(), e.getCause(), true);
            return false;
        }
        catch (InterruptedException interruptedException) {}
        return true;
    }

    private void addRefContentProposalToText(Text textField) {
        KeyStroke stroke;
        try {
            stroke = KeyStroke.getInstance((String)"CTRL+SPACE");
            UIUtils.addBulbDecorator((Control)textField, NLS.bind((String)UIText.FetchGerritChangePage_ContentAssistTooltip, (Object)stroke.format()));
        }
        catch (ParseException e1) {
            Activator.handleError(e1.getMessage(), e1, false);
            stroke = null;
        }
        IContentProposalProvider cp = new IContentProposalProvider(){

            public IContentProposal[] getProposals(String contents, int position) {
                List proposals;
                Pattern pattern;
                ArrayList<ChangeContentProposal> resultList = new ArrayList<ChangeContentProposal>();
                String patternString = contents;
                while (patternString.length() > 0 && patternString.charAt(0) == ' ') {
                    patternString = patternString.substring(1);
                }
                patternString = Pattern.quote(patternString);
                if (!(patternString = patternString.replaceAll("\\x2A", ".*")).endsWith(".*")) {
                    patternString = String.valueOf(patternString) + ".*";
                }
                try {
                    pattern = Pattern.compile(patternString, 2);
                }
                catch (PatternSyntaxException patternSyntaxException) {
                    pattern = null;
                }
                try {
                    proposals = FetchGerritChangePage.this.getRefsForContentAssist();
                }
                catch (InvocationTargetException e) {
                    Activator.handleError(e.getMessage(), e, false);
                    return null;
                }
                catch (InterruptedException interruptedException) {
                    return null;
                }
                if (proposals != null) {
                    for (Change ref : proposals) {
                        if (pattern != null && !pattern.matcher(ref.getChangeNumber().toString()).matches()) continue;
                        ChangeContentProposal propsal = new ChangeContentProposal(ref);
                        resultList.add(propsal);
                    }
                }
                return resultList.toArray(new IContentProposal[resultList.size()]);
            }
        };
        ContentProposalAdapter adapter = new ContentProposalAdapter((Control)textField, (IControlContentAdapter)new TextContentAdapter(), cp, stroke, null);
        adapter.setProposalAcceptanceStyle(2);
    }

    private static final class Change {
        private final String refName;
        private final Integer changeNumber;
        private final Integer patchSetNumber;

        static Change fromRef(String refName) {
            String[] tokens;
            block6: {
                block5: {
                    if (refName.startsWith("refs/changes/")) break block5;
                    return null;
                }
                tokens = refName.substring(13).split("/");
                if (tokens.length == 3) break block6;
                return null;
            }
            try {
                Integer changeNumber = Integer.valueOf(tokens[1]);
                Integer patchSetNumber = Integer.valueOf(tokens[2]);
                return new Change(refName, changeNumber, patchSetNumber);
            }
            catch (NumberFormatException numberFormatException) {
                return null;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                return null;
            }
        }

        private Change(String refName, Integer changeNumber, Integer patchSetNumber) {
            this.refName = refName;
            this.changeNumber = changeNumber;
            this.patchSetNumber = patchSetNumber;
        }

        public String getRefName() {
            return this.refName;
        }

        public Integer getChangeNumber() {
            return this.changeNumber;
        }

        public Integer getPatchSetNumber() {
            return this.patchSetNumber;
        }

        public String toString() {
            return this.refName;
        }
    }

    private static final class ChangeContentProposal
    implements IContentProposal {
        private final Change myChange;

        ChangeContentProposal(Change change) {
            this.myChange = change;
        }

        public String getContent() {
            return this.myChange.getRefName();
        }

        public int getCursorPosition() {
            return 0;
        }

        public String getDescription() {
            return NLS.bind((String)UIText.FetchGerritChangePage_ContentAssistDescription, (Object)this.myChange.getPatchSetNumber(), (Object)this.myChange.getChangeNumber());
        }

        public String getLabel() {
            return NLS.bind((String)"{0} - {1}", (Object)this.myChange.getChangeNumber(), (Object)this.myChange.getPatchSetNumber());
        }

        public String toString() {
            return this.getContent();
        }
    }
}

