/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.spi.common.id;

import java.io.IOException;
import java.util.Arrays;
import org.eclipse.emf.cdo.common.id.CDOIDUtil;
import org.eclipse.emf.cdo.spi.common.id.AbstractCDOID;
import org.eclipse.net4j.util.CheckUtil;
import org.eclipse.net4j.util.io.ExtendedDataInput;
import org.eclipse.net4j.util.io.ExtendedDataOutput;

public abstract class AbstractCDOIDByteArray
extends AbstractCDOID {
    public static final String NULL_VALUE = null;
    private static final long serialVersionUID = 1L;
    private byte[] value;

    public AbstractCDOIDByteArray() {
    }

    public AbstractCDOIDByteArray(byte[] value) {
        CheckUtil.checkArg((value != null && value.length == 16 ? 1 : 0) != 0, (String)"Illegal UUID value");
        this.value = value;
    }

    public byte[] getByteArrayValue() {
        return this.value;
    }

    public String toURIFragment() {
        return CDOIDUtil.encodeUUID(this.value);
    }

    public void read(String fragmentPart) {
        this.value = CDOIDUtil.decodeUUID(fragmentPart);
    }

    public void read(ExtendedDataInput in) throws IOException {
        this.value = in.readByteArray();
    }

    public void write(ExtendedDataOutput out) throws IOException {
        out.writeByteArray(this.value);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && obj.getClass() == this.getClass()) {
            AbstractCDOIDByteArray that = (AbstractCDOIDByteArray)obj;
            return Arrays.equals(this.value, that.value);
        }
        return false;
    }

    public int hashCode() {
        return this.getClass().hashCode() ^ Arrays.hashCode(this.value);
    }
}

