/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.spi.common.revision;

import java.text.MessageFormat;
import org.eclipse.emf.cdo.common.branch.CDOBranch;
import org.eclipse.emf.cdo.common.branch.CDOBranchPoint;
import org.eclipse.emf.cdo.common.model.CDOClassInfo;
import org.eclipse.emf.cdo.common.model.CDOModelUtil;
import org.eclipse.emf.cdo.common.revision.CDORevision;
import org.eclipse.emf.cdo.common.revision.CDORevisionData;
import org.eclipse.emf.cdo.common.util.CDOCommonUtil;
import org.eclipse.emf.cdo.internal.common.messages.Messages;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDORevision;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.net4j.util.ObjectUtil;

public abstract class AbstractCDORevision
implements InternalCDORevision {
    private CDOClassInfo classInfo;

    protected AbstractCDORevision(EClass eClass) {
        if (eClass != null) {
            if (eClass.isAbstract()) {
                throw new IllegalArgumentException(MessageFormat.format(Messages.getString("AbstractCDORevision.0"), eClass));
            }
            this.classInfo = CDOModelUtil.getClassInfo(eClass);
        }
    }

    public CDOClassInfo getClassInfo() {
        return this.classInfo;
    }

    public EClass getEClass() {
        CDOClassInfo classInfo = this.getClassInfo();
        if (classInfo != null) {
            return classInfo.getEClass();
        }
        return null;
    }

    public boolean isResourceNode() {
        return this.getClassInfo().isResourceNode();
    }

    public boolean isResourceFolder() {
        return this.getClassInfo().isResourceFolder();
    }

    public boolean isResource() {
        return this.getClassInfo().isResource();
    }

    public CDORevisionData data() {
        return this;
    }

    public CDORevision revision() {
        return this;
    }

    public boolean isHistorical() {
        return this.getRevised() != 0L;
    }

    public boolean isValid(long timeStamp) {
        long startTime = this.getTimeStamp();
        long endTime = this.getRevised();
        return CDOCommonUtil.isValidTimeStamp(timeStamp, startTime, endTime);
    }

    public boolean isValid(CDOBranchPoint branchPoint) {
        return this.getBranch() == branchPoint.getBranch() && this.isValid(branchPoint.getTimeStamp());
    }

    public boolean isReadable() {
        return this.getPermission().isReadable();
    }

    public boolean isWritable() {
        return this.getPermission().isWritable();
    }

    public void adjustForCommit(CDOBranch branch, long timeStamp) {
        if (ObjectUtil.equals((Object)branch, (Object)this.getBranch())) {
            this.setVersion(this.getVersion() + 1);
        } else {
            this.setVersion(1);
        }
        this.setBranchPoint(branch.getPoint(timeStamp));
        this.setRevised(0L);
    }

    public int hashCode() {
        return this.getID().hashCode() ^ this.getBranch().hashCode() ^ this.getVersion();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof CDORevision) {
            CDORevision that = (CDORevision)obj;
            return this.getID().equals(that.getID()) && this.getBranch().equals(that.getBranch()) && this.getVersion() == that.getVersion();
        }
        return false;
    }

    public String toString() {
        EClass eClass = this.getEClass();
        String name = eClass == null ? "Revision" : eClass.getName();
        CDOBranch branch = this.getBranch();
        if (branch == null) {
            return String.valueOf(name) + "@" + this.getID() + "v" + this.getVersion();
        }
        return String.valueOf(name) + "@" + this.getID() + ":" + branch.getID() + "v" + this.getVersion();
    }

    protected void setClassInfo(CDOClassInfo classInfo) {
        this.classInfo = classInfo;
    }

    protected EStructuralFeature[] getAllPersistentFeatures() {
        return this.classInfo.getAllPersistentFeatures();
    }

    protected int getFeatureIndex(EStructuralFeature feature) {
        return this.classInfo.getFeatureIndex(feature);
    }
}

