/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.internal.location;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.cdo.common.branch.CDOBranch;
import org.eclipse.emf.cdo.location.ICheckoutSource;
import org.eclipse.emf.cdo.location.IRepositoryLocation;
import org.eclipse.emf.cdo.session.CDOSession;
import org.eclipse.emf.cdo.session.CDOSessionConfiguration;
import org.eclipse.net4j.util.collection.Closeable;
import org.eclipse.net4j.util.container.Container;
import org.eclipse.net4j.util.container.ISlow;
import org.eclipse.net4j.util.io.IOUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BranchCheckoutSource
extends Container<BranchCheckoutSource>
implements ICheckoutSource,
ISlow {
    private BranchCheckoutSource parent;
    private String name;
    private List<BranchCheckoutSource> subBranches;

    public BranchCheckoutSource(BranchCheckoutSource parent, String name) {
        this.parent = parent;
        this.name = name;
        this.activate();
    }

    @Override
    public IRepositoryLocation getRepositoryLocation() {
        return this.parent.getRepositoryLocation();
    }

    @Override
    public String getBranchPath() {
        if (this.parent != null) {
            return String.valueOf(this.parent.getBranchPath()) + "/" + this.name;
        }
        return this.name;
    }

    @Override
    public long getTimeStamp() {
        return 0L;
    }

    public synchronized BranchCheckoutSource[] getElements() {
        if (this.subBranches == null) {
            this.subBranches = new ArrayList<BranchCheckoutSource>();
            CDOSessionConfiguration config = this.getRepositoryLocation().createSessionConfiguration();
            CDOSession session = config.openSession();
            if (session.getRepositoryInfo().isSupportingBranches()) {
                try {
                    CDOBranch[] branches;
                    CDOBranch branch = session.getBranchManager().getBranch(this.getBranchPath());
                    CDOBranch[] cDOBranchArray = branches = branch.getBranches();
                    int n = branches.length;
                    int n2 = 0;
                    while (n2 < n) {
                        CDOBranch subBranch = cDOBranchArray[n2];
                        this.subBranches.add(new BranchCheckoutSource(this, subBranch.getName()));
                        ++n2;
                    }
                }
                finally {
                    IOUtil.close((Closeable)session);
                }
            }
        }
        return this.subBranches.toArray(new BranchCheckoutSource[this.subBranches.size()]);
    }

    public String toString() {
        return this.name;
    }

    public static class Main
    extends BranchCheckoutSource {
        private IRepositoryLocation location;

        public Main(IRepositoryLocation location) {
            super(null, "MAIN");
            this.location = location;
        }

        public IRepositoryLocation getRepositoryLocation() {
            return this.location;
        }
    }
}

