/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.internal.net4j;

import java.util.Set;
import org.eclipse.emf.cdo.common.CDOCommonRepository;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.internal.net4j.CDONet4jSessionImpl;
import org.eclipse.emf.cdo.net4j.CDONet4jSession;
import org.eclipse.emf.cdo.net4j.CDOSession;
import org.eclipse.emf.cdo.net4j.CDOSessionConfiguration;
import org.eclipse.emf.cdo.session.CDORepositoryInfo;
import org.eclipse.emf.internal.cdo.session.CDOSessionConfigurationImpl;
import org.eclipse.emf.spi.cdo.CDOSessionProtocol;
import org.eclipse.emf.spi.cdo.InternalCDOSession;
import org.eclipse.net4j.connector.IConnector;
import org.eclipse.net4j.util.CheckUtil;
import org.eclipse.net4j.util.io.IStreamWrapper;

public class CDONet4jSessionConfigurationImpl
extends CDOSessionConfigurationImpl
implements CDOSessionConfiguration {
    private String repositoryName;
    private IConnector connector;
    private IStreamWrapper streamWrapper;
    private long signalTimeout = 10000L;

    public String getRepositoryName() {
        return this.repositoryName;
    }

    public void setRepositoryName(String repositoryName) {
        this.repositoryName = repositoryName;
    }

    public IConnector getConnector() {
        return this.connector;
    }

    public void setConnector(IConnector connector) {
        this.checkNotOpen();
        this.uncheckedSetConnector(connector);
    }

    protected void uncheckedSetConnector(IConnector connector) {
        this.connector = connector;
    }

    public IStreamWrapper getStreamWrapper() {
        return this.streamWrapper;
    }

    public void setStreamWrapper(IStreamWrapper streamWrapper) {
        this.checkNotOpen();
        this.streamWrapper = streamWrapper;
    }

    public long getSignalTimeout() {
        return this.signalTimeout;
    }

    public void setSignalTimeout(long signalTimeout) {
        this.signalTimeout = signalTimeout;
    }

    public CDONet4jSession openNet4jSession() {
        return (CDONet4jSession)super.openSession();
    }

    public CDOSession openSession() {
        return (CDOSession)this.openNet4jSession();
    }

    public InternalCDOSession createSession() {
        if (this.isActivateOnOpen()) {
            CheckUtil.checkState((Object)this.connector, (String)"connector");
        }
        return new CDONet4jSessionImpl();
    }

    protected void configureSession(InternalCDOSession session) {
        super.configureSession(session);
        CDONet4jSessionImpl sessionImpl = (CDONet4jSessionImpl)session;
        sessionImpl.setStreamWrapper(this.streamWrapper);
        sessionImpl.setConnector(this.connector);
        sessionImpl.setRepositoryName(this.repositoryName);
        sessionImpl.setSignalTimeout(this.signalTimeout);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class RepositoryInfo
    implements CDORepositoryInfo {
        private String name;
        private String uuid;
        private CDOCommonRepository.Type type;
        private CDOCommonRepository.State state;
        private String storeType;
        private Set<CDOID.ObjectType> objectIDTypes;
        private long creationTime;
        private CDOSessionProtocol.RepositoryTimeResult timeResult;
        private CDOID rootResourceID;
        private boolean supportingAudits;
        private boolean supportingBranches;
        private boolean supportingEcore;
        private boolean ensuringReferentialIntegrity;
        private CDOCommonRepository.IDGenerationLocation idGenerationLocation;
        private InternalCDOSession session;

        public RepositoryInfo(String name, CDOSessionProtocol.OpenSessionResult result, InternalCDOSession session) {
            this.name = name;
            this.uuid = result.getRepositoryUUID();
            this.type = result.getRepositoryType();
            this.state = result.getRepositoryState();
            this.storeType = result.getStoreType();
            this.objectIDTypes = result.getObjectIDTypes();
            this.creationTime = result.getRepositoryCreationTime();
            this.timeResult = result.getRepositoryTimeResult();
            this.rootResourceID = result.getRootResourceID();
            this.supportingAudits = result.isRepositorySupportingAudits();
            this.supportingBranches = result.isRepositorySupportingBranches();
            this.supportingEcore = result.isRepositorySupportingEcore();
            this.ensuringReferentialIntegrity = result.isRepositoryEnsuringReferentialIntegrity();
            this.idGenerationLocation = result.getRepositoryIDGenerationLocation();
            this.session = session;
        }

        public String getName() {
            return this.name;
        }

        public String getUUID() {
            return this.uuid;
        }

        public CDOCommonRepository.Type getType() {
            return this.type;
        }

        public void setType(CDOCommonRepository.Type type) {
            this.type = type;
        }

        public CDOCommonRepository.State getState() {
            return this.state;
        }

        public void setState(CDOCommonRepository.State state) {
            this.state = state;
        }

        public String getStoreType() {
            return this.storeType;
        }

        public Set<CDOID.ObjectType> getObjectIDTypes() {
            return this.objectIDTypes;
        }

        public long getCreationTime() {
            return this.creationTime;
        }

        public long getTimeStamp() {
            return this.getTimeStamp(false);
        }

        public long getTimeStamp(boolean forceRefresh) {
            if (this.timeResult == null || forceRefresh) {
                this.timeResult = this.refreshTime();
            }
            return this.timeResult.getAproximateRepositoryTime();
        }

        public CDOID getRootResourceID() {
            return this.rootResourceID;
        }

        public void setRootResourceID(CDOID rootResourceID) {
            if (this.rootResourceID == null || this.rootResourceID.isNull()) {
                this.rootResourceID = rootResourceID;
            } else if (this.rootResourceID == null || !this.rootResourceID.equals(rootResourceID)) {
                throw new IllegalStateException("rootResourceID must not be changed unless it is null");
            }
        }

        public boolean isSupportingAudits() {
            return this.supportingAudits;
        }

        public boolean isSupportingBranches() {
            return this.supportingBranches;
        }

        public boolean isSupportingEcore() {
            return this.supportingEcore;
        }

        public boolean isEnsuringReferentialIntegrity() {
            return this.ensuringReferentialIntegrity;
        }

        public CDOCommonRepository.IDGenerationLocation getIDGenerationLocation() {
            return this.idGenerationLocation;
        }

        private CDOSessionProtocol.RepositoryTimeResult refreshTime() {
            return this.session.getSessionProtocol().getRepositoryTime();
        }
    }
}

