/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.internal.net4j.protocol;

import java.io.IOException;
import java.util.HashSet;
import org.eclipse.emf.cdo.common.CDOCommonRepository;
import org.eclipse.emf.cdo.common.CDOCommonSession;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.model.CDOPackageUnit;
import org.eclipse.emf.cdo.common.protocol.CDODataInput;
import org.eclipse.emf.cdo.common.protocol.CDODataOutput;
import org.eclipse.emf.cdo.common.util.CDOCommonUtil;
import org.eclipse.emf.cdo.internal.net4j.bundle.OM;
import org.eclipse.emf.cdo.internal.net4j.protocol.CDOClientProtocol;
import org.eclipse.emf.cdo.internal.net4j.protocol.CDOClientRequestWithMonitoring;
import org.eclipse.emf.cdo.spi.common.model.InternalCDOPackageUnit;
import org.eclipse.emf.spi.cdo.CDOSessionProtocol;
import org.eclipse.net4j.util.om.monitor.OMMonitor;
import org.eclipse.net4j.util.om.trace.ContextTracer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OpenSessionRequest
extends CDOClientRequestWithMonitoring<CDOSessionProtocol.OpenSessionResult> {
    private static final ContextTracer TRACER = new ContextTracer(OM.DEBUG_PROTOCOL, OpenSessionRequest.class);
    private String repositoryName;
    private boolean passiveUpdateEnabled;
    private CDOCommonSession.Options.PassiveUpdateMode passiveUpdateMode;
    private CDOCommonSession.Options.LockNotificationMode lockNotificationMode;
    private CDOSessionProtocol.OpenSessionResult result;

    public OpenSessionRequest(CDOClientProtocol protocol, String repositoryName, boolean passiveUpdateEnabled, CDOCommonSession.Options.PassiveUpdateMode passiveUpdateMode, CDOCommonSession.Options.LockNotificationMode lockNotificationMode) {
        super(protocol, (short)1);
        this.repositoryName = repositoryName;
        this.passiveUpdateEnabled = passiveUpdateEnabled;
        this.passiveUpdateMode = passiveUpdateMode;
        this.lockNotificationMode = lockNotificationMode;
    }

    @Override
    protected void requesting(CDODataOutput out, OMMonitor monitor) throws IOException {
        if (TRACER.isEnabled()) {
            TRACER.format("Writing repositoryName: {0}", new Object[]{this.repositoryName});
        }
        out.writeString(this.repositoryName);
        if (TRACER.isEnabled()) {
            TRACER.format("Writing passiveUpdateEnabled: {0}", new Object[]{this.passiveUpdateEnabled});
        }
        out.writeBoolean(this.passiveUpdateEnabled);
        if (TRACER.isEnabled()) {
            TRACER.format("Writing passiveUpdateMode: {0}", new Object[]{this.passiveUpdateMode});
        }
        out.writeEnum((Enum)this.passiveUpdateMode);
        if (TRACER.isEnabled()) {
            TRACER.format("Writing lockNotificationMode: {0}", new Object[]{this.lockNotificationMode});
        }
        out.writeEnum((Enum)this.lockNotificationMode);
    }

    @Override
    protected CDOSessionProtocol.OpenSessionResult confirming(CDODataInput in, OMMonitor monitor) throws IOException {
        int sessionID = in.readInt();
        if (sessionID == 0) {
            return null;
        }
        if (TRACER.isEnabled()) {
            TRACER.format("Read sessionID: {0}", new Object[]{sessionID});
        }
        String userID = in.readString();
        if (TRACER.isEnabled()) {
            TRACER.format("Read userID: {0}", new Object[]{userID});
        }
        String repositoryUUID = in.readString();
        if (TRACER.isEnabled()) {
            TRACER.format("Read repositoryUUID: {0}", new Object[]{repositoryUUID});
        }
        CDOCommonRepository.Type repositoryType = (CDOCommonRepository.Type)in.readEnum(CDOCommonRepository.Type.class);
        if (TRACER.isEnabled()) {
            TRACER.format("Read repositoryType: {0}", new Object[]{repositoryType});
        }
        CDOCommonRepository.State repositoryState = (CDOCommonRepository.State)in.readEnum(CDOCommonRepository.State.class);
        if (TRACER.isEnabled()) {
            TRACER.format("Read repositoryState: {0}", new Object[]{repositoryState});
        }
        String storeType = in.readString();
        if (TRACER.isEnabled()) {
            TRACER.format("Read storeType: {0}", new Object[]{storeType});
        }
        HashSet<CDOID.ObjectType> objectIDTypes = new HashSet<CDOID.ObjectType>();
        int types = in.readInt();
        int i = 0;
        while (i < types) {
            CDOID.ObjectType objectIDType = (CDOID.ObjectType)in.readEnum(CDOID.ObjectType.class);
            if (TRACER.isEnabled()) {
                TRACER.format("Read objectIDType: {0}", new Object[]{objectIDType});
            }
            objectIDTypes.add(objectIDType);
            ++i;
        }
        long repositoryCreationTime = in.readLong();
        if (TRACER.isEnabled()) {
            TRACER.format("Read repositoryCreationTime: {0}", new Object[]{CDOCommonUtil.formatTimeStamp((long)repositoryCreationTime)});
        }
        long lastUpdateTime = in.readLong();
        if (TRACER.isEnabled()) {
            TRACER.format("Read lastUpdateTime: {0}", new Object[]{CDOCommonUtil.formatTimeStamp((long)lastUpdateTime)});
        }
        CDOID rootResourceID = in.readCDOID();
        if (TRACER.isEnabled()) {
            TRACER.format("Read rootResourceID: {0}", new Object[]{rootResourceID});
        }
        boolean repositorySupportingAudits = in.readBoolean();
        if (TRACER.isEnabled()) {
            TRACER.format("Read repositorySupportingAudits: {0}", new Object[]{repositorySupportingAudits});
        }
        boolean repositorySupportingBranches = in.readBoolean();
        if (TRACER.isEnabled()) {
            TRACER.format("Read repositorySupportingBranches: {0}", new Object[]{repositorySupportingBranches});
        }
        boolean repositorySupportingEcore = in.readBoolean();
        if (TRACER.isEnabled()) {
            TRACER.format("Read repositorySupportingEcore: {0}", new Object[]{repositorySupportingEcore});
        }
        boolean repositoryEnsuringReferentialIntegrity = in.readBoolean();
        if (TRACER.isEnabled()) {
            TRACER.format("Read repositoryEnsuringReferentialIntegrity: {0}", new Object[]{repositoryEnsuringReferentialIntegrity});
        }
        CDOCommonRepository.IDGenerationLocation repositoryIDGenerationLocation = (CDOCommonRepository.IDGenerationLocation)in.readEnum(CDOCommonRepository.IDGenerationLocation.class);
        if (TRACER.isEnabled()) {
            TRACER.format("Read repositoryIDGenerationLocation: {0}", new Object[]{repositoryIDGenerationLocation});
        }
        this.result = new CDOSessionProtocol.OpenSessionResult(sessionID, userID, repositoryUUID, repositoryType, repositoryState, storeType, objectIDTypes, repositoryCreationTime, lastUpdateTime, rootResourceID, repositorySupportingAudits, repositorySupportingBranches, repositorySupportingEcore, repositoryEnsuringReferentialIntegrity, repositoryIDGenerationLocation);
        CDOPackageUnit[] packageUnits = in.readCDOPackageUnits(null);
        int i2 = 0;
        while (i2 < packageUnits.length) {
            this.result.getPackageUnits().add((InternalCDOPackageUnit)packageUnits[i2]);
            ++i2;
        }
        return this.result;
    }
}

