/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.security.impl;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.eclipse.emf.cdo.common.branch.CDOBranchPoint;
import org.eclipse.emf.cdo.common.revision.CDORevision;
import org.eclipse.emf.cdo.common.revision.CDORevisionProvider;
import org.eclipse.emf.cdo.common.revision.CDORevisionUtil;
import org.eclipse.emf.cdo.security.ResourcePermission;
import org.eclipse.emf.cdo.security.SecurityPackage;
import org.eclipse.emf.cdo.security.impl.PermissionImpl;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;

public class ResourcePermissionImpl
extends PermissionImpl
implements ResourcePermission {
    private Pattern pattern;

    protected ResourcePermissionImpl() {
    }

    protected EClass eStaticClass() {
        return SecurityPackage.Literals.RESOURCE_PERMISSION;
    }

    public String getPattern() {
        return (String)this.eGet((EStructuralFeature)SecurityPackage.Literals.RESOURCE_PERMISSION__PATTERN, true);
    }

    public void setPattern(String newPattern) {
        this.eSet((EStructuralFeature)SecurityPackage.Literals.RESOURCE_PERMISSION__PATTERN, newPattern);
    }

    public void eSet(EStructuralFeature eFeature, Object newValue) {
        super.eSet(eFeature, newValue);
        if (eFeature == SecurityPackage.Literals.RESOURCE_PERMISSION__PATTERN) {
            String value = (String)newValue;
            this.pattern = this.compilePattern(value);
        }
    }

    private Pattern compilePattern(String value) {
        if (value == null) {
            return null;
        }
        try {
            return Pattern.compile(value);
        }
        catch (PatternSyntaxException ex) {
            return null;
        }
    }

    public boolean isApplicable(CDORevision revision, CDORevisionProvider revisionProvider, CDOBranchPoint securityContext) {
        if (this.pattern == null) {
            return false;
        }
        if (revisionProvider == null) {
            return false;
        }
        String path = CDORevisionUtil.getResourceNodePath((CDORevision)revision, (CDORevisionProvider)revisionProvider);
        Matcher matcher = this.pattern.matcher(path);
        return matcher.matches();
    }
}

