/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.server.internal.db;

import java.io.PrintStream;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import org.eclipse.emf.cdo.server.CDOServerBrowser;
import org.eclipse.emf.cdo.spi.server.InternalRepository;
import org.eclipse.net4j.db.DBException;
import org.eclipse.net4j.db.DBUtil;
import org.eclipse.net4j.db.IDBConnectionProvider;
import org.eclipse.net4j.util.factory.ProductCreationException;

public class DBBrowserPage
extends CDOServerBrowser.AbstractPage {
    public DBBrowserPage() {
        super("tables", "Database Tables");
    }

    public boolean canDisplay(InternalRepository repository) {
        return repository.getStore() instanceof IDBConnectionProvider;
    }

    public void display(CDOServerBrowser browser, InternalRepository repository, PrintStream out) {
        IDBConnectionProvider connectionProvider = (IDBConnectionProvider)repository.getStore();
        Connection connection = null;
        try {
            try {
                connection = connectionProvider.getConnection();
                out.print("<table border=\"0\">\r\n");
                out.print("<tr>\r\n");
                out.print("<td valign=\"top\">\r\n");
                String table = this.showTables(browser, out, connection, repository.getName());
                out.print("</td>\r\n");
                if (table != null) {
                    out.print("<td valign=\"top\">\r\n");
                    this.showTable(browser, out, connection, table);
                    out.print("</td>\r\n");
                }
                out.print("</tr>\r\n");
                out.print("</table>\r\n");
            }
            catch (DBException ex) {
                ex.printStackTrace();
                DBUtil.close((Connection)connection);
            }
        }
        finally {
            DBUtil.close((Connection)connection);
        }
    }

    protected String showTables(CDOServerBrowser browser, PrintStream pout, Connection connection, String repo) {
        String table = browser.getParam("table");
        List allTableNames = DBUtil.getAllTableNames((Connection)connection, (String)repo);
        for (String tableName : allTableNames) {
            if (table == null) {
                table = tableName;
            }
            String label = browser.escape(tableName);
            if (tableName.equals(table)) {
                pout.print("<b>" + label + "</b><br>\r\n");
                continue;
            }
            pout.print(String.valueOf(browser.href(label, this.getName(), new String[]{"table", tableName, "order", null, "direction", null})) + "<br>\r\n");
        }
        return table;
    }

    protected void showTable(CDOServerBrowser browser, PrintStream pout, Connection connection, String table) {
        try {
            String order = browser.getParam("order");
            this.executeQuery(browser, pout, connection, "SELECT * FROM " + table + (order == null ? "" : " ORDER BY " + order + " " + browser.getParam("direction")));
        }
        catch (Exception ex) {
            browser.removeParam("order");
            browser.removeParam("direction");
            this.executeQuery(browser, pout, connection, "SELECT * FROM " + table);
        }
    }

    protected void executeQuery(CDOServerBrowser browser, PrintStream pout, Connection connection, String sql) {
        block8: {
            String order = browser.getParam("order");
            String direction = browser.getParam("direction");
            String highlight = browser.getParam("highlight");
            Statement stmt = null;
            ResultSet resultSet = null;
            try {
                try {
                    stmt = connection.createStatement();
                    resultSet = stmt.executeQuery(sql);
                    ResultSetMetaData metaData = resultSet.getMetaData();
                    int columns = metaData.getColumnCount();
                    pout.print("<table border=\"1\" cellpadding=\"2\">\r\n");
                    pout.print("<tr>\r\n");
                    pout.print("<td>&nbsp;</td>\r\n");
                    int i = 0;
                    while (i < columns) {
                        String column = metaData.getColumnLabel(1 + i);
                        String type = metaData.getColumnTypeName(1 + i).toLowerCase();
                        String dir = column.equals(order) && "ASC".equals(direction) ? "DESC" : "ASC";
                        pout.print("<td align=\"center\"><b>" + browser.href(column, this.getName(), new String[]{"order", column, "direction", dir}));
                        pout.print("</b><br>" + type + "</td>\r\n");
                        ++i;
                    }
                    pout.print("</tr>\r\n");
                    int row = 0;
                    while (resultSet.next()) {
                        pout.print("<tr>\r\n");
                        pout.print("<td><b>" + ++row + "</b></td>\r\n");
                        int i2 = 0;
                        while (i2 < columns) {
                            String value = resultSet.getString(1 + i2);
                            String bgcolor = highlight != null && highlight.equals(value) ? " bgcolor=\"#fffca6\"" : "";
                            pout.print("<td" + bgcolor + ">" + browser.href(value, this.getName(), new String[]{"highlight", value}) + "</td>\r\n");
                            ++i2;
                        }
                        pout.print("</tr>\r\n");
                    }
                    pout.print("</table>\r\n");
                }
                catch (SQLException ex) {
                    ex.printStackTrace();
                    DBUtil.close(resultSet);
                    DBUtil.close((Statement)stmt);
                    break block8;
                }
            }
            catch (Throwable throwable) {
                DBUtil.close(resultSet);
                DBUtil.close((Statement)stmt);
                throw throwable;
            }
            DBUtil.close((ResultSet)resultSet);
            DBUtil.close((Statement)stmt);
        }
    }

    public static class Factory
    extends org.eclipse.net4j.util.factory.Factory {
        public static final String TYPE = "default";

        public Factory() {
            super("org.eclipse.emf.cdo.server.browserPages", TYPE);
        }

        public DBBrowserPage create(String description) throws ProductCreationException {
            return new DBBrowserPage();
        }
    }
}

