/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.server.internal.db;

import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.emf.cdo.common.branch.CDOBranchPoint;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.lock.CDOLockUtil;
import org.eclipse.emf.cdo.common.lock.IDurableLockingManager;
import org.eclipse.emf.cdo.common.protocol.CDODataInput;
import org.eclipse.emf.cdo.common.protocol.CDODataOutput;
import org.eclipse.emf.cdo.server.db.IIDHandler;
import org.eclipse.emf.cdo.server.db.IPreparedStatementCache;
import org.eclipse.emf.cdo.server.internal.db.DBStore;
import org.eclipse.emf.cdo.server.internal.db.DBStoreAccessor;
import org.eclipse.emf.cdo.spi.common.branch.InternalCDOBranchManager;
import org.eclipse.emf.cdo.spi.server.InternalLockManager;
import org.eclipse.net4j.db.DBException;
import org.eclipse.net4j.db.DBType;
import org.eclipse.net4j.db.DBUtil;
import org.eclipse.net4j.db.ddl.IDBField;
import org.eclipse.net4j.db.ddl.IDBIndex;
import org.eclipse.net4j.db.ddl.IDBSchema;
import org.eclipse.net4j.db.ddl.IDBTable;
import org.eclipse.net4j.util.concurrent.IRWLockManager;
import org.eclipse.net4j.util.io.ExtendedDataInput;
import org.eclipse.net4j.util.io.ExtendedDataOutput;
import org.eclipse.net4j.util.lifecycle.Lifecycle;
import org.eclipse.net4j.util.om.monitor.OMMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DurableLockingManager
extends Lifecycle {
    private DBStore store;
    private InternalCDOBranchManager branchManager;
    private IIDHandler idHandler;
    private IDBTable lockAreas;
    private IDBField lockAreasID;
    private IDBField lockAreasUser;
    private IDBField lockAreasBranch;
    private IDBField lockAreasTime;
    private IDBField lockAreasReadOnly;
    private IDBTable locks;
    private IDBField locksArea;
    private IDBField locksObject;
    private IDBField locksGrade;
    private String sqlInsertLockArea;
    private String sqlSelectLockArea;
    private String sqlSelectAllLockAreas;
    private String sqlSelectLockAreas;
    private String sqlDeleteLockArea;
    private String sqlDeleteLockAreas;
    private String sqlSelectLocks;
    private String sqlSelectLock;
    private String sqlInsertLock;
    private String sqlUpdateLock;
    private String sqlDeleteLock;
    private String sqlDeleteLocks;

    public DurableLockingManager(DBStore store) {
        this.store = store;
    }

    public synchronized IDurableLockingManager.LockArea createLockArea(DBStoreAccessor accessor, String durableLockingID, String userID, CDOBranchPoint branchPoint, boolean readOnly, Map<CDOID, IDurableLockingManager.LockGrade> locks) {
        try {
            if (durableLockingID == null) {
                durableLockingID = this.getNextDurableLockingID(accessor);
            } else {
                try {
                    this.getLockArea(accessor, durableLockingID);
                    throw new IDurableLockingManager.LockAreaAlreadyExistsException(durableLockingID);
                }
                catch (IDurableLockingManager.LockAreaNotFoundException lockAreaNotFoundException) {
                    // empty catch block
                }
            }
            IPreparedStatementCache statementCache = accessor.getStatementCache();
            PreparedStatement stmt = null;
            try {
                try {
                    stmt = statementCache.getPreparedStatement(this.sqlInsertLockArea, IPreparedStatementCache.ReuseProbability.LOW);
                    stmt.setString(1, durableLockingID);
                    stmt.setString(2, userID);
                    stmt.setInt(3, branchPoint.getBranch().getID());
                    stmt.setLong(4, branchPoint.getTimeStamp());
                    stmt.setBoolean(5, readOnly);
                    DBUtil.update((PreparedStatement)stmt, (boolean)true);
                }
                catch (SQLException e) {
                    throw new DBException((Throwable)e);
                }
            }
            catch (Throwable throwable) {
                statementCache.releasePreparedStatement(stmt);
                throw throwable;
            }
            statementCache.releasePreparedStatement(stmt);
            if (!locks.isEmpty()) {
                this.insertLocks(accessor, durableLockingID, locks);
            }
            accessor.getConnection().commit();
            return CDOLockUtil.createLockArea((String)durableLockingID, (String)userID, (CDOBranchPoint)branchPoint, (boolean)readOnly, locks);
        }
        catch (SQLException ex) {
            throw new DBException((Throwable)ex);
        }
    }

    private void insertLocks(DBStoreAccessor accessor, String durableLockingID, Map<CDOID, IDurableLockingManager.LockGrade> locks) {
        IPreparedStatementCache statementCache = accessor.getStatementCache();
        PreparedStatement stmt = null;
        try {
            try {
                stmt = statementCache.getPreparedStatement(this.sqlInsertLock, IPreparedStatementCache.ReuseProbability.MEDIUM);
                stmt.setString(1, durableLockingID);
                for (Map.Entry<CDOID, IDurableLockingManager.LockGrade> entry : locks.entrySet()) {
                    CDOID id = entry.getKey();
                    int grade = entry.getValue().getValue();
                    this.idHandler.setCDOID(stmt, 2, id);
                    stmt.setInt(3, grade);
                    DBUtil.update((PreparedStatement)stmt, (boolean)true);
                }
            }
            catch (SQLException e) {
                throw new DBException((Throwable)e);
            }
        }
        catch (Throwable throwable) {
            statementCache.releasePreparedStatement(stmt);
            throw throwable;
        }
        statementCache.releasePreparedStatement(stmt);
    }

    public IDurableLockingManager.LockArea getLockArea(DBStoreAccessor accessor, String durableLockingID) throws IDurableLockingManager.LockAreaNotFoundException {
        IDurableLockingManager.LockArea lockArea;
        IPreparedStatementCache statementCache = accessor.getStatementCache();
        PreparedStatement stmt = null;
        ResultSet resultSet = null;
        try {
            stmt = statementCache.getPreparedStatement(this.sqlSelectLockArea, IPreparedStatementCache.ReuseProbability.MEDIUM);
            stmt.setString(1, durableLockingID);
            resultSet = stmt.executeQuery();
            if (!resultSet.next()) {
                throw new IDurableLockingManager.LockAreaNotFoundException(durableLockingID);
            }
            String userID = resultSet.getString(1);
            int branchID = resultSet.getInt(2);
            long timeStamp = resultSet.getLong(3);
            boolean readOnly = resultSet.getBoolean(4);
            lockArea = this.makeLockArea(accessor, durableLockingID, userID, branchID, timeStamp, readOnly);
        }
        catch (SQLException e) {
            try {
                throw new DBException((Throwable)e);
            }
            catch (Throwable throwable) {
                DBUtil.close(resultSet);
                statementCache.releasePreparedStatement(stmt);
                throw throwable;
            }
        }
        DBUtil.close((ResultSet)resultSet);
        statementCache.releasePreparedStatement(stmt);
        return lockArea;
    }

    public void getLockAreas(DBStoreAccessor accessor, String userIDPrefix, IDurableLockingManager.LockArea.Handler handler) {
        IPreparedStatementCache statementCache = accessor.getStatementCache();
        PreparedStatement stmt = null;
        ResultSet resultSet = null;
        try {
            try {
                if (userIDPrefix.length() == 0) {
                    stmt = statementCache.getPreparedStatement(this.sqlSelectAllLockAreas, IPreparedStatementCache.ReuseProbability.MEDIUM);
                } else {
                    stmt = statementCache.getPreparedStatement(this.sqlSelectLockAreas, IPreparedStatementCache.ReuseProbability.MEDIUM);
                    stmt.setString(1, String.valueOf(userIDPrefix) + "%");
                }
                resultSet = stmt.executeQuery();
                while (resultSet.next()) {
                    boolean readOnly;
                    long timeStamp;
                    int branchID;
                    String userID;
                    String durableLockingID = resultSet.getString(1);
                    IDurableLockingManager.LockArea area = this.makeLockArea(accessor, durableLockingID, userID = resultSet.getString(2), branchID = resultSet.getInt(3), timeStamp = resultSet.getLong(4), readOnly = resultSet.getBoolean(5));
                    if (handler.handleLockArea(area)) {
                        continue;
                    }
                    break;
                }
            }
            catch (SQLException e) {
                throw new DBException((Throwable)e);
            }
        }
        catch (Throwable throwable) {
            DBUtil.close(resultSet);
            statementCache.releasePreparedStatement(stmt);
            throw throwable;
        }
        DBUtil.close((ResultSet)resultSet);
        statementCache.releasePreparedStatement(stmt);
    }

    public void deleteLockArea(DBStoreAccessor accessor, String durableLockingID) {
        try {
            this.unlockWithoutCommit(accessor, durableLockingID);
            IPreparedStatementCache statementCache = accessor.getStatementCache();
            PreparedStatement stmt = null;
            try {
                try {
                    stmt = statementCache.getPreparedStatement(this.sqlDeleteLockArea, IPreparedStatementCache.ReuseProbability.LOW);
                    stmt.setString(1, durableLockingID);
                    DBUtil.update((PreparedStatement)stmt, (boolean)true);
                }
                catch (SQLException e) {
                    throw new DBException((Throwable)e);
                }
            }
            catch (Throwable throwable) {
                statementCache.releasePreparedStatement(stmt);
                throw throwable;
            }
            statementCache.releasePreparedStatement(stmt);
            accessor.getConnection().commit();
        }
        catch (SQLException e) {
            throw new DBException((Throwable)e);
        }
    }

    public void updateLockArea(DBStoreAccessor accessor, IDurableLockingManager.LockArea area) {
        try {
            String areaID = area.getDurableLockingID();
            this.unlockWithoutCommit(accessor, areaID);
            this.insertLocks(accessor, areaID, area.getLocks());
            accessor.getConnection().commit();
        }
        catch (SQLException e) {
            throw new DBException((Throwable)e);
        }
    }

    public void lock(DBStoreAccessor accessor, String durableLockingID, IRWLockManager.LockType type, Collection<? extends Object> objectsToLock) {
        this.changeLocks(accessor, durableLockingID, type, objectsToLock, true);
    }

    public void unlock(DBStoreAccessor accessor, String durableLockingID, IRWLockManager.LockType type, Collection<? extends Object> objectsToUnlock) {
        this.changeLocks(accessor, durableLockingID, type, objectsToUnlock, false);
    }

    public void unlock(DBStoreAccessor accessor, String durableLockingID) {
        try {
            this.unlockWithoutCommit(accessor, durableLockingID);
            accessor.getConnection().commit();
        }
        catch (SQLException e) {
            throw new DBException((Throwable)e);
        }
    }

    private void unlockWithoutCommit(DBStoreAccessor accessor, String durableLockingID) {
        IPreparedStatementCache statementCache = accessor.getStatementCache();
        PreparedStatement stmt = null;
        try {
            try {
                stmt = statementCache.getPreparedStatement(this.sqlDeleteLocks, IPreparedStatementCache.ReuseProbability.MEDIUM);
                stmt.setString(1, durableLockingID);
                DBUtil.update((PreparedStatement)stmt, (boolean)false);
            }
            catch (SQLException e) {
                throw new DBException((Throwable)e);
            }
        }
        catch (Throwable throwable) {
            statementCache.releasePreparedStatement(stmt);
            throw throwable;
        }
        statementCache.releasePreparedStatement(stmt);
    }

    protected void doActivate() throws Exception {
        super.doActivate();
        this.branchManager = this.store.getRepository().getBranchManager();
        this.idHandler = this.store.getIDHandler();
        IDBSchema schema = this.store.getDBSchema();
        this.lockAreas = schema.addTable("cdo_lock_areas");
        this.lockAreasID = this.lockAreas.addField("id", DBType.VARCHAR);
        this.lockAreasUser = this.lockAreas.addField("user_id", DBType.VARCHAR);
        this.lockAreasBranch = this.lockAreas.addField("view_branch", DBType.INTEGER);
        this.lockAreasTime = this.lockAreas.addField("view_time", DBType.BIGINT);
        this.lockAreasReadOnly = this.lockAreas.addField("read_only", DBType.BOOLEAN);
        this.lockAreas.addIndex(IDBIndex.Type.PRIMARY_KEY, new IDBField[]{this.lockAreasID});
        this.lockAreas.addIndex(IDBIndex.Type.NON_UNIQUE, new IDBField[]{this.lockAreasUser});
        this.locks = schema.addTable("cdo_locks");
        this.locksArea = this.locks.addField("area_id", DBType.VARCHAR);
        this.locksObject = this.locks.addField("object_id", this.idHandler.getDBType());
        this.locksGrade = this.locks.addField("lock_grade", DBType.INTEGER);
        this.locks.addIndex(IDBIndex.Type.PRIMARY_KEY, new IDBField[]{this.locksArea, this.locksObject});
        this.locks.addIndex(IDBIndex.Type.NON_UNIQUE, new IDBField[]{this.locksArea});
        DBStoreAccessor writer = this.store.getWriter(null);
        Connection connection = writer.getConnection();
        Statement statement = null;
        try {
            try {
                statement = connection.createStatement();
                this.store.getDBAdapter().createTable(this.lockAreas, statement);
                this.store.getDBAdapter().createTable(this.locks, statement);
                connection.commit();
            }
            catch (SQLException ex) {
                connection.rollback();
                throw new DBException((Throwable)ex);
            }
        }
        finally {
            DBUtil.close((Statement)statement);
            writer.release();
        }
        StringBuilder builder = new StringBuilder();
        builder.append("INSERT INTO ");
        builder.append(this.lockAreas);
        builder.append("(");
        builder.append(this.lockAreasID);
        builder.append(",");
        builder.append(this.lockAreasUser);
        builder.append(",");
        builder.append(this.lockAreasBranch);
        builder.append(",");
        builder.append(this.lockAreasTime);
        builder.append(",");
        builder.append(this.lockAreasReadOnly);
        builder.append(") VALUES (?, ?, ?, ?, ?)");
        this.sqlInsertLockArea = builder.toString();
        builder = new StringBuilder();
        builder.append("SELECT ");
        builder.append(this.lockAreasUser);
        builder.append(",");
        builder.append(this.lockAreasBranch);
        builder.append(",");
        builder.append(this.lockAreasTime);
        builder.append(",");
        builder.append(this.lockAreasReadOnly);
        builder.append(" FROM ");
        builder.append(this.lockAreas);
        builder.append(" WHERE ");
        builder.append(this.lockAreasID);
        builder.append("=?");
        this.sqlSelectLockArea = builder.toString();
        builder = new StringBuilder();
        builder.append("SELECT ");
        builder.append(this.lockAreasID);
        builder.append(",");
        builder.append(this.lockAreasUser);
        builder.append(",");
        builder.append(this.lockAreasBranch);
        builder.append(",");
        builder.append(this.lockAreasTime);
        builder.append(",");
        builder.append(this.lockAreasReadOnly);
        builder.append(" FROM ");
        builder.append(this.lockAreas);
        this.sqlSelectAllLockAreas = builder.toString();
        builder.append(" WHERE ");
        builder.append(this.lockAreasUser);
        builder.append(" LIKE ?");
        this.sqlSelectLockAreas = builder.toString();
        builder = new StringBuilder();
        builder.append("DELETE FROM ");
        builder.append(this.lockAreas);
        builder.append(" WHERE ");
        builder.append(this.lockAreasID);
        builder.append("=?");
        this.sqlDeleteLockArea = builder.toString();
        builder = new StringBuilder();
        builder.append("DELETE FROM ");
        builder.append(this.lockAreas);
        builder.append(" WHERE EXISTS (SELECT * FROM ");
        builder.append(this.locks);
        builder.append(" WHERE ");
        builder.append(this.locks);
        builder.append(".");
        builder.append(this.locksArea);
        builder.append("=");
        builder.append(this.lockAreas);
        builder.append(".");
        builder.append(this.lockAreasID);
        builder.append(")");
        this.sqlDeleteLockAreas = builder.toString();
        builder = new StringBuilder();
        builder.append("SELECT ");
        builder.append(this.locksObject);
        builder.append(",");
        builder.append(this.locksGrade);
        builder.append(" FROM ");
        builder.append(this.locks);
        builder.append(" WHERE ");
        builder.append(this.locksArea);
        builder.append("=?");
        this.sqlSelectLocks = builder.toString();
        builder = new StringBuilder();
        builder.append("SELECT ");
        builder.append(this.locksGrade);
        builder.append(" FROM ");
        builder.append(this.locks);
        builder.append(" WHERE ");
        builder.append(this.locksArea);
        builder.append("=? AND ");
        builder.append(this.locksObject);
        builder.append("=?");
        this.sqlSelectLock = builder.toString();
        builder = new StringBuilder();
        builder.append("INSERT INTO ");
        builder.append(this.locks);
        builder.append("(");
        builder.append(this.locksArea);
        builder.append(",");
        builder.append(this.locksObject);
        builder.append(",");
        builder.append(this.locksGrade);
        builder.append(") VALUES (?, ?, ?)");
        this.sqlInsertLock = builder.toString();
        builder = new StringBuilder();
        builder.append("UPDATE ");
        builder.append(this.locks);
        builder.append(" SET ");
        builder.append(this.locksGrade);
        builder.append("=? ");
        builder.append(" WHERE ");
        builder.append(this.locksArea);
        builder.append("=? AND ");
        builder.append(this.locksObject);
        builder.append("=?");
        this.sqlUpdateLock = builder.toString();
        builder = new StringBuilder();
        builder.append("DELETE FROM ");
        builder.append(this.locks);
        builder.append(" WHERE ");
        builder.append(this.locksArea);
        builder.append("=? AND ");
        builder.append(this.locksObject);
        builder.append("=?");
        this.sqlDeleteLock = builder.toString();
        builder = new StringBuilder();
        builder.append("DELETE FROM ");
        builder.append(this.locks);
        builder.append(" WHERE ");
        builder.append(this.locksArea);
        builder.append("=?");
        this.sqlDeleteLocks = builder.toString();
    }

    private String getNextDurableLockingID(DBStoreAccessor accessor) {
        while (true) {
            String durableLockingID = CDOLockUtil.createDurableLockingID();
            try {
                this.getLockArea(accessor, durableLockingID);
            }
            catch (IDurableLockingManager.LockAreaNotFoundException ex) {
                return durableLockingID;
            }
        }
    }

    private IDurableLockingManager.LockArea makeLockArea(DBStoreAccessor accessor, String durableLockingID, String userID, int branchID, long timeStamp, boolean readOnly) {
        CDOBranchPoint branchPoint = this.branchManager.getBranch(branchID).getPoint(timeStamp);
        Map<CDOID, IDurableLockingManager.LockGrade> lockMap = this.getLockMap(accessor, durableLockingID);
        return CDOLockUtil.createLockArea((String)durableLockingID, (String)userID, (CDOBranchPoint)branchPoint, (boolean)readOnly, lockMap);
    }

    private Map<CDOID, IDurableLockingManager.LockGrade> getLockMap(DBStoreAccessor accessor, String durableLockingID) {
        HashMap<CDOID, IDurableLockingManager.LockGrade> hashMap;
        IPreparedStatementCache statementCache = accessor.getStatementCache();
        PreparedStatement stmt = null;
        ResultSet resultSet = null;
        try {
            stmt = statementCache.getPreparedStatement(this.sqlSelectLocks, IPreparedStatementCache.ReuseProbability.MEDIUM);
            stmt.setString(1, durableLockingID);
            resultSet = stmt.executeQuery();
            HashMap<CDOID, IDurableLockingManager.LockGrade> lockMap = new HashMap<CDOID, IDurableLockingManager.LockGrade>();
            while (resultSet.next()) {
                CDOID id = this.idHandler.getCDOID(resultSet, 1);
                int grade = resultSet.getInt(2);
                lockMap.put(id, IDurableLockingManager.LockGrade.get((int)grade));
            }
            hashMap = lockMap;
        }
        catch (SQLException e) {
            try {
                throw new DBException((Throwable)e);
            }
            catch (Throwable throwable) {
                DBUtil.close(resultSet);
                statementCache.releasePreparedStatement(stmt);
                throw throwable;
            }
        }
        DBUtil.close((ResultSet)resultSet);
        statementCache.releasePreparedStatement(stmt);
        return hashMap;
    }

    private void changeLocks(DBStoreAccessor accessor, String durableLockingID, IRWLockManager.LockType type, Collection<? extends Object> keys, boolean on) {
        if (keys.isEmpty()) {
            return;
        }
        IPreparedStatementCache statementCache = accessor.getStatementCache();
        PreparedStatement stmtSelect = null;
        PreparedStatement stmtInsertOrDelete = null;
        PreparedStatement stmtUpdate = null;
        ResultSet resultSet = null;
        try {
            try {
                stmtSelect = statementCache.getPreparedStatement(this.sqlSelectLock, IPreparedStatementCache.ReuseProbability.MEDIUM);
                stmtSelect.setString(1, durableLockingID);
                String sql = on ? this.sqlInsertLock : this.sqlDeleteLock;
                stmtInsertOrDelete = statementCache.getPreparedStatement(sql, IPreparedStatementCache.ReuseProbability.MEDIUM);
                stmtInsertOrDelete.setString(1, durableLockingID);
                stmtUpdate = statementCache.getPreparedStatement(this.sqlUpdateLock, IPreparedStatementCache.ReuseProbability.MEDIUM);
                stmtUpdate.setString(2, durableLockingID);
                InternalLockManager lockManager = accessor.getStore().getRepository().getLockingManager();
                for (Object object : keys) {
                    CDOID id = lockManager.getLockKeyID(object);
                    this.idHandler.setCDOID(stmtSelect, 2, id);
                    resultSet = stmtSelect.executeQuery();
                    IDurableLockingManager.LockGrade oldGrade = IDurableLockingManager.LockGrade.NONE;
                    if (resultSet.next()) {
                        oldGrade = IDurableLockingManager.LockGrade.get((int)resultSet.getInt(1));
                    }
                    IDurableLockingManager.LockGrade newGrade = oldGrade.getUpdated(type, on);
                    if (on && oldGrade == IDurableLockingManager.LockGrade.NONE) {
                        this.idHandler.setCDOID(stmtInsertOrDelete, 2, id);
                        stmtInsertOrDelete.setInt(3, newGrade.getValue());
                        DBUtil.update((PreparedStatement)stmtInsertOrDelete, (boolean)true);
                        continue;
                    }
                    if (!on && newGrade == IDurableLockingManager.LockGrade.NONE) {
                        this.idHandler.setCDOID(stmtInsertOrDelete, 2, id);
                        DBUtil.update((PreparedStatement)stmtInsertOrDelete, (boolean)true);
                        continue;
                    }
                    stmtUpdate.setInt(1, newGrade.getValue());
                    this.idHandler.setCDOID(stmtUpdate, 3, id);
                    DBUtil.update((PreparedStatement)stmtUpdate, (boolean)true);
                }
                accessor.getConnection().commit();
            }
            catch (SQLException e) {
                throw new DBException((Throwable)e);
            }
        }
        catch (Throwable throwable) {
            DBUtil.close(resultSet);
            statementCache.releasePreparedStatement(stmtUpdate);
            statementCache.releasePreparedStatement(stmtInsertOrDelete);
            statementCache.releasePreparedStatement(stmtSelect);
            throw throwable;
        }
        DBUtil.close(resultSet);
        statementCache.releasePreparedStatement(stmtUpdate);
        statementCache.releasePreparedStatement(stmtInsertOrDelete);
        statementCache.releasePreparedStatement(stmtSelect);
    }

    public void rawExport(Connection connection, CDODataOutput out, long fromCommitTime, long toCommitTime) throws IOException {
        DBUtil.serializeTable((ExtendedDataOutput)out, (Connection)connection, (IDBTable)this.lockAreas, null, null);
        DBUtil.serializeTable((ExtendedDataOutput)out, (Connection)connection, (IDBTable)this.locks, null, null);
    }

    public void rawImport(Connection connection, CDODataInput in, long fromCommitTime, long toCommitTime, OMMonitor monitor) throws IOException {
        monitor.begin(4.0);
        try {
            DBUtil.update((Connection)connection, (String)this.sqlDeleteLockAreas);
            monitor.worked();
            DBUtil.deserializeTable((ExtendedDataInput)in, (Connection)connection, (IDBTable)this.lockAreas, (OMMonitor)monitor.fork());
            DBUtil.clearTable((Connection)connection, (IDBTable)this.locks);
            monitor.worked();
            DBUtil.deserializeTable((ExtendedDataInput)in, (Connection)connection, (IDBTable)this.locks, (OMMonitor)monitor.fork());
        }
        finally {
            monitor.done();
        }
    }
}

