/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.server.internal.db;

import java.sql.Clob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.util.CDOQueryInfo;
import org.eclipse.emf.cdo.server.IQueryContext;
import org.eclipse.emf.cdo.server.IQueryHandler;
import org.eclipse.emf.cdo.server.db.IIDHandler;
import org.eclipse.emf.cdo.server.internal.db.DBStoreAccessor;
import org.eclipse.net4j.db.DBException;
import org.eclipse.net4j.db.DBUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SQLQueryHandler
implements IQueryHandler {
    public static final String QUERY_LANGUAGE = "sql";
    public static final String FIRST_RESULT = "firstResult";
    public static final String CDO_OBJECT_QUERY = "cdoObjectQuery";
    public static final String MAP_QUERY = "mapQuery";
    public static final String QUERY_STATEMENT = "queryStatement";
    private DBStoreAccessor storeAccessor;

    public SQLQueryHandler(DBStoreAccessor storeAccessor) {
        this.storeAccessor = storeAccessor;
    }

    public DBStoreAccessor getStoreAccessor() {
        return this.storeAccessor;
    }

    public void executeQuery(CDOQueryInfo info, IQueryContext context) {
        ResultSet resultSet;
        PreparedStatement statement;
        block29: {
            String language = info.getQueryLanguage();
            if (!QUERY_LANGUAGE.equals(language)) {
                throw new IllegalArgumentException("Unsupported query language: " + language);
            }
            IIDHandler idHandler = this.storeAccessor.getStore().getIDHandler();
            Connection connection = this.storeAccessor.getConnection();
            statement = null;
            resultSet = null;
            String query = info.getQueryString();
            try {
                try {
                    int firstResult = -1;
                    boolean queryStatement = true;
                    boolean objectQuery = true;
                    boolean mapQuery = false;
                    HashMap<String, List<Integer>> paramMap = new HashMap<String, List<Integer>>();
                    query = this.parse(query, paramMap);
                    statement = connection.prepareStatement(query, 1004, 1007);
                    for (String key : info.getParameters().keySet()) {
                        Object o;
                        if (FIRST_RESULT.equalsIgnoreCase(key)) {
                            o = info.getParameters().get(key);
                            if (o == null) continue;
                            try {
                                firstResult = (Integer)o;
                                continue;
                            }
                            catch (ClassCastException ex) {
                                throw new IllegalArgumentException("Parameter firstResult must be an integer but it is a " + o + " class " + o.getClass().getName(), ex);
                            }
                        }
                        if (QUERY_STATEMENT.equalsIgnoreCase(key)) {
                            o = info.getParameters().get(key);
                            if (o == null) continue;
                            try {
                                queryStatement = (Boolean)o;
                                continue;
                            }
                            catch (ClassCastException ex) {
                                throw new IllegalArgumentException("Parameter queryStatement must be an boolean but it is a " + o + " class " + o.getClass().getName(), ex);
                            }
                        }
                        if (CDO_OBJECT_QUERY.equalsIgnoreCase(key)) {
                            o = info.getParameters().get(key);
                            if (o == null) continue;
                            try {
                                objectQuery = (Boolean)o;
                                continue;
                            }
                            catch (ClassCastException ex) {
                                throw new IllegalArgumentException("Parameter cdoObjectQuery must be a boolean but it is a " + o + " class " + o.getClass().getName(), ex);
                            }
                        }
                        if (MAP_QUERY.equalsIgnoreCase(key)) {
                            o = info.getParameters().get(key);
                            if (o == null) continue;
                            try {
                                mapQuery = (Boolean)o;
                                continue;
                            }
                            catch (ClassCastException ex) {
                                throw new IllegalArgumentException("Parameter mapQuery must be a boolean but it is a " + o + " class " + o.getClass().getName(), ex);
                            }
                        }
                        if (!paramMap.containsKey(key) || paramMap.get(key) == null) {
                            throw new IllegalArgumentException("No parameter value found for named parameter " + key);
                        }
                        Integer[] indexes = paramMap.get(key).toArray(new Integer[0]);
                        int i = 0;
                        while (i < indexes.length) {
                            Object parameter = info.getParameters().get(key);
                            statement.setObject(indexes[i], parameter);
                            ++i;
                        }
                    }
                    if (queryStatement) {
                        resultSet = statement.executeQuery();
                        if (firstResult > -1) {
                            resultSet.absolute(firstResult);
                        }
                        String[] columnNames = null;
                        if (mapQuery) {
                            columnNames = new String[resultSet.getMetaData().getColumnCount()];
                            int i = 1;
                            while (i <= columnNames.length) {
                                columnNames[i - 1] = resultSet.getMetaData().getColumnName(i);
                                ++i;
                            }
                        }
                        int maxResults = info.getMaxResults();
                        int counter = 0;
                        while (resultSet.next()) {
                            if (maxResults == -1 || counter++ < maxResults) {
                                if (objectQuery) {
                                    CDOID result = idHandler.getCDOID(resultSet, 1);
                                    context.addResult((Object)result);
                                    continue;
                                }
                                int columnCount = resultSet.getMetaData().getColumnCount();
                                if (columnCount == 1) {
                                    Map<String, Object> result = this.convertFromSQL(resultSet.getObject(1));
                                    context.addResult((Object)(mapQuery ? this.toMap(columnNames, new Object[]{result}) : result));
                                    continue;
                                }
                                Object[] results = new Object[columnCount];
                                int i = 0;
                                while (i < columnCount) {
                                    results[i] = this.convertFromSQL(resultSet.getObject(i + 1));
                                    ++i;
                                }
                                context.addResult(mapQuery ? this.toMap(columnNames, results) : results);
                                continue;
                            }
                            break block29;
                        }
                        break block29;
                    }
                    int result = statement.executeUpdate();
                    context.addResult((Object)result);
                }
                catch (SQLException ex) {
                    throw new DBException("Problem while executing SQL query: " + query, (Throwable)ex);
                }
            }
            catch (Throwable throwable) {
                DBUtil.close(resultSet);
                DBUtil.close(statement);
                throw throwable;
            }
        }
        DBUtil.close((ResultSet)resultSet);
        DBUtil.close((Statement)statement);
    }

    private Object convertToSQL(Object value) {
        if (value instanceof java.util.Date) {
            java.util.Date date = (java.util.Date)value;
            value = new Date(date.getTime());
        }
        return value;
    }

    private Object convertFromSQL(Object value) {
        if (value instanceof Clob) {
            Clob clob = (Clob)value;
            try {
                value = clob.getSubString(1L, (int)clob.length());
            }
            catch (SQLException ex) {
                throw new DBException("Could not extract CLOB value", (Throwable)ex);
            }
        }
        return value;
    }

    private Map<String, Object> toMap(String[] columnNames, Object[] results) {
        HashMap<String, Object> ret = new HashMap<String, Object>();
        int i = 0;
        while (i < columnNames.length) {
            String columnName = columnNames[i];
            ret.put(columnName, results[i]);
            ++i;
        }
        return ret;
    }

    private String parse(String query, Map<String, List<Integer>> paramMap) {
        int length = query.length();
        StringBuilder builder = new StringBuilder(length);
        boolean inSingleQuote = false;
        boolean inDoubleQuote = false;
        int index = 1;
        int i = 0;
        while (i < length) {
            int c = query.charAt(i);
            if (inSingleQuote) {
                if (c == 39) {
                    inSingleQuote = false;
                }
            } else if (inDoubleQuote) {
                if (c == 34) {
                    inDoubleQuote = false;
                }
            } else if (c == 39) {
                inSingleQuote = true;
            } else if (c == 34) {
                inDoubleQuote = true;
            } else if (c == 58 && i + 1 < length && Character.isJavaIdentifierStart(query.charAt(i + 1))) {
                int j = i + 2;
                while (j < length && Character.isJavaIdentifierPart(query.charAt(j))) {
                    ++j;
                }
                String name = query.substring(i + 1, j);
                c = 63;
                i += name.length();
                List<Integer> indexList = paramMap.get(name);
                if (indexList == null) {
                    indexList = new ArrayList<Integer>();
                    paramMap.put(name, indexList);
                }
                indexList.add(new Integer(index));
                ++index;
            }
            builder.append((char)c);
            ++i;
        }
        return builder.toString();
    }
}

