/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.server.internal.db.mapping.horizontal;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.Assert;
import org.eclipse.emf.cdo.common.branch.CDOBranch;
import org.eclipse.emf.cdo.common.branch.CDOBranchManager;
import org.eclipse.emf.cdo.common.branch.CDOBranchPoint;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.model.CDOModelUtil;
import org.eclipse.emf.cdo.common.revision.CDOList;
import org.eclipse.emf.cdo.common.revision.CDORevision;
import org.eclipse.emf.cdo.common.revision.CDORevisionHandler;
import org.eclipse.emf.cdo.common.revision.CDORevisionManager;
import org.eclipse.emf.cdo.eresource.EresourcePackage;
import org.eclipse.emf.cdo.server.IRepository;
import org.eclipse.emf.cdo.server.IStoreAccessor;
import org.eclipse.emf.cdo.server.db.IDBStore;
import org.eclipse.emf.cdo.server.db.IDBStoreAccessor;
import org.eclipse.emf.cdo.server.db.IIDHandler;
import org.eclipse.emf.cdo.server.db.IPreparedStatementCache;
import org.eclipse.emf.cdo.server.db.mapping.IClassMapping;
import org.eclipse.emf.cdo.server.db.mapping.IListMapping;
import org.eclipse.emf.cdo.server.db.mapping.IMappingStrategy;
import org.eclipse.emf.cdo.server.db.mapping.ITypeMapping;
import org.eclipse.emf.cdo.server.internal.db.bundle.OM;
import org.eclipse.emf.cdo.server.internal.db.mapping.horizontal.AbstractHorizontalMappingStrategy;
import org.eclipse.emf.cdo.server.internal.db.mapping.horizontal.BasicAbstractListTableMapping;
import org.eclipse.emf.cdo.spi.common.commit.CDOChangeSetSegment;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDOList;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDORevision;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.FeatureMapUtil;
import org.eclipse.net4j.db.DBException;
import org.eclipse.net4j.db.DBType;
import org.eclipse.net4j.db.DBUtil;
import org.eclipse.net4j.db.ddl.IDBField;
import org.eclipse.net4j.db.ddl.IDBIndex;
import org.eclipse.net4j.db.ddl.IDBTable;
import org.eclipse.net4j.util.om.monitor.OMMonitor;
import org.eclipse.net4j.util.om.trace.ContextTracer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractHorizontalClassMapping
implements IClassMapping {
    private static final ContextTracer TRACER = new ContextTracer(OM.DEBUG, AbstractHorizontalClassMapping.class);
    private EClass eClass;
    private IDBTable table;
    private AbstractHorizontalMappingStrategy mappingStrategy;
    private List<ITypeMapping> valueMappings;
    private List<IListMapping> listMappings;
    private Map<EStructuralFeature, String> listSizeFields;
    private Map<EStructuralFeature, String> unsettableFields;
    private String sqlSelectForHandle;
    private String sqlSelectForChangeSet;

    public AbstractHorizontalClassMapping(AbstractHorizontalMappingStrategy mappingStrategy, EClass eClass) {
        this.mappingStrategy = mappingStrategy;
        this.eClass = eClass;
        this.initTable();
        this.initFeatures();
        this.initSQLStrings();
    }

    private void initTable() {
        IDBStore store = this.getMappingStrategy().getStore();
        DBType idType = store.getIDHandler().getDBType();
        String name = this.getMappingStrategy().getTableName((ENamedElement)this.eClass);
        this.table = store.getDBSchema().addTable(name);
        IDBField idField = this.table.addField("cdo_id", idType, true);
        IDBField versionField = this.table.addField("cdo_version", DBType.INTEGER, true);
        IDBField branchField = this.addBranchingField(this.table);
        this.table.addField("cdo_created", DBType.BIGINT, true);
        IDBField revisedField = this.table.addField("cdo_revised", DBType.BIGINT, true);
        this.table.addField("cdo_resource", idType, true);
        this.table.addField("cdo_container", idType, true);
        this.table.addField("cdo_feature", DBType.INTEGER, true);
        if (branchField != null) {
            this.table.addIndex(IDBIndex.Type.UNIQUE, new IDBField[]{idField, versionField, branchField});
        } else {
            this.table.addIndex(IDBIndex.Type.UNIQUE, new IDBField[]{idField, versionField});
        }
        this.table.addIndex(IDBIndex.Type.NON_UNIQUE, new IDBField[]{idField, revisedField});
    }

    protected IDBField addBranchingField(IDBTable table) {
        return null;
    }

    private void initFeatures() {
        EStructuralFeature[] features = CDOModelUtil.getAllPersistentFeatures((EClass)this.eClass);
        if (features == null) {
            this.valueMappings = Collections.emptyList();
            this.listMappings = Collections.emptyList();
        } else {
            this.valueMappings = this.createValueMappings(features);
            this.listMappings = this.createListMappings(features);
        }
    }

    private void initSQLStrings() {
        StringBuilder builder = new StringBuilder("SELECT ");
        builder.append("cdo_id");
        builder.append(", ");
        builder.append("cdo_version");
        builder.append(" FROM ");
        builder.append(this.getTable());
        this.sqlSelectForHandle = builder.toString();
        builder = new StringBuilder("SELECT DISTINCT ");
        builder.append("cdo_id");
        builder.append(" FROM ");
        builder.append(this.getTable());
        builder.append(" WHERE ");
        this.sqlSelectForChangeSet = builder.toString();
    }

    private List<ITypeMapping> createValueMappings(EStructuralFeature[] features) {
        ArrayList<ITypeMapping> mappings = new ArrayList<ITypeMapping>();
        EStructuralFeature[] eStructuralFeatureArray = features;
        int n = features.length;
        int n2 = 0;
        while (n2 < n) {
            EStructuralFeature feature = eStructuralFeatureArray[n2];
            if (!feature.isMany()) {
                ITypeMapping mapping = this.mappingStrategy.createValueMapping(feature);
                mapping.createDBField(this.getTable());
                mappings.add(mapping);
                if (feature.isUnsettable()) {
                    String fieldName = this.mappingStrategy.getUnsettableFieldName(feature);
                    if (this.unsettableFields == null) {
                        this.unsettableFields = new LinkedHashMap<EStructuralFeature, String>();
                    }
                    this.unsettableFields.put(feature, fieldName);
                }
            }
            ++n2;
        }
        if (this.unsettableFields != null) {
            for (String fieldName : this.unsettableFields.values()) {
                this.table.addField(fieldName, DBType.BOOLEAN, 1);
            }
        }
        return mappings;
    }

    private List<IListMapping> createListMappings(EStructuralFeature[] features) {
        ArrayList<IListMapping> listMappings = new ArrayList<IListMapping>();
        EStructuralFeature[] eStructuralFeatureArray = features;
        int n = features.length;
        int n2 = 0;
        while (n2 < n) {
            EStructuralFeature feature = eStructuralFeatureArray[n2];
            if (feature.isMany()) {
                IListMapping mapping = null;
                mapping = FeatureMapUtil.isFeatureMap((EStructuralFeature)feature) ? this.mappingStrategy.createFeatureMapMapping(this.eClass, feature) : this.mappingStrategy.createListMapping(this.eClass, feature);
                listMappings.add(mapping);
                this.createListSizeField(feature);
            }
            ++n2;
        }
        return listMappings;
    }

    private void createListSizeField(EStructuralFeature feature) {
        if (this.listSizeFields == null) {
            this.listSizeFields = new LinkedHashMap<EStructuralFeature, String>();
        }
        String fieldName = this.mappingStrategy.getFieldName(feature);
        this.table.addField(fieldName, DBType.INTEGER);
        this.listSizeFields.put(feature, fieldName);
    }

    protected final boolean readValuesFromStatement(PreparedStatement stmt, InternalCDORevision revision, IDBStoreAccessor accessor) {
        ResultSet resultSet;
        block12: {
            block10: {
                block11: {
                    resultSet = null;
                    if (TRACER.isEnabled()) {
                        TRACER.format("Executing Query: {0}", new Object[]{stmt.toString()});
                    }
                    stmt.setMaxRows(1);
                    resultSet = stmt.executeQuery();
                    if (resultSet.next()) break block10;
                    if (!TRACER.isEnabled()) break block11;
                    TRACER.format("Resultset was empty", new Object[0]);
                }
                DBUtil.close((ResultSet)resultSet);
                return false;
            }
            try {
                EStructuralFeature feature;
                revision.setVersion(resultSet.getInt("cdo_version"));
                long timeStamp = resultSet.getLong("cdo_created");
                IIDHandler idHandler = this.getMappingStrategy().getStore().getIDHandler();
                CDOBranchPoint branchPoint = revision.getBranch().getPoint(timeStamp);
                revision.setBranchPoint(branchPoint);
                revision.setRevised(resultSet.getLong("cdo_revised"));
                revision.setResourceID(idHandler.getCDOID(resultSet, "cdo_resource"));
                revision.setContainerID((Object)idHandler.getCDOID(resultSet, "cdo_container"));
                revision.setContainingFeatureID(resultSet.getInt("cdo_feature"));
                for (ITypeMapping iTypeMapping : this.valueMappings) {
                    feature = iTypeMapping.getFeature();
                    if (feature.isUnsettable() && !resultSet.getBoolean(this.unsettableFields.get(feature))) {
                        revision.setValue(feature, null);
                        continue;
                    }
                    iTypeMapping.readValueToRevision(resultSet, revision);
                }
                if (this.listSizeFields == null) break block12;
                for (Map.Entry entry : this.listSizeFields.entrySet()) {
                    feature = (EStructuralFeature)entry.getKey();
                    String fieldName = (String)entry.getValue();
                    int size = resultSet.getInt(fieldName);
                    CDOList list = revision.getList(feature, size);
                    int i = 0;
                    while (i < size) {
                        list.add(InternalCDOList.UNINITIALIZED);
                        ++i;
                    }
                    if (list.size() == size) continue;
                    Assert.isTrue((boolean)false);
                }
            }
            catch (SQLException ex) {
                try {
                    throw new DBException((Throwable)ex);
                }
                catch (Throwable throwable) {
                    DBUtil.close(resultSet);
                    throw throwable;
                }
            }
        }
        DBUtil.close((ResultSet)resultSet);
        return true;
    }

    protected final void readLists(IDBStoreAccessor accessor, InternalCDORevision revision, int listChunk) {
        for (IListMapping listMapping : this.listMappings) {
            listMapping.readValues(accessor, revision, listChunk);
        }
    }

    protected final IMappingStrategy getMappingStrategy() {
        return this.mappingStrategy;
    }

    @Override
    public final EClass getEClass() {
        return this.eClass;
    }

    protected final Map<EStructuralFeature, String> getUnsettableFields() {
        return this.unsettableFields;
    }

    protected final Map<EStructuralFeature, String> getListSizeFields() {
        return this.listSizeFields;
    }

    @Override
    public final List<ITypeMapping> getValueMappings() {
        return this.valueMappings;
    }

    public final ITypeMapping getValueMapping(EStructuralFeature feature) {
        for (ITypeMapping mapping : this.valueMappings) {
            if (mapping.getFeature() != feature) continue;
            return mapping;
        }
        return null;
    }

    @Override
    public final List<IListMapping> getListMappings() {
        return this.listMappings;
    }

    @Override
    public final IListMapping getListMapping(EStructuralFeature feature) {
        for (IListMapping mapping : this.listMappings) {
            if (mapping.getFeature() != feature) continue;
            return mapping;
        }
        throw new IllegalArgumentException("List mapping for feature " + feature + " does not exist");
    }

    protected final IDBTable getTable() {
        return this.table;
    }

    @Override
    public List<IDBTable> getDBTables() {
        ArrayList<IDBTable> tables = new ArrayList<IDBTable>();
        tables.add(this.table);
        for (IListMapping listMapping : this.listMappings) {
            tables.addAll(listMapping.getDBTables());
        }
        return tables;
    }

    protected void checkDuplicateResources(IDBStoreAccessor accessor, CDORevision revision) throws IllegalStateException {
        String name;
        CDOID folderID = (CDOID)revision.data().getContainerID();
        CDOID existingID = accessor.readResourceID(folderID, name = (String)revision.data().get((EStructuralFeature)EresourcePackage.eINSTANCE.getCDOResourceNode_Name(), 0), revision.getBranch().getHead());
        if (existingID != null && !existingID.equals(revision.getID())) {
            throw new IllegalStateException("Duplicate resource or folder: " + name + " in folder " + folderID);
        }
    }

    protected void writeLists(IDBStoreAccessor accessor, InternalCDORevision revision) {
        for (IListMapping listMapping : this.listMappings) {
            listMapping.writeValues(accessor, revision);
        }
    }

    @Override
    public void writeRevision(IDBStoreAccessor accessor, InternalCDORevision revision, boolean mapType, boolean revise, OMMonitor monitor) {
        OMMonitor.Async async = null;
        monitor.begin(10.0);
        try {
            try {
                async = monitor.forkAsync();
                CDOID id = revision.getID();
                if (mapType) {
                    long timeStamp = revision.getTimeStamp();
                    this.mappingStrategy.putObjectType(accessor, timeStamp, id, this.eClass);
                } else if (revise) {
                    long revised = revision.getTimeStamp() - 1L;
                    this.reviseOldRevision(accessor, id, revision.getBranch(), revised);
                    for (IListMapping mapping : this.getListMappings()) {
                        mapping.objectDetached(accessor, id, revised);
                    }
                }
            }
            finally {
                if (async != null) {
                    async.stop();
                }
            }
            try {
                async = monitor.forkAsync();
                if (revision.isResourceFolder() || revision.isResource()) {
                    this.checkDuplicateResources(accessor, (CDORevision)revision);
                }
            }
            finally {
                if (async != null) {
                    async.stop();
                }
            }
            try {
                async = monitor.forkAsync();
                this.writeValues(accessor, revision);
            }
            finally {
                if (async != null) {
                    async.stop();
                }
            }
            try {
                if (this.listMappings != null) {
                    async = monitor.forkAsync(7.0);
                    this.writeLists(accessor, revision);
                } else {
                    monitor.worked(7.0);
                }
            }
            finally {
                if (async != null) {
                    async.stop();
                }
            }
        }
        finally {
            monitor.done();
        }
    }

    @Override
    public void handleRevisions(IDBStoreAccessor accessor, CDOBranch branch, long timeStamp, boolean exactTime, CDORevisionHandler handler) {
        IRepository repository = accessor.getStore().getRepository();
        CDORevisionManager revisionManager = repository.getRevisionManager();
        CDOBranchManager branchManager = repository.getBranchManager();
        IIDHandler idHandler = this.getMappingStrategy().getStore().getIDHandler();
        IPreparedStatementCache statementCache = accessor.getStatementCache();
        PreparedStatement stmt = null;
        ResultSet resultSet = null;
        StringBuilder builder = new StringBuilder(this.sqlSelectForHandle);
        int timeParameters = 0;
        if (timeStamp != -1L) {
            if (exactTime) {
                if (timeStamp != 0L) {
                    builder.append(" WHERE ");
                    builder.append("cdo_created");
                    builder.append("=?");
                    timeParameters = 1;
                }
            } else {
                builder.append(" WHERE ");
                if (timeStamp != 0L) {
                    builder.append("cdo_created");
                    builder.append(">=?");
                    builder.append(" AND (");
                    builder.append("cdo_revised");
                    builder.append("<=? OR ");
                    builder.append("cdo_revised");
                    builder.append("=");
                    builder.append(0L);
                    builder.append(")");
                    timeParameters = 2;
                } else {
                    builder.append("cdo_revised");
                    builder.append("=");
                    builder.append(0L);
                }
            }
        }
        try {
            try {
                stmt = statementCache.getPreparedStatement(builder.toString(), IPreparedStatementCache.ReuseProbability.LOW);
                int i = 0;
                while (i < timeParameters) {
                    stmt.setLong(i + 1, timeStamp);
                    ++i;
                }
                resultSet = stmt.executeQuery();
                while (resultSet.next()) {
                    InternalCDORevision revision;
                    CDOID id = idHandler.getCDOID(resultSet, 1);
                    int version = resultSet.getInt(2);
                    if (version < 1 || handler.handleRevision((CDORevision)(revision = (InternalCDORevision)revisionManager.getRevisionByVersion(id, branchManager.getMainBranch().getVersion(version), -1, true)))) {
                        continue;
                    }
                    break;
                }
            }
            catch (SQLException e) {
                throw new DBException((Throwable)e);
            }
        }
        catch (Throwable throwable) {
            DBUtil.close(resultSet);
            statementCache.releasePreparedStatement(stmt);
            throw throwable;
        }
        DBUtil.close((ResultSet)resultSet);
        statementCache.releasePreparedStatement(stmt);
    }

    @Override
    public Set<CDOID> readChangeSet(IDBStoreAccessor accessor, CDOChangeSetSegment[] segments) {
        HashSet<CDOID> hashSet;
        StringBuilder builder = new StringBuilder(this.sqlSelectForChangeSet);
        boolean isFirst = true;
        int i = 0;
        while (i < segments.length) {
            if (isFirst) {
                isFirst = false;
            } else {
                builder.append(" OR ");
            }
            builder.append("cdo_created");
            builder.append(">=?");
            builder.append(" AND (");
            builder.append("cdo_revised");
            builder.append("<=? OR ");
            builder.append("cdo_revised");
            builder.append("=");
            builder.append(0L);
            builder.append(")");
            ++i;
        }
        IIDHandler idHandler = this.getMappingStrategy().getStore().getIDHandler();
        IPreparedStatementCache statementCache = accessor.getStatementCache();
        PreparedStatement stmt = null;
        ResultSet resultSet = null;
        HashSet<CDOID> result = new HashSet<CDOID>();
        try {
            stmt = statementCache.getPreparedStatement(builder.toString(), IPreparedStatementCache.ReuseProbability.LOW);
            int column = 1;
            CDOChangeSetSegment[] cDOChangeSetSegmentArray = segments;
            int n = segments.length;
            int n2 = 0;
            while (n2 < n) {
                CDOChangeSetSegment segment = cDOChangeSetSegmentArray[n2];
                stmt.setLong(column++, segment.getTimeStamp());
                stmt.setLong(column++, segment.getEndTime());
                ++n2;
            }
            resultSet = stmt.executeQuery();
            while (resultSet.next()) {
                CDOID id = idHandler.getCDOID(resultSet, 1);
                result.add(id);
            }
            hashSet = result;
        }
        catch (SQLException e) {
            try {
                throw new DBException((Throwable)e);
            }
            catch (Throwable throwable) {
                DBUtil.close(resultSet);
                statementCache.releasePreparedStatement(stmt);
                throw throwable;
            }
        }
        DBUtil.close((ResultSet)resultSet);
        statementCache.releasePreparedStatement(stmt);
        return hashSet;
    }

    @Override
    public void detachObject(IDBStoreAccessor accessor, CDOID id, int version, CDOBranch branch, long timeStamp, OMMonitor monitor) {
        OMMonitor.Async async = null;
        monitor.begin((double)(1 + this.listMappings.size()));
        try {
            if (version >= 1) {
                this.reviseOldRevision(accessor, id, branch, timeStamp - 1L);
            }
            this.detachAttributes(accessor, id, version + 1, branch, timeStamp, monitor.fork());
            for (IListMapping mapping : this.getListMappings()) {
                try {
                    async = monitor.forkAsync();
                    mapping.objectDetached(accessor, id, timeStamp);
                }
                finally {
                    if (async != null) {
                        async.stop();
                    }
                }
            }
        }
        finally {
            monitor.done();
        }
    }

    public void rawDelete(IDBStoreAccessor accessor, CDOID id, int version, CDOBranch branch, OMMonitor monitor) {
        OMMonitor.Async async = null;
        monitor.begin((double)(1 + this.listMappings.size()));
        try {
            this.rawDeleteAttributes(accessor, id, branch, version, monitor.fork());
            for (IListMapping mapping : this.getListMappings()) {
                if (mapping instanceof BasicAbstractListTableMapping) {
                    try {
                        async = monitor.forkAsync();
                        BasicAbstractListTableMapping m = (BasicAbstractListTableMapping)mapping;
                        m.rawDeleted(accessor, id, branch, version);
                        continue;
                    }
                    finally {
                        if (async != null) {
                            async.stop();
                        }
                    }
                }
                throw new UnsupportedOperationException("rawDeleted() is not supported by " + mapping.getClass().getName());
            }
        }
        finally {
            monitor.done();
        }
    }

    protected abstract void rawDeleteAttributes(IDBStoreAccessor var1, CDOID var2, CDOBranch var3, int var4, OMMonitor var5);

    @Override
    public final boolean queryXRefs(IDBStoreAccessor accessor, IStoreAccessor.QueryXRefsContext context, String idString) {
        boolean more;
        String tableName = this.getTable().getName();
        EClass eClass = this.getEClass();
        List refs = (List)context.getSourceCandidates().get(eClass);
        ArrayList<EReference> scalarRefs = new ArrayList<EReference>();
        for (EReference ref : refs) {
            if (ref.isMany()) {
                String where;
                IListMapping listMapping = this.getListMapping((EStructuralFeature)ref);
                boolean more2 = listMapping.queryXRefs(accessor, tableName, where = this.getListXRefsWhere(context), context, idString);
                if (more2) continue;
                return false;
            }
            scalarRefs.add(ref);
        }
        return scalarRefs.isEmpty() || (more = this.queryScalarXRefs(accessor, scalarRefs, context, idString));
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected final boolean queryScalarXRefs(IDBStoreAccessor accessor, List<EReference> scalarRefs, IStoreAccessor.QueryXRefsContext context, String idString) {
        tableName = this.getTable().getName();
        where = this.getListXRefsWhere(context);
        var8_7 = scalarRefs.iterator();
        while (true) {
            if (!var8_7.hasNext()) {
                return true;
            }
            ref = var8_7.next();
            valueMapping = this.getValueMapping((EStructuralFeature)ref);
            valueField = valueMapping.getField().getName();
            builder = new StringBuilder();
            builder.append("SELECT ");
            builder.append("cdo_id");
            builder.append(", ");
            builder.append(valueField);
            builder.append(" FROM ");
            builder.append(tableName);
            builder.append(" WHERE ");
            builder.append("cdo_version");
            builder.append(">0 AND ");
            builder.append(where);
            builder.append(" AND ");
            builder.append(valueField);
            builder.append(" IN ");
            builder.append(idString);
            sql = builder.toString();
            idHandler = this.getMappingStrategy().getStore().getIDHandler();
            resultSet = null;
            stmt = null;
            try {
                stmt = accessor.getConnection().createStatement();
                if (AbstractHorizontalClassMapping.TRACER.isEnabled()) {
                    AbstractHorizontalClassMapping.TRACER.format("Query XRefs (attributes): {0}", new Object[]{sql});
                }
                resultSet = stmt.executeQuery(sql);
                ** GOTO lbl-1000
            }
            catch (SQLException ex) {
                throw new DBException((Throwable)ex);
                catch (Throwable var19_20) {
                    DBUtil.close(resultSet);
                    DBUtil.close((Statement)stmt);
                    throw var19_20;
                }
lbl57:
                // 2 sources

                while (true) {
                    DBUtil.close((ResultSet)resultSet);
                    DBUtil.close((Statement)stmt);
                    return false;
                }
lbl-1000:
                // 2 sources

                {
                    ** while (resultSet.next())
                }
lbl-1000:
                // 1 sources

                {
                    sourceID = idHandler.getCDOID(resultSet, 1);
                    targetID = idHandler.getCDOID(resultSet, 2);
                    more = context.addXRef(targetID, sourceID, ref, 0);
                    if (AbstractHorizontalClassMapping.TRACER.isEnabled()) {
                        AbstractHorizontalClassMapping.TRACER.format("  add XRef to context: src={0}, tgt={1}, idx=0", new Object[]{sourceID, targetID});
                    }
                    if (more) continue;
                    if (!AbstractHorizontalClassMapping.TRACER.isEnabled()) ** GOTO lbl57
                    AbstractHorizontalClassMapping.TRACER.format("  result limit reached. Ignoring further results.", new Object[0]);
                    ** continue;
lbl73:
                    // 1 sources

                    ** GOTO lbl57
                }
            }
lbl74:
            // 1 sources

            DBUtil.close((ResultSet)resultSet);
            DBUtil.close((Statement)stmt);
        }
    }

    protected abstract String getListXRefsWhere(IStoreAccessor.QueryXRefsContext var1);

    protected abstract void detachAttributes(IDBStoreAccessor var1, CDOID var2, int var3, CDOBranch var4, long var5, OMMonitor var7);

    protected abstract void reviseOldRevision(IDBStoreAccessor var1, CDOID var2, CDOBranch var3, long var4);

    protected abstract void writeValues(IDBStoreAccessor var1, InternalCDORevision var2);
}

