/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.server.internal.db.mapping.horizontal;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.cdo.common.revision.CDOList;
import org.eclipse.emf.cdo.common.revision.CDORevision;
import org.eclipse.emf.cdo.server.IStoreAccessor;
import org.eclipse.emf.cdo.server.IStoreChunkReader;
import org.eclipse.emf.cdo.server.db.IDBStoreAccessor;
import org.eclipse.emf.cdo.server.db.IDBStoreChunkReader;
import org.eclipse.emf.cdo.server.db.IPreparedStatementCache;
import org.eclipse.emf.cdo.server.db.mapping.IMappingStrategy;
import org.eclipse.emf.cdo.server.db.mapping.ITypeMapping;
import org.eclipse.emf.cdo.server.internal.db.bundle.OM;
import org.eclipse.emf.cdo.server.internal.db.mapping.horizontal.BasicAbstractListTableMapping;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDORevision;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.net4j.db.DBException;
import org.eclipse.net4j.db.DBType;
import org.eclipse.net4j.db.DBUtil;
import org.eclipse.net4j.db.ddl.IDBField;
import org.eclipse.net4j.db.ddl.IDBIndex;
import org.eclipse.net4j.db.ddl.IDBTable;
import org.eclipse.net4j.util.om.trace.ContextTracer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractListTableMapping
extends BasicAbstractListTableMapping {
    private static final ContextTracer TRACER = new ContextTracer(OM.DEBUG, AbstractListTableMapping.class);
    private IDBTable table;
    private ITypeMapping typeMapping;
    private String sqlSelectChunksPrefix;
    private String sqlOrderByIndex;
    private String sqlInsertEntry;

    public AbstractListTableMapping(IMappingStrategy mappingStrategy, EClass eClass, EStructuralFeature feature) {
        super(mappingStrategy, eClass, feature);
        this.initTable();
        this.initSQLStrings();
    }

    private void initTable() {
        IMappingStrategy mappingStrategy = this.getMappingStrategy();
        String tableName = mappingStrategy.getTableName(this.getContainingClass(), this.getFeature());
        this.table = mappingStrategy.getStore().getDBSchema().addTable(tableName);
        FieldInfo[] fields = this.getKeyFields();
        IDBField[] dbFields = new IDBField[fields.length + 1];
        int i = 0;
        while (i < fields.length) {
            dbFields[i] = this.table.addField(fields[i].getName(), fields[i].getDbType());
            ++i;
        }
        dbFields[dbFields.length - 1] = this.table.addField("cdo_idx", DBType.INTEGER);
        this.typeMapping = mappingStrategy.createValueMapping(this.getFeature());
        this.typeMapping.createDBField(this.table, "cdo_value");
        this.table.addIndex(IDBIndex.Type.UNIQUE, dbFields);
    }

    protected abstract FieldInfo[] getKeyFields();

    protected abstract void setKeyFields(PreparedStatement var1, CDORevision var2) throws SQLException;

    @Override
    public Collection<IDBTable> getDBTables() {
        return Arrays.asList(this.table);
    }

    private void initSQLStrings() {
        String tableName = this.getTable().getName();
        FieldInfo[] fields = this.getKeyFields();
        StringBuilder builder = new StringBuilder();
        builder.append("SELECT ");
        builder.append("cdo_value");
        builder.append(" FROM ");
        builder.append(tableName);
        builder.append(" WHERE ");
        int i = 0;
        while (i < fields.length) {
            builder.append(fields[i].getName());
            if (i + 1 < fields.length) {
                builder.append("=? AND ");
            } else {
                builder.append("=? ");
            }
            ++i;
        }
        this.sqlSelectChunksPrefix = builder.toString();
        this.sqlOrderByIndex = " ORDER BY cdo_idx";
        builder = new StringBuilder("INSERT INTO ");
        builder.append(tableName);
        builder.append("(");
        i = 0;
        while (i < fields.length) {
            builder.append(fields[i].getName());
            builder.append(", ");
            ++i;
        }
        builder.append("cdo_idx");
        builder.append(", ");
        builder.append("cdo_value");
        builder.append(") VALUES (");
        i = 0;
        while (i < fields.length) {
            builder.append("?, ");
            ++i;
        }
        builder.append(" ?, ?)");
        this.sqlInsertEntry = builder.toString();
    }

    protected final IDBTable getTable() {
        return this.table;
    }

    protected final ITypeMapping getTypeMapping() {
        return this.typeMapping;
    }

    @Override
    public void readValues(IDBStoreAccessor accessor, InternalCDORevision revision, int listChunk) {
        CDOList list = revision.getList(this.getFeature());
        if (listChunk == 0 || list.size() == 0) {
            return;
        }
        if (TRACER.isEnabled()) {
            TRACER.format("Reading list values for feature {0}.{1} of {2}v{3}", new Object[]{this.getContainingClass().getName(), this.getFeature().getName(), revision.getID(), revision.getVersion()});
        }
        IPreparedStatementCache statementCache = accessor.getStatementCache();
        PreparedStatement stmt = null;
        ResultSet resultSet = null;
        try {
            try {
                String sql = String.valueOf(this.sqlSelectChunksPrefix) + this.sqlOrderByIndex;
                stmt = statementCache.getPreparedStatement(sql, IPreparedStatementCache.ReuseProbability.HIGH);
                this.setKeyFields(stmt, (CDORevision)revision);
                if (TRACER.isEnabled()) {
                    TRACER.trace(stmt.toString());
                }
                if (listChunk != -1) {
                    stmt.setMaxRows(listChunk);
                }
                resultSet = stmt.executeQuery();
                int currentIndex = 0;
                while ((listChunk == -1 || --listChunk >= 0) && resultSet.next()) {
                    Object value = this.typeMapping.readValue(resultSet);
                    if (TRACER.isEnabled()) {
                        TRACER.format("Read value for index {0} from result set: {1}", new Object[]{list.size(), value});
                    }
                    list.set(currentIndex++, value);
                }
            }
            catch (SQLException ex) {
                throw new DBException((Throwable)ex);
            }
        }
        catch (Throwable throwable) {
            DBUtil.close(resultSet);
            statementCache.releasePreparedStatement(stmt);
            throw throwable;
        }
        DBUtil.close((ResultSet)resultSet);
        statementCache.releasePreparedStatement(stmt);
        if (TRACER.isEnabled()) {
            TRACER.format("Reading list values done for feature {0}.{1} of {2}v{3}", new Object[]{this.getContainingClass().getName(), this.getFeature().getName(), revision.getID(), revision.getVersion()});
        }
    }

    @Override
    public final void readChunks(IDBStoreChunkReader chunkReader, List<IStoreChunkReader.Chunk> chunks, String where) {
        if (TRACER.isEnabled()) {
            TRACER.format("Reading list chunk values for feature {0}.{1} of {2}v{3}", new Object[]{this.getContainingClass().getName(), this.getFeature().getName(), chunkReader.getRevision().getID(), chunkReader.getRevision().getVersion()});
        }
        IPreparedStatementCache statementCache = chunkReader.getAccessor().getStatementCache();
        PreparedStatement stmt = null;
        ResultSet resultSet = null;
        try {
            try {
                StringBuilder builder = new StringBuilder(this.sqlSelectChunksPrefix);
                if (where != null) {
                    builder.append(" AND ");
                    builder.append(where);
                }
                builder.append(this.sqlOrderByIndex);
                String sql = builder.toString();
                stmt = statementCache.getPreparedStatement(sql, IPreparedStatementCache.ReuseProbability.LOW);
                this.setKeyFields(stmt, chunkReader.getRevision());
                resultSet = stmt.executeQuery();
                IStoreChunkReader.Chunk chunk = null;
                int chunkSize = 0;
                int chunkIndex = 0;
                int indexInChunk = 0;
                while (resultSet.next()) {
                    Object value = this.typeMapping.readValue(resultSet);
                    if (chunk == null) {
                        chunk = chunks.get(chunkIndex++);
                        chunkSize = chunk.size();
                        if (TRACER.isEnabled()) {
                            TRACER.format("Current chunk no. {0} is [start = {1}, size = {2}]", new Object[]{chunkIndex - 1, chunk.getStartIndex(), chunkSize});
                        }
                    }
                    if (TRACER.isEnabled()) {
                        TRACER.format("Read value for chunk index {0} from result set: {1}", new Object[]{indexInChunk, value});
                    }
                    chunk.add(indexInChunk++, value);
                    if (indexInChunk != chunkSize) continue;
                    if (TRACER.isEnabled()) {
                        TRACER.format("Chunk finished", new Object[0]);
                    }
                    chunk = null;
                    indexInChunk = 0;
                }
                if (TRACER.isEnabled()) {
                    TRACER.format("Reading list chunk values done for feature {0}.{1} of {2}v{3}", new Object[]{this.getContainingClass().getName(), this.getFeature().getName(), chunkReader.getRevision().getID(), chunkReader.getRevision().getVersion()});
                }
            }
            catch (SQLException ex) {
                throw new DBException((Throwable)ex);
            }
        }
        catch (Throwable throwable) {
            DBUtil.close(resultSet);
            statementCache.releasePreparedStatement(stmt);
            throw throwable;
        }
        DBUtil.close((ResultSet)resultSet);
        statementCache.releasePreparedStatement(stmt);
    }

    @Override
    public void writeValues(IDBStoreAccessor accessor, InternalCDORevision revision) {
        CDOList values = revision.getList(this.getFeature());
        int idx = 0;
        for (Object element : values) {
            this.writeValue(accessor, (CDORevision)revision, idx++, element);
        }
    }

    protected final void writeValue(IDBStoreAccessor accessor, CDORevision revision, int idx, Object value) {
        IPreparedStatementCache statementCache = accessor.getStatementCache();
        PreparedStatement stmt = null;
        if (TRACER.isEnabled()) {
            TRACER.format("Writing value for feature {0}.{1} index {2} of {3}v{4} : {5}", new Object[]{this.getContainingClass().getName(), this.getFeature().getName(), idx, revision.getID(), revision.getVersion(), value});
        }
        try {
            try {
                stmt = statementCache.getPreparedStatement(this.sqlInsertEntry, IPreparedStatementCache.ReuseProbability.HIGH);
                this.setKeyFields(stmt, revision);
                int column = this.getKeyFields().length + 1;
                stmt.setInt(column++, idx);
                this.typeMapping.setValue(stmt, column++, value);
                DBUtil.update((PreparedStatement)stmt, (boolean)true);
            }
            catch (SQLException e) {
                throw new DBException((Throwable)e);
            }
        }
        catch (Throwable throwable) {
            statementCache.releasePreparedStatement(stmt);
            throw throwable;
        }
        statementCache.releasePreparedStatement(stmt);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean queryXRefs(IDBStoreAccessor accessor, String mainTableName, String mainTableWhere, IStoreAccessor.QueryXRefsContext context, String idString) {
        tableName = this.getTable().getName();
        listJoin = this.getMappingStrategy().getListJoin("a_t", "l_t");
        builder = new StringBuilder();
        builder.append("SELECT l_t.");
        builder.append("cdo_source");
        builder.append(", l_t.");
        builder.append("cdo_value");
        builder.append(", l_t.");
        builder.append("cdo_idx");
        builder.append(" FROM ");
        builder.append(tableName);
        builder.append(" AS l_t, ");
        builder.append(mainTableName);
        builder.append(" AS a_t WHERE ");
        builder.append("a_t." + mainTableWhere);
        builder.append(listJoin);
        builder.append(" AND ");
        builder.append("cdo_value");
        builder.append(" IN ");
        builder.append(idString);
        sql = builder.toString();
        idHandler = this.getMappingStrategy().getStore().getIDHandler();
        resultSet = null;
        stmt = null;
        try {
            stmt = accessor.getConnection().createStatement();
            if (AbstractListTableMapping.TRACER.isEnabled()) {
                AbstractListTableMapping.TRACER.format("Query XRefs (list): {0}", new Object[]{sql});
            }
            resultSet = stmt.executeQuery(sql);
            ** GOTO lbl-1000
        }
        catch (SQLException ex) {
            try {
                throw new DBException((Throwable)ex);
            }
            catch (Throwable var17_18) {
                DBUtil.close(resultSet);
                DBUtil.close((Statement)stmt);
                throw var17_18;
            }
        }
lbl57:
        // 2 sources

        while (true) {
            DBUtil.close((ResultSet)resultSet);
            DBUtil.close((Statement)stmt);
            return false;
        }
lbl-1000:
        // 2 sources

        {
            ** while (resultSet.next())
        }
lbl-1000:
        // 1 sources

        {
            srcId = idHandler.getCDOID(resultSet, 1);
            targetId = idHandler.getCDOID(resultSet, 2);
            idx = resultSet.getInt(3);
            more = context.addXRef(targetId, srcId, (EReference)this.getFeature(), idx);
            if (AbstractListTableMapping.TRACER.isEnabled()) {
                AbstractListTableMapping.TRACER.format("  add XRef to context: src={0}, tgt={1}, idx={2}", new Object[]{srcId, targetId, idx});
            }
            if (more) continue;
            if (!AbstractListTableMapping.TRACER.isEnabled()) ** GOTO lbl57
            AbstractListTableMapping.TRACER.format("  result limit reached. Ignoring further results.", new Object[0]);
            ** continue;
lbl74:
            // 1 sources

            ** GOTO lbl57
        }
lbl75:
        // 1 sources

        DBUtil.close((ResultSet)resultSet);
        DBUtil.close((Statement)stmt);
        return true;
    }

    protected static class FieldInfo {
        private String name;
        private DBType dbType;

        public FieldInfo(String name, DBType dbType) {
            this.name = name;
            this.dbType = dbType;
        }

        public String getName() {
            return this.name;
        }

        public DBType getDbType() {
            return this.dbType;
        }
    }
}

