/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.server.internal.db.mapping.horizontal;

import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collection;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.protocol.CDODataInput;
import org.eclipse.emf.cdo.common.protocol.CDODataOutput;
import org.eclipse.emf.cdo.server.db.IIDHandler;
import org.eclipse.emf.cdo.server.db.mapping.IClassMapping;
import org.eclipse.emf.cdo.server.db.mapping.IListMapping;
import org.eclipse.emf.cdo.server.internal.db.mapping.horizontal.BranchingFeatureMapTableMappingWithRanges;
import org.eclipse.emf.cdo.server.internal.db.mapping.horizontal.BranchingListTableMappingWithRanges;
import org.eclipse.emf.cdo.server.internal.db.mapping.horizontal.HorizontalBranchingClassMapping;
import org.eclipse.emf.cdo.server.internal.db.mapping.horizontal.HorizontalBranchingMappingStrategy;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.net4j.db.DBException;
import org.eclipse.net4j.db.DBUtil;
import org.eclipse.net4j.db.ddl.IDBField;
import org.eclipse.net4j.db.ddl.IDBTable;
import org.eclipse.net4j.util.io.ExtendedDataInput;
import org.eclipse.net4j.util.om.monitor.OMMonitor;

public class HorizontalBranchingMappingStrategyWithRanges
extends HorizontalBranchingMappingStrategy {
    private boolean copyOnBranch;

    public boolean hasDeltaSupport() {
        return true;
    }

    public boolean shallCopyOnBranch() {
        return this.copyOnBranch;
    }

    public IClassMapping doCreateClassMapping(EClass eClass) {
        return new HorizontalBranchingClassMapping(this, eClass);
    }

    public IListMapping doCreateListMapping(EClass containingClass, EStructuralFeature feature) {
        return new BranchingListTableMappingWithRanges(this, containingClass, feature);
    }

    public IListMapping doCreateFeatureMapMapping(EClass containingClass, EStructuralFeature feature) {
        return new BranchingFeatureMapTableMappingWithRanges(this, containingClass, feature);
    }

    protected void rawExportList(CDODataOutput out, Connection connection, IListMapping listMapping, IDBTable attrTable, String attrSuffix) throws IOException {
        super.rawExportList(out, connection, listMapping, attrTable, attrSuffix);
        for (IDBTable table : listMapping.getDBTables()) {
            this.rawExportListPostProcess(out, connection, attrTable, attrSuffix, table);
        }
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void rawExportListPostProcess(CDODataOutput out, Connection connection, IDBTable attrTable, String attrSuffix, IDBTable table) throws IOException {
        builder = new StringBuilder();
        builder.append("SELECT l_t.");
        builder.append("cdo_source");
        builder.append(", l_t.");
        builder.append("cdo_branch");
        builder.append(", l_t.");
        builder.append("cdo_version_added");
        builder.append(", l_t.");
        builder.append("cdo_version_removed");
        builder.append(", l_t.");
        builder.append("cdo_idx");
        builder.append(" FROM ");
        builder.append(table);
        builder.append(" l_t, ");
        builder.append(attrTable);
        builder.append(" a_t");
        builder.append(attrSuffix);
        builder.append(this.getListJoinForPostProcess("a_t", "l_t"));
        builder.append(" AND l_t.");
        builder.append("cdo_version_removed");
        builder.append(" IS NOT NULL");
        sql = DBUtil.trace((String)builder.toString());
        idHandler = this.getStore().getIDHandler();
        stmt = null;
        resultSet = null;
        try {
            stmt = connection.prepareStatement(sql, 1004, 1007);
            resultSet = stmt.executeQuery();
            size = DBUtil.getRowCount((ResultSet)resultSet);
            out.writeInt(size);
            ** if (size != 0) goto lbl57
        }
        catch (Throwable var17_18) {
            DBUtil.close(resultSet);
            DBUtil.close((Statement)stmt);
            throw var17_18;
        }
lbl-1000:
        // 1 sources

        {
            DBUtil.close((ResultSet)resultSet);
            DBUtil.close((Statement)stmt);
            return;
        }
lbl57:
        // 1 sources

        ** GOTO lbl76
        {
            catch (SQLException ex) {
                throw new DBException((Throwable)ex);
            }
        }
lbl-1000:
        // 1 sources

        {
            source = idHandler.getCDOID(resultSet, 1);
            branch = resultSet.getInt(2);
            versionAdded = resultSet.getInt(3);
            versionRemoved = resultSet.getInt(4);
            idx = resultSet.getInt(5);
            out.writeCDOID(source);
            out.writeInt(branch);
            out.writeInt(versionAdded);
            out.writeInt(versionRemoved);
            out.writeInt(idx);
lbl76:
            // 2 sources

            ** while (resultSet.next())
        }
lbl77:
        // 1 sources

        DBUtil.close((ResultSet)resultSet);
        DBUtil.close((Statement)stmt);
    }

    protected void rawImportList(CDODataInput in, Connection connection, IListMapping listMapping, OMMonitor monitor) throws IOException {
        Collection<IDBTable> tables = listMapping.getDBTables();
        int size = tables.size();
        if (size == 0) {
            return;
        }
        monitor.begin((double)(2 * size));
        try {
            super.rawImportList(in, connection, listMapping, monitor.fork((double)size));
            for (IDBTable table : tables) {
                this.rawImportListPostProcess(in, connection, table, monitor.fork());
            }
        }
        finally {
            monitor.done();
        }
    }

    private void rawImportListPostProcess(CDODataInput in, Connection connection, IDBTable table, OMMonitor monitor) throws IOException {
        int size = in.readInt();
        if (size == 0) {
            return;
        }
        StringBuilder builder = new StringBuilder();
        builder.append("UPDATE ");
        builder.append(table);
        builder.append(" SET ");
        builder.append("cdo_version_removed");
        builder.append("=? WHERE ");
        builder.append("cdo_source");
        builder.append("=? AND ");
        builder.append("cdo_branch");
        builder.append("=? AND ");
        builder.append("cdo_version_added");
        builder.append("=? AND ");
        builder.append("cdo_idx");
        builder.append("=?");
        String sql = DBUtil.trace((String)builder.toString());
        IIDHandler idHandler = this.getStore().getIDHandler();
        PreparedStatement stmt = null;
        monitor.begin((double)(1 + 2 * size));
        try {
            try {
                stmt = connection.prepareStatement(sql);
                monitor.worked();
                int row = 0;
                while (row < size) {
                    CDOID source = in.readCDOID();
                    int branch = in.readInt();
                    int versionAdded = in.readInt();
                    int versionRemoved = in.readInt();
                    int idx = in.readInt();
                    stmt.setInt(1, versionRemoved);
                    idHandler.setCDOID(stmt, 2, source);
                    stmt.setInt(3, branch);
                    stmt.setInt(4, versionAdded);
                    stmt.setInt(5, idx);
                    stmt.addBatch();
                    monitor.worked();
                    ++row;
                }
                OMMonitor.Async async = monitor.forkAsync((double)size);
                try {
                    stmt.executeBatch();
                }
                finally {
                    async.stop();
                }
            }
            catch (SQLException ex) {
                throw new DBException((Throwable)ex);
            }
        }
        catch (Throwable throwable) {
            DBUtil.close(stmt);
            monitor.done();
            throw throwable;
        }
        DBUtil.close((Statement)stmt);
        monitor.done();
    }

    protected String getListJoinForPostProcess(String attrTable, String listTable) {
        String join = this.getListJoinBasic(attrTable, listTable);
        return this.modifyListJoin2(attrTable, listTable, join, true, true);
    }

    protected String modifyListJoin(String attrTable, String listTable, String join, boolean forRawExport) {
        return this.modifyListJoin2(attrTable, listTable, join, forRawExport, false);
    }

    private String modifyListJoin2(String attrTable, String listTable, String join, boolean forRawExport, boolean forPostProcess) {
        join = String.valueOf(join) + " AND " + listTable + ".";
        if (forRawExport) {
            join = forPostProcess ? String.valueOf(join) + "cdo_version_removed" : String.valueOf(join) + "cdo_version_added";
            join = String.valueOf(join) + "=" + attrTable + "." + "cdo_version";
        } else {
            join = String.valueOf(join) + "cdo_version_added";
            join = String.valueOf(join) + "<=" + attrTable + "." + "cdo_version";
            join = String.valueOf(join) + " AND (" + listTable + "." + "cdo_version_removed";
            join = String.valueOf(join) + " IS NULL OR " + listTable + "." + "cdo_version_removed";
            join = String.valueOf(join) + ">" + attrTable + "." + "cdo_version" + ")";
        }
        join = String.valueOf(join) + " AND " + attrTable + "." + "cdo_branch";
        join = String.valueOf(join) + "=" + listTable + "." + "cdo_branch";
        if (forRawExport && !forPostProcess) {
            join = String.valueOf(join) + " ORDER BY " + listTable + "." + "cdo_source";
            join = String.valueOf(join) + ", " + listTable + "." + "cdo_branch";
            join = String.valueOf(join) + ", " + listTable + "." + "cdo_version_added";
            join = String.valueOf(join) + ", " + listTable + "." + "cdo_idx";
        }
        return join;
    }

    protected DBUtil.DeserializeRowHandler getImportListHandler() {
        return new ImportListHandler();
    }

    protected void doAfterActivate() throws Exception {
        super.doAfterActivate();
        String value = this.getProperties().get("copyOnBranch");
        this.copyOnBranch = value == null ? false : Boolean.valueOf(value);
    }

    private final class ImportListHandler
    implements DBUtil.DeserializeRowHandler {
        private final IIDHandler idHandler;
        private PreparedStatement stmt;

        private ImportListHandler() {
            this.idHandler = HorizontalBranchingMappingStrategyWithRanges.this.getStore().getIDHandler();
        }

        public void handleRow(ExtendedDataInput in, Connection connection, IDBField[] fields, Object[] values) throws SQLException, IOException {
            int versionAdded = (Integer)values[2];
            if (versionAdded == 1) {
                return;
            }
            if (this.stmt == null) {
                String sql = "UPDATE " + fields[0].getTable() + " SET " + "cdo_version_removed" + "=?" + " WHERE " + "cdo_source" + "=?" + " AND " + "cdo_branch" + "=?" + " AND " + "cdo_idx" + "=?" + " AND " + "cdo_version_added" + "<?" + " AND " + "cdo_version_removed" + " IS NULL";
                this.stmt = connection.prepareStatement(sql);
            }
            Object sourceID = values[0];
            int branch = (Integer)values[1];
            int index = (Integer)values[4];
            this.stmt.setInt(1, versionAdded);
            this.idHandler.setCDOIDRaw(this.stmt, 2, sourceID);
            this.stmt.setInt(3, branch);
            this.stmt.setInt(4, index);
            this.stmt.setInt(5, versionAdded);
            this.stmt.addBatch();
        }

        public void done(boolean successful) throws SQLException, IOException {
            if (this.stmt != null) {
                try {
                    if (successful) {
                        this.stmt.executeBatch();
                    }
                }
                finally {
                    DBUtil.close((Statement)this.stmt);
                    this.stmt = null;
                }
            }
        }
    }
}

