/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.server.internal.objectivity.db;

import com.objy.db.app.Session;
import com.objy.db.app.ooId;
import com.objy.db.app.ooObj;
import com.objy.db.util.ooTreeSetX;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.cdo.common.branch.CDOBranch;
import org.eclipse.emf.cdo.server.internal.objectivity.schema.ObjyCommitInfo;
import org.eclipse.emf.cdo.server.internal.objectivity.utils.ObjyDb;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObjyCommitInfoHandler {
    protected ooId commitInfoSetId;

    public ObjyCommitInfoHandler(String repositoryName) {
        this.commitInfoSetId = ObjyDb.getOrCreateCommitInfoList(repositoryName);
    }

    public static ooId create(ooId scopeContOid) {
        ooTreeSetX treeSet = new ooTreeSetX(20, true);
        ooObj clusterObject = ooObj.create_ooObj((ooId)scopeContOid);
        clusterObject.cluster((Object)treeSet);
        return treeSet.getOid();
    }

    public void writeCommitInfo(int id, long timeStamp, long previousTimeStamp, String userID, String comment) {
        ObjyCommitInfo commitInfo = new ObjyCommitInfo(id, timeStamp, previousTimeStamp, userID, comment);
        this.getTreeSet().add((Object)commitInfo);
    }

    public List<ObjyCommitInfo> getCommitInfo(CDOBranch branch, long startTime, long endTime) {
        ooTreeSetX treeSet = this.getTreeSet();
        ObjyCommitInfo ooCommitInfo2 = null;
        ArrayList<ObjyCommitInfo> results = new ArrayList<ObjyCommitInfo>();
        boolean getIt = false;
        for (ObjyCommitInfo ooCommitInfo2 : treeSet) {
            getIt = true;
            long timeStamp = ooCommitInfo2.getTimeStamp();
            long branchId = ooCommitInfo2.getBranchId();
            if (branch != null && (long)branch.getID() != branchId) {
                getIt = false;
            }
            if (getIt && startTime != 0L && timeStamp < startTime) {
                getIt = false;
            }
            if (getIt && endTime != 0L && timeStamp > endTime) {
                getIt = false;
            }
            if (!getIt) continue;
            results.add(ooCommitInfo2);
        }
        return results;
    }

    protected ooTreeSetX getTreeSet() {
        ooTreeSetX treeSet = null;
        treeSet = (ooTreeSetX)Session.getCurrent().getFD().objectFrom(this.commitInfoSetId.getString());
        return treeSet;
    }
}

