/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.server.internal.objectivity.db;

import com.objy.as.app.Class_Object;
import com.objy.as.app.Numeric_Value;
import com.objy.as.app.Relationship_Object;
import com.objy.as.app.String_Value;
import com.objy.as.app.VArray_Object;
import com.objy.as.app.d_Attribute;
import com.objy.as.app.d_Class;
import com.objy.as.app.d_Ref_Type;
import com.objy.as.asException;
import com.objy.db.app.Iterator;
import com.objy.db.app.ooId;
import com.objy.db.app.ooObj;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.cdo.common.branch.CDOBranch;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.id.CDOIDExternal;
import org.eclipse.emf.cdo.common.model.EMFUtil;
import org.eclipse.emf.cdo.common.revision.CDOList;
import org.eclipse.emf.cdo.common.revision.CDORevisionUtil;
import org.eclipse.emf.cdo.common.util.CDOCommonUtil;
import org.eclipse.emf.cdo.server.internal.objectivity.ObjectivityStoreAccessor;
import org.eclipse.emf.cdo.server.internal.objectivity.bundle.OM;
import org.eclipse.emf.cdo.server.internal.objectivity.db.ObjyClass;
import org.eclipse.emf.cdo.server.internal.objectivity.db.ObjyObjectManager;
import org.eclipse.emf.cdo.server.internal.objectivity.db.ObjySchema;
import org.eclipse.emf.cdo.server.internal.objectivity.mapper.IManyTypeMapper;
import org.eclipse.emf.cdo.server.internal.objectivity.mapper.ISingleTypeMapper;
import org.eclipse.emf.cdo.server.internal.objectivity.mapper.ITypeMapper;
import org.eclipse.emf.cdo.server.internal.objectivity.mapper.ObjyMapper;
import org.eclipse.emf.cdo.server.internal.objectivity.mapper.SingleReferenceMapper;
import org.eclipse.emf.cdo.server.internal.objectivity.schema.ObjyArrayListId;
import org.eclipse.emf.cdo.server.internal.objectivity.schema.ObjyArrayListString;
import org.eclipse.emf.cdo.server.internal.objectivity.schema.ObjyFeatureMapArrayList;
import org.eclipse.emf.cdo.server.internal.objectivity.schema.ObjyFeatureMapEntry;
import org.eclipse.emf.cdo.server.internal.objectivity.schema.ObjyProxy;
import org.eclipse.emf.cdo.server.internal.objectivity.utils.OBJYCDOIDUtil;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDOList;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDORevision;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.FeatureMap;
import org.eclipse.net4j.util.om.trace.ContextTracer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObjyObject {
    private static final ContextTracer TRACER_DEBUG = new ContextTracer(OM.DEBUG, ObjyObject.class);
    protected Class_Object classObject;
    protected ObjyClass objyClass;
    protected Class_Object baseClassObject = null;
    protected Relationship_Object baseRel = null;
    protected boolean hasBaseRelationshipChecked = false;
    protected Relationship_Object revisionsRel = null;
    protected Relationship_Object lastRevisionRel = null;
    protected ooId objectId;
    protected ooId revisionId = null;
    protected int version = Integer.MAX_VALUE;
    public static int fetchCount = 0;
    public static int updateCount = 0;
    public static long createObjectTime = 0L;
    public static int createObjectCount = 0;
    private Map<String, Object> featureMap = new HashMap<String, Object>();

    public ObjyObject(Class_Object classObject) {
        this.classObject = classObject;
        d_Class dClass = classObject.type_of();
        String fullyQualifiedClassName = null;
        try {
            fullyQualifiedClassName = dClass.namespace_name() != null ? String.valueOf(dClass.namespace_name()) + ":" + dClass.name() : dClass.name();
            this.objyClass = ObjySchema.getObjyClass(fullyQualifiedClassName);
            this.setObjectId(classObject.objectID());
        }
        catch (RuntimeException ex) {
            ex.printStackTrace();
        }
    }

    private Relationship_Object getLastRevisionRelationship() {
        if (this.lastRevisionRel == null) {
            this.lastRevisionRel = this.classObject.nget_relationship("oo_lastRevision");
        }
        return this.lastRevisionRel;
    }

    private Relationship_Object getRevisionsRelationship() {
        if (this.revisionsRel == null) {
            this.revisionsRel = this.classObject.nget_relationship("oo_revisions");
        }
        return this.revisionsRel;
    }

    private Relationship_Object getBaseRelationship() {
        if (this.baseRel == null) {
            this.baseRel = this.classObject.nget_relationship("oo_base");
        }
        return this.baseRel;
    }

    public ObjyClass objyClass() {
        return this.objyClass;
    }

    public Class_Object ooClassObject() {
        if (TRACER_DEBUG.isEnabled()) {
            this.checkSession();
        }
        return this.classObject;
    }

    public void setObjectId(ooId objectId) {
        this.objectId = objectId;
    }

    public ooId ooId() {
        return this.objectId;
    }

    public void setEContainer(Object containerID) {
        if (TRACER_DEBUG.isEnabled()) {
            this.checkSession();
        }
        SingleReferenceMapper.INSTANCE.setValue(this, "oo_containerId", containerID);
    }

    public Object getEContainer() {
        if (TRACER_DEBUG.isEnabled()) {
            this.checkSession();
        }
        Object value = SingleReferenceMapper.INSTANCE.getValue(this, "oo_containerId");
        return value;
    }

    public ooId getEContainerAsOid() {
        if (TRACER_DEBUG.isEnabled()) {
            this.checkSession();
        }
        ooId childOid = this.get_ooId("oo_containerId");
        return childOid;
    }

    public void setEResource(Object resourceID) {
        if (TRACER_DEBUG.isEnabled()) {
            this.checkSession();
        }
        SingleReferenceMapper.INSTANCE.setValue(this, "oo_resourceId", resourceID);
    }

    public Object getEResource() {
        if (TRACER_DEBUG.isEnabled()) {
            this.checkSession();
        }
        Object value = SingleReferenceMapper.INSTANCE.getValue(this, "oo_resourceId");
        return value;
    }

    public ooId getEResourceAsOid() {
        if (TRACER_DEBUG.isEnabled()) {
            this.checkSession();
        }
        ooId childOid = this.get_ooId("oo_resourceId");
        return childOid;
    }

    public void setEContainingFeature(int contFeature) {
        if (TRACER_DEBUG.isEnabled()) {
            this.checkSession();
        }
        this.set_numeric("oo_containerFeatureId", new Numeric_Value(contFeature));
    }

    public int getEContainingFeature() {
        if (TRACER_DEBUG.isEnabled()) {
            this.checkSession();
        }
        return this.get_numeric("oo_containerFeatureId").intValue();
    }

    public Object getFeatureList(String featureName) {
        return this.featureMap.get(featureName);
    }

    public void setFeatureList(String featureName, Object object) {
        this.featureMap.put(featureName, object);
    }

    public int getVersion() {
        if (TRACER_DEBUG.isEnabled()) {
            this.checkSession();
        }
        this.version = this.classObject.nget_numeric("oo_version").intValue();
        return this.version;
    }

    public void setVersion(int version) {
        if (TRACER_DEBUG.isEnabled()) {
            this.checkSession();
        }
        this.classObject.nset_numeric("oo_version", new Numeric_Value(version));
        this.version = version;
    }

    public long getCreationTime() {
        if (TRACER_DEBUG.isEnabled()) {
            this.checkSession();
        }
        long creationTime = this.classObject.nget_numeric("oo_creationTime").longValue();
        return creationTime;
    }

    public void setCreationTime(long creationTime) {
        if (TRACER_DEBUG.isEnabled()) {
            this.checkSession();
        }
        this.classObject.nset_numeric("oo_creationTime", new Numeric_Value(creationTime));
    }

    public long getRevisedTime() {
        long revisedTime = 0L;
        try {
            if (TRACER_DEBUG.isEnabled()) {
                this.checkSession();
            }
            revisedTime = this.classObject.nget_numeric("oo_revisedTime").longValue();
        }
        catch (RuntimeException ex) {
            ex.printStackTrace();
        }
        return revisedTime;
    }

    public void setRevisedTime(long revisedTime) {
        try {
            if (TRACER_DEBUG.isEnabled()) {
                this.checkSession();
            }
            this.classObject.nset_numeric("oo_revisedTime", new Numeric_Value(revisedTime));
        }
        catch (RuntimeException ex) {
            ex.printStackTrace();
        }
    }

    public void setBranchId(int branchId) {
        try {
            if (TRACER_DEBUG.isEnabled()) {
                this.checkSession();
            }
            this.classObject.nset_numeric("oo_branchId", new Numeric_Value(branchId));
        }
        catch (RuntimeException ex) {
            ex.printStackTrace();
        }
    }

    public long getBranchId() {
        int branchId = 0;
        try {
            if (TRACER_DEBUG.isEnabled()) {
                this.checkSession();
            }
            branchId = this.classObject.nget_numeric("oo_branchId").intValue();
        }
        catch (RuntimeException ex) {
            ex.printStackTrace();
        }
        return branchId;
    }

    public ObjyObject copy(EClass eClass, ObjyObjectManager objyObjectManager) {
        ObjyObject newObjyObject = null;
        ooObj obj = ooObj.create_ooObj((ooId)this.objectId);
        ooObj newObj = (ooObj)obj.copy((Object)obj);
        newObjyObject = objyObjectManager.getObject(newObj.getOid());
        try {
            if (TRACER_DEBUG.isEnabled()) {
                TRACER_DEBUG.trace("ObjyObject.copy() - oid:" + this.ooId().getStoreString() + " version:" + this.getVersion());
            }
            for (EStructuralFeature feature : eClass.getEAllStructuralFeatures()) {
                Class_Object cObj;
                d_Attribute attribute;
                if (!(feature instanceof EAttribute) && !(feature instanceof EReference) || !EMFUtil.isPersistent((EStructuralFeature)feature) || !feature.isMany() || (attribute = this.objyClass.resolve_attribute(feature.getName())) == null || !(attribute.type_of() instanceof d_Ref_Type) || (cObj = this.get_class_obj(feature.getName())) == null) continue;
                d_Class refClass = cObj.type_of();
                String refClassName = refClass.name();
                if (refClassName.equals(ObjyFeatureMapArrayList.ClassName)) {
                    TRACER_DEBUG.trace("\t TBD - copying ObjyFeatureMapArrayList attr: " + attribute.name());
                    continue;
                }
                if (refClassName.equals(ObjyArrayListString.ClassName)) {
                    TRACER_DEBUG.trace("\t TBD - copying ObjyArrayListString attr: " + attribute.name());
                    continue;
                }
                if (refClassName.equals(ObjyArrayListId.className)) {
                    ObjyArrayListId arrayListId = new ObjyArrayListId(cObj);
                    ooObj newArrayListId = arrayListId.copy(newObj);
                    newObjyObject.set_ooId(feature.getName(), newArrayListId.getOid());
                    continue;
                }
                if (!refClassName.equals(ObjyProxy.className)) continue;
                TRACER_DEBUG.trace("\t TBD - copying ObjyProxy attr: " + attribute.name());
            }
        }
        catch (asException ex) {
            ex.printStackTrace();
        }
        return newObjyObject;
    }

    public void update(ObjectivityStoreAccessor storeAccessor, InternalCDORevision revision) {
        ++updateCount;
        try {
            if (TRACER_DEBUG.isEnabled()) {
                this.checkSession();
                TRACER_DEBUG.trace("ObjyObject.update() - oid:" + this.ooId().getStoreString() + " - version:" + revision.getVersion());
            }
            this.updateData(storeAccessor, revision);
        }
        catch (asException ex) {
            ex.printStackTrace();
        }
    }

    private void updateData(ObjectivityStoreAccessor storeAccessor, InternalCDORevision revision) {
        EClass eClass = revision.getEClass();
        try {
            if (TRACER_DEBUG.isEnabled()) {
                TRACER_DEBUG.trace("=> ObjyObject.updateData() - oid:" + this.ooId().getStoreString() + " - version:" + revision.getVersion());
            }
            this.setVersion(revision.getVersion());
            this.setEContainer(revision.getContainerID());
            this.setEResource(revision.getResourceID());
            this.setEContainingFeature(revision.getContainingFeatureID());
            this.setCreationTime(revision.getTimeStamp());
            this.setRevisedTime(revision.getRevised());
            this.setBranchId(revision.getBranch().getID());
            for (EStructuralFeature feature : eClass.getEAllStructuralFeatures()) {
                if (!(feature instanceof EAttribute) && !(feature instanceof EReference) || !EMFUtil.isPersistent((EStructuralFeature)feature)) continue;
                ITypeMapper mapper = ObjyMapper.INSTANCE.getTypeMapper(feature);
                if (mapper == null) {
                    if (!TRACER_DEBUG.isEnabled()) continue;
                    TRACER_DEBUG.trace("In " + this.ooId().getStoreString() + " - Can't find mapper for feature " + feature.getName());
                    continue;
                }
                if (feature.isMany()) {
                    CDOList list = revision.getList(feature);
                    Object[] values = new Object[list.size()];
                    int i = 0;
                    while (i < values.length) {
                        Object value = list.get(i);
                        if (value == null) {
                            values[i] = value;
                        } else if (value instanceof CDOIDExternal) {
                            TRACER_DEBUG.trace("... CDOIDExternal inserted, at:" + i + ", content:" + ((CDOIDExternal)value).getURI());
                            ObjyProxy proxyObject = ObjyProxy.createObject(this.ooId());
                            proxyObject.setUri(((CDOIDExternal)value).getURI());
                            values[i] = proxyObject.ooId();
                        } else if (value instanceof CDOID) {
                            values[i] = OBJYCDOIDUtil.getooId((CDOID)value);
                        } else if (value instanceof FeatureMap.Entry) {
                            FeatureMap.Entry entry = (FeatureMap.Entry)value;
                            EStructuralFeature entryFeature = entry.getEStructuralFeature();
                            Object entryValue = entry.getValue();
                            ooId oid = null;
                            if (entryValue instanceof CDOIDExternal) {
                                TRACER_DEBUG.trace("... CDOIDExternal inserted, at:" + i + ", content:" + ((CDOIDExternal)entryValue).getURI());
                                ObjyProxy proxyObject = ObjyProxy.createObject(this.ooId());
                                proxyObject.setUri(((CDOIDExternal)entryValue).getURI());
                                oid = proxyObject.ooId();
                            } else if (entryValue instanceof CDOID) {
                                oid = OBJYCDOIDUtil.getooId((CDOID)entryValue);
                            } else if (TRACER_DEBUG.isEnabled()) {
                                TRACER_DEBUG.trace("OBJY: don't know what kind of entryValue is this!!! - " + entryValue);
                            }
                            ObjyFeatureMapEntry featureMapEntry = new ObjyFeatureMapEntry(entryFeature.getFeatureID(), oid, this.objectId);
                            values[i] = featureMapEntry;
                        } else if (value.equals(InternalCDOList.UNINITIALIZED)) {
                            TRACER_DEBUG.format("...GOT UNINITIALIZED at {0}, listSize:{1}, feature:{2}, oid:{3}", new Object[]{i, values.length, feature.getName(), this.objectId.getStoreString()});
                        } else {
                            values[i] = value;
                        }
                        ++i;
                    }
                    ((IManyTypeMapper)mapper).setAll(this, feature, 0, values);
                    continue;
                }
                Object newValue = revision.get(feature, feature.getFeatureID());
                ((ISingleTypeMapper)mapper).setValue(this, feature, newValue);
            }
        }
        catch (asException ex) {
            ex.printStackTrace();
        }
    }

    public ObjyObject getLastRevision(ObjyObjectManager objyObjectManager) {
        if (!this.getLastRevisionRelationship().exists()) {
            return this;
        }
        ooId lastRevisionOid = this.getLastRevisionRelationship().get_ooId();
        return objyObjectManager.getObject(lastRevisionOid);
    }

    public ObjyObject getRevisionByVersion(int version, long branchId, ObjyObjectManager objyObjectManager) {
        ObjyObject objyRevision = null;
        int objectVersion = this.getVersion();
        long objectBranchId = this.getBranchId();
        if (branchId == objectBranchId && Math.abs(objectVersion) == version) {
            return this;
        }
        objyRevision = this.getLastRevision(objyObjectManager);
        objectVersion = objyRevision.getVersion();
        objectBranchId = objyRevision.getBranchId();
        if (branchId == objectBranchId && Math.abs(objectVersion) == version) {
            return objyRevision;
        }
        Iterator itr = this.getRevisionsRelationship().get_iterator();
        while (itr.hasNext()) {
            objyRevision = objyObjectManager.getObject(((ooObj)itr.next()).getOid());
            objectVersion = objyRevision.getVersion();
            objectBranchId = objyRevision.getBranchId();
            if (branchId == objectBranchId && Math.abs(objectVersion) == version) {
                return objyRevision;
            }
            objyRevision = null;
        }
        return null;
    }

    public void addToRevisions(ObjyObject objyRevision) {
        try {
            this.getRevisionsRelationship().add(objyRevision.objectId);
            this.getLastRevisionRelationship().clear();
            this.getLastRevisionRelationship().form(objyRevision.objectId);
        }
        catch (RuntimeException ex) {
            ex.printStackTrace();
        }
    }

    public boolean fetch(ObjectivityStoreAccessor storeAccessor, InternalCDORevision revision, int listChunk) {
        boolean bRet = true;
        ++fetchCount;
        if (TRACER_DEBUG.isEnabled()) {
            this.checkSession();
        }
        EClass eClass = revision.getEClass();
        try {
            if (TRACER_DEBUG.isEnabled()) {
                TRACER_DEBUG.trace("ObjyObject.fetch() - oid:" + this.ooId().getStoreString() + " version:" + this.getVersion());
            }
            revision.setVersion(this.getVersion());
            revision.setContainerID(this.getEContainer());
            revision.setResourceID((CDOID)this.getEResource());
            revision.setContainingFeatureID(this.getEContainingFeature());
            long creationTime = this.getCreationTime();
            long revisedTime = this.getRevisedTime();
            if (TRACER_DEBUG.isEnabled()) {
                TRACER_DEBUG.trace("... ObjyObject.creationTime: " + creationTime);
                TRACER_DEBUG.trace("... ObjyObject.revisedTime : " + revisedTime);
            }
            revision.setRevised(revisedTime);
            for (EStructuralFeature feature : eClass.getEAllStructuralFeatures()) {
                if (!(feature instanceof EAttribute) && !(feature instanceof EReference) || !EMFUtil.isPersistent((EStructuralFeature)feature)) continue;
                if (feature.isMany()) {
                    int featureSize;
                    int chunkSize = featureSize = this.size(feature);
                    if (listChunk != -1 && listChunk > 0) {
                        chunkSize = Math.min(chunkSize, listChunk);
                    }
                    Object[] objects = this.getAll(feature, 0, chunkSize);
                    CDOList list = revision.getList(feature);
                    int i = 0;
                    while (i < chunkSize) {
                        if (objects[i] instanceof ooId) {
                            CDOID cdoId = null;
                            ooId objyOid = (ooId)objects[i];
                            if (objyOid.isNull()) {
                                cdoId = OBJYCDOIDUtil.getCDOID(objyOid);
                            } else {
                                Class_Object refClassObject = Class_Object.class_object_from_oid((ooId)((ooId)objects[i]));
                                if (refClassObject.type_of().name().equals(ObjyProxy.className)) {
                                    ObjyProxy proxyObject = new ObjyProxy(refClassObject);
                                    cdoId = OBJYCDOIDUtil.createCDIDExternal(proxyObject);
                                } else {
                                    cdoId = OBJYCDOIDUtil.getCDOID(objyOid);
                                }
                                refClassObject = null;
                            }
                            list.add((Object)cdoId);
                        } else if (objects[i] instanceof ObjyFeatureMapEntry) {
                            FeatureMap.Entry entry = this.getFeatureMapEntry(eClass, (ObjyFeatureMapEntry)objects[i]);
                            list.add((Object)entry);
                        } else {
                            list.add(objects[i]);
                        }
                        ++i;
                    }
                    if (featureSize - chunkSize <= 0) continue;
                    i = 0;
                    while (i < featureSize - chunkSize) {
                        list.add(InternalCDOList.UNINITIALIZED);
                        ++i;
                    }
                    continue;
                }
                Object object = this.get(feature, 0);
                revision.set(feature, 0, object);
            }
        }
        catch (asException ex) {
            ex.printStackTrace();
        }
        return bRet;
    }

    public List<Object> fetchList(ObjectivityStoreAccessor storeAccessor, EStructuralFeature feature, int startIndex, int chunkSize) {
        ++fetchCount;
        ArrayList<Object> results = new ArrayList<Object>();
        EClass eClass = feature.getEContainingClass();
        if (TRACER_DEBUG.isEnabled()) {
            this.checkSession();
        }
        try {
            if (TRACER_DEBUG.isEnabled()) {
                TRACER_DEBUG.trace("ObjyObject.fetch() - feature:" + feature.getName() + "from Object: " + this.ooId().getStoreString() + " version:" + this.getVersion());
            }
            int featureSize = this.size(feature);
            chunkSize = Math.min(featureSize - startIndex, chunkSize);
            Object[] objects = this.getAll(feature, startIndex, chunkSize);
            this.convertToCdoList(objects, results, eClass, chunkSize);
        }
        catch (asException ex) {
            ex.printStackTrace();
        }
        return results;
    }

    protected void convertToCdoList(Object[] objects, List<Object> results, EClass eClass, int chunkSize) {
        int i = 0;
        while (i < chunkSize) {
            if (objects[i] instanceof ooId) {
                CDOID cdoId = null;
                ooId objyOid = (ooId)objects[i];
                if (objyOid.isNull()) {
                    cdoId = OBJYCDOIDUtil.getCDOID(objyOid);
                } else {
                    Class_Object refClassObject = Class_Object.class_object_from_oid((ooId)objyOid);
                    if (refClassObject.type_of().name().equals(ObjyProxy.className)) {
                        ObjyProxy proxyObject = new ObjyProxy(refClassObject);
                        cdoId = OBJYCDOIDUtil.createCDIDExternal(proxyObject);
                    } else {
                        cdoId = OBJYCDOIDUtil.getCDOID(objyOid);
                    }
                    refClassObject = null;
                }
                results.add(cdoId);
            } else if (objects[i] instanceof ObjyFeatureMapEntry) {
                FeatureMap.Entry entry = this.getFeatureMapEntry(eClass, (ObjyFeatureMapEntry)objects[i]);
                results.add(entry);
            }
            ++i;
        }
    }

    private FeatureMap.Entry getFeatureMapEntry(EClass eClass, ObjyFeatureMapEntry mapEntry) {
        ooId oid = mapEntry.getObject();
        CDOID id = null;
        Class_Object refClassObject = Class_Object.class_object_from_oid((ooId)oid);
        if (refClassObject.type_of().name().equals(ObjyProxy.className)) {
            ObjyProxy proxyObject = new ObjyProxy(refClassObject);
            id = OBJYCDOIDUtil.createCDIDExternal(proxyObject);
        } else {
            id = OBJYCDOIDUtil.getCDOID(oid);
        }
        EStructuralFeature entryFeature = eClass.getEStructuralFeature(mapEntry.getTagId());
        FeatureMap.Entry entry = CDORevisionUtil.createFeatureMapEntry((EStructuralFeature)entryFeature, (Object)id);
        return entry;
    }

    private int size(EStructuralFeature feature) {
        if (TRACER_DEBUG.isEnabled()) {
            this.checkSession();
        }
        int size = 0;
        try {
            IManyTypeMapper mapper = (IManyTypeMapper)ObjyMapper.INSTANCE.getTypeMapper(feature);
            size = mapper.size(this, feature);
            if (TRACER_DEBUG.isEnabled()) {
                TRACER_DEBUG.trace("Size of object " + this.ooId().getStoreString() + " - is: " + size + " - feature: " + feature.getName());
            }
        }
        catch (RuntimeException ex) {
            ex.printStackTrace();
        }
        return size;
    }

    public Object get(EStructuralFeature feature) {
        if (feature.isMany()) {
            return this.getAll(feature, 0, -1);
        }
        return this.get(feature, 0);
    }

    private Object get(EStructuralFeature feature, int index) {
        if (TRACER_DEBUG.isEnabled()) {
            this.checkSession();
        }
        if (TRACER_DEBUG.isEnabled()) {
            TRACER_DEBUG.trace("Getting object " + this.objectId.getStoreString() + " <feature ' " + feature.getName() + "':" + feature.getEType() + "> from " + this);
        }
        ITypeMapper mapper = ObjyMapper.INSTANCE.getTypeMapper(feature);
        Object value = null;
        try {
            value = feature.isMany() ? ((IManyTypeMapper)mapper).getValue(this, feature, index) : ((ISingleTypeMapper)mapper).getValue(this, feature);
        }
        catch (RuntimeException ex) {
            ex.printStackTrace();
        }
        return value;
    }

    protected Object[] getAll(EStructuralFeature feature, int startIndex, int chunkSize) {
        if (TRACER_DEBUG.isEnabled()) {
            this.checkSession();
            TRACER_DEBUG.trace("Get All objects for ID: " + this.ooId().getStoreString() + " <feature ' " + feature + "':" + feature.getEType() + "> from " + this);
        }
        assert (feature.isMany());
        Object[] values = null;
        try {
            IManyTypeMapper mapper = (IManyTypeMapper)ObjyMapper.INSTANCE.getTypeMapper(feature);
            values = mapper.getAll(this, feature, startIndex, chunkSize);
        }
        catch (RuntimeException ex) {
            ex.printStackTrace();
        }
        return values;
    }

    public void add(EStructuralFeature feature, int index, Object value) {
        if (TRACER_DEBUG.isEnabled()) {
            this.checkSession();
            TRACER_DEBUG.trace("Adding object " + value + " to " + this.ooId().getStoreString());
        }
        assert (feature.isMany());
        try {
            IManyTypeMapper mapper = (IManyTypeMapper)ObjyMapper.INSTANCE.getTypeMapper(feature);
            mapper.add(this, feature, index, value);
        }
        catch (RuntimeException ex) {
            ex.printStackTrace();
        }
    }

    public void clear(EStructuralFeature feature) {
        if (TRACER_DEBUG.isEnabled()) {
            this.checkSession();
            TRACER_DEBUG.trace("Clear List for " + this.ooId().getStoreString());
        }
        try {
            ITypeMapper mapper = ObjyMapper.INSTANCE.getTypeMapper(feature);
            ((IManyTypeMapper)mapper).clear(this, feature);
        }
        catch (RuntimeException ex) {
            ex.printStackTrace();
        }
    }

    public void move(EStructuralFeature feature, int targetIndex, int sourceIndex) {
        if (TRACER_DEBUG.isEnabled()) {
            this.checkSession();
            TRACER_DEBUG.trace("Move element from " + sourceIndex + " to " + targetIndex);
        }
        try {
            ITypeMapper mapper = ObjyMapper.INSTANCE.getTypeMapper(feature);
            ((IManyTypeMapper)mapper).move(this, feature, targetIndex, sourceIndex);
        }
        catch (RuntimeException ex) {
            ex.printStackTrace();
        }
    }

    public Object remove(EStructuralFeature feature, int index) {
        if (TRACER_DEBUG.isEnabled()) {
            this.checkSession();
            TRACER_DEBUG.trace("Remove object from '" + this.ooId().getStoreString() + "' at index " + index);
        }
        CDOID retObject = null;
        try {
            IManyTypeMapper mapper = (IManyTypeMapper)ObjyMapper.INSTANCE.getTypeMapper(feature);
            Object value = mapper.remove(this, feature, index);
            if (feature instanceof EAttribute) {
                return value;
            }
            retObject = OBJYCDOIDUtil.getCDOID((ooId)value);
        }
        catch (RuntimeException ex) {
            ex.printStackTrace();
        }
        return retObject;
    }

    public Object set(EStructuralFeature feature, int index, Object value) {
        if (TRACER_DEBUG.isEnabled()) {
            this.checkSession();
            TRACER_DEBUG.trace("Set object '" + this.ooId().getStoreString() + "' feature : " + feature.getName());
        }
        try {
            ITypeMapper mapper = ObjyMapper.INSTANCE.getTypeMapper(feature);
            if (feature.isMany()) {
                ((IManyTypeMapper)mapper).setValue(this, feature, index, value);
            } else {
                ((ISingleTypeMapper)mapper).setValue(this, feature, value);
            }
        }
        catch (RuntimeException ex) {
            ex.printStackTrace();
        }
        return value;
    }

    public void unset(EStructuralFeature feature) {
        this.set(feature, 0, null);
    }

    protected void checkSession() {
    }

    public void delete(ObjectivityStoreAccessor storeAccessor, ObjyObjectManager objectManager) {
        EClass eClass = ObjySchema.getEClass(storeAccessor.getStore(), this.objyClass());
        try {
            for (EStructuralFeature feature : eClass.getEAllStructuralFeatures()) {
                if (!(feature instanceof EAttribute) && !(feature instanceof EReference) || !EMFUtil.isPersistent((EStructuralFeature)feature)) continue;
                if (feature.isMany()) {
                    this.deleteFeatureObjects(objectManager, feature);
                    continue;
                }
                ITypeMapper mapper = ObjyMapper.INSTANCE.getTypeMapper(feature);
                if (mapper == null) continue;
                mapper.delete(this, feature);
            }
        }
        catch (RuntimeException ex) {
            ex.printStackTrace();
        }
    }

    private void deleteFeatureObjects(ObjyObjectManager objectManager, EStructuralFeature feature) {
        Object[] objects = this.getAll(feature, 0, -1);
        if (objects == null) {
            return;
        }
        int i = 0;
        while (i < objects.length) {
            if (objects[i] instanceof ooId) {
                ooId oid = (ooId)objects[i];
                ooObj obj = ooObj.create_ooObj((ooId)oid);
                if (!obj.isDead()) {
                    Class_Object refClassObject = Class_Object.class_object_from_oid((ooId)oid);
                    if (refClassObject.type_of().name().equals(ObjyProxy.className)) {
                        obj.delete();
                    } else {
                        ObjyObject childObjyObject = objectManager.getObject(oid);
                        ooId containerId = childObjyObject.getEContainerAsOid();
                        ooId resourceId = childObjyObject.getEResourceAsOid();
                        int childVersion = childObjyObject.getVersion();
                        if (containerId.equals(this.objectId) || resourceId.equals(this.objectId)) {
                            childObjyObject.setVersion(-childVersion);
                        }
                    }
                }
            } else if (objects[i] instanceof ObjyFeatureMapEntry) {
                ObjyFeatureMapEntry mapEntry = (ObjyFeatureMapEntry)objects[i];
                ooId oid = mapEntry.getObject();
                ooObj obj = ooObj.create_ooObj((ooId)oid);
                obj.delete();
            } else if (TRACER_DEBUG.isEnabled()) {
                TRACER_DEBUG.trace("-->> No process to delete() feature (" + i + ") -> feature:" + feature.getName() + " - value:" + objects[i] + " ... nothing to do here.");
            }
            ++i;
        }
    }

    public Numeric_Value get_numeric(String attributeName) {
        return this.classObject.nget_numeric(attributeName);
    }

    public String_Value get_string(String attributeName) {
        return this.classObject.nget_string(attributeName);
    }

    public void set_numeric(String attributeName, Numeric_Value value) {
        this.classObject.nset_numeric(attributeName, value);
    }

    public VArray_Object get_varray(String attributeName) {
        return this.classObject.nget_varray(attributeName);
    }

    public ooId get_ooId(String attributeName) {
        return this.classObject.nget_ooId(attributeName);
    }

    public Class_Object get_class_obj(String attributeName) {
        return this.classObject.nget_class_obj(attributeName);
    }

    public void set_ooId(String attributeName, ooId object) {
        this.classObject.nset_ooId(attributeName, object);
    }

    public CDOID getRevisionId() {
        if (this.revisionId == null) {
            if (this.hasBaseRelationship()) {
                this.baseClassObject = this.getBaseRelationship().get_class_obj();
                this.revisionId = this.baseClassObject.objectID();
            } else {
                this.revisionId = this.objectId;
            }
        }
        return OBJYCDOIDUtil.getCDOID(this.revisionId);
    }

    public ObjyObject getBaseObject() {
        ObjyObject objyObject = null;
        if (this.hasBaseRelationship()) {
            this.baseClassObject = this.getBaseRelationship().get_class_obj();
            objyObject = new ObjyObject(this.baseClassObject);
        } else {
            objyObject = this;
        }
        return objyObject;
    }

    private boolean hasBaseRelationship() {
        if (!this.hasBaseRelationshipChecked) {
            this.hasBaseRelationshipChecked = this.getBaseRelationship().exists();
        }
        return this.hasBaseRelationshipChecked;
    }

    public ObjyObject getRevision(long timeStamp, int branchId, ObjyObjectManager objyObjectManager) {
        ObjyObject objyRevision = null;
        objyRevision = this.getLastRevision(objyObjectManager);
        if (this.evaluateRevision(timeStamp, branchId, objyRevision)) {
            return objyRevision;
        }
        ObjyObject possibleRevision = null;
        if (this.evaluateRevision(timeStamp, branchId, this)) {
            possibleRevision = this;
        }
        Iterator itr = this.getRevisionsRelationship().get_iterator();
        while (itr.hasNext()) {
            objyRevision = objyObjectManager.getObject(((ooObj)itr.next()).getOid());
            if (!this.evaluateRevision(timeStamp, branchId, objyRevision)) continue;
            possibleRevision = objyRevision;
        }
        return possibleRevision;
    }

    protected boolean evaluateRevision(long timeStamp, int branchId, ObjyObject objyRevision) {
        long revisedTS;
        long creationTS;
        return objyRevision.getBranchId() == (long)branchId && CDOCommonUtil.isValidTimeStamp((long)timeStamp, (long)(creationTS = objyRevision.getCreationTime()), (long)(revisedTS = objyRevision.getRevisedTime()));
    }

    public void detach(int version, CDOBranch branch, long timeStamp) {
        ObjyClass objyClass = ObjySchema.getObjyClass("ObjyBase");
        Class_Object detachedClassObject = Class_Object.new_persistent_object((d_Class)objyClass.getASClass(), (ooId)this.objectId, (boolean)false);
        if (TRACER_DEBUG.isEnabled()) {
            ++ObjyObjectManager.newInternalObjCount;
        }
        ObjyObject detachedObjyObject = null;
        try {
            detachedObjyObject = new ObjyObject(detachedClassObject);
            detachedObjyObject.setVersion(-(version + 1));
            detachedObjyObject.setBranchId(branch.getID());
            detachedObjyObject.setCreationTime(timeStamp);
            this.addToRevisions(detachedObjyObject);
        }
        catch (RuntimeException ex) {
            ex.printStackTrace();
        }
    }
}

