/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.internal.ui.dialogs;

import org.eclipse.emf.cdo.internal.ui.messages.Messages;
import org.eclipse.emf.cdo.transaction.CDOTransaction;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.net4j.util.ui.UIUtil;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;

public class RollbackTransactionDialog
extends TitleAreaDialog {
    private IWorkbenchPage page;
    private String title;
    private String description;
    private CDOTransaction transaction;

    public RollbackTransactionDialog(IWorkbenchPage page, String title, String description, CDOTransaction transaction) {
        super(new Shell(page.getWorkbenchWindow().getShell()));
        this.page = page;
        this.title = title;
        this.description = description;
        this.transaction = transaction;
        this.setShellStyle(this.getShellStyle() | 0x10000 | 0x400 | 0x20 | 0x10);
    }

    public IWorkbenchPage getPage() {
        return this.page;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(this.title);
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = new Composite((Composite)super.createDialogArea(parent), 0);
        composite.setLayoutData((Object)UIUtil.createGridData());
        composite.setLayout((Layout)new GridLayout(1, false));
        this.setTitle(this.description);
        this.setTitleImage(this.getShell().getDisplay().getSystemImage(4));
        Label label = new Label(composite, 0);
        label.setText(this.formatMessage());
        label.setLayoutData((Object)new GridData(0x1000000, 0x1000000, true, true));
        return composite;
    }

    protected String formatMessage() {
        StringBuilder builder = new StringBuilder();
        builder.append(Messages.getString("RollbackTransactionDialog.0"));
        this.append(builder, this.transaction.getNewObjects().size(), Messages.getString("RollbackTransactionDialog.4"), Messages.getString("RollbackTransactionDialog.5"));
        this.append(builder, this.transaction.getDirtyObjects().size(), Messages.getString("RollbackTransactionDialog.6"), Messages.getString("RollbackTransactionDialog.7"));
        this.append(builder, this.transaction.getDetachedObjects().size(), Messages.getString("RollbackTransactionDialog.8"), Messages.getString("RollbackTransactionDialog.9"));
        builder.append("\n\n");
        builder.append(Messages.getString("RollbackTransactionDialog.11"));
        return builder.toString();
    }

    private void append(StringBuilder builder, int count, String labelSingular, String labelPlural) {
        if (count > 0) {
            builder.append("\n- ");
            builder.append(count);
            builder.append(" ");
            if (count > 1) {
                builder.append(labelPlural);
            } else {
                builder.append(labelSingular);
            }
        }
    }
}

