/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.internal.ui.dialogs;

import org.eclipse.emf.cdo.common.branch.CDOBranchPoint;
import org.eclipse.emf.cdo.session.CDOSession;
import org.eclipse.emf.cdo.ui.widgets.ComposeBranchPointComposite;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.net4j.util.StringUtil;
import org.eclipse.net4j.util.ui.UIUtil;
import org.eclipse.net4j.util.ui.ValidationContext;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbenchPage;

public class SelectBranchPointDialog
extends TitleAreaDialog
implements ValidationContext {
    protected final ValidationContext aggregator = new ValidationContext.Aggregator((ValidationContext)this);
    private CDOSession session;
    private CDOBranchPoint branchPoint;
    private boolean allowTimeStamp;
    private CTabItem composeTab;
    private CTabItem commitsTab;
    private CTabItem tagsTab;
    private CTabItem viewsTab;

    public SelectBranchPointDialog(IWorkbenchPage page, CDOSession session, CDOBranchPoint branchPoint, boolean allowTimeStamp) {
        super(page.getWorkbenchWindow().getShell());
        this.setShellStyle(this.getShellStyle() | 0x10000 | 0x400 | 0x20 | 0x10);
        this.session = session;
        this.branchPoint = branchPoint;
        this.allowTimeStamp = allowTimeStamp;
    }

    public CDOSession getSession() {
        return this.session;
    }

    public boolean isAllowTimeStamp() {
        return this.allowTimeStamp;
    }

    public CTabItem getComposeTab() {
        return this.composeTab;
    }

    public CTabItem getCommitsTab() {
        return this.commitsTab;
    }

    public CTabItem getTagsTab() {
        return this.tagsTab;
    }

    public CTabItem getViewsTab() {
        return this.viewsTab;
    }

    public CDOBranchPoint getBranchPoint() {
        return this.branchPoint;
    }

    public void setBranchPoint(CDOBranchPoint branchPoint) {
        this.branchPoint = branchPoint;
        this.validate();
    }

    public void setValidationError(Object source, String message) {
        this.setMessage(message, 3);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setSize(500, 500);
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        composite.setLayoutData((Object)UIUtil.createGridData());
        composite.setLayout((Layout)new GridLayout(1, false));
        this.createBranchPointArea(composite);
        UIUtil.setValidationContext((Control)composite, (ValidationContext)this.aggregator);
        return composite;
    }

    protected void createBranchPointArea(Composite parent) {
        CTabFolder tabFolder = new CTabFolder(parent, 2048);
        tabFolder.setSimple(false);
        tabFolder.setLayoutData((Object)UIUtil.createGridData());
        tabFolder.setSelectionBackground(Display.getCurrent().getSystemColor(35));
        this.composeTab = new CTabItem(tabFolder, 0);
        this.composeTab.setText(this.getComposeTabTitle());
        Composite composite_0 = new Composite((Composite)tabFolder, 0);
        composite_0.setLayout((Layout)new GridLayout(1, false));
        this.createComposeTab(composite_0);
        this.composeTab.setControl((Control)composite_0);
        this.commitsTab = new CTabItem(tabFolder, 0);
        this.commitsTab.setText("Commits");
        Composite composite_1 = new Composite((Composite)tabFolder, 0);
        composite_1.setLayout((Layout)new GridLayout(1, false));
        this.createCommitsTab(composite_1);
        this.commitsTab.setControl((Control)composite_1);
        this.tagsTab = new CTabItem(tabFolder, 0);
        this.tagsTab.setText("Tags");
        Composite composite_2 = new Composite((Composite)tabFolder, 0);
        composite_2.setLayout((Layout)new GridLayout(1, false));
        this.createTagsTab(composite_2);
        this.tagsTab.setControl((Control)composite_2);
        this.viewsTab = new CTabItem(tabFolder, 0);
        this.viewsTab.setText("Views");
        Composite composite_3 = new Composite((Composite)tabFolder, 0);
        composite_3.setLayout((Layout)new GridLayout(1, false));
        this.createViewsTab(composite_3);
        this.viewsTab.setControl((Control)composite_3);
        tabFolder.setSelection(this.composeTab);
    }

    protected void createComposeTab(Composite parent) {
        ComposeBranchPointComposite control = new ComposeBranchPointComposite(parent, 0, this.session, null, this.allowTimeStamp){

            protected void branchPointChanged(CDOBranchPoint newBranchPoint) {
                SelectBranchPointDialog.this.setBranchPoint(newBranchPoint);
            }
        };
        control.setLayoutData(UIUtil.createGridData());
    }

    protected void createCommitsTab(Composite parent) {
    }

    protected void createTagsTab(Composite parent) {
    }

    protected void createViewsTab(Composite parent) {
    }

    protected String getComposeTabTitle() {
        return "Compose";
    }

    protected void validate() {
    }

    public static class WithName
    extends SelectBranchPointDialog {
        private String name;
        private Text nameText;

        public WithName(IWorkbenchPage page, CDOSession session, CDOBranchPoint branchPoint, boolean allowTimeStamp, String name) {
            super(page, session, branchPoint, allowTimeStamp);
            this.name = StringUtil.safe((String)name);
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
            this.validate();
        }

        public Text getNameText() {
            return this.nameText;
        }

        protected void createBranchPointArea(Composite parent) {
            GridLayout gridLayout = UIUtil.createGridLayout((int)2);
            gridLayout.marginHeight = 5;
            gridLayout.horizontalSpacing = 5;
            Composite composite = new Composite(parent, 0);
            composite.setLayoutData((Object)UIUtil.createGridData((boolean)true, (boolean)false));
            composite.setLayout((Layout)gridLayout);
            Label label = new Label(composite, 0);
            label.setLayoutData((Object)UIUtil.createGridData((boolean)false, (boolean)false));
            label.setText("Name:");
            this.nameText = new Text(composite, 2048);
            this.nameText.setLayoutData((Object)UIUtil.createGridData((boolean)true, (boolean)false));
            this.nameText.setText(this.name);
            this.nameText.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    WithName.this.setName(WithName.this.nameText.getText());
                }
            });
            super.createBranchPointArea(parent);
        }
    }
}

