/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.ui;

import java.util.ArrayList;
import org.eclipse.emf.cdo.internal.ui.CDOEditorInputImpl;
import org.eclipse.emf.cdo.internal.ui.bundle.OM;
import org.eclipse.emf.cdo.internal.ui.editor.CDOEditor;
import org.eclipse.emf.cdo.ui.CDOEditorInput;
import org.eclipse.emf.cdo.view.CDOView;
import org.eclipse.net4j.util.ObjectUtil;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;

public final class CDOEditorUtil {
    public static final String EDITOR_ID = "org.eclipse.emf.cdo.ui.CDOEditor";
    private static String editorID = "org.eclipse.emf.cdo.ui.CDOEditor";

    private CDOEditorUtil() {
    }

    public static String getEditorID() {
        return editorID;
    }

    public static void setEditorID(String editorID) {
        CDOEditorUtil.editorID = editorID;
    }

    public static CDOEditorInput createCDOEditorInput(CDOView view, String resourcePath, boolean viewOwned) {
        return new CDOEditorInputImpl(view, resourcePath, viewOwned);
    }

    public static void openEditor(final IWorkbenchPage page, final CDOView view, final String resourcePath) {
        Display display = page.getWorkbenchWindow().getShell().getDisplay();
        display.asyncExec(new Runnable(){

            public void run() {
                try {
                    IEditorReference[] references = CDOEditorUtil.findEditor(page, view, resourcePath);
                    if (references.length != 0) {
                        IEditorPart editor = references[0].getEditor(true);
                        page.activate((IWorkbenchPart)editor);
                    } else {
                        CDOEditorInput input = CDOEditorUtil.createCDOEditorInput(view, resourcePath, false);
                        page.openEditor((IEditorInput)input, CDOEditorUtil.getEditorID());
                    }
                }
                catch (Exception ex) {
                    OM.LOG.error((Throwable)ex);
                }
            }
        });
    }

    public static IEditorReference[] findEditor(IWorkbenchPage page, CDOView view, String resourcePath) {
        IEditorReference[] editorReferences;
        ArrayList<IEditorReference> result = new ArrayList<IEditorReference>();
        IEditorReference[] iEditorReferenceArray = editorReferences = page.getEditorReferences();
        int n = editorReferences.length;
        int n2 = 0;
        while (n2 < n) {
            IEditorReference editorReference = iEditorReferenceArray[n2];
            try {
                CDOEditorInput cdoInput;
                IEditorInput editorInput;
                if (ObjectUtil.equals((Object)editorReference.getId(), (Object)CDOEditorUtil.getEditorID()) && (editorInput = editorReference.getEditorInput()) instanceof CDOEditorInput && (cdoInput = (CDOEditorInput)editorInput).getView() == view && (resourcePath == null || ObjectUtil.equals((Object)cdoInput.getResourcePath(), (Object)resourcePath))) {
                    result.add(editorReference);
                }
            }
            catch (PartInitException ex) {
                OM.LOG.error((Throwable)ex);
            }
            ++n2;
        }
        return result.toArray(new IEditorReference[result.size()]);
    }

    public static void refreshEditors(IWorkbenchPage page, CDOView view) {
        IEditorReference[] references;
        IEditorReference[] iEditorReferenceArray = references = CDOEditorUtil.findEditor(page, view, null);
        int n = references.length;
        int n2 = 0;
        while (n2 < n) {
            IEditorReference reference = iEditorReferenceArray[n2];
            CDOEditor editor = (CDOEditor)reference.getEditor(false);
            if (editor != null) {
                editor.refreshViewer(null);
            }
            ++n2;
        }
    }
}

