/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.workspace.internal.efs;

import java.io.File;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.filesystem.provider.FileSystem;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.emf.cdo.workspace.CDOWorkspace;
import org.eclipse.emf.cdo.workspace.internal.efs.CDOWorkspaceStore;

public class CDOWorkspaceFileSystem
extends FileSystem
implements IResourceChangeListener {
    public static final String SCHEME = "cdo.workspace";
    public static final String[] NO_CHILD_NAMES = new String[0];
    private static CDOWorkspaceFileSystem instance;
    private Map<String, CDOWorkspaceStore> workspaceStores = new HashMap<String, CDOWorkspaceStore>();
    private boolean workspaceListenerRegistered;

    public CDOWorkspaceFileSystem() {
        instance = this;
    }

    public static CDOWorkspaceFileSystem getInstance() {
        return instance;
    }

    public int attributes() {
        return 0x30000000;
    }

    public boolean isCaseSensitive() {
        return true;
    }

    public IFileStore getStore(URI uri) {
        String path = uri.getSchemeSpecificPart();
        StringTokenizer tokenizer = new StringTokenizer(path, "/");
        String name = tokenizer.nextToken();
        IFileStore store = this.getWorkspaceStore(name);
        while (tokenizer.hasMoreTokens()) {
            name = tokenizer.nextToken();
            store = store.getChild(name);
        }
        return store;
    }

    public void resourceChanged(IResourceChangeEvent event) {
        IResourceDelta delta = event.getDelta();
        if (delta != null) {
            IResourceDelta[] deltas = delta.getAffectedChildren();
            this.projectsChanged(deltas);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void projectsChanged(IResourceDelta[] deltas) {
        IResourceDelta[] iResourceDeltaArray = deltas;
        int n = deltas.length;
        int n2 = 0;
        while (n2 < n) {
            int flags;
            boolean removed;
            IResourceDelta delta = iResourceDeltaArray[n2];
            int kind = delta.getKind();
            boolean bl = removed = kind == 2;
            if (!removed && ((flags = delta.getFlags()) & 0x4000) != 0) {
                IProject project = (IProject)delta.getResource();
                boolean bl2 = removed = !project.isOpen();
            }
            if (removed) {
                CDOWorkspaceStore store;
                String name = delta.getFullPath().segment(0);
                Map<String, CDOWorkspaceStore> map = this.workspaceStores;
                synchronized (map) {
                    store = this.workspaceStores.remove(name);
                    if (this.workspaceStores.isEmpty()) {
                        ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this);
                        this.workspaceListenerRegistered = false;
                    }
                }
                if (store != null) {
                    store.dispose();
                }
            }
            ++n2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CDOWorkspaceStore addWorkspaceStore(String name, CDOWorkspace workspace) {
        Map<String, CDOWorkspaceStore> map = this.workspaceStores;
        synchronized (map) {
            CDOWorkspaceStore store = this.createWorkspaceStore(name);
            store.setWorkspace(workspace);
            this.addWorkspaceStore((IFileStore)store);
            return store;
        }
    }

    private void addWorkspaceStore(IFileStore store) {
        this.workspaceStores.put(store.getName(), (CDOWorkspaceStore)store);
        if (!this.workspaceListenerRegistered) {
            ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this);
            this.workspaceListenerRegistered = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IFileStore getWorkspaceStore(String name) {
        Map<String, CDOWorkspaceStore> map = this.workspaceStores;
        synchronized (map) {
            Object store = (IFileStore)this.workspaceStores.get(name);
            if (store == null) {
                store = this.createWorkspaceStore(name);
                this.addWorkspaceStore((IFileStore)store);
            }
            return store;
        }
    }

    private CDOWorkspaceStore createWorkspaceStore(String name) {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IPath location = root.getLocation().append(name);
        return new CDOWorkspaceStore(name, new File(location.toOSString()));
    }
}

