/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.util;

import java.util.Iterator;
import java.util.Map;
import org.eclipse.emf.cdo.CDOObject;
import org.eclipse.emf.cdo.common.branch.CDOBranch;
import org.eclipse.emf.cdo.common.revision.CDORevision;
import org.eclipse.emf.cdo.eresource.CDOResource;
import org.eclipse.emf.cdo.eresource.CDOResourceFactory;
import org.eclipse.emf.cdo.session.CDOCollectionLoadingPolicy;
import org.eclipse.emf.cdo.session.CDOSession;
import org.eclipse.emf.cdo.session.remote.CDORemoteSessionManager;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDORevision;
import org.eclipse.emf.cdo.transaction.CDOXATransaction;
import org.eclipse.emf.cdo.util.CDOURIData;
import org.eclipse.emf.cdo.util.ObjectNotFoundException;
import org.eclipse.emf.cdo.view.CDOFeatureAnalyzer;
import org.eclipse.emf.cdo.view.CDOFetchRuleManager;
import org.eclipse.emf.cdo.view.CDORevisionPrefetchingPolicy;
import org.eclipse.emf.cdo.view.CDOStaleObject;
import org.eclipse.emf.cdo.view.CDOView;
import org.eclipse.emf.cdo.view.CDOViewSet;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.internal.cdo.analyzer.CDOFeatureAnalyzerModelBased;
import org.eclipse.emf.internal.cdo.analyzer.CDOFeatureAnalyzerUI;
import org.eclipse.emf.internal.cdo.analyzer.CDOFetchRuleManagerThreadLocal;
import org.eclipse.emf.internal.cdo.bundle.OM;
import org.eclipse.emf.internal.cdo.messages.Messages;
import org.eclipse.emf.internal.cdo.object.CDOFactoryImpl;
import org.eclipse.emf.internal.cdo.object.CDOObjectWrapper;
import org.eclipse.emf.internal.cdo.session.CDOCollectionLoadingPolicyImpl;
import org.eclipse.emf.internal.cdo.transaction.CDOXATransactionImpl;
import org.eclipse.emf.internal.cdo.view.CDORevisionPrefetchingPolicyImpl;
import org.eclipse.emf.internal.cdo.view.CDOStateMachine;
import org.eclipse.emf.spi.cdo.FSMUtil;
import org.eclipse.emf.spi.cdo.InternalCDOObject;
import org.eclipse.emf.spi.cdo.InternalCDOView;
import org.eclipse.net4j.util.AdapterUtil;
import org.eclipse.net4j.util.container.IPluginContainer;
import org.eclipse.net4j.util.om.OMPlatform;
import org.eclipse.net4j.util.security.IPasswordCredentialsProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CDOUtil {
    private static final ThreadLocal<Boolean> legacyModeDefault = new InheritableThreadLocal<Boolean>(){

        @Override
        protected Boolean initialValue() {
            return false;
        }
    };

    static {
        if (!OMPlatform.INSTANCE.isOSGiRunning()) {
            CDOUtil.registerResourceFactory(Resource.Factory.Registry.INSTANCE);
        }
    }

    private CDOUtil() {
    }

    public static boolean registerResourceFactory(Resource.Factory.Registry registry) {
        if (registry == null) {
            return false;
        }
        Map map = registry.getProtocolToFactoryMap();
        if (!map.containsKey("cdo")) {
            map.put("cdo", CDOResourceFactory.INSTANCE);
            return true;
        }
        return false;
    }

    public static CDOSession getSession(Object object) {
        if (object == null) {
            return null;
        }
        CDOSession session = (CDOSession)AdapterUtil.adapt((Object)object, CDOSession.class);
        if (session != null) {
            return session;
        }
        CDOView view = (CDOView)AdapterUtil.adapt((Object)object, CDOView.class);
        if (view != null) {
            return view.getSession();
        }
        CDOObject cdoObject = (CDOObject)AdapterUtil.adapt((Object)object, CDOObject.class);
        if (cdoObject != null) {
            return cdoObject.cdoView().getSession();
        }
        CDORemoteSessionManager remoteSessionManager = (CDORemoteSessionManager)AdapterUtil.adapt((Object)object, CDORemoteSessionManager.class);
        if (remoteSessionManager != null) {
            return remoteSessionManager.getLocalSession();
        }
        return null;
    }

    public static boolean prepareDynamicEPackage(EPackage startPackage) {
        if (CDOFactoryImpl.prepareDynamicEPackage(startPackage)) {
            for (EPackage subPackage : startPackage.getESubpackages()) {
                CDOUtil.prepareDynamicEPackage(subPackage);
            }
            return true;
        }
        return false;
    }

    public static CDOCollectionLoadingPolicy createCollectionLoadingPolicy(int initialChunkSize, int resolveChunkSize) {
        return new CDOCollectionLoadingPolicyImpl(initialChunkSize, resolveChunkSize);
    }

    public static CDORevisionPrefetchingPolicy createRevisionPrefetchingPolicy(int chunkSize) {
        if (chunkSize <= 0) {
            return CDORevisionPrefetchingPolicy.NO_PREFETCHING;
        }
        return new CDORevisionPrefetchingPolicyImpl(chunkSize);
    }

    public static CDOFetchRuleManager createThreadLocalFetchRuleManager() {
        return new CDOFetchRuleManagerThreadLocal();
    }

    public static CDOFeatureAnalyzer createModelBasedFeatureAnalyzer() {
        return new CDOFeatureAnalyzerModelBased();
    }

    public static CDOFeatureAnalyzer createUIFeatureAnalyzer() {
        return new CDOFeatureAnalyzerUI();
    }

    public static CDOFeatureAnalyzer createUIFeatureAnalyzer(long maxTimeBetweenOperation) {
        return new CDOFeatureAnalyzerUI(maxTimeBetweenOperation);
    }

    public static CDOXATransaction createXATransaction(Notifier ... notifiers) {
        CDOXATransactionImpl xaTransaction = new CDOXATransactionImpl();
        Notifier[] notifierArray = notifiers;
        int n = notifiers.length;
        int n2 = 0;
        while (n2 < n) {
            Notifier notifier = notifierArray[n2];
            CDOViewSet viewSet = CDOUtil.getViewSet(notifier);
            if (viewSet == null) {
                throw new IllegalArgumentException("Notifier is not associated with a CDOViewSet: " + notifier);
            }
            try {
                xaTransaction.add(viewSet);
            }
            catch (IllegalArgumentException ex) {
                OM.LOG.warn((Throwable)ex);
            }
            ++n2;
        }
        return xaTransaction;
    }

    public static CDOXATransaction getXATransaction(CDOViewSet viewSet) {
        EList adapters = viewSet.eAdapters();
        for (Adapter adapter : adapters) {
            if (!(adapter instanceof CDOXATransactionImpl.CDOXAInternalAdapter)) continue;
            return ((CDOXATransactionImpl.CDOXAInternalAdapter)adapter).getXATransaction();
        }
        return null;
    }

    public static CDOViewSet getViewSet(Notifier notifier) {
        Resource resource;
        ResourceSet resourceSet;
        CDOViewSet viewSet;
        if (notifier instanceof CDOViewSet) {
            return (CDOViewSet)notifier;
        }
        EList adapters = notifier.eAdapters();
        for (Adapter adapter : adapters) {
            if (!(adapter instanceof CDOViewSet)) continue;
            return (CDOViewSet)adapter;
        }
        if (notifier instanceof InternalEObject) {
            CDOViewSet viewSet2;
            InternalEObject object = (InternalEObject)notifier;
            EObject container = object.eContainer();
            if (container != null && (viewSet = CDOUtil.getViewSet((Notifier)container)) != null) {
                return viewSet;
            }
            Resource.Internal resource2 = object.eDirectResource();
            if (resource2 != null && (viewSet2 = CDOUtil.getViewSet((Notifier)resource2)) != null) {
                return viewSet2;
            }
        }
        if (notifier instanceof Resource && (resourceSet = (resource = (Resource)notifier).getResourceSet()) != null && (viewSet = CDOUtil.getViewSet((Notifier)resourceSet)) != null) {
            return viewSet;
        }
        return null;
    }

    public static boolean isStaleObject(Object object) {
        return object instanceof CDOStaleObject;
    }

    public static void cleanStaleReference(EObject eObject, EStructuralFeature eFeature) {
        if (!eFeature.isMany() && eFeature.getEContainingClass() != null) {
            InternalCDOObject cdoObject = (InternalCDOObject)CDOUtil.getCDOObject(eObject);
            cdoObject.eStore().unset((InternalEObject)cdoObject, eFeature);
        }
    }

    public static void cleanStaleReference(EObject eObject, EStructuralFeature eFeature, int index) {
        if (eFeature.isMany() && eFeature.getEContainingClass() != null) {
            InternalCDOObject cdoObject = (InternalCDOObject)CDOUtil.getCDOObject(eObject);
            try {
                cdoObject.eStore().remove((InternalEObject)cdoObject, eFeature, index);
            }
            catch (ObjectNotFoundException objectNotFoundException) {
                // empty catch block
            }
        }
    }

    public static void load(EObject eObject, CDOView view) {
        InternalCDOObject cdoObject = FSMUtil.adapt(eObject, view);
        CDOStateMachine.INSTANCE.read(cdoObject);
        Iterator<InternalCDOObject> it = FSMUtil.iterator(cdoObject.eContents(), (InternalCDOView)view);
        while (it.hasNext()) {
            InternalCDOObject content = it.next();
            CDOUtil.load(content, view);
        }
    }

    public static EObject getEObject(EObject object) {
        if (object instanceof InternalCDOObject) {
            return ((InternalCDOObject)object).cdoInternalInstance();
        }
        return object;
    }

    public static CDOObject getCDOObject(EObject object) {
        if (object instanceof CDOObject) {
            return (CDOObject)object;
        }
        return FSMUtil.adaptLegacy((InternalEObject)object);
    }

    public static CDORevision getRevisionByVersion(CDOObject object, int version) {
        if (FSMUtil.isTransient(object)) {
            return null;
        }
        InternalCDORevision revision = CDOStateMachine.INSTANCE.read((InternalCDOObject)object);
        return CDOUtil.getRevisionByVersion(object, revision.getBranch(), version, (CDORevision)revision);
    }

    public static CDORevision getRevisionByVersion(CDOObject object, CDOBranch branch, int version) {
        if (FSMUtil.isTransient(object)) {
            return null;
        }
        InternalCDORevision revision = CDOStateMachine.INSTANCE.read((InternalCDOObject)object);
        return CDOUtil.getRevisionByVersion(object, branch, version, (CDORevision)revision);
    }

    private static CDORevision getRevisionByVersion(CDOObject object, CDOBranch branch, int version, CDORevision revision) {
        if (revision.getVersion() != version) {
            CDOSession session = object.cdoView().getSession();
            if (!session.getRepositoryInfo().isSupportingAudits()) {
                throw new IllegalStateException(Messages.getString("CDOUtil.0"));
            }
            revision = session.getRevisionManager().getRevisionByVersion(object.cdoID(), branch.getVersion(version), 0, true);
        }
        return revision;
    }

    public static EList<Resource> getResources(ResourceSet resourceSet) {
        BasicEList result = new BasicEList();
        EList resources = resourceSet.getResources();
        for (Resource resource : resources) {
            CDOResource cdoResource;
            if (resource instanceof CDOResource && (cdoResource = (CDOResource)resource).isRoot()) continue;
            result.add((Object)resource);
        }
        return result;
    }

    public static boolean isSessionDirty(CDOSession session) {
        CDOView[] cDOViewArray = (CDOView[])session.getElements();
        int n = cDOViewArray.length;
        int n2 = 0;
        while (n2 < n) {
            CDOView view = cDOViewArray[n2];
            if (view.isDirty()) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    @Deprecated
    public static boolean isInvalidationRunnerActive() {
        throw new UnsupportedOperationException("Use CDOView.isInvalidationRunnerActive()");
    }

    public static boolean isLegacyObject(EObject object) {
        return object instanceof CDOObjectWrapper;
    }

    public static boolean isLegacyModeDefault() {
        return legacyModeDefault.get();
    }

    public static void setLegacyModeDefault(boolean on) {
        legacyModeDefault.set(on);
    }

    public static void setCredentialsProvider(URI uri, IPasswordCredentialsProvider provider) {
        CDOURIData data = new CDOURIData(uri);
        data.setUserName(null);
        data.setPassWord(null);
        data.setResourcePath(null);
        data.setBranchPath(null);
        data.setTimeStamp(0L);
        data.setTransactional(false);
        String resource = data.toString();
        IPluginContainer.INSTANCE.putElement("org.eclipse.net4j.util.credentialsProviders", "password", resource, (Object)provider);
    }
}

