/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.internal.cdo.object;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.emf.cdo.CDOState;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.model.CDOModelUtil;
import org.eclipse.emf.cdo.common.model.CDOPackageRegistry;
import org.eclipse.emf.cdo.common.model.CDOType;
import org.eclipse.emf.cdo.common.model.EMFUtil;
import org.eclipse.emf.cdo.common.revision.CDOElementProxy;
import org.eclipse.emf.cdo.common.revision.CDORevision;
import org.eclipse.emf.cdo.common.revision.CDORevisionData;
import org.eclipse.emf.cdo.common.security.CDOPermission;
import org.eclipse.emf.cdo.common.util.CDOException;
import org.eclipse.emf.cdo.eresource.CDOResource;
import org.eclipse.emf.cdo.eresource.impl.CDOResourceImpl;
import org.eclipse.emf.cdo.spi.common.model.InternalCDOPackageRegistry;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDORevision;
import org.eclipse.emf.cdo.util.CDOUtil;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.emf.internal.cdo.CDOObjectImpl;
import org.eclipse.emf.internal.cdo.bundle.OM;
import org.eclipse.emf.internal.cdo.object.CDOObjectWrapper;
import org.eclipse.emf.internal.cdo.view.CDOStateMachine;
import org.eclipse.emf.spi.cdo.CDOStore;
import org.eclipse.emf.spi.cdo.FSMUtil;
import org.eclipse.emf.spi.cdo.InternalCDOObject;
import org.eclipse.emf.spi.cdo.InternalCDOView;
import org.eclipse.net4j.util.ReflectUtil;
import org.eclipse.net4j.util.WrappedException;
import org.eclipse.net4j.util.om.trace.ContextTracer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CDOLegacyWrapper
extends CDOObjectWrapper {
    private static final ContextTracer TRACER = new ContextTracer(OM.DEBUG_OBJECT, CDOLegacyWrapper.class);
    private static ThreadLocal<Map<CDOID, CDOLegacyWrapper>> wrapperRegistry = new InheritableThreadLocal<Map<CDOID, CDOLegacyWrapper>>(){

        @Override
        protected Map<CDOID, CDOLegacyWrapper> initialValue() {
            return new HashMap<CDOID, CDOLegacyWrapper>();
        }
    };
    private static ThreadLocal<Counter> recursionCounter = new InheritableThreadLocal<Counter>(){

        @Override
        protected Counter initialValue() {
            return new Counter();
        }
    };
    protected CDOState state;
    protected InternalCDORevision revision;
    private boolean underConstruction;

    public CDOLegacyWrapper(InternalEObject instance) {
        this.instance = instance;
        this.state = CDOState.TRANSIENT;
    }

    @Override
    public CDOState cdoState() {
        return this.state;
    }

    @Override
    public InternalCDORevision cdoRevision() {
        return this.revision;
    }

    @Override
    public CDOResourceImpl cdoResource() {
        this.revisionToInstanceResource();
        return super.cdoResource();
    }

    @Override
    public void cdoReload() {
        CDOStateMachine.INSTANCE.reload(this);
    }

    @Override
    public CDOState cdoInternalSetState(CDOState state) {
        if (this.state != state) {
            if (TRACER.isEnabled()) {
                TRACER.format("Setting state {0} for {1}", new Object[]{state, this});
            }
            CDOState oldState = this.state;
            this.state = state;
            this.adjustEProxy();
            if (this.view != null) {
                this.view.handleObjectStateChanged(this, oldState, state);
            }
            return oldState;
        }
        return null;
    }

    @Override
    public void cdoInternalSetRevision(CDORevision revision) {
        if (TRACER.isEnabled()) {
            TRACER.trace("Setting revision: " + revision);
        }
        this.revision = (InternalCDORevision)revision;
    }

    @Override
    public void cdoInternalPostAttach() {
        this.instanceToRevision();
        for (Adapter adapter : this.eAdapters()) {
            if (adapter instanceof CDOObjectWrapper) continue;
            this.view.handleAddAdapter(this, adapter);
            this.view.subscribe(this, adapter);
        }
    }

    @Override
    public void cdoInternalPostDetach(boolean remote) {
        if (remote) {
            return;
        }
        EClass eClass = this.revision.getEClass();
        EStructuralFeature[] eStructuralFeatureArray = CDOModelUtil.getAllPersistentFeatures((EClass)eClass);
        int n = eStructuralFeatureArray.length;
        int n2 = 0;
        while (n2 < n) {
            EStructuralFeature feature = eStructuralFeatureArray[n2];
            EReference oppositeReference = ((EStructuralFeature.Internal)feature).getEOpposite();
            if (oppositeReference != null && !oppositeReference.isContainment() && EMFUtil.isPersistent((EStructuralFeature)oppositeReference)) {
                if (feature.isMany()) {
                    int size = this.revision.size(feature);
                    int i = 0;
                    while (i < size) {
                        EObject object = (EObject)this.getValueFromRevision(feature, i);
                        this.adjustPersistentOppositeReference(this, object, oppositeReference);
                        ++i;
                    }
                } else {
                    EObject oppositeObject = (EObject)this.instance.eGet(feature);
                    if (oppositeObject != null) {
                        this.adjustPersistentOppositeReference(this, oppositeObject, oppositeReference);
                    }
                }
            }
            ++n2;
        }
    }

    @Override
    public void cdoInternalPostRollback() {
        CDOStateMachine.INSTANCE.read(this);
    }

    @Override
    public void cdoInternalPreCommit() {
        this.instanceToRevisionContainment();
        EClass eClass = this.revision.getEClass();
        EStructuralFeature[] eStructuralFeatureArray = CDOModelUtil.getAllPersistentFeatures((EClass)eClass);
        int n = eStructuralFeatureArray.length;
        int n2 = 0;
        while (n2 < n) {
            EStructuralFeature feature = eStructuralFeatureArray[n2];
            if (feature.isUnsettable()) {
                if (!this.instance.eIsSet(feature)) {
                    if (feature.isMany()) {
                        InternalEList list = (InternalEList)this.instance.eGet(feature);
                        this.clearEList(list);
                    } else {
                        this.revision.set(feature, -1, null);
                    }
                } else if (this.instance.eGet(feature) == null) {
                    this.revision.set(feature, -1, CDORevisionData.NIL);
                }
            }
            ++n2;
        }
    }

    @Override
    public void cdoInternalPreLoad() {
    }

    @Override
    public void cdoInternalPostLoad() {
        this.revisionToInstance();
    }

    @Override
    public void cdoInternalPostInvalidate() {
        if (this.cdoState() != CDOState.CLEAN) {
            InternalCDORevision revision = this.cdoView().getRevision(this.cdoID(), true);
            this.cdoInternalSetRevision((CDORevision)revision);
        }
        this.revisionToInstance();
        this.cdoInternalSetState(CDOState.CLEAN);
    }

    public boolean equals(Object obj) {
        return obj == this || obj == this.instance;
    }

    public int hashCode() {
        if (this.instance != null) {
            return this.instance.hashCode();
        }
        return super.hashCode();
    }

    public String toString() {
        return "CDOLegacyWrapper[" + this.instance.getClass().getSimpleName() + "@" + this.id + "]";
    }

    protected void instanceToRevision() {
        if (TRACER.isEnabled()) {
            TRACER.format("Transfering instance to revision: {0} --> {1}", new Object[]{this.instance, this.revision});
        }
        this.instanceToRevisionContainment();
        InternalCDOPackageRegistry packageRegistry = this.cdoView().getSession().getPackageRegistry();
        EClass eClass = this.revision.getEClass();
        EStructuralFeature[] eStructuralFeatureArray = CDOModelUtil.getAllPersistentFeatures((EClass)eClass);
        int n = eStructuralFeatureArray.length;
        int n2 = 0;
        while (n2 < n) {
            EStructuralFeature feature = eStructuralFeatureArray[n2];
            this.instanceToRevisionFeature(feature, (CDOPackageRegistry)packageRegistry);
            ++n2;
        }
        this.revision.setUnchunked();
    }

    protected void instanceToRevisionContainment() {
        CDOResource resource = (CDOResource)this.getInstanceResource(this.instance);
        this.revision.setResourceID(resource == null ? CDOID.NULL : resource.cdoID());
        InternalEObject eContainer = this.getInstanceContainer(this.instance);
        if (eContainer == null) {
            this.revision.setContainerID((Object)CDOID.NULL);
            this.revision.setContainingFeatureID(0);
        } else {
            InternalCDOObject cdoContainer = FSMUtil.adapt(eContainer, this.view);
            this.revision.setContainerID((Object)cdoContainer);
            this.revision.setContainingFeatureID(this.getInstanceContainerFeatureID(this.instance));
        }
    }

    protected void instanceToRevisionFeature(EStructuralFeature feature, CDOPackageRegistry packageRegistry) {
        Object instanceValue = this.getInstanceValue(this.instance, feature, packageRegistry);
        CDOObjectImpl.instanceToRevisionFeature(this.view, this, feature, instanceValue);
    }

    protected void revisionToInstance() {
        boolean deliver;
        if (this.underConstruction) {
            return;
        }
        this.underConstruction = true;
        if (TRACER.isEnabled()) {
            TRACER.format("Transfering revision to instance: {0} --> {1}", new Object[]{this.revision, this.instance});
        }
        if (deliver = this.instance.eDeliver()) {
            this.instance.eSetDeliver(false);
        }
        Counter counter = recursionCounter.get();
        try {
            try {
                CDOLegacyWrapper.registerWrapper(this);
                counter.increment();
                this.view.registerObject(this);
                this.revisionToInstanceContainer();
                EStructuralFeature[] eStructuralFeatureArray = CDOModelUtil.getAllPersistentFeatures((EClass)this.revision.getEClass());
                int n = eStructuralFeatureArray.length;
                int n2 = 0;
                while (n2 < n) {
                    EStructuralFeature feature = eStructuralFeatureArray[n2];
                    this.revisionToInstanceFeature(feature);
                    ++n2;
                }
                this.revisionToInstanceResource();
            }
            catch (RuntimeException ex) {
                OM.LOG.error((Throwable)ex);
                throw ex;
            }
            catch (Exception ex) {
                OM.LOG.error((Throwable)ex);
                throw new CDOException((Throwable)ex);
            }
        }
        finally {
            if (deliver) {
                this.instance.eSetDeliver(true);
            }
            counter.decrement();
            CDOLegacyWrapper.unregisterWrapper(this);
            this.underConstruction = false;
        }
    }

    protected void revisionToInstanceContainer() {
        CDOPermission permission = this.revision.getPermission();
        if (permission != CDOPermission.WRITE) {
            this.revision.setPermission(CDOPermission.WRITE);
        }
        try {
            Object containerID = this.revision.getContainerID();
            InternalEObject container = this.getEObjectFromPotentialID(this.view, null, containerID);
            EObject oldContainer = this.instance.eContainer();
            if (oldContainer != container) {
                this.setInstanceContainer(container, this.revision.getContainingFeatureID());
            }
        }
        finally {
            if (permission != CDOPermission.WRITE) {
                this.revision.setPermission(permission);
            }
        }
    }

    protected void revisionToInstanceResource() {
        if (this.revision != null) {
            CDOID resourceID = this.revision.getResourceID();
            InternalEObject resource = this.getEObjectFromPotentialID(this.view, null, resourceID);
            this.setInstanceResource((Resource.Internal)resource);
            if (resource != null) {
                this.view.registerObject((InternalCDOObject)resource);
            }
        }
    }

    protected void revisionToInstanceFeature(EStructuralFeature feature) {
        if (feature.isUnsettable() && !this.view.getStore().isSet(this, feature)) {
            this.instance.eUnset(feature);
            return;
        }
        if (feature.isMany()) {
            if (TRACER.isEnabled()) {
                TRACER.format("State of Object (" + this + "/" + this.instance + ") is : " + (Object)((Object)this.state), new Object[0]);
            }
            if (this.state == CDOState.CLEAN || this.state == CDOState.PROXY || this.state == CDOState.NEW || this.state == CDOState.DIRTY) {
                int size = this.revision.size(feature);
                InternalEList list = (InternalEList)this.instance.eGet(feature);
                this.clearEList(list);
                int i = 0;
                while (i < size) {
                    Object object = this.getValueFromRevision(feature, i);
                    if (TRACER.isEnabled()) {
                        TRACER.format("Adding " + object + " to feature " + feature + "in instance " + this.instance, new Object[0]);
                    }
                    list.basicAdd(object, null);
                    ++i;
                }
            }
        } else {
            Object object = this.getValueFromRevision(feature, 0);
            if (feature instanceof EAttribute) {
                if (TRACER.isEnabled()) {
                    TRACER.format("Setting attribute value " + object + " to feature " + feature + " in instance " + this.instance, new Object[0]);
                }
                if (feature.isUnsettable() && object.equals(CDORevisionData.NIL)) {
                    this.eSet(feature, null);
                } else {
                    this.eSet(feature, object);
                }
            } else {
                if (TRACER.isEnabled()) {
                    TRACER.format("Adding object " + object + " to feature " + feature + " in instance " + this.instance, new Object[0]);
                }
                int featureID = this.instance.eClass().getFeatureID(feature);
                Class<?> baseClass = object == null ? null : object.getClass();
                EStructuralFeature.Internal internalFeature = (EStructuralFeature.Internal)feature;
                EReference oppositeReference = internalFeature.getEOpposite();
                if (oppositeReference != null) {
                    if (object != null) {
                        if (object != this.instance.eContainer()) {
                            this.instance.eInverseAdd((InternalEObject)object, featureID, baseClass, null);
                        }
                        if (!EMFUtil.isPersistent((EStructuralFeature)oppositeReference)) {
                            this.adjustTransientOppositeReference(this.instance, (InternalEObject)object, oppositeReference);
                        }
                    }
                } else if (object != CDORevisionData.NIL) {
                    EReference reference = (EReference)feature;
                    if (reference.isContainment()) {
                        if (object != null) {
                            this.instance.eSet(feature, object);
                        } else {
                            this.instance.eSet(feature, null);
                        }
                    } else {
                        this.instance.eSet(feature, object);
                    }
                } else {
                    this.instance.eSet(feature, null);
                }
                if (TRACER.isEnabled()) {
                    TRACER.format("Added object " + object + " to feature " + feature + " in instance " + this.instance, new Object[0]);
                }
            }
        }
    }

    private Object getValueFromRevision(EStructuralFeature feature, int index) {
        Object object = this.revision.get(feature, index);
        if (object == null) {
            return null;
        }
        if (object instanceof CDOElementProxy) {
            CDOElementProxy proxy = (CDOElementProxy)object;
            object = this.view.getSession().resolveElementProxy((CDORevision)this.revision, feature, index, proxy.getIndex());
        }
        if (object instanceof CDOLegacyWrapper) {
            return ((CDOLegacyWrapper)object).cdoInternalInstance();
        }
        CDOType type = CDOModelUtil.getType((EClassifier)feature.getEType());
        object = this.view.getStore().convertToEMF((EObject)this.instance, this.revision, feature, index, object);
        if (type == CDOType.OBJECT && object instanceof CDOID) {
            CDOID id = (CDOID)object;
            if (id.isNull()) {
                return null;
            }
            object = CDOLegacyWrapper.getRegisteredWrapper(id);
            if (object != null) {
                return ((CDOLegacyWrapper)object).cdoInternalInstance();
            }
            object = id.isExternal() ? this.view.getResourceSet().getEObject(URI.createURI((String)id.toURIFragment()), true) : this.view.getObject(id);
            if (object instanceof CDOObjectWrapper) {
                return ((CDOObjectWrapper)object).cdoInternalInstance();
            }
        }
        return object;
    }

    protected InternalEObject getEObjectFromPotentialID(InternalCDOView view, EStructuralFeature feature, Object potentialID) {
        CDOLegacyWrapper wrapper;
        if (potentialID instanceof CDOID && (wrapper = CDOLegacyWrapper.getRegisteredWrapper((CDOID)potentialID)) != null) {
            potentialID = wrapper.instance;
            if (TRACER.isEnabled()) {
                TRACER.format("Getting Object (" + potentialID + ") from localThread instead of the view", new Object[0]);
            }
        } else {
            if (potentialID instanceof CDOID) {
                CDOID id = (CDOID)potentialID;
                if (id.isNull()) {
                    return null;
                }
                if (id.isExternal()) {
                    URI uri = URI.createURI((String)id.toURIFragment());
                    InternalEObject eObject = (InternalEObject)view.getResourceSet().getEObject(uri, true);
                    return eObject;
                }
                boolean loadOnDemand = feature == null;
                potentialID = view.getObject(id, loadOnDemand);
                if (potentialID == null && !loadOnDemand) {
                    return this.createProxy(view, feature, id);
                }
            }
            if (potentialID instanceof InternalCDOObject) {
                return ((InternalCDOObject)potentialID).cdoInternalInstance();
            }
        }
        return (InternalEObject)potentialID;
    }

    protected InternalEObject createProxy(InternalCDOView view, EStructuralFeature feature, CDOID id) {
        EClassifier eType = feature.getEType();
        Class instanceClass = eType.getInstanceClass();
        Class[] interfaces = new Class[]{instanceClass, InternalEObject.class, LegacyProxy.class};
        ClassLoader classLoader = CDOLegacyWrapper.class.getClassLoader();
        LegacyProxyInvocationHandler handler = new LegacyProxyInvocationHandler(this, id);
        return (InternalEObject)Proxy.newProxyInstance(classLoader, interfaces, (InvocationHandler)handler);
    }

    protected void clearEList(InternalEList<?> list) {
        int i = list.size() - 1;
        while (i >= 0) {
            Object obj = list.get(i);
            list.basicRemove(obj, null);
            --i;
        }
    }

    protected void resolveAllProxies() {
        InternalCDOPackageRegistry packageRegistry = this.cdoView().getSession().getPackageRegistry();
        EClass eClass = this.revision.getEClass();
        EStructuralFeature[] eStructuralFeatureArray = CDOModelUtil.getAllPersistentFeatures((EClass)eClass);
        int n = eStructuralFeatureArray.length;
        int n2 = 0;
        while (n2 < n) {
            EStructuralFeature feature = eStructuralFeatureArray[n2];
            if (feature instanceof EReference) {
                this.resolveProxies(feature, (CDOPackageRegistry)packageRegistry);
            }
            ++n2;
        }
    }

    protected void resolveProxies(EStructuralFeature feature, CDOPackageRegistry packageRegistry) {
        Object value = this.getInstanceValue(this.instance, feature, packageRegistry);
        if (value != null) {
            if (feature.isMany()) {
                InternalEList list = (InternalEList)value;
                int size = list.size();
                boolean deliver = this.instance.eDeliver();
                if (deliver) {
                    this.instance.eSetDeliver(false);
                }
                int i = 0;
                while (i < size) {
                    Object element = list.get(i);
                    if (element instanceof LegacyProxy) {
                        CDOID id = ((LegacyProxy)element).getID();
                        InternalCDOObject resolved = (InternalCDOObject)this.view.getObject(id);
                        InternalEObject instance = resolved.cdoInternalInstance();
                        list.set(i, (Object)instance);
                    }
                    ++i;
                }
                if (deliver) {
                    this.instance.eSetDeliver(true);
                }
            } else if (value instanceof LegacyProxy) {
                CDOID id = ((LegacyProxy)value).getID();
                InternalCDOObject resolved = (InternalCDOObject)this.view.getObject(id);
                InternalEObject instance = resolved.cdoInternalInstance();
                this.setInstanceValue(instance, feature, instance);
            }
        }
    }

    protected void adjustEProxy() {
        if (this.state == CDOState.PROXY) {
            if (!this.instance.eIsProxy()) {
                URI uri = URI.createURI((String)("cdo:proxy#" + this.id));
                if (TRACER.isEnabled()) {
                    TRACER.format("Setting proxyURI {0} for {1}", new Object[]{uri, this.instance});
                }
                this.instance.eSetProxyURI(uri);
            }
        } else if (this.instance.eIsProxy()) {
            if (TRACER.isEnabled()) {
                TRACER.format("Unsetting proxyURI for {0}", new Object[]{this.instance});
            }
            this.instance.eSetProxyURI(null);
        }
    }

    @Override
    public synchronized EList<Adapter> eAdapters() {
        EList adapters = this.instance.eAdapters();
        for (Adapter adapter : adapters) {
            if (FSMUtil.isTransient(this) || adapter instanceof CDOLegacyWrapper) continue;
            this.cdoView().handleAddAdapter(this, adapter);
        }
        return adapters;
    }

    public static boolean isLegacyProxy(Object object) {
        return object instanceof LegacyProxy;
    }

    protected static int getEFlagMask(Class<?> instanceClass, String flagName) {
        Field field = ReflectUtil.getField(instanceClass, (String)flagName);
        if (!field.isAccessible()) {
            field.setAccessible(true);
        }
        try {
            return (Integer)field.get(null);
        }
        catch (IllegalAccessException ex) {
            throw WrappedException.wrap((Exception)ex);
        }
    }

    protected static CDOLegacyWrapper getRegisteredWrapper(CDOID id) {
        return wrapperRegistry.get().get(id);
    }

    protected static void registerWrapper(CDOLegacyWrapper wrapper) {
        wrapperRegistry.get().put(wrapper.cdoID(), wrapper);
    }

    protected static void unregisterWrapper(CDOLegacyWrapper wrapper) {
        wrapperRegistry.get().remove(wrapper.cdoID());
    }

    protected static boolean isRegisteredWrapper(CDOLegacyWrapper wrapper) {
        return wrapperRegistry.get().containsKey(wrapper.cdoID());
    }

    private void adjustPersistentOppositeReference(InternalCDOObject cdoObject, EObject oppositeObject, EReference oppositeReference) {
        CDOStore store;
        InternalCDOView view;
        InternalCDOObject oppositeCDOObject = (InternalCDOObject)CDOUtil.getCDOObject(oppositeObject);
        if (oppositeCDOObject != null && (view = oppositeCDOObject.cdoView()) != null && (store = view.getStore()) != null) {
            if (oppositeReference.isMany()) {
                InternalEObject eObject = oppositeCDOObject.cdoInternalInstance();
                EList list = (EList)eObject.eGet((EStructuralFeature)oppositeReference);
                int index = list.indexOf((Object)this.instance);
                if (!store.isEmpty(oppositeCDOObject, (EStructuralFeature)oppositeReference) && index != -1) {
                    store.set(oppositeCDOObject, (EStructuralFeature)oppositeReference, index, cdoObject);
                }
            } else {
                store.set(oppositeCDOObject, (EStructuralFeature)oppositeReference, 0, cdoObject);
            }
        }
    }

    private void adjustTransientOppositeReference(InternalEObject instance, InternalEObject object, EReference oppositeReference) {
        boolean wasDeliver = object.eDeliver();
        if (wasDeliver) {
            object.eSetDeliver(false);
        }
        try {
            if (oppositeReference.isMany()) {
                InternalEList list = (InternalEList)object.eGet((EStructuralFeature)oppositeReference);
                list.basicAdd((Object)instance, null);
            } else if (object.eGet((EStructuralFeature)oppositeReference) != instance) {
                object.eInverseAdd(instance, oppositeReference.getFeatureID(), instance.getClass(), null);
            }
        }
        finally {
            if (wasDeliver) {
                object.eSetDeliver(true);
            }
        }
    }

    private static final class Counter {
        private int value;

        public void increment() {
            ++this.value;
        }

        public int decrement() {
            return --this.value;
        }
    }

    private static interface LegacyProxy {
        public CDOID getID();
    }

    private static final class LegacyProxyInvocationHandler
    implements InvocationHandler,
    LegacyProxy {
        private static final Method getIDMethod = ReflectUtil.getMethod(LegacyProxy.class, (String)"getID", (Class[])new Class[0]);
        private static final Method eIsProxyMethod = ReflectUtil.getMethod(EObject.class, (String)"eIsProxy", (Class[])new Class[0]);
        private static final Method eProxyURIMethod = ReflectUtil.getMethod(InternalEObject.class, (String)"eProxyURI", (Class[])new Class[0]);
        private CDOLegacyWrapper wrapper;
        private CDOID id;

        public LegacyProxyInvocationHandler(CDOLegacyWrapper wrapper, CDOID id) {
            this.wrapper = wrapper;
            this.id = id;
        }

        public CDOID getID() {
            return this.id;
        }

        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            if (method.equals(getIDMethod)) {
                return this.id;
            }
            if (method.equals(eIsProxyMethod)) {
                return true;
            }
            if (method.equals(eProxyURIMethod)) {
                Resource resource = this.wrapper.eResource();
                return resource.getURI().appendFragment(this.id.toURIFragment());
            }
            throw new UnsupportedOperationException(method.getName());
        }
    }
}

