/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.internal.cdo.object;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.eclipse.emf.cdo.CDOLock;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.lock.CDOLockState;
import org.eclipse.emf.cdo.common.model.CDOPackageRegistry;
import org.eclipse.emf.cdo.eresource.impl.CDOResourceImpl;
import org.eclipse.emf.cdo.view.CDOView;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.internal.cdo.CDOObjectImpl;
import org.eclipse.emf.internal.cdo.bundle.OM;
import org.eclipse.emf.spi.cdo.FSMUtil;
import org.eclipse.emf.spi.cdo.InternalCDOObject;
import org.eclipse.emf.spi.cdo.InternalCDOView;
import org.eclipse.net4j.util.ReflectUtil;
import org.eclipse.net4j.util.concurrent.IRWLockManager;
import org.eclipse.net4j.util.om.trace.ContextTracer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CDOObjectWrapper
implements InternalCDOObject {
    private static final ContextTracer TRACER = new ContextTracer(OM.DEBUG_OBJECT, CDOObjectWrapper.class);
    protected CDOID id;
    protected InternalCDOView view;
    protected InternalEObject instance;

    @Override
    public CDOID cdoID() {
        return this.id;
    }

    @Override
    public InternalCDOView cdoView() {
        return this.view;
    }

    @Override
    public CDOResourceImpl cdoResource() {
        Resource resource = this.eResource();
        if (resource instanceof CDOResourceImpl) {
            return (CDOResourceImpl)resource;
        }
        return null;
    }

    @Override
    public CDOResourceImpl cdoDirectResource() {
        Resource.Internal resource = this.eDirectResource();
        if (resource instanceof CDOResourceImpl) {
            return (CDOResourceImpl)resource;
        }
        return null;
    }

    @Override
    public void cdoInternalSetID(CDOID id) {
        if (TRACER.isEnabled()) {
            TRACER.format("Setting ID: {0} for {1}", new Object[]{id, this.instance});
        }
        this.id = id;
    }

    @Override
    public void cdoInternalSetView(CDOView view) {
        if (TRACER.isEnabled()) {
            TRACER.format("Setting view: {0} for {1}", new Object[]{view, this.instance});
        }
        this.view = (InternalCDOView)view;
    }

    @Override
    public InternalEObject cdoInternalInstance() {
        return this.instance;
    }

    @Override
    public boolean cdoConflict() {
        return FSMUtil.isConflict(this);
    }

    @Override
    public boolean cdoInvalid() {
        return FSMUtil.isInvalid(this);
    }

    @Override
    public void cdoPrefetch(int depth) {
        this.view.prefetchRevisions(this.id, depth);
    }

    @Override
    public EStructuralFeature cdoInternalDynamicFeature(int dynamicFeatureID) {
        return this.eDynamicFeature(dynamicFeatureID);
    }

    protected EStructuralFeature eDynamicFeature(int dynamicFeatureID) {
        return this.eClass().getEStructuralFeature(dynamicFeatureID + this.eStaticFeatureCount());
    }

    protected int eStaticFeatureCount() {
        return this.eStaticClass().getFeatureCount();
    }

    protected final EClass eStaticClass() {
        return EcorePackage.eINSTANCE.getEObject();
    }

    @Override
    public CDOLock cdoReadLock() {
        return CDOObjectImpl.createLock(this, IRWLockManager.LockType.READ);
    }

    @Override
    public CDOLock cdoWriteLock() {
        return CDOObjectImpl.createLock(this, IRWLockManager.LockType.WRITE);
    }

    @Override
    public CDOLock cdoWriteOption() {
        return CDOObjectImpl.createLock(this, IRWLockManager.LockType.OPTION);
    }

    @Override
    public synchronized CDOLockState cdoLockState() {
        return CDOObjectImpl.getLockState(this);
    }

    public Resource.Internal getInstanceResource(InternalEObject instance) {
        return instance.eDirectResource();
    }

    public InternalEObject getInstanceContainer(InternalEObject instance) {
        return instance.eInternalContainer();
    }

    public int getInstanceContainerFeatureID(InternalEObject instance) {
        return instance.eContainerFeatureID();
    }

    public Object getInstanceValue(InternalEObject instance, EStructuralFeature feature, CDOPackageRegistry packageRegistry) {
        return instance.eGet(feature);
    }

    public void setInstanceResource(Resource.Internal resource) {
        Method method = ReflectUtil.getMethod(this.instance.getClass(), (String)"eSetDirectResource", (Class[])new Class[]{Resource.Internal.class});
        ReflectUtil.invokeMethod((Method)method, (Object)this.instance, (Object[])new Object[]{resource});
    }

    public void setInstanceContainer(InternalEObject container, int containerFeatureID) {
        Method method = ReflectUtil.getMethod(this.instance.getClass(), (String)"eBasicSetContainer", (Class[])new Class[]{InternalEObject.class, Integer.TYPE});
        ReflectUtil.invokeMethod((Method)method, (Object)this.instance, (Object[])new Object[]{container, containerFeatureID});
    }

    public void setInstanceValue(InternalEObject instance, EStructuralFeature feature, Object value) {
        instance.eSet(feature, value);
    }

    public EList<Adapter> eAdapters() {
        return this.instance.eAdapters();
    }

    public TreeIterator<EObject> eAllContents() {
        return this.instance.eAllContents();
    }

    public int eBaseStructuralFeatureID(int derivedFeatureID, Class<?> baseClass) {
        return this.instance.eBaseStructuralFeatureID(derivedFeatureID, baseClass);
    }

    public NotificationChain eBasicRemoveFromContainer(NotificationChain notifications) {
        return this.instance.eBasicRemoveFromContainer(notifications);
    }

    public NotificationChain eBasicSetContainer(InternalEObject newContainer, int newContainerFeatureID, NotificationChain notifications) {
        return this.instance.eBasicSetContainer(newContainer, newContainerFeatureID, notifications);
    }

    public EClass eClass() {
        return this.instance.eClass();
    }

    public EObject eContainer() {
        return this.instance.eContainer();
    }

    public int eContainerFeatureID() {
        return this.instance.eContainerFeatureID();
    }

    public EStructuralFeature eContainingFeature() {
        return this.instance.eContainingFeature();
    }

    public EReference eContainmentFeature() {
        return this.instance.eContainmentFeature();
    }

    public EList<EObject> eContents() {
        return this.instance.eContents();
    }

    public EList<EObject> eCrossReferences() {
        return this.instance.eCrossReferences();
    }

    public boolean eDeliver() {
        return this.instance.eDeliver();
    }

    public int eDerivedStructuralFeatureID(int baseFeatureID, Class<?> baseClass) {
        return this.instance.eDerivedStructuralFeatureID(baseFeatureID, baseClass);
    }

    public Resource.Internal eDirectResource() {
        return this.instance.eDirectResource();
    }

    public Object eGet(EStructuralFeature feature, boolean resolve, boolean coreType) {
        return this.instance.eGet(feature, resolve, coreType);
    }

    public Object eGet(EStructuralFeature feature, boolean resolve) {
        return this.instance.eGet(feature, resolve);
    }

    public Object eGet(EStructuralFeature feature) {
        return this.instance.eGet(feature);
    }

    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        return this.instance.eGet(featureID, resolve, coreType);
    }

    public int eDerivedOperationID(int baseOperationID, Class<?> baseClass) {
        return this.instance.eDerivedOperationID(baseOperationID, baseClass);
    }

    public Object eInvoke(EOperation operation, EList<?> arguments) throws InvocationTargetException {
        return this.instance.eInvoke(operation, arguments);
    }

    public Object eInvoke(int operationID, EList<?> arguments) throws InvocationTargetException {
        return this.instance.eInvoke(operationID, arguments);
    }

    public InternalEObject eInternalContainer() {
        return this.instance.eInternalContainer();
    }

    public Resource.Internal eInternalResource() {
        return this.instance.eInternalResource();
    }

    public NotificationChain eInverseAdd(InternalEObject otherEnd, int featureID, Class<?> baseClass, NotificationChain notifications) {
        return this.instance.eInverseAdd(otherEnd, featureID, baseClass, notifications);
    }

    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, Class<?> baseClass, NotificationChain notifications) {
        return this.instance.eInverseRemove(otherEnd, featureID, baseClass, notifications);
    }

    public boolean eIsProxy() {
        return this.instance.eIsProxy();
    }

    public boolean eIsSet(EStructuralFeature feature) {
        return this.instance.eIsSet(feature);
    }

    public boolean eIsSet(int featureID) {
        return this.instance.eIsSet(featureID);
    }

    public boolean eNotificationRequired() {
        return this.instance.eNotificationRequired();
    }

    public void eNotify(Notification notification) {
        this.instance.eNotify(notification);
    }

    public EObject eObjectForURIFragmentSegment(String uriFragmentSegment) {
        return this.instance.eObjectForURIFragmentSegment(uriFragmentSegment);
    }

    public URI eProxyURI() {
        return this.instance.eProxyURI();
    }

    public EObject eResolveProxy(InternalEObject proxy) {
        return this.instance.eResolveProxy(proxy);
    }

    public Resource eResource() {
        return this.instance.eResource();
    }

    public void eSet(EStructuralFeature feature, Object newValue) {
        this.instance.eSet(feature, newValue);
    }

    public void eSet(int featureID, Object newValue) {
        this.instance.eSet(featureID, newValue);
    }

    public void eSetClass(EClass class1) {
        this.instance.eSetClass(class1);
    }

    public void eSetDeliver(boolean deliver) {
        this.instance.eSetDeliver(deliver);
    }

    public void eSetProxyURI(URI uri) {
        this.instance.eSetProxyURI(uri);
    }

    public NotificationChain eSetResource(Resource.Internal resource, NotificationChain notifications) {
        return this.instance.eSetResource(resource, notifications);
    }

    public void eSetStore(InternalEObject.EStore store) {
        this.instance.eSetStore(store);
    }

    public EStructuralFeature.Setting eSetting(EStructuralFeature feature) {
        return this.instance.eSetting(feature);
    }

    public InternalEObject.EStore eStore() {
        return this.instance.eStore();
    }

    public void eUnset(EStructuralFeature feature) {
        this.instance.eUnset(feature);
    }

    public void eUnset(int featureID) {
        this.instance.eUnset(featureID);
    }

    public String eURIFragmentSegment(EStructuralFeature feature, EObject object) {
        return this.instance.eURIFragmentSegment(feature, object);
    }
}

