/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.internal.cdo.transaction;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.cdo.CDOObject;
import org.eclipse.emf.cdo.CDOState;
import org.eclipse.emf.cdo.common.CDOCommonRepository;
import org.eclipse.emf.cdo.common.CDOCommonView;
import org.eclipse.emf.cdo.common.branch.CDOBranch;
import org.eclipse.emf.cdo.common.branch.CDOBranchManager;
import org.eclipse.emf.cdo.common.branch.CDOBranchPoint;
import org.eclipse.emf.cdo.common.commit.CDOChangeSet;
import org.eclipse.emf.cdo.common.commit.CDOChangeSetData;
import org.eclipse.emf.cdo.common.commit.CDOCommitData;
import org.eclipse.emf.cdo.common.commit.CDOCommitInfo;
import org.eclipse.emf.cdo.common.commit.CDOCommitInfoManager;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.id.CDOIDGenerator;
import org.eclipse.emf.cdo.common.id.CDOIDProvider;
import org.eclipse.emf.cdo.common.id.CDOIDTemp;
import org.eclipse.emf.cdo.common.id.CDOIDUtil;
import org.eclipse.emf.cdo.common.lob.CDOLob;
import org.eclipse.emf.cdo.common.lob.CDOLobStore;
import org.eclipse.emf.cdo.common.lock.CDOLockChangeInfo;
import org.eclipse.emf.cdo.common.lock.CDOLockOwner;
import org.eclipse.emf.cdo.common.lock.CDOLockState;
import org.eclipse.emf.cdo.common.lock.CDOLockUtil;
import org.eclipse.emf.cdo.common.model.CDOModelUtil;
import org.eclipse.emf.cdo.common.model.CDOPackageRegistry;
import org.eclipse.emf.cdo.common.model.CDOPackageUnit;
import org.eclipse.emf.cdo.common.model.EMFUtil;
import org.eclipse.emf.cdo.common.protocol.CDODataInput;
import org.eclipse.emf.cdo.common.revision.CDOIDAndVersion;
import org.eclipse.emf.cdo.common.revision.CDOList;
import org.eclipse.emf.cdo.common.revision.CDOListFactory;
import org.eclipse.emf.cdo.common.revision.CDORevision;
import org.eclipse.emf.cdo.common.revision.CDORevisionFactory;
import org.eclipse.emf.cdo.common.revision.CDORevisionKey;
import org.eclipse.emf.cdo.common.revision.CDORevisionProvider;
import org.eclipse.emf.cdo.common.revision.CDORevisionUtil;
import org.eclipse.emf.cdo.common.revision.delta.CDOFeatureDelta;
import org.eclipse.emf.cdo.common.revision.delta.CDORevisionDelta;
import org.eclipse.emf.cdo.common.util.CDOException;
import org.eclipse.emf.cdo.eresource.CDOResource;
import org.eclipse.emf.cdo.eresource.CDOResourceFolder;
import org.eclipse.emf.cdo.eresource.CDOResourceNode;
import org.eclipse.emf.cdo.eresource.EresourceFactory;
import org.eclipse.emf.cdo.eresource.impl.CDOResourceImpl;
import org.eclipse.emf.cdo.eresource.impl.CDOResourceNodeImpl;
import org.eclipse.emf.cdo.internal.common.commit.CDOCommitDataImpl;
import org.eclipse.emf.cdo.internal.common.commit.FailureCommitInfo;
import org.eclipse.emf.cdo.internal.common.protocol.CDODataInputImpl;
import org.eclipse.emf.cdo.internal.common.protocol.CDODataOutputImpl;
import org.eclipse.emf.cdo.internal.common.revision.CDOListWithElementProxiesImpl;
import org.eclipse.emf.cdo.session.CDORepositoryInfo;
import org.eclipse.emf.cdo.spi.common.branch.CDOBranchUtil;
import org.eclipse.emf.cdo.spi.common.commit.CDORevisionAvailabilityInfo;
import org.eclipse.emf.cdo.spi.common.commit.InternalCDOCommitInfoManager;
import org.eclipse.emf.cdo.spi.common.lock.InternalCDOLockState;
import org.eclipse.emf.cdo.spi.common.model.InternalCDOPackageRegistry;
import org.eclipse.emf.cdo.spi.common.model.InternalCDOPackageUnit;
import org.eclipse.emf.cdo.spi.common.revision.CDOIDMapper;
import org.eclipse.emf.cdo.spi.common.revision.CDOReferenceAdjuster;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDORevision;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDORevisionDelta;
import org.eclipse.emf.cdo.transaction.CDOCommitContext;
import org.eclipse.emf.cdo.transaction.CDOConflictResolver;
import org.eclipse.emf.cdo.transaction.CDOConflictResolver2;
import org.eclipse.emf.cdo.transaction.CDODefaultTransactionHandler1;
import org.eclipse.emf.cdo.transaction.CDOMerger;
import org.eclipse.emf.cdo.transaction.CDOSavepoint;
import org.eclipse.emf.cdo.transaction.CDOTransaction;
import org.eclipse.emf.cdo.transaction.CDOTransactionConflictEvent;
import org.eclipse.emf.cdo.transaction.CDOTransactionFinishedEvent;
import org.eclipse.emf.cdo.transaction.CDOTransactionHandler;
import org.eclipse.emf.cdo.transaction.CDOTransactionHandler1;
import org.eclipse.emf.cdo.transaction.CDOTransactionHandler2;
import org.eclipse.emf.cdo.transaction.CDOTransactionHandler3;
import org.eclipse.emf.cdo.transaction.CDOTransactionHandlerBase;
import org.eclipse.emf.cdo.transaction.CDOTransactionStartedEvent;
import org.eclipse.emf.cdo.transaction.CDOUserSavepoint;
import org.eclipse.emf.cdo.util.CDOURIUtil;
import org.eclipse.emf.cdo.util.CDOUtil;
import org.eclipse.emf.cdo.util.CommitException;
import org.eclipse.emf.cdo.util.LegacyModeNotEnabledException;
import org.eclipse.emf.cdo.util.ObjectNotFoundException;
import org.eclipse.emf.cdo.view.CDOView;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.EClassImpl;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EContentsEList;
import org.eclipse.emf.ecore.util.ECrossReferenceEList;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.internal.cdo.CDOObjectImpl;
import org.eclipse.emf.internal.cdo.bundle.OM;
import org.eclipse.emf.internal.cdo.messages.Messages;
import org.eclipse.emf.internal.cdo.object.CDONotificationBuilder;
import org.eclipse.emf.internal.cdo.object.CDOObjectMerger;
import org.eclipse.emf.internal.cdo.object.CDOObjectWrapper;
import org.eclipse.emf.internal.cdo.query.CDOQueryImpl;
import org.eclipse.emf.internal.cdo.transaction.CDOSavepointImpl;
import org.eclipse.emf.internal.cdo.util.CommitIntegrityCheck;
import org.eclipse.emf.internal.cdo.util.CompletePackageClosure;
import org.eclipse.emf.internal.cdo.view.AbstractCDOView;
import org.eclipse.emf.internal.cdo.view.CDOStateMachine;
import org.eclipse.emf.internal.cdo.view.CDOViewImpl;
import org.eclipse.emf.spi.cdo.CDOSessionProtocol;
import org.eclipse.emf.spi.cdo.CDOTransactionStrategy;
import org.eclipse.emf.spi.cdo.FSMUtil;
import org.eclipse.emf.spi.cdo.InternalCDOObject;
import org.eclipse.emf.spi.cdo.InternalCDOSavepoint;
import org.eclipse.emf.spi.cdo.InternalCDOSession;
import org.eclipse.emf.spi.cdo.InternalCDOTransaction;
import org.eclipse.emf.spi.cdo.InternalCDOViewSet;
import org.eclipse.net4j.util.CheckUtil;
import org.eclipse.net4j.util.ObjectUtil;
import org.eclipse.net4j.util.WrappedException;
import org.eclipse.net4j.util.collection.ByteArrayWrapper;
import org.eclipse.net4j.util.collection.ConcurrentArray;
import org.eclipse.net4j.util.collection.Pair;
import org.eclipse.net4j.util.concurrent.IRWLockManager;
import org.eclipse.net4j.util.event.IEvent;
import org.eclipse.net4j.util.event.IListener;
import org.eclipse.net4j.util.io.ExtendedDataInput;
import org.eclipse.net4j.util.io.ExtendedDataInputStream;
import org.eclipse.net4j.util.io.ExtendedDataOutput;
import org.eclipse.net4j.util.io.ExtendedDataOutputStream;
import org.eclipse.net4j.util.om.trace.ContextTracer;
import org.eclipse.net4j.util.options.IOptions;
import org.eclipse.net4j.util.options.OptionsEvent;
import org.eclipse.net4j.util.transaction.TransactionException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CDOTransactionImpl
extends CDOViewImpl
implements InternalCDOTransaction {
    private static final ContextTracer TRACER = new ContextTracer(OM.DEBUG_TRANSACTION, CDOTransactionImpl.class);
    private Object transactionHandlersLock = new Object();
    private ConcurrentArray<CDOTransactionHandler1> transactionHandlers1 = new ConcurrentArray<CDOTransactionHandler1>(){

        protected CDOTransactionHandler1[] newArray(int length) {
            return new CDOTransactionHandler1[length];
        }
    };
    private ConcurrentArray<CDOTransactionHandler2> transactionHandlers2 = new ConcurrentArray<CDOTransactionHandler2>(){

        protected CDOTransactionHandler2[] newArray(int length) {
            return new CDOTransactionHandler2[length];
        }
    };
    private InternalCDOSavepoint lastSavepoint;
    private InternalCDOSavepoint firstSavepoint = this.lastSavepoint = this.createSavepoint(null);
    private boolean dirty;
    private int conflict;
    private CDOTransactionStrategy transactionStrategy;
    private CDOIDGenerator idGenerator;
    private volatile long lastCommitTime = 0L;
    private String commitComment;
    private final ThreadLocal<Boolean> providingCDOID = new InheritableThreadLocal<Boolean>(){

        @Override
        protected Boolean initialValue() {
            return false;
        }
    };
    private Set<? extends EObject> committables;
    private Map<InternalCDOObject, InternalCDORevision> cleanRevisions = new ResolvingRevisionMap();

    public CDOTransactionImpl(CDOBranch branch) {
        super(branch, 0L);
    }

    public CDOTransactionImpl(String durableLockingID) {
        super(durableLockingID);
    }

    @Override
    public OptionsImpl options() {
        return (OptionsImpl)super.options();
    }

    @Override
    protected OptionsImpl createOptions() {
        return new OptionsImpl();
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    @Override
    public synchronized boolean setBranchPoint(CDOBranchPoint branchPoint) {
        if (branchPoint.getTimeStamp() != 0L) {
            throw new IllegalArgumentException("Changing the target time is not supported by transactions");
        }
        if (this.isDirty() && !this.getBranch().equals(branchPoint.getBranch())) {
            throw new IllegalStateException("Changing the target branch is impossible while transaction is dirty");
        }
        return super.setBranchPoint(branchPoint);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addTransactionHandler(CDOTransactionHandlerBase handler) {
        Object object = this.transactionHandlersLock;
        synchronized (object) {
            if (handler instanceof CDOTransactionHandler1) {
                this.transactionHandlers1.add((Object)((CDOTransactionHandler1)handler));
            }
            if (handler instanceof CDOTransactionHandler2) {
                this.transactionHandlers2.add((Object)((CDOTransactionHandler2)handler));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeTransactionHandler(CDOTransactionHandlerBase handler) {
        Object object = this.transactionHandlersLock;
        synchronized (object) {
            if (handler instanceof CDOTransactionHandler1) {
                this.transactionHandlers1.remove((Object)((CDOTransactionHandler1)handler));
            }
            if (handler instanceof CDOTransactionHandler2) {
                this.transactionHandlers2.remove((Object)((CDOTransactionHandler2)handler));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CDOTransactionHandler[] getTransactionHandlers() {
        HashSet<CDOTransactionHandler> result = new HashSet<CDOTransactionHandler>();
        Object object = this.transactionHandlersLock;
        synchronized (object) {
            CDOTransactionHandler2[] handlers2;
            int n;
            CDOTransactionHandler1[] handlers1 = (CDOTransactionHandler1[])this.transactionHandlers1.get();
            if (handlers1 != null) {
                CDOTransactionHandler1[] cDOTransactionHandler1Array = handlers1;
                n = handlers1.length;
                int n2 = 0;
                while (n2 < n) {
                    CDOTransactionHandler1 handler = cDOTransactionHandler1Array[n2];
                    if (handler instanceof CDOTransactionHandler) {
                        result.add((CDOTransactionHandler)handler);
                    }
                    ++n2;
                }
            }
            if ((handlers2 = (CDOTransactionHandler2[])this.transactionHandlers2.get()) != null) {
                CDOTransactionHandler2[] cDOTransactionHandler2Array = handlers2;
                int n3 = handlers2.length;
                n = 0;
                while (n < n3) {
                    CDOTransactionHandler2 handler = cDOTransactionHandler2Array[n];
                    if (handler instanceof CDOTransactionHandler) {
                        result.add((CDOTransactionHandler)handler);
                    }
                    ++n;
                }
            }
        }
        return result.toArray(new CDOTransactionHandler[result.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CDOTransactionHandler1[] getTransactionHandlers1() {
        Object object = this.transactionHandlersLock;
        synchronized (object) {
            return (CDOTransactionHandler1[])this.transactionHandlers1.get();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CDOTransactionHandler2[] getTransactionHandlers2() {
        Object object = this.transactionHandlersLock;
        synchronized (object) {
            return (CDOTransactionHandler2[])this.transactionHandlers2.get();
        }
    }

    @Override
    public synchronized boolean isDirty() {
        if (this.isClosed()) {
            return false;
        }
        return this.dirty;
    }

    public void setDirty(boolean dirty) {
        this.dirty = dirty;
    }

    @Override
    public synchronized boolean hasConflict() {
        this.checkActive();
        return this.conflict != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setConflict(InternalCDOObject object) {
        ConflictEvent event = null;
        CDOTransactionImpl cDOTransactionImpl = this;
        synchronized (cDOTransactionImpl) {
            event = new ConflictEvent(object, this.conflict == 0);
            ++this.conflict;
        }
        this.fireEvent(event);
    }

    @Override
    public synchronized Set<CDOObject> getConflicts() {
        HashSet<CDOObject> conflicts = new HashSet<CDOObject>();
        for (CDOObject object : this.getDirtyObjects().values()) {
            if (!object.cdoConflict()) continue;
            conflicts.add(object);
        }
        for (CDOObject object : this.getDetachedObjects().values()) {
            if (!object.cdoConflict()) continue;
            conflicts.add(object);
        }
        return conflicts;
    }

    public synchronized CDOChangeSetData getChangeSetData() {
        this.checkActive();
        return this.lastSavepoint.getAllChangeSetData();
    }

    @Override
    public synchronized CDOChangeSetData merge(CDOBranchPoint source, CDOMerger merger) {
        return this.merge(source, null, merger);
    }

    @Override
    public synchronized CDOChangeSetData merge(CDOBranchPoint source, CDOBranchPoint sourceBase, CDOMerger merger) {
        if (this.isDirty()) {
            throw new IllegalStateException("Merging into dirty transactions not yet supported");
        }
        long now = this.getLastUpdateTime();
        CDOBranchPoint target = this.getBranch().getPoint(now);
        if (source.getTimeStamp() == 0L) {
            source = source.getBranch().getPoint(now);
        }
        if (CDOBranchUtil.isContainedBy((CDOBranchPoint)source, (CDOBranchPoint)target)) {
            throw new IllegalArgumentException("Source is already contained in " + target);
        }
        if (sourceBase != null && CDOBranchUtil.isContainedBy((CDOBranchPoint)sourceBase, (CDOBranchPoint)source)) {
            throw new IllegalArgumentException("Source base is not contained in " + source);
        }
        CDOBranchPoint ancestor = CDOBranchUtil.getAncestor((CDOBranchPoint)target, (CDOBranchPoint)source);
        InternalCDOSession session = this.getSession();
        CDORevisionAvailabilityInfo ancestorInfo = session.createRevisionAvailabilityInfo(ancestor);
        CDORevisionAvailabilityInfo targetInfo = session.createRevisionAvailabilityInfo(target);
        CDORevisionAvailabilityInfo sourceInfo = session.createRevisionAvailabilityInfo(source);
        CDORevisionAvailabilityInfo baseInfo = sourceBase != null ? session.createRevisionAvailabilityInfo(sourceBase) : null;
        CDOSessionProtocol sessionProtocol = session.getSessionProtocol();
        Set<CDOID> ids = sessionProtocol.loadMergeData(targetInfo, sourceInfo, ancestorInfo, baseInfo);
        session.cacheRevisions(targetInfo);
        session.cacheRevisions(sourceInfo);
        session.cacheRevisions(ancestorInfo);
        if (baseInfo != null) {
            session.cacheRevisions(baseInfo);
        } else {
            baseInfo = ancestorInfo;
        }
        CDOChangeSet targetChanges = this.createChangeSet(ids, ancestorInfo, targetInfo);
        CDOChangeSet sourceChanges = this.createChangeSet(ids, baseInfo, sourceInfo);
        CDOChangeSetData result = merger.merge(targetChanges, sourceChanges);
        if (result == null) {
            return null;
        }
        return this.applyChangeSet(result, (CDORevisionProvider)ancestorInfo, (CDORevisionProvider)targetInfo, source, false).getChangeSetData();
    }

    private CDOChangeSet createChangeSet(Set<CDOID> ids, CDORevisionAvailabilityInfo startInfo, CDORevisionAvailabilityInfo endInfo) {
        CDOChangeSetData data = CDORevisionUtil.createChangeSetData(ids, (CDORevisionProvider)startInfo, (CDORevisionProvider)endInfo);
        return CDORevisionUtil.createChangeSet((CDOBranchPoint)startInfo.getBranchPoint(), (CDOBranchPoint)endInfo.getBranchPoint(), (CDOChangeSetData)data);
    }

    @Override
    @Deprecated
    public Pair<CDOChangeSetData, Pair<Map<CDOID, CDOID>, List<CDOID>>> applyChangeSetData(CDOChangeSetData changeSetData, CDORevisionProvider ancestorProvider, CDORevisionProvider targetProvider, CDOBranchPoint source) {
        throw new UnsupportedOperationException();
    }

    @Override
    public synchronized InternalCDOTransaction.ApplyChangeSetResult applyChangeSet(CDOChangeSetData changeSetData, CDORevisionProvider ancestorProvider, CDORevisionProvider targetProvider, CDOBranchPoint source, boolean keepVersions) throws InternalCDOTransaction.ChangeSetOutdatedException {
        InternalCDOTransaction.ApplyChangeSetResult result = new InternalCDOTransaction.ApplyChangeSetResult();
        if (source != null && source.getBranch().isLocal()) {
            this.applyLocalIDMapping(changeSetData, result);
        }
        this.applyNewObjects(changeSetData.getNewObjects(), result.getChangeSetData().getNewObjects());
        Set<CDOObject> detachedSet = this.applyDetachedObjects(changeSetData.getDetachedObjects(), result.getChangeSetData().getDetachedObjects());
        Map<CDOID, InternalCDORevision> oldRevisions = this.applyChangedObjects(changeSetData.getChangedObjects(), ancestorProvider, targetProvider, keepVersions, result.getChangeSetData().getChangedObjects());
        Collection<CDORevisionDelta> notificationDeltas = this.lastSavepoint.getRevisionDeltas().values();
        if (!notificationDeltas.isEmpty() || !detachedSet.isEmpty()) {
            this.sendDeltaNotifications(notificationDeltas, detachedSet, oldRevisions);
        }
        return result;
    }

    private void applyLocalIDMapping(CDOChangeSetData changeSetData, InternalCDOTransaction.ApplyChangeSetResult result) {
        Map<CDOID, CDOID> idMappings = result.getIDMappings();
        for (CDOIDAndVersion key : changeSetData.getNewObjects()) {
            InternalCDORevision revision = (InternalCDORevision)key;
            if (!revision.getBranch().isLocal()) continue;
            CDOID oldID = revision.getID();
            CDOID newID = this.createIDForNewObject(null);
            idMappings.put(oldID, newID);
            revision.setID(newID);
            revision.setVersion(0);
        }
        if (!idMappings.isEmpty()) {
            CDOIDMapper idMapper = new CDOIDMapper(idMappings);
            idMapper.setAllowUnmappedTempIDs(true);
            for (CDOIDAndVersion key : changeSetData.getNewObjects()) {
                InternalCDORevision revision = (InternalCDORevision)key;
                revision.adjustReferences((CDOReferenceAdjuster)idMapper);
            }
            for (CDOIDAndVersion key : changeSetData.getChangedObjects()) {
                InternalCDORevisionDelta revisionDelta = (InternalCDORevisionDelta)key;
                if (!revisionDelta.adjustReferences((CDOReferenceAdjuster)idMapper)) continue;
                result.getAdjustedObjects().add(revisionDelta.getID());
            }
        }
    }

    private void applyNewObjects(List<CDOIDAndVersion> newObjects, List<CDOIDAndVersion> result) {
        for (CDOIDAndVersion key : newObjects) {
            InternalCDORevision revision = (InternalCDORevision)key;
            CDOID id = revision.getID();
            if (this.getObjectIfExists(id) != null) continue;
            InternalCDOObject object = this.newInstance(revision.getEClass());
            object.cdoInternalSetView(this);
            object.cdoInternalSetRevision((CDORevision)revision);
            object.cdoInternalSetID(id);
            object.cdoInternalSetState(CDOState.NEW);
            object.cdoInternalPostLoad();
            this.registerObject(object);
            this.registerAttached(object, true);
            result.add((CDOIDAndVersion)revision);
            this.dirty = true;
        }
    }

    private Set<CDOObject> applyDetachedObjects(List<CDOIDAndVersion> detachedObjects, List<CDOIDAndVersion> result) {
        HashSet<CDOObject> detachedSet = new HashSet<CDOObject>();
        for (CDOIDAndVersion key : detachedObjects) {
            CDOID id = key.getID();
            InternalCDOObject object = this.getObjectIfExists(id);
            if (object == null) continue;
            result.add(CDOIDUtil.createIDAndVersion((CDOID)id, (int)0));
            CDOStateMachine.INSTANCE.detach(object);
            detachedSet.add(object);
            this.dirty = true;
        }
        return detachedSet;
    }

    private Map<CDOID, InternalCDORevision> applyChangedObjects(List<CDORevisionKey> changedObjects, CDORevisionProvider ancestorProvider, CDORevisionProvider targetProvider, boolean keepVersions, List<CDORevisionKey> result) throws InternalCDOTransaction.ChangeSetOutdatedException {
        HashMap<CDOID, InternalCDORevision> oldRevisions = new HashMap<CDOID, InternalCDORevision>();
        Map<CDOID, CDOObject> dirtyObjects = this.lastSavepoint.getDirtyObjects();
        ConcurrentMap<CDOID, CDORevisionDelta> revisionDeltas = this.lastSavepoint.getRevisionDeltas();
        for (CDORevisionKey key : changedObjects) {
            InternalCDORevisionDelta ancestorGoalDelta = (InternalCDORevisionDelta)key;
            ancestorGoalDelta.setTarget(null);
            CDOID id = ancestorGoalDelta.getID();
            InternalCDORevision ancestorRevision = (InternalCDORevision)ancestorProvider.getRevision(id);
            InternalCDOObject object = this.getObject(id);
            boolean revisionChanged = false;
            InternalCDORevision targetRevision = object.cdoRevision();
            if (targetRevision == null) {
                targetRevision = (InternalCDORevision)targetProvider.getRevision(id);
                object.cdoInternalSetRevision((CDORevision)targetRevision);
                revisionChanged = true;
            }
            oldRevisions.put(id, targetRevision);
            InternalCDORevision goalRevision = ancestorRevision.copy();
            goalRevision.setBranchPoint((CDOBranchPoint)this);
            if (!keepVersions) {
                goalRevision.setVersion(targetRevision.getVersion());
            }
            goalRevision.setRevised(0L);
            ancestorGoalDelta.apply((CDORevision)goalRevision);
            InternalCDORevisionDelta targetGoalDelta = goalRevision.compare((CDORevision)targetRevision);
            targetGoalDelta.setTarget(null);
            if (!targetGoalDelta.isEmpty()) {
                if (keepVersions && targetGoalDelta.getVersion() != ancestorRevision.getVersion()) {
                    throw new InternalCDOTransaction.ChangeSetOutdatedException();
                }
                revisionDeltas.put(id, (CDORevisionDelta)targetGoalDelta);
                result.add((CDORevisionKey)targetGoalDelta);
                if (this.lastSavepoint.getDetachedObjects().containsKey(id)) {
                    CDOStateMachine.INSTANCE.attach(object, this);
                }
                object.cdoInternalSetState(CDOState.DIRTY);
                object.cdoInternalSetRevision((CDORevision)goalRevision);
                revisionChanged = true;
                dirtyObjects.put(id, object);
                this.dirty = true;
            }
            if (!revisionChanged) continue;
            object.cdoInternalPostLoad();
        }
        return oldRevisions;
    }

    private InternalCDOObject getObjectIfExists(CDOID id) {
        try {
            return this.getObject(id);
        }
        catch (ObjectNotFoundException ex) {
            return null;
        }
    }

    /*
     * Unable to fully structure code
     */
    @Override
    protected synchronized void handleConflicts(Map<CDOObject, Pair<CDORevision, CDORevisionDelta>> conflicts, List<CDORevisionDelta> deltas) {
        block9: {
            resolvers = this.options().getConflictResolvers();
            if (resolvers.length == 0) {
                return;
            }
            states = new ArrayList<CDOState>(conflicts.size());
            revisions = new ArrayList<CDORevision>(conflicts.size());
            for (CDOObject conflict : conflicts.keySet()) {
                states.add(conflict.cdoState());
                revisions.add(conflict.cdoRevision());
            }
            resolved = 0;
            try {
                remaining = new HashMap<CDOObject, Pair<CDORevision, CDORevisionDelta>>(conflicts);
                var11_10 = resolvers;
                var10_12 = resolvers.length;
                var9_14 = 0;
                while (var9_14 < var10_12) {
                    resolver = var11_10[var9_14];
                    if (resolver instanceof CDOConflictResolver2) {
                        ((CDOConflictResolver2)resolver).resolveConflicts(Collections.unmodifiableMap(remaining), deltas);
                    } else {
                        resolver.resolveConflicts(Collections.unmodifiableSet(remaining.keySet()));
                    }
                    it = remaining.keySet().iterator();
                    while (it.hasNext()) {
                        object = (CDOObject)it.next();
                        if (object.cdoConflict()) continue;
                        ++resolved;
                        it.remove();
                    }
                    ++var9_14;
                }
                break block9;
            }
            catch (Exception ex) {
                state = states.iterator();
                revision = revisions.iterator();
                ** for (object : conflicts.keySet())
            }
lbl-1000:
            // 1 sources

            {
                ((InternalCDOObject)object).cdoInternalSetState((CDOState)state.next());
                ((InternalCDOObject)object).cdoInternalSetRevision((CDORevision)revision.next());
                continue;
            }
lbl42:
            // 1 sources

            throw WrappedException.wrap((Exception)ex);
        }
        this.conflict -= resolved;
    }

    @Override
    @Deprecated
    public synchronized CDOIDTemp getNextTemporaryID() {
        throw new UnsupportedOperationException();
    }

    @Override
    public CDOID createIDForNewObject(EObject object) {
        return this.idGenerator.generateCDOID(object);
    }

    @Override
    public synchronized CDOResourceFolder createResourceFolder(String path) {
        if (path.endsWith(CDOURIUtil.SEGMENT_SEPARATOR)) {
            path = path.substring(0, path.length() - 1);
        }
        CDOResourceFolder folder = EresourceFactory.eINSTANCE.createCDOResourceFolder();
        int pos = path.lastIndexOf(47);
        if (pos <= 0) {
            String name = path.substring(pos == 0 ? 1 : 0);
            folder.setName(name);
            this.getRootResource().getContents().add((Object)folder);
        } else {
            String name = path.substring(pos + 1);
            folder.setName(name);
            path = path.substring(0, pos);
            CDOResourceNode parent = null;
            try {
                parent = this.getResourceNode(path);
            }
            catch (Exception ex) {
                parent = this.createResourceFolder(path);
            }
            if (parent instanceof CDOResourceFolder) {
                ((CDOResourceFolder)parent).getNodes().add((Object)folder);
            } else {
                throw new CDOException("Parent is not a folder: " + parent);
            }
        }
        return folder;
    }

    @Override
    public synchronized CDOResource createResource(String path) {
        this.checkActive();
        URI uri = CDOURIUtil.createResourceURI(this, path);
        return (CDOResource)this.getResourceSet().createResource(uri);
    }

    @Override
    public synchronized CDOResource getOrCreateResource(String path) {
        this.checkActive();
        try {
            CDOID id = this.getResourceNodeID(path);
            if (!CDOIDUtil.isNull((CDOID)id)) {
                return (CDOResource)((Object)this.getObject(id));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.createResource(path);
    }

    @Override
    public synchronized void attachResource(CDOResourceImpl resource) {
        if (resource.isExisting()) {
            super.attachResource(resource);
        } else {
            this.attachNewResource(resource);
        }
    }

    private void attachNewResource(CDOResourceImpl resource) {
        URI uri = resource.getURI();
        List<String> names = CDOURIUtil.analyzePath(uri);
        String resourceName = names.isEmpty() ? null : names.remove(names.size() - 1);
        CDOResourceFolder folder = this.getOrCreateResourceFolder(names);
        this.attachNewResourceNode(folder, resourceName, resource);
    }

    @Override
    public synchronized CDOResourceFolder getOrCreateResourceFolder(String path) {
        this.checkActive();
        try {
            CDOID id = this.getResourceNodeID(path);
            if (!CDOIDUtil.isNull((CDOID)id)) {
                return (CDOResourceFolder)((Object)this.getObject(id));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.createResourceFolder(path);
    }

    @Override
    public synchronized CDOResourceFolder getOrCreateResourceFolder(List<String> names) {
        CDOObject folder = null;
        for (String name : names) {
            CDOResourceNode node;
            try {
                CDOID folderID = folder == null ? null : folder.cdoID();
                node = this.getResourceNode(folderID, name);
            }
            catch (CDOException ex) {
                node = EresourceFactory.eINSTANCE.createCDOResourceFolder();
                this.attachNewResourceNode((CDOResourceFolder)folder, name, node);
            }
            if (node instanceof CDOResourceFolder) {
                folder = node;
                continue;
            }
            throw new CDOException(MessageFormat.format(Messages.getString("CDOTransactionImpl.0"), node));
        }
        return folder;
    }

    private void attachNewResourceNode(CDOResourceFolder folder, String name, CDOResourceNode newNode) {
        CDOResourceNodeImpl node = (CDOResourceNodeImpl)newNode;
        node.basicSetName(name, false);
        if (folder == null) {
            if (node.isRoot()) {
                CDOStateMachine.INSTANCE.attach(node, this);
            } else {
                this.getRootResource().getContents().add((Object)node);
            }
        } else {
            node.basicSetFolder(folder, false);
        }
    }

    public synchronized void detach(CDOResourceImpl cdoResource) {
        CDOStateMachine.INSTANCE.detach(cdoResource);
    }

    @Override
    public InternalCDOSavepoint getFirstSavepoint() {
        return this.firstSavepoint;
    }

    @Override
    public synchronized InternalCDOSavepoint getLastSavepoint() {
        this.checkActive();
        return this.lastSavepoint;
    }

    @Override
    public synchronized CDOTransactionStrategy getTransactionStrategy() {
        if (this.transactionStrategy == null) {
            this.transactionStrategy = CDOTransactionStrategy.DEFAULT;
            this.transactionStrategy.setTarget(this);
        }
        return this.transactionStrategy;
    }

    @Override
    public synchronized void setTransactionStrategy(CDOTransactionStrategy transactionStrategy) {
        if (this.transactionStrategy != null) {
            this.transactionStrategy.unsetTarget(this);
        }
        this.transactionStrategy = transactionStrategy;
        if (this.transactionStrategy != null) {
            this.transactionStrategy.setTarget(this);
        }
    }

    @Override
    protected synchronized CDOID getRootOrTopLevelResourceNodeID(String name) {
        if (this.dirty) {
            CDOResourceNode node = this.getRootResourceNode(name, this.getDirtyObjects().values());
            if (node != null) {
                return node.cdoID();
            }
            node = this.getRootResourceNode(name, this.getNewObjects().values());
            if (node != null) {
                return node.cdoID();
            }
        }
        CDOID id = super.getRootOrTopLevelResourceNodeID(name);
        if (this.getLastSavepoint().getAllDetachedObjects().containsKey(id) || this.getDirtyObjects().containsKey(id)) {
            throw new CDOException(MessageFormat.format(Messages.getString("CDOTransactionImpl.1"), name));
        }
        return id;
    }

    private CDOResourceNode getRootResourceNode(String name, Collection<? extends CDOObject> objects) {
        for (CDOObject cDOObject : objects) {
            CDOResourceNode node;
            if (!(cDOObject instanceof CDOResourceNode) || (node = (CDOResourceNode)cDOObject).getFolder() != null || !ObjectUtil.equals((Object)name, (Object)node.getName())) continue;
            return node;
        }
        return null;
    }

    @Override
    public synchronized InternalCDOObject getObject(CDOID id, boolean loadOnDemand) {
        this.checkActive();
        if (CDOIDUtil.isNull((CDOID)id)) {
            return null;
        }
        if (this.isObjectNew(id) && this.isObjectDetached(id)) {
            throw new ObjectNotFoundException(id, (CDOBranchPoint)this);
        }
        return super.getObject(id, loadOnDemand);
    }

    @Override
    public boolean isObjectNew(CDOID id) {
        return this.lastSavepoint.isNewObject(id);
    }

    private boolean isObjectDetached(CDOID id) {
        return this.lastSavepoint.getAllDetachedObjects().containsKey(id);
    }

    @Override
    public synchronized InternalCDOTransaction.InternalCDOCommitContext createCommitContext() {
        return new CDOCommitContextImpl(this);
    }

    @Override
    public synchronized CDOCommitInfo commit(IProgressMonitor progressMonitor) throws CommitException {
        try {
            CDOTransactionStrategy transactionStrategy;
            CDOCommitInfo info;
            this.checkActive();
            if (this.hasConflict()) {
                throw new CommitException(Messages.getString("CDOTransactionImpl.2"));
            }
            if (progressMonitor == null) {
                progressMonitor = new NullProgressMonitor();
            }
            if ((info = (transactionStrategy = this.getTransactionStrategy()).commit(this, progressMonitor)) != null) {
                this.lastCommitTime = info.getTimeStamp();
            }
            return info;
        }
        catch (CommitException ex) {
            throw ex;
        }
        catch (Throwable t) {
            throw new CommitException(t);
        }
    }

    @Override
    public synchronized CDOCommitInfo commit() throws CommitException {
        return this.commit(null);
    }

    @Override
    public synchronized void rollback() {
        this.checkActive();
        CDOTransactionStrategy strategy = this.getTransactionStrategy();
        strategy.rollback(this, this.firstSavepoint);
        this.cleanUp(null);
    }

    private void removeObject(CDOID id, final CDOObject object) {
        InternalCDOObject internal = (InternalCDOObject)object;
        internal.cdoInternalSetState(CDOState.TRANSIENT);
        this.removeObject(id);
        if (object instanceof CDOResource) {
            InternalCDOViewSet viewSet = this.getViewSet();
            viewSet.executeWithoutNotificationHandling(new Callable<Boolean>(){

                @Override
                public Boolean call() throws Exception {
                    EList resources = CDOTransactionImpl.this.getResourceSet().getResources();
                    resources.remove((Object)object);
                    return true;
                }
            });
        }
        internal.cdoInternalSetID(null);
        internal.cdoInternalSetRevision(null);
        internal.cdoInternalSetView(null);
    }

    private Set<CDOID> rollbackCompletely(CDOUserSavepoint savepoint) {
        HashSet<CDOID> idsOfNewObjectsWithDeltas = new HashSet<CDOID>();
        InternalCDOSavepoint itrSavepoint = this.lastSavepoint;
        while (itrSavepoint != null) {
            CDOID id;
            Map<CDOID, CDOObject> detachedObjectsMap;
            HashSet<Object> toBeDetached = new HashSet<Object>();
            Map<CDOID, CDOObject> newObjectsMap = itrSavepoint.getNewObjects();
            for (CDOID id2 : newObjectsMap.keySet()) {
                CDOObject cDOObject = newObjectsMap.get(id2);
                toBeDetached.add(id2);
                toBeDetached.add(cDOObject);
                toBeDetached.add(((InternalCDOObject)cDOObject).cdoInternalInstance());
                this.removeObject(id2, cDOObject);
            }
            Map<CDOID, CDOObject> reattachedObjectsMap = itrSavepoint.getReattachedObjects();
            Set<CDOID> detachedIDs = itrSavepoint.getDetachedObjects().keySet();
            for (CDOObject cDOObject : reattachedObjectsMap.values()) {
                CDOID id3 = cDOObject.cdoID();
                if (detachedIDs.contains(id3)) continue;
                toBeDetached.add(id3);
                toBeDetached.add(cDOObject);
                toBeDetached.add(((InternalCDOObject)cDOObject).cdoInternalInstance());
                this.removeObject(id3, cDOObject);
            }
            for (CDOObject cDOObject : toBeDetached) {
                EObject container;
                Resource.Internal directResource;
                if (cDOObject instanceof CDOObjectImpl) {
                    CDOObjectImpl impl = (CDOObjectImpl)cDOObject;
                    directResource = impl.eDirectResource();
                    container = impl.eContainer();
                    if (toBeDetached.contains(directResource) || toBeDetached.contains(container)) continue;
                    impl.cdoInternalSetResource(null);
                    continue;
                }
                if (!(cDOObject instanceof CDOObjectWrapper)) continue;
                CDOObjectWrapper wrapper = (CDOObjectWrapper)cDOObject;
                directResource = wrapper.eDirectResource();
                container = wrapper.eContainer();
                if (toBeDetached.contains(directResource) || toBeDetached.contains(container)) continue;
                wrapper.setInstanceResource(null);
                wrapper.setInstanceContainer(null, 0);
            }
            ConcurrentMap<CDOID, CDORevisionDelta> concurrentMap = itrSavepoint.getRevisionDeltas();
            if (!concurrentMap.isEmpty()) {
                for (CDORevisionDelta dirtyObject : concurrentMap.values()) {
                    CDOID id4 = dirtyObject.getID();
                    if (!this.isObjectNew(id4)) continue;
                    idsOfNewObjectsWithDeltas.add(id4);
                }
            }
            if (!(detachedObjectsMap = itrSavepoint.getDetachedObjects()).isEmpty()) {
                for (Map.Entry<CDOID, CDOObject> detachedObjectEntry : detachedObjectsMap.entrySet()) {
                    id = detachedObjectEntry.getKey();
                    if (this.isObjectNew(id)) {
                        idsOfNewObjectsWithDeltas.add(id);
                        continue;
                    }
                    InternalCDOObject detachedObject = (InternalCDOObject)detachedObjectEntry.getValue();
                    InternalCDORevision cleanRev = this.cleanRevisions.get(detachedObject);
                    this.cleanObject(detachedObject, cleanRev);
                }
            }
            for (Map.Entry<CDOID, CDOObject> entryDirtyObject : itrSavepoint.getDirtyObjects().entrySet()) {
                id = entryDirtyObject.getKey();
                if (this.isObjectNew(id)) continue;
                InternalCDOObject internalDirtyObject = (InternalCDOObject)entryDirtyObject.getValue();
                if (reattachedObjectsMap.values().contains(internalDirtyObject)) continue;
                CDOStateMachine.INSTANCE.rollback(internalDirtyObject);
            }
            if (savepoint == itrSavepoint) break;
            itrSavepoint = itrSavepoint.getPreviousSavepoint();
        }
        return idsOfNewObjectsWithDeltas;
    }

    private void loadSavepoint(CDOSavepoint savepoint, Set<CDOID> idsOfNewObjectWithDeltas) {
        InternalCDOObject object;
        Map<CDOID, CDOObject> dirtyObjects = this.getDirtyObjects();
        Map<CDOID, CDOObject> newObjMaps = this.getNewObjects();
        Map<CDOID, CDORevision> newBaseRevision = this.getBaseNewObjects();
        Map<CDOID, CDOObject> detachedObjects = this.getDetachedObjects();
        for (CDOID cDOID : idsOfNewObjectWithDeltas) {
            if (detachedObjects.containsKey(cDOID)) continue;
            object = (InternalCDOObject)newObjMaps.get(cDOID);
            CDORevision revision = newBaseRevision.get(cDOID);
            if (revision == null) continue;
            object.cdoInternalSetRevision(revision.copy());
            object.cdoInternalSetView(this);
            object.cdoInternalSetID(revision.getID());
            object.cdoInternalSetState(CDOState.NEW);
            object.cdoInternalPostLoad();
            if (super.getObject(object.cdoID(), false) != null) continue;
            this.registerObject(object);
        }
        for (Map.Entry entry : newObjMaps.entrySet()) {
            object = (InternalCDOObject)entry.getValue();
            this.cleanObject(object, object.cdoRevision());
            object.cdoInternalSetState(CDOState.NEW);
        }
        for (Map.Entry entry : dirtyObjects.entrySet()) {
            if (detachedObjects.containsKey(entry.getKey())) continue;
            InternalCDOObject internalDirtyObject = (InternalCDOObject)entry.getValue();
            this.cleanObject(internalDirtyObject, this.getRevision((CDOID)entry.getKey(), true));
        }
        CDOObjectMerger cDOObjectMerger = new CDOObjectMerger();
        InternalCDOSavepoint itrSavepoint = this.firstSavepoint;
        while (itrSavepoint != savepoint) {
            for (CDORevisionDelta delta : itrSavepoint.getRevisionDeltas().values()) {
                CDOID id = delta.getID();
                boolean isNew = this.isObjectNew(id);
                if (isNew && !idsOfNewObjectWithDeltas.contains(id) || detachedObjects.containsKey(id)) continue;
                Map<CDOID, CDOObject> map = isNew ? newObjMaps : dirtyObjects;
                InternalCDOObject object2 = (InternalCDOObject)map.get(id);
                cDOObjectMerger.merge(object2, delta);
                object2.cdoInternalPostLoad();
            }
            itrSavepoint = itrSavepoint.getNextSavepoint();
        }
        this.dirty = savepoint.wasDirty();
    }

    @Override
    public synchronized void detachObject(InternalCDOObject object) {
        CDOTransactionHandler1[] handlers = this.getTransactionHandlers1();
        int i = 0;
        while (i < handlers.length) {
            CDOTransactionHandler1 handler = handlers[i];
            handler.detachingObject(this, object);
            ++i;
        }
        CDOID id = object.cdoID();
        if (object.cdoState() == CDOState.NEW) {
            Map<CDOID, CDOObject> map = this.getLastSavepoint().getNewObjects();
            if (map.containsKey(id)) {
                map.remove(id);
            } else {
                this.getLastSavepoint().getDetachedObjects().put(id, object);
            }
            this.deregisterObject(object);
        } else {
            this.getLastSavepoint().getDetachedObjects().put(id, object);
            if (!this.cleanRevisions.containsKey(object)) {
                this.cleanRevisions.put(object, object.cdoRevision());
            }
            this.lastSavepoint.getReattachedObjects().remove(id);
        }
        if (!this.dirty) {
            this.dirty = true;
            IListener[] listeners = this.getListeners();
            if (listeners != null) {
                this.fireEvent(new StartedEvent(), listeners);
            }
        }
    }

    @Override
    public synchronized void handleRollback(InternalCDOSavepoint savepoint) {
        if (savepoint == null) {
            throw new IllegalArgumentException(Messages.getString("CDOTransactionImpl.3"));
        }
        if (savepoint.getTransaction() != this) {
            throw new IllegalArgumentException(MessageFormat.format(Messages.getString("CDOTransactionImpl.4"), savepoint));
        }
        if (!savepoint.isValid()) {
            throw new IllegalArgumentException(MessageFormat.format(Messages.getString("CDOTransactionImpl.6"), savepoint));
        }
        if (TRACER.isEnabled()) {
            TRACER.trace("handleRollback()");
        }
        try {
            HashMap<CDOObject, CDORevision> oldRevisions = new HashMap<CDOObject, CDORevision>();
            for (CDOObject object : this.getDirtyObjects().values()) {
                CDORevision oldRevision = object.cdoRevision();
                if (oldRevision == null) continue;
                oldRevisions.put(object, oldRevision);
            }
            Set<CDOID> idsOfNewObjectWithDeltas = this.rollbackCompletely(savepoint);
            this.lastSavepoint = savepoint;
            this.lastSavepoint.setNextSavepoint(null);
            this.lastSavepoint.clear();
            this.loadSavepoint(this.lastSavepoint, idsOfNewObjectWithDeltas);
            if (this.lastSavepoint == this.firstSavepoint && this.options().isAutoReleaseLocksEnabled()) {
                CDORepositoryInfo cDORepositoryInfo = this.getSession().getRepositoryInfo();
                if (this.isDurableView() && cDORepositoryInfo.getState() == CDOCommonRepository.State.ONLINE || cDORepositoryInfo.getType() == CDOCommonRepository.Type.MASTER) {
                    this.unlockObjects(null, null);
                }
            }
            for (Map.Entry entry : oldRevisions.entrySet()) {
                Set<CDOObject> detachedObjects;
                CDONotificationBuilder builder;
                NotificationChain notification;
                InternalCDORevisionDelta delta;
                InternalCDOObject object = (InternalCDOObject)entry.getKey();
                if (FSMUtil.isTransient(object)) continue;
                InternalCDORevision oldRevision = (InternalCDORevision)entry.getValue();
                InternalCDORevision newRevision = object.cdoRevision();
                if (newRevision == null) {
                    newRevision = this.getRevision(oldRevision.getID(), true);
                    object.cdoInternalSetRevision((CDORevision)newRevision);
                    object.cdoInternalSetState(CDOState.CLEAN);
                }
                if (newRevision == null || (delta = newRevision.compare((CDORevision)oldRevision)).isEmpty() || (notification = (builder = new CDONotificationBuilder(this)).buildNotification(object, oldRevision, (CDORevisionDelta)delta, detachedObjects = Collections.emptySet())) == null) continue;
                notification.dispatch();
            }
            Map map = Collections.emptyMap();
            IListener[] listeners = this.getListeners();
            if (listeners != null) {
                this.fireEvent(new FinishedEvent(CDOTransactionFinishedEvent.Type.ROLLED_BACK, map), listeners);
            }
            CDOTransactionHandler2[] handlers = this.getTransactionHandlers2();
            int i = 0;
            while (i < handlers.length) {
                CDOTransactionHandler2 handler = handlers[i];
                try {
                    handler.rolledBackTransaction(this);
                }
                catch (RuntimeException ex) {
                    OM.LOG.error((Throwable)ex);
                }
                ++i;
            }
        }
        catch (RuntimeException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new TransactionException((Throwable)ex);
        }
    }

    @Override
    public synchronized InternalCDOSavepoint handleSetSavepoint() {
        this.addToBase(this.lastSavepoint.getNewObjects());
        this.lastSavepoint = this.createSavepoint(this.lastSavepoint);
        return this.lastSavepoint;
    }

    private CDOSavepointImpl createSavepoint(InternalCDOSavepoint lastSavepoint) {
        return new CDOSavepointImpl(this, lastSavepoint);
    }

    @Override
    public synchronized InternalCDOSavepoint setSavepoint() {
        this.checkActive();
        return (InternalCDOSavepoint)this.getTransactionStrategy().setSavepoint(this);
    }

    private void addToBase(Map<CDOID, CDOObject> objects) {
        for (CDOObject object : objects.values()) {
            ((InternalCDOObject)object).cdoInternalPreCommit();
            this.lastSavepoint.getBaseNewObjects().put(object.cdoID(), object.cdoRevision().copy());
        }
    }

    @Override
    protected String getClassName() {
        return "CDOTransaction";
    }

    @Override
    public synchronized void registerAttached(InternalCDOObject object, boolean isNew) {
        if (TRACER.isEnabled()) {
            TRACER.format("Registering new object {0}", new Object[]{object});
        }
        if (isNew) {
            this.registerNewPackage(object.eClass().getEPackage());
        }
        CDOTransactionHandler1[] handlers = this.getTransactionHandlers1();
        int i = 0;
        while (i < handlers.length) {
            CDOTransactionHandler1 handler = handlers[i];
            handler.attachingObject(this, object);
            ++i;
        }
        if (isNew) {
            this.registerNew(this.lastSavepoint.getNewObjects(), object);
        }
    }

    private void registerNewPackage(EPackage ePackage) {
        InternalCDOPackageRegistry packageRegistry = this.getSession().getPackageRegistry();
        if (!packageRegistry.containsKey((Object)ePackage.getNsURI())) {
            packageRegistry.putEPackage(ePackage);
        }
    }

    @Override
    public synchronized void registerFeatureDelta(InternalCDOObject object, CDOFeatureDelta featureDelta) {
        CDOID id = object.cdoID();
        boolean needToSaveFeatureDelta = true;
        if (object.cdoState() == CDOState.NEW) {
            if (this.getLastSavepoint().getPreviousSavepoint() == null || featureDelta == null) {
                needToSaveFeatureDelta = false;
            } else {
                Map<CDOID, CDOObject> map = this.getLastSavepoint().getNewObjects();
                boolean bl = needToSaveFeatureDelta = !map.containsKey(id);
            }
        }
        if (needToSaveFeatureDelta) {
            CDORevisionDelta revisionDelta = (CDORevisionDelta)this.lastSavepoint.getRevisionDeltas().get(id);
            if (revisionDelta == null) {
                revisionDelta = CDORevisionUtil.createDelta((CDORevision)object.cdoRevision());
                this.lastSavepoint.getRevisionDeltas().put(id, revisionDelta);
            }
            ((InternalCDORevisionDelta)revisionDelta).addFeatureDelta(featureDelta);
        }
        CDOTransactionHandler1[] handlers = this.getTransactionHandlers1();
        int i = 0;
        while (i < handlers.length) {
            CDOTransactionHandler1 handler = handlers[i];
            handler.modifyingObject(this, object, featureDelta);
            ++i;
        }
    }

    @Override
    public synchronized void registerRevisionDelta(CDORevisionDelta revisionDelta) {
        this.lastSavepoint.getRevisionDeltas().putIfAbsent(revisionDelta.getID(), revisionDelta);
    }

    @Override
    public synchronized void registerDirty(InternalCDOObject object, CDOFeatureDelta featureDelta) {
        if (TRACER.isEnabled()) {
            TRACER.format("Registering dirty object {0}", new Object[]{object});
        }
        if (featureDelta != null) {
            this.registerFeatureDelta(object, featureDelta);
        }
        this.registerNew(this.lastSavepoint.getDirtyObjects(), object);
    }

    private void registerNew(Map map, InternalCDOObject object) {
        InternalCDOObject old = map.put(object.cdoID(), object);
        if (old != null) {
            throw new IllegalStateException(MessageFormat.format(Messages.getString("CDOTransactionImpl.10"), object));
        }
        if (!this.dirty) {
            this.dirty = true;
            IListener[] listeners = this.getListeners();
            if (listeners != null) {
                this.fireEvent(new StartedEvent(), listeners);
            }
        }
    }

    public synchronized List<CDOPackageUnit> analyzeNewPackages() {
        InternalCDOPackageRegistry packageRegistry = this.getSession().getPackageRegistry();
        HashSet<EPackage> usedPackages = new HashSet<EPackage>();
        HashSet<EPackage> usedNewPackages = new HashSet<EPackage>();
        for (CDOObject object : this.getNewObjects().values()) {
            CDOPackageUnit packageUnit;
            EPackage topLevelPackage;
            EPackage ePackage = object.eClass().getEPackage();
            if (!usedPackages.add(ePackage) || ePackage != (topLevelPackage = EMFUtil.getTopLevelPackage((EPackage)ePackage)) && !usedPackages.add(topLevelPackage) || (packageUnit = packageRegistry.getPackageUnit(topLevelPackage)).getState() != CDOPackageUnit.State.NEW) continue;
            usedNewPackages.add(topLevelPackage);
        }
        if (usedNewPackages.size() > 0) {
            HashSet<CDOPackageUnit> result = new HashSet<CDOPackageUnit>();
            for (EPackage usedNewPackage : CDOTransactionImpl.analyzeNewPackages(usedNewPackages, (CDOPackageRegistry)packageRegistry)) {
                CDOPackageUnit packageUnit = packageRegistry.getPackageUnit(usedNewPackage);
                result.add(packageUnit);
            }
            return new ArrayList<CDOPackageUnit>(result);
        }
        return Collections.emptyList();
    }

    private static List<EPackage> analyzeNewPackages(Collection<EPackage> usedTopLevelPackages, CDOPackageRegistry packageRegistry) {
        ArrayList<EPackage> newPackages = new ArrayList<EPackage>();
        CompletePackageClosure closure = new CompletePackageClosure();
        usedTopLevelPackages = closure.calculate(usedTopLevelPackages);
        for (EPackage usedPackage : usedTopLevelPackages) {
            CDOPackageUnit packageUnit = packageRegistry.getPackageUnit(usedPackage);
            if (packageUnit == null) {
                throw new CDOException(MessageFormat.format(Messages.getString("CDOTransactionImpl.11"), usedPackage));
            }
            if (packageUnit.getState() != CDOPackageUnit.State.NEW) continue;
            newPackages.add(usedPackage);
        }
        return newPackages;
    }

    private void cleanUp(CDOCommitContext commitContext) {
        if (commitContext == null || !commitContext.isPartialCommit()) {
            this.lastSavepoint = this.firstSavepoint;
            this.firstSavepoint.clear();
            this.firstSavepoint.setNextSavepoint(null);
            this.cleanRevisions.clear();
            this.dirty = false;
            this.conflict = 0;
            this.idGenerator.reset();
        } else {
            this.collapseSavepoints(commitContext);
            for (CDOObject object : commitContext.getDetachedObjects().values()) {
                this.cleanRevisions.remove(object);
            }
            for (CDOObject object : commitContext.getDirtyObjects().values()) {
                this.cleanRevisions.remove(object);
            }
        }
        this.committables = null;
    }

    private void collapseSavepoints(CDOCommitContext commitContext) {
        CDOSavepointImpl newSavepoint = this.createSavepoint(null);
        this.copyUncommitted(this.lastSavepoint.getAllNewObjects(), commitContext.getNewObjects(), newSavepoint.getNewObjects());
        this.copyUncommitted(this.lastSavepoint.getAllDirtyObjects(), commitContext.getDirtyObjects(), newSavepoint.getDirtyObjects());
        this.copyUncommitted(this.lastSavepoint.getAllRevisionDeltas(), commitContext.getRevisionDeltas(), newSavepoint.getRevisionDeltas());
        this.copyUncommitted(this.lastSavepoint.getAllDetachedObjects(), commitContext.getDetachedObjects(), newSavepoint.getDetachedObjects());
        this.firstSavepoint = this.lastSavepoint = newSavepoint;
    }

    private <T> void copyUncommitted(Map<CDOID, T> oldSavepointMap, Map<CDOID, T> commitContextMap, Map<CDOID, T> newSavepointMap) {
        for (Map.Entry<CDOID, T> entry : oldSavepointMap.entrySet()) {
            if (commitContextMap.containsKey(entry.getKey())) continue;
            newSavepointMap.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public synchronized CDOSavepoint[] exportChanges(OutputStream stream) throws IOException {
        Collection<CDOObject> newObjects;
        CDODataOutputImpl out = new CDODataOutputImpl((ExtendedDataOutput)new ExtendedDataOutputStream(stream)){

            public CDOIDProvider getIDProvider() {
                return CDOTransactionImpl.this;
            }

            public CDOPackageRegistry getPackageRegistry() {
                return CDOTransactionImpl.this.getSession().getPackageRegistry();
            }
        };
        ArrayList<InternalCDOSavepoint> savepoints = new ArrayList<InternalCDOSavepoint>();
        int totalNewObjects = 0;
        InternalCDOSavepoint savepoint = this.firstSavepoint;
        while (savepoint != null) {
            newObjects = savepoint.getNewObjects().values();
            totalNewObjects += newObjects.size();
            savepoint = savepoint.getNextSavepoint();
        }
        out.writeInt(totalNewObjects);
        savepoint = this.firstSavepoint;
        while (savepoint != null) {
            newObjects = savepoint.getNewObjects().values();
            Collection revisionDeltas = savepoint.getRevisionDeltas().values();
            if (newObjects.isEmpty() && revisionDeltas.isEmpty()) {
                savepoint = savepoint.getNextSavepoint();
                continue;
            }
            savepoints.add(savepoint);
            out.writeBoolean(true);
            out.writeInt(newObjects.size());
            for (CDOObject newObject : newObjects) {
                out.writeCDORevision(newObject.cdoRevision(), -1);
            }
            out.writeInt(revisionDeltas.size());
            for (CDORevisionDelta revisionDelta : revisionDeltas) {
                out.writeCDORevisionDelta(revisionDelta);
            }
            savepoint = savepoint.getNextSavepoint();
        }
        out.writeBoolean(false);
        return savepoints.toArray(new CDOSavepoint[savepoints.size()]);
    }

    @Override
    public synchronized CDOSavepoint[] importChanges(InputStream stream, boolean reconstructSavepoints) throws IOException {
        ArrayList<InternalCDOSavepoint> savepoints = new ArrayList<InternalCDOSavepoint>();
        if (stream.available() > 0) {
            CDODataInputImpl in = new CDODataInputImpl((ExtendedDataInput)new ExtendedDataInputStream(stream)){

                protected CDOPackageRegistry getPackageRegistry() {
                    return CDOTransactionImpl.this.getSession().getPackageRegistry();
                }

                protected CDOBranchManager getBranchManager() {
                    return CDOTransactionImpl.this.getSession().getBranchManager();
                }

                protected CDOCommitInfoManager getCommitInfoManager() {
                    return CDOTransactionImpl.this.getSession().getCommitInfoManager();
                }

                protected CDORevisionFactory getRevisionFactory() {
                    return CDOTransactionImpl.this.getSession().getRevisionManager().getFactory();
                }

                protected CDOLobStore getLobStore() {
                    return CDOTransactionImpl.this.getSession().getLobStore();
                }

                protected CDOListFactory getListFactory() {
                    return CDOListWithElementProxiesImpl.FACTORY;
                }
            };
            int totalNewObjects = in.readInt();
            int i = 0;
            while (i < totalNewObjects) {
                this.createIDForNewObject(null);
                ++i;
            }
            HashMap<CDOID, CDOID> idMappings = new HashMap<CDOID, CDOID>();
            while (in.readBoolean()) {
                if (reconstructSavepoints) {
                    InternalCDOSavepoint savepoint = this.setSavepoint();
                    savepoints.add(savepoint);
                }
                ArrayList<InternalCDORevision> revisions = new ArrayList<InternalCDORevision>();
                this.importNewRevisions((CDODataInput)in, revisions, idMappings);
                List<InternalCDORevisionDelta> revisionDeltas = this.importRevisionDeltas((CDODataInput)in);
                CDOIDMapper idMapper = new CDOIDMapper(idMappings);
                for (InternalCDORevision revision : revisions) {
                    revision.adjustReferences((CDOReferenceAdjuster)idMapper);
                }
                for (InternalCDORevisionDelta delta : revisionDeltas) {
                    delta.adjustReferences((CDOReferenceAdjuster)idMapper);
                }
                ArrayList<InternalCDOObject> newObjects = new ArrayList<InternalCDOObject>();
                for (InternalCDORevision revision : revisions) {
                    InternalCDOObject object = this.newInstance(revision);
                    this.registerObject(object);
                    this.registerAttached(object, true);
                    newObjects.add(object);
                }
                for (InternalCDOObject object : newObjects) {
                    object.cdoInternalPostLoad();
                }
                CDOObjectMerger merger = new CDOObjectMerger();
                for (InternalCDORevisionDelta delta : revisionDeltas) {
                    InternalCDOObject object = this.getObject(delta.getID());
                    int oldVersion = object.cdoRevision().getVersion();
                    merger.merge(object, (CDORevisionDelta)delta);
                    this.registerRevisionDelta((CDORevisionDelta)delta);
                    this.registerDirty(object, null);
                    if (delta.getVersion() >= oldVersion) continue;
                    this.setConflict(object);
                }
            }
        }
        return savepoints.toArray(new CDOSavepoint[savepoints.size()]);
    }

    private void importNewRevisions(CDODataInput in, List<InternalCDORevision> revisions, Map<CDOID, CDOID> idMappings) throws IOException {
        int size = in.readInt();
        int i = 0;
        while (i < size) {
            InternalCDORevision revision = (InternalCDORevision)in.readCDORevision(false);
            CDOID oldID = revision.getID();
            if (oldID.isTemporary()) {
                CDOID newID = this.createIDForNewObject(null);
                idMappings.put(oldID, newID);
                revision.setID(newID);
            }
            revisions.add(revision);
            ++i;
        }
    }

    private List<InternalCDORevisionDelta> importRevisionDeltas(CDODataInput in) throws IOException {
        int size = in.readInt();
        ArrayList<InternalCDORevisionDelta> deltas = new ArrayList<InternalCDORevisionDelta>(size);
        int i = 0;
        while (i < size) {
            InternalCDORevisionDelta delta = (InternalCDORevisionDelta)in.readCDORevisionDelta();
            deltas.add(delta);
            ++i;
        }
        return deltas;
    }

    private InternalCDOObject newInstance(InternalCDORevision revision) {
        InternalCDOObject object = this.newInstance(revision.getEClass());
        object.cdoInternalSetID(revision.getID());
        object.cdoInternalSetRevision((CDORevision)revision);
        object.cdoInternalSetState(CDOState.NEW);
        object.cdoInternalSetView(this);
        return object;
    }

    @Override
    public synchronized Map<CDOID, CDOObject> getDirtyObjects() {
        this.checkActive();
        return this.lastSavepoint.getAllDirtyObjects();
    }

    @Override
    public synchronized Map<CDOID, CDOObject> getNewObjects() {
        this.checkActive();
        return this.lastSavepoint.getAllNewObjects();
    }

    public synchronized Map<CDOID, CDORevision> getBaseNewObjects() {
        this.checkActive();
        return this.lastSavepoint.getAllBaseNewObjects();
    }

    @Override
    public synchronized Map<CDOID, CDORevisionDelta> getRevisionDeltas() {
        this.checkActive();
        return this.lastSavepoint.getAllRevisionDeltas();
    }

    @Override
    public synchronized Map<CDOID, CDOObject> getDetachedObjects() {
        this.checkActive();
        return this.lastSavepoint.getAllDetachedObjects();
    }

    @Override
    protected synchronized CDOID getXRefTargetID(CDOObject target) {
        CDORevisionKey key = (CDORevisionKey)this.cleanRevisions.get(target);
        if (key != null) {
            return key.getID();
        }
        return super.getXRefTargetID(target);
    }

    @Override
    protected synchronized CDOID getID(InternalCDOObject object, boolean onlyPersistedID) {
        CDOID id = super.getID(object, onlyPersistedID);
        if (id != null) {
            return id;
        }
        if (this.providingCDOID.get().booleanValue()) {
            return null;
        }
        CDORevisionKey revKey = (CDORevisionKey)this.cleanRevisions.get(object);
        if (revKey != null && this.getDetachedObjects().containsValue(object)) {
            id = revKey.getID();
        }
        return id;
    }

    @Override
    public synchronized CDOID provideCDOID(Object idOrObject) {
        try {
            this.providingCDOID.set(true);
            CDOID cDOID = super.provideCDOID(idOrObject);
            return cDOID;
        }
        finally {
            this.providingCDOID.set(false);
        }
    }

    @Override
    public synchronized CDOQueryImpl createQuery(String language, String queryString, Object context) {
        return this.createQuery(language, queryString, context, false);
    }

    @Override
    public synchronized CDOQueryImpl createQuery(String language, String queryString, boolean considerDirtyState) {
        return this.createQuery(language, queryString, null, considerDirtyState);
    }

    @Override
    public synchronized CDOQueryImpl createQuery(String language, String queryString, Object context, boolean considerDirtyState) {
        CDOQueryImpl query = super.createQuery(language, queryString, context);
        if (considerDirtyState && this.isDirty()) {
            query.setChangeSetData(this.getChangeSetData());
        }
        return query;
    }

    @Override
    protected void doActivate() throws Exception {
        super.doActivate();
        InternalCDOSession session = this.getSession();
        if (session.getRepositoryInfo().getIDGenerationLocation() == CDOCommonRepository.IDGenerationLocation.STORE) {
            this.idGenerator = new TempIDGenerator();
        } else {
            this.idGenerator = session.getIDGenerator();
            if (this.idGenerator == null) {
                this.idGenerator = CDOIDGenerator.UUID;
            }
        }
    }

    @Override
    protected void doDeactivate() throws Exception {
        this.options().disposeConflictResolvers();
        this.lastSavepoint = null;
        this.firstSavepoint = null;
        this.transactionStrategy = null;
        this.idGenerator = null;
        super.doDeactivate();
    }

    @Override
    protected Map<CDOObject, Pair<CDORevision, CDORevisionDelta>> invalidate(long lastUpdateTime, List<CDORevisionKey> allChangedObjects, List<CDOIDAndVersion> allDetachedObjects, List<CDORevisionDelta> deltas, Map<CDOObject, CDORevisionDelta> revisionDeltas, Set<CDOObject> detachedObjects) {
        InternalCDOSession session;
        if (!allDetachedObjects.isEmpty()) {
            HashSet<CDOID> referencedOIDs = new HashSet<CDOID>();
            for (CDOIDAndVersion key : allDetachedObjects) {
                referencedOIDs.add(key.getID());
            }
            Collection<CDOObject> cachedDirtyObjects = this.getDirtyObjects().values();
            this.removeCrossReferences(cachedDirtyObjects, referencedOIDs);
            Collection<CDOObject> cachedNewObjects = this.getNewObjects().values();
            this.removeCrossReferences(cachedNewObjects, referencedOIDs);
        }
        if ((session = this.getSession()).isSticky()) {
            session.clearCommittedSinceLastRefresh();
        }
        return super.invalidate(lastUpdateTime, allChangedObjects, allDetachedObjects, deltas, revisionDeltas, detachedObjects);
    }

    private void removeCrossReferences(Collection<CDOObject> referencers, Set<CDOID> referencedOIDs) {
        LinkedList<Pair> objectsToBeRemoved = new LinkedList<Pair>();
        for (CDOObject referencer : referencers) {
            EContentsEList.FeatureIterator<EObject> it = this.getChangeableCrossReferences(referencer);
            while (it.hasNext()) {
                InternalCDORevision cleanRevision;
                Object value;
                EObject referencedObject = (EObject)it.next();
                CDOID referencedOID = CDOUtil.getCDOObject(referencedObject).cdoID();
                if (!referencedOIDs.contains(referencedOID)) continue;
                EReference reference = (EReference)it.feature();
                if (referencer.cdoState() == CDOState.DIRTY && EMFUtil.isPersistent((EStructuralFeature)reference) && ((value = (cleanRevision = this.cleanRevisions.get(referencer)).get((EStructuralFeature)reference, -1)) instanceof CDOObject && value == referencedObject || value instanceof CDOID && value.equals(referencedOID) || value instanceof CDOList && ((CDOList)value).contains((Object)referencedOID))) continue;
                EStructuralFeature.Setting setting = ((InternalEObject)referencer).eSetting((EStructuralFeature)reference);
                objectsToBeRemoved.add(new Pair((Object)setting, (Object)referencedObject));
            }
        }
        for (Pair pair : objectsToBeRemoved) {
            EcoreUtil.remove((EStructuralFeature.Setting)((EStructuralFeature.Setting)pair.getElement1()), (Object)pair.getElement2());
        }
    }

    private EContentsEList.FeatureIterator<EObject> getChangeableCrossReferences(EObject object) {
        EClassImpl.FeatureSubsetSupplier features = (EClassImpl.FeatureSubsetSupplier)object.eClass().getEAllStructuralFeatures();
        EStructuralFeature[] crossReferences = features.crossReferences();
        if (crossReferences != null) {
            ArrayList<EStructuralFeature> changeableReferences = new ArrayList<EStructuralFeature>();
            int i = 0;
            while (i < crossReferences.length) {
                EStructuralFeature reference = crossReferences[i];
                if (!reference.isDerived() && reference.isChangeable()) {
                    changeableReferences.add(reference);
                }
                ++i;
            }
            if (!changeableReferences.isEmpty()) {
                EStructuralFeature[] collectedStructuralFeatures = changeableReferences.toArray(new EStructuralFeature[changeableReferences.size()]);
                return (EContentsEList.FeatureIterator)new ECrossReferenceEListDerived(object, collectedStructuralFeatures).iterator();
            }
        }
        return (EContentsEList.FeatureIterator)ECrossReferenceEList.emptyContentsEList().iterator();
    }

    @Override
    public synchronized long getLastCommitTime() {
        return this.lastCommitTime;
    }

    @Override
    public synchronized String getCommitComment() {
        return this.commitComment;
    }

    @Override
    public synchronized void setCommitComment(String comment) {
        this.commitComment = comment;
    }

    @Override
    public synchronized void setCommittables(Set<? extends EObject> committables) {
        this.committables = committables;
    }

    @Override
    public synchronized Set<? extends EObject> getCommittables() {
        return this.committables;
    }

    @Override
    public synchronized Map<InternalCDOObject, InternalCDORevision> getCleanRevisions() {
        return this.cleanRevisions;
    }

    @Override
    protected InternalCDORevision getViewedRevision(InternalCDOObject object) {
        InternalCDORevision cleanRev;
        InternalCDORevision rev = super.getViewedRevision(object);
        if (rev != null && (cleanRev = this.cleanRevisions.get(object)) != null) {
            return cleanRev;
        }
        return rev;
    }

    @Override
    protected InternalCDORevision getRevision(CDOObject object) {
        if (object.cdoState() == CDOState.TRANSIENT) {
            InternalCDORevision revision = this.cleanRevisions.get(object);
            if (revision == null) {
                throw new IllegalStateException("No revision for transient object " + object);
            }
            return revision;
        }
        return super.getRevision(object);
    }

    @Override
    protected InternalCDOLockState createUpdatedLockStateForNewObject(CDOObject object, IRWLockManager.LockType lockType, boolean on) {
        InternalCDOLockState lockState;
        block13: {
            CDOLockOwner lockOwner;
            block12: {
                CheckUtil.checkState((boolean)FSMUtil.isNew(object), (String)"Object is not in NEW state");
                CheckUtil.checkArg((Object)lockType, (String)"lockType");
                lockState = (InternalCDOLockState)this.getLockState(object);
                if (lockState == null) {
                    CheckUtil.checkArg((boolean)on, (String)"on != true");
                    Object lockTarget = CDOTransactionImpl.getLockTarget(object);
                    lockState = (InternalCDOLockState)CDOLockUtil.createLockState((Object)lockTarget);
                } else {
                    lockState = (InternalCDOLockState)CDOLockUtil.copyLockState((CDOLockState)lockState);
                }
                lockOwner = CDOLockUtil.createLockOwner((CDOCommonView)this);
                if (!on) break block12;
                switch (lockType) {
                    case READ: {
                        lockState.addReadLockOwner(lockOwner);
                        break block13;
                    }
                    case WRITE: {
                        lockState.setWriteLockOwner(lockOwner);
                        break block13;
                    }
                    case OPTION: {
                        lockState.setWriteOptionOwner(lockOwner);
                        break block13;
                    }
                    default: {
                        throw new IllegalArgumentException("Unknown lock type " + lockType);
                    }
                }
            }
            switch (lockType) {
                case READ: {
                    lockState.removeReadLockOwner(lockOwner);
                    break;
                }
                case WRITE: {
                    lockState.setWriteLockOwner(null);
                    break;
                }
                case OPTION: {
                    lockState.setWriteOptionOwner(null);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown lock type " + lockType);
                }
            }
        }
        return lockState;
    }

    protected List<CDOLockState> createUnlockedLockStatesForAllNewObjects() {
        LinkedList<CDOLockState> locksOnNewObjects = new LinkedList<CDOLockState>();
        for (CDOObject object : this.getNewObjects().values()) {
            Object lockTarget = CDOTransactionImpl.getLockTarget(object);
            CDOLockState lockState = CDOLockUtil.createLockState((Object)lockTarget);
            locksOnNewObjects.add(lockState);
        }
        return locksOnNewObjects;
    }

    private static Object getLockTarget(CDOObject object) {
        CDOView view = object.cdoView();
        if (view == null) {
            return null;
        }
        CDOID id = object.cdoID();
        boolean branching = view.getSession().getRepositoryInfo().isSupportingBranches();
        if (branching) {
            return CDOIDUtil.createIDAndBranch((CDOID)id, (CDOBranch)view.getBranch());
        }
        return id;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class CDOCommitContextImpl
    implements InternalCDOTransaction.InternalCDOCommitContext {
        private InternalCDOTransaction transaction;
        private boolean isPartialCommit;
        private CDOCommitData commitData;
        private Collection<CDOLockState> locksOnNewObjects;
        private Map<CDOID, CDOObject> newObjects;
        private Map<CDOID, CDOObject> detachedObjects;
        private Map<CDOID, CDORevisionDelta> revisionDeltas;
        private Map<CDOID, CDOObject> dirtyObjects;
        private Map<ByteArrayWrapper, CDOLob<?>> lobs = new HashMap();

        public CDOCommitContextImpl(InternalCDOTransaction transaction) {
            this.transaction = transaction;
            this.calculateCommitData();
        }

        private void calculateCommitData() {
            List<CDOPackageUnit> newPackageUnits = CDOTransactionImpl.this.analyzeNewPackages();
            this.newObjects = this.filterCommittables(this.transaction.getNewObjects());
            ArrayList<CDORevision> revisions = new ArrayList<CDORevision>(this.newObjects.size());
            for (CDOObject newObject : this.newObjects.values()) {
                revisions.add(newObject.cdoRevision());
            }
            this.revisionDeltas = this.filterCommittables(this.transaction.getRevisionDeltas());
            ArrayList<CDORevisionDelta> deltas = new ArrayList<CDORevisionDelta>(this.revisionDeltas.size());
            for (CDORevisionDelta delta : this.revisionDeltas.values()) {
                deltas.add(delta);
            }
            this.detachedObjects = this.filterCommittables(this.transaction.getDetachedObjects());
            ArrayList<CDOIDAndVersion> detached = new ArrayList<CDOIDAndVersion>(this.detachedObjects.size());
            for (CDOID id : this.detachedObjects.keySet()) {
                detached.add(CDOIDUtil.createIDAndVersion((CDOID)id, (int)0));
            }
            this.dirtyObjects = this.filterCommittables(this.transaction.getDirtyObjects());
            CDOLockState[] locksOnNewObjectsArray = CDOTransactionImpl.this.getLockStates(this.newObjects.keySet(), false);
            this.locksOnNewObjects = Arrays.asList(locksOnNewObjectsArray);
            this.commitData = new CDOCommitDataImpl(newPackageUnits, revisions, deltas, detached);
        }

        private <T> Map<CDOID, T> filterCommittables(Map<CDOID, T> map) {
            if (CDOTransactionImpl.this.committables == null) {
                return map;
            }
            HashMap<CDOID, T> newMap = new HashMap<CDOID, T>();
            for (Map.Entry<CDOID, T> entry : map.entrySet()) {
                CDOID id = entry.getKey();
                InternalCDOObject o = CDOTransactionImpl.this.getObject(id);
                if (CDOTransactionImpl.this.committables.contains(o)) {
                    newMap.put(id, entry.getValue());
                    continue;
                }
                this.isPartialCommit = true;
            }
            return newMap;
        }

        @Override
        public String getUserID() {
            return this.transaction.getSession().getUserID();
        }

        @Override
        public int getViewID() {
            return this.transaction.getViewID();
        }

        @Override
        public CDOBranch getBranch() {
            return this.transaction.getBranch();
        }

        @Override
        public InternalCDOTransaction getTransaction() {
            return this.transaction;
        }

        @Override
        public boolean isPartialCommit() {
            return this.isPartialCommit;
        }

        @Override
        public boolean isAutoReleaseLocks() {
            return this.transaction.options().isAutoReleaseLocksEnabled();
        }

        @Override
        public String getCommitComment() {
            return this.transaction.getCommitComment();
        }

        @Override
        public CDOCommitData getCommitData() {
            return this.commitData;
        }

        @Override
        public Map<CDOID, CDOObject> getDirtyObjects() {
            return this.dirtyObjects;
        }

        @Override
        public Map<CDOID, CDOObject> getNewObjects() {
            return this.newObjects;
        }

        @Override
        public List<CDOPackageUnit> getNewPackageUnits() {
            return this.commitData.getNewPackageUnits();
        }

        @Override
        public Collection<CDOLockState> getLocksOnNewObjects() {
            return this.locksOnNewObjects;
        }

        @Override
        public Map<CDOID, CDOObject> getDetachedObjects() {
            return this.detachedObjects;
        }

        @Override
        public Map<CDOID, CDORevisionDelta> getRevisionDeltas() {
            return this.revisionDeltas;
        }

        @Override
        public Collection<CDOLob<?>> getLobs() {
            return this.lobs.values();
        }

        @Override
        public void preCommit() {
            if (CDOTransactionImpl.this.isDirty()) {
                CDOTransactionHandler2[] handlers;
                if (TRACER.isEnabled()) {
                    TRACER.trace("commit()");
                }
                if ((handlers = CDOTransactionImpl.this.getTransactionHandlers2()).length != 0) {
                    final boolean[] modifiedAgain = new boolean[1];
                    CDODefaultTransactionHandler1 modifiedAgainHandler = new CDODefaultTransactionHandler1(){

                        public void modifyingObject(CDOTransaction transaction, CDOObject object, CDOFeatureDelta featureChange) {
                            modifiedAgain[0] = true;
                        }
                    };
                    CDOTransactionImpl.this.addTransactionHandler(modifiedAgainHandler);
                    try {
                        int i = 0;
                        while (i < handlers.length) {
                            modifiedAgain[0] = false;
                            CDOTransactionHandler2 handler = handlers[i];
                            handler.committingTransaction(this.getTransaction(), this);
                            if (modifiedAgain[0]) {
                                this.calculateCommitData();
                            }
                            ++i;
                        }
                    }
                    finally {
                        CDOTransactionImpl.this.removeTransactionHandler(modifiedAgainHandler);
                    }
                }
                try {
                    if (this.isPartialCommit) {
                        new CommitIntegrityCheck(this, CommitIntegrityCheck.Style.EXCEPTION_FAST).check();
                    }
                    this.preCommit(this.getNewObjects(), this.lobs);
                    this.preCommit(this.getDirtyObjects(), this.lobs);
                    if (!this.lobs.isEmpty()) {
                        CDOSessionProtocol sessionProtocol = CDOTransactionImpl.this.getSession().getSessionProtocol();
                        List<byte[]> alreadyKnown = sessionProtocol.queryLobs(ByteArrayWrapper.toByteArray(this.lobs.keySet()));
                        for (byte[] id : alreadyKnown) {
                            this.lobs.remove(new ByteArrayWrapper(id));
                        }
                    }
                }
                catch (RuntimeException ex) {
                    throw ex;
                }
                catch (Exception ex) {
                    throw new TransactionException((Throwable)ex);
                }
            }
        }

        @Override
        public void postCommit(CDOSessionProtocol.CommitTransactionResult result) {
            try {
                CDOLockState[] newLockStates;
                boolean branchChanged;
                InternalCDOSession session = CDOTransactionImpl.this.getSession();
                long timeStamp = result.getTimeStamp();
                if (result.getRollbackMessage() != null) {
                    FailureCommitInfo commitInfo = new FailureCommitInfo(timeStamp, result.getPreviousTimeStamp());
                    session.invalidate((CDOCommitInfo)commitInfo, this.transaction);
                    return;
                }
                CDOBranch branch = result.getBranch();
                boolean bl = branchChanged = !ObjectUtil.equals((Object)branch, (Object)this.getBranch());
                if (branchChanged) {
                    CDOTransactionImpl.this.basicSetBranchPoint(branch.getHead());
                }
                for (CDOPackageUnit newPackageUnit : this.getNewPackageUnits()) {
                    ((InternalCDOPackageUnit)newPackageUnit).setState(CDOPackageUnit.State.LOADED);
                }
                this.postCommit(this.getNewObjects(), result);
                this.postCommit(this.getDirtyObjects(), result);
                for (CDORevisionDelta delta : this.getRevisionDeltas().values()) {
                    ((InternalCDORevisionDelta)delta).adjustReferences(result.getReferenceAdjuster());
                }
                for (CDOID id : this.getDetachedObjects().keySet()) {
                    CDOTransactionImpl.this.removeObject(id);
                }
                CDOCommitInfo commitInfo = this.makeCommitInfo(timeStamp, result.getPreviousTimeStamp());
                session.invalidate(commitInfo, this.transaction);
                if (session.isSticky()) {
                    CDOBranchPoint commitBranchPoint = CDOBranchUtil.copyBranchPoint((CDOBranchPoint)result);
                    for (CDOObject object : this.getNewObjects().values()) {
                        session.setCommittedSinceLastRefresh(object.cdoID(), commitBranchPoint);
                    }
                    for (CDOID id : this.getDirtyObjects().keySet()) {
                        session.setCommittedSinceLastRefresh(id, commitBranchPoint);
                    }
                    for (CDOID id : this.getDetachedObjects().keySet()) {
                        session.setCommittedSinceLastRefresh(id, commitBranchPoint);
                    }
                }
                CDOTransactionHandler2[] handlers = CDOTransactionImpl.this.getTransactionHandlers2();
                int i = 0;
                while (i < handlers.length) {
                    CDOTransactionHandler2 handler = handlers[i];
                    if (handler instanceof CDOTransactionHandler3) {
                        CDOTransactionHandler3 handler3 = (CDOTransactionHandler3)handler;
                        handler3.committedTransaction(this.transaction, this, commitInfo);
                    } else {
                        handler.committedTransaction(this.transaction, this);
                    }
                    ++i;
                }
                CDOTransactionImpl.this.getChangeSubscriptionManager().committedTransaction(this.transaction, this);
                CDOTransactionImpl.this.getAdapterManager().committedTransaction(this.transaction, this);
                CDOTransactionImpl.this.cleanUp(this);
                Map<CDOID, CDOID> idMappings = result.getIDMappings();
                IListener[] listeners = CDOTransactionImpl.this.getListeners();
                if (listeners != null) {
                    if (branchChanged) {
                        CDOTransactionImpl.this.fireViewTargetChangedEvent(listeners);
                    }
                    CDOTransactionImpl.this.fireEvent(new FinishedEvent(CDOTransactionFinishedEvent.Type.COMMITTED, idMappings), listeners);
                }
                if ((newLockStates = result.getNewLockStates()) != null) {
                    CDOTransactionImpl.this.updateAndNotifyLockStates(CDOLockChangeInfo.Operation.UNLOCK, null, result.getTimeStamp(), newLockStates);
                }
            }
            catch (RuntimeException ex) {
                throw ex;
            }
            catch (Exception ex) {
                throw new TransactionException((Throwable)ex);
            }
        }

        private CDOCommitInfo makeCommitInfo(long timeStamp, long previousTimeStamp) {
            InternalCDOSession session = CDOTransactionImpl.this.getSession();
            CDOBranch branch = this.getBranch();
            String userID = session.getUserID();
            String comment = this.getCommitComment();
            InternalCDOCommitInfoManager commitInfoManager = session.getCommitInfoManager();
            return commitInfoManager.createCommitInfo(branch, timeStamp, previousTimeStamp, userID, comment, this.commitData);
        }

        private void preCommit(Map<CDOID, CDOObject> objects, Map<ByteArrayWrapper, CDOLob<?>> lobs) {
            if (!objects.isEmpty()) {
                boolean noLegacy = !CDOTransactionImpl.this.isLegacyModeEnabled();
                for (CDOObject object : objects.values()) {
                    if (noLegacy && object instanceof CDOObjectWrapper) {
                        throw new LegacyModeNotEnabledException();
                    }
                    this.collectLobs((InternalCDORevision)object.cdoRevision(), lobs);
                    ((InternalCDOObject)object).cdoInternalPreCommit();
                }
            }
        }

        private void collectLobs(InternalCDORevision revision, Map<ByteArrayWrapper, CDOLob<?>> lobs) {
            EStructuralFeature[] features = revision.getClassInfo().getAllPersistentFeatures();
            int i = 0;
            while (i < features.length) {
                CDOLob lob;
                EStructuralFeature feature = features[i];
                if (CDOModelUtil.isLob((EClassifier)feature.getEType()) && (lob = (CDOLob)revision.getValue(feature)) != null) {
                    lobs.put(new ByteArrayWrapper(lob.getID()), lob);
                }
                ++i;
            }
        }

        private void postCommit(Map<CDOID, CDOObject> objects, CDOSessionProtocol.CommitTransactionResult result) {
            if (!objects.isEmpty()) {
                for (CDOObject object : objects.values()) {
                    CDOStateMachine.INSTANCE.commit((InternalCDOObject)object, result);
                }
            }
        }
    }

    private final class ConflictEvent
    extends AbstractCDOView.Event
    implements CDOTransactionConflictEvent {
        private static final long serialVersionUID = 1L;
        private InternalCDOObject conflictingObject;
        private boolean firstConflict;

        public ConflictEvent(InternalCDOObject conflictingObject, boolean firstConflict) {
            super(CDOTransactionImpl.this);
            this.conflictingObject = conflictingObject;
            this.firstConflict = firstConflict;
        }

        public InternalCDOObject getConflictingObject() {
            return this.conflictingObject;
        }

        public boolean isFirstConflict() {
            return this.firstConflict;
        }

        public String toString() {
            return MessageFormat.format("CDOTransactionConflictEvent[source={0}, conflictingObject={1}, firstConflict={2}]", this.getSource(), this.getConflictingObject(), this.isFirstConflict());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ECrossReferenceEListDerived
    extends ECrossReferenceEList<EObject> {
        public ECrossReferenceEListDerived(EObject eObject) {
            super(eObject);
        }

        public ECrossReferenceEListDerived(EObject eObject, EStructuralFeature[] eStructuralFeatures) {
            super(eObject, eStructuralFeatures);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class FinishedEvent
    extends AbstractCDOView.Event
    implements CDOTransactionFinishedEvent {
        private static final long serialVersionUID = 1L;
        private CDOTransactionFinishedEvent.Type type;
        private Map<CDOID, CDOID> idMappings;

        private FinishedEvent(CDOTransactionFinishedEvent.Type type, Map<CDOID, CDOID> idMappings) {
            super(CDOTransactionImpl.this);
            this.type = type;
            this.idMappings = idMappings;
        }

        @Override
        public CDOTransactionFinishedEvent.Type getType() {
            return this.type;
        }

        @Override
        public Map<CDOID, CDOID> getIDMappings() {
            return this.idMappings;
        }

        public String toString() {
            return MessageFormat.format("CDOTransactionFinishedEvent[source={0}, type={1}, idMappings={2}]", new Object[]{this.getSource(), this.getType(), this.idMappings == null ? 0 : this.idMappings.size()});
        }
    }

    protected final class OptionsImpl
    extends CDOViewImpl.OptionsImpl
    implements CDOTransaction.Options {
        private List<CDOConflictResolver> conflictResolvers;
        private boolean autoReleaseLocksEnabled;

        public OptionsImpl() {
            super(CDOTransactionImpl.this);
            this.conflictResolvers = new ArrayList<CDOConflictResolver>();
            this.autoReleaseLocksEnabled = true;
        }

        public CDOTransactionImpl getContainer() {
            return (CDOTransactionImpl)super.getContainer();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public CDOConflictResolver[] getConflictResolvers() {
            CDOTransactionImpl cDOTransactionImpl = CDOTransactionImpl.this;
            synchronized (cDOTransactionImpl) {
                return this.conflictResolvers.toArray(new CDOConflictResolver[this.conflictResolvers.size()]);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setConflictResolvers(CDOConflictResolver[] resolvers) {
            CDOTransactionImpl cDOTransactionImpl = CDOTransactionImpl.this;
            synchronized (cDOTransactionImpl) {
                for (CDOConflictResolver resolver : this.conflictResolvers) {
                    resolver.setTransaction(null);
                }
                this.conflictResolvers.clear();
                CDOConflictResolver[] cDOConflictResolverArray = resolvers;
                int n = resolvers.length;
                int n2 = 0;
                while (n2 < n) {
                    CDOConflictResolver resolver;
                    resolver = cDOConflictResolverArray[n2];
                    this.validateResolver(resolver);
                    this.conflictResolvers.add(resolver);
                    ++n2;
                }
            }
            this.fireEvent((IEvent)new ConflictResolversEventImpl());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addConflictResolver(CDOConflictResolver resolver) {
            ConflictResolversEventImpl event = null;
            CDOTransactionImpl cDOTransactionImpl = CDOTransactionImpl.this;
            synchronized (cDOTransactionImpl) {
                this.validateResolver(resolver);
                this.conflictResolvers.add(resolver);
                event = new ConflictResolversEventImpl();
            }
            this.fireEvent((IEvent)event);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removeConflictResolver(CDOConflictResolver resolver) {
            ConflictResolversEventImpl event = null;
            CDOTransactionImpl cDOTransactionImpl = CDOTransactionImpl.this;
            synchronized (cDOTransactionImpl) {
                if (this.conflictResolvers.remove(resolver)) {
                    resolver.setTransaction(null);
                    event = new ConflictResolversEventImpl();
                }
            }
            this.fireEvent((IEvent)event);
        }

        public void disposeConflictResolvers() {
            try {
                CDOConflictResolver[] array;
                CDOConflictResolver[] cDOConflictResolverArray = array = this.conflictResolvers.toArray(new CDOConflictResolver[this.conflictResolvers.size()]);
                int n = array.length;
                int n2 = 0;
                while (n2 < n) {
                    CDOConflictResolver resolver = cDOConflictResolverArray[n2];
                    try {
                        resolver.setTransaction(null);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    ++n2;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        private void validateResolver(CDOConflictResolver resolver) {
            if (resolver.getTransaction() != null) {
                throw new IllegalArgumentException(Messages.getString("CDOTransactionImpl.17"));
            }
            resolver.setTransaction(CDOTransactionImpl.this);
        }

        public boolean isAutoReleaseLocksEnabled() {
            return this.autoReleaseLocksEnabled;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setAutoReleaseLocksEnabled(boolean on) {
            AutoReleaseLocksEventImpl event = null;
            CDOTransactionImpl cDOTransactionImpl = CDOTransactionImpl.this;
            synchronized (cDOTransactionImpl) {
                if (this.autoReleaseLocksEnabled != on) {
                    this.autoReleaseLocksEnabled = on;
                    event = new AutoReleaseLocksEventImpl();
                }
            }
            this.fireEvent((IEvent)event);
        }

        private final class AutoReleaseLocksEventImpl
        extends OptionsEvent
        implements CDOTransaction.Options.AutoReleaseLocksEvent {
            private static final long serialVersionUID = 1L;

            public AutoReleaseLocksEventImpl() {
                super((IOptions)OptionsImpl.this);
            }
        }

        private final class ConflictResolversEventImpl
        extends OptionsEvent
        implements CDOTransaction.Options.ConflictResolversEvent {
            private static final long serialVersionUID = 1L;

            public ConflictResolversEventImpl() {
                super((IOptions)OptionsImpl.this);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class ResolvingRevisionMap
    extends HashMap<InternalCDOObject, InternalCDORevision> {
        private static final long serialVersionUID = 1L;

        @Override
        public InternalCDORevision get(Object cdoObject) {
            InternalCDORevision revision = (InternalCDORevision)super.get(cdoObject);
            if (revision != null) {
                CDOTransactionImpl.this.getSession().resolveAllElementProxies((CDORevision)revision);
            }
            return revision;
        }
    }

    private final class StartedEvent
    extends AbstractCDOView.Event
    implements CDOTransactionStartedEvent {
        private static final long serialVersionUID = 1L;

        private StartedEvent() {
            super(CDOTransactionImpl.this);
        }

        public String toString() {
            return MessageFormat.format("CDOTransactionStartedEvent[source={0}]", this.getSource());
        }
    }

    private static final class TempIDGenerator
    implements CDOIDGenerator {
        private AtomicInteger lastTemporaryID = new AtomicInteger();

        public CDOID generateCDOID(EObject object) {
            return CDOIDUtil.createTempObject((int)this.lastTemporaryID.incrementAndGet());
        }

        public void reset() {
            this.lastTemporaryID.set(0);
        }
    }
}

