/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.internal.cdo.view;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.cdo.CDOObject;
import org.eclipse.emf.cdo.CDOObjectReference;
import org.eclipse.emf.cdo.CDOState;
import org.eclipse.emf.cdo.common.branch.CDOBranch;
import org.eclipse.emf.cdo.common.branch.CDOBranchPoint;
import org.eclipse.emf.cdo.common.commit.CDOChangeSetData;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.id.CDOIDExternal;
import org.eclipse.emf.cdo.common.id.CDOIDUtil;
import org.eclipse.emf.cdo.common.model.CDOClassifierRef;
import org.eclipse.emf.cdo.common.model.CDOModelUtil;
import org.eclipse.emf.cdo.common.revision.CDOIDAndVersion;
import org.eclipse.emf.cdo.common.revision.CDORevision;
import org.eclipse.emf.cdo.common.revision.CDORevisionKey;
import org.eclipse.emf.cdo.common.revision.delta.CDORevisionDelta;
import org.eclipse.emf.cdo.common.util.CDOCommonUtil;
import org.eclipse.emf.cdo.common.util.CDOException;
import org.eclipse.emf.cdo.eresource.CDOResource;
import org.eclipse.emf.cdo.eresource.CDOResourceFolder;
import org.eclipse.emf.cdo.eresource.CDOResourceNode;
import org.eclipse.emf.cdo.eresource.EresourcePackage;
import org.eclipse.emf.cdo.eresource.impl.CDOResourceImpl;
import org.eclipse.emf.cdo.internal.common.revision.delta.CDORevisionDeltaImpl;
import org.eclipse.emf.cdo.spi.common.branch.CDOBranchUtil;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDORevision;
import org.eclipse.emf.cdo.transaction.CDOTransaction;
import org.eclipse.emf.cdo.util.CDOURIUtil;
import org.eclipse.emf.cdo.util.CDOUtil;
import org.eclipse.emf.cdo.util.DanglingReferenceException;
import org.eclipse.emf.cdo.util.InvalidURIException;
import org.eclipse.emf.cdo.util.ObjectNotFoundException;
import org.eclipse.emf.cdo.util.ReadOnlyException;
import org.eclipse.emf.cdo.view.CDOObjectHandler;
import org.eclipse.emf.cdo.view.CDOQuery;
import org.eclipse.emf.cdo.view.CDOView;
import org.eclipse.emf.cdo.view.CDOViewAdaptersNotifiedEvent;
import org.eclipse.emf.cdo.view.CDOViewEvent;
import org.eclipse.emf.cdo.view.CDOViewTargetChangedEvent;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.internal.cdo.bundle.OM;
import org.eclipse.emf.internal.cdo.messages.Messages;
import org.eclipse.emf.internal.cdo.object.CDOLegacyAdapter;
import org.eclipse.emf.internal.cdo.query.CDOQueryImpl;
import org.eclipse.emf.internal.cdo.view.CDOStateMachine;
import org.eclipse.emf.internal.cdo.view.CDOStoreImpl;
import org.eclipse.emf.internal.cdo.view.CDOURIHandler;
import org.eclipse.emf.spi.cdo.CDOStore;
import org.eclipse.emf.spi.cdo.FSMUtil;
import org.eclipse.emf.spi.cdo.InternalCDOObject;
import org.eclipse.emf.spi.cdo.InternalCDOSession;
import org.eclipse.emf.spi.cdo.InternalCDOView;
import org.eclipse.emf.spi.cdo.InternalCDOViewSet;
import org.eclipse.net4j.util.CheckUtil;
import org.eclipse.net4j.util.ImplementationError;
import org.eclipse.net4j.util.ReflectUtil;
import org.eclipse.net4j.util.StringUtil;
import org.eclipse.net4j.util.collection.CloseableIterator;
import org.eclipse.net4j.util.collection.ConcurrentArray;
import org.eclipse.net4j.util.collection.Pair;
import org.eclipse.net4j.util.event.IListener;
import org.eclipse.net4j.util.event.INotifier;
import org.eclipse.net4j.util.lifecycle.Lifecycle;
import org.eclipse.net4j.util.lifecycle.LifecycleUtil;
import org.eclipse.net4j.util.om.log.OMLogger;
import org.eclipse.net4j.util.om.trace.ContextTracer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractCDOView
extends Lifecycle
implements InternalCDOView {
    private static final ContextTracer TRACER = new ContextTracer(OM.DEBUG_VIEW, AbstractCDOView.class);
    private final boolean legacyModeEnabled;
    private CDOBranchPoint branchPoint;
    private final CDOURIHandler uriHandler = new CDOURIHandler(this);
    private InternalCDOViewSet viewSet;
    private Map<CDOID, InternalCDOObject> objects;
    private CDOStore store = new CDOStoreImpl(this);
    private CDOResourceImpl rootResource;
    private final ConcurrentArray<CDOObjectHandler> objectHandlers = new ConcurrentArray<CDOObjectHandler>(){

        protected CDOObjectHandler[] newArray(int length) {
            return new CDOObjectHandler[length];
        }
    };
    @ReflectUtil.ExcludeFromDump
    private transient CDOID lastLookupID;
    @ReflectUtil.ExcludeFromDump
    private transient InternalCDOObject lastLookupObject;

    public AbstractCDOView(CDOBranchPoint branchPoint, boolean legacyModeEnabled) {
        this(legacyModeEnabled);
        this.basicSetBranchPoint(branchPoint);
    }

    public AbstractCDOView(boolean legacyModeEnabled) {
        this.legacyModeEnabled = legacyModeEnabled;
    }

    public boolean isReadOnly() {
        return true;
    }

    @Override
    public boolean isLegacyModeEnabled() {
        return this.legacyModeEnabled;
    }

    protected final synchronized Map<CDOID, InternalCDOObject> getModifiableObjects() {
        return this.objects;
    }

    @Override
    public synchronized Map<CDOID, InternalCDOObject> getObjects() {
        if (this.objects == null) {
            return Collections.emptyMap();
        }
        return Collections.unmodifiableMap(this.objects);
    }

    protected final synchronized void setObjects(Map<CDOID, InternalCDOObject> objects) {
        this.objects = objects;
    }

    @Override
    public CDOStore getStore() {
        this.checkActive();
        return this.store;
    }

    @Override
    public ResourceSet getResourceSet() {
        return this.getViewSet().getResourceSet();
    }

    @Override
    public InternalCDOViewSet getViewSet() {
        return this.viewSet;
    }

    @Override
    public void setViewSet(InternalCDOViewSet viewSet) {
        this.viewSet = viewSet;
        if (viewSet != null) {
            viewSet.getResourceSet().getURIConverter().getURIHandlers().add(0, (Object)this.getURIHandler());
        }
    }

    @Override
    public synchronized CDOResourceImpl getRootResource() {
        this.checkActive();
        if (this.rootResource == null) {
            CDOID rootResourceID = this.getSession().getRepositoryInfo().getRootResourceID();
            if (rootResourceID == null || rootResourceID.isNull()) {
                throw new IllegalStateException("RootResourceID is null; is the repository not yet initialized?");
            }
            this.getObject(rootResourceID);
            CheckUtil.checkState((Object)this.rootResource, (String)"rootResource");
        }
        return this.rootResource;
    }

    private synchronized void setRootResource(CDOResourceImpl resource) {
        this.rootResource = resource;
        this.rootResource.setRoot(true);
        this.registerObject(this.rootResource);
    }

    @Override
    public CDOURIHandler getURIHandler() {
        return this.uriHandler;
    }

    protected synchronized CDOBranchPoint getBranchPoint() {
        return this.branchPoint;
    }

    @Override
    public synchronized boolean setBranch(CDOBranch branch) {
        return this.setBranchPoint(branch, this.getTimeStamp());
    }

    @Override
    public synchronized boolean setTimeStamp(long timeStamp) {
        return this.setBranchPoint(this.getBranch(), timeStamp);
    }

    @Override
    public synchronized boolean setBranchPoint(CDOBranch branch, long timeStamp) {
        return this.setBranchPoint(branch.getPoint(timeStamp));
    }

    protected synchronized void basicSetBranchPoint(CDOBranchPoint branchPoint) {
        this.branchPoint = CDOBranchUtil.copyBranchPoint((CDOBranchPoint)branchPoint);
    }

    @Override
    public void waitForUpdate(long updateTime) {
        this.waitForUpdate(updateTime, -1L);
    }

    public synchronized CDOBranch getBranch() {
        return this.branchPoint.getBranch();
    }

    public synchronized long getTimeStamp() {
        return this.branchPoint.getTimeStamp();
    }

    protected void fireViewTargetChangedEvent(IListener[] listeners) {
        this.fireEvent(new ViewTargetChangedEvent(this.branchPoint), listeners);
    }

    @Override
    public boolean isDirty() {
        return false;
    }

    @Override
    public boolean hasConflict() {
        return false;
    }

    @Override
    public synchronized boolean hasResource(String path) {
        try {
            this.checkActive();
            this.getResourceNodeID(path);
            return true;
        }
        catch (Exception ex) {
            return false;
        }
    }

    @Override
    public synchronized CDOQueryImpl createQuery(String language, String queryString) {
        return this.createQuery(language, queryString, null);
    }

    @Override
    public synchronized CDOQueryImpl createQuery(String language, String queryString, Object context) {
        this.checkActive();
        return new CDOQueryImpl(this, language, queryString, context);
    }

    @Override
    public synchronized CDOResourceNode getResourceNode(String path) {
        InternalCDOObject object;
        CDOID id = this.getResourceNodeID(path);
        if (id != null && (object = this.getObject(id)) instanceof CDOResourceNode) {
            return (CDOResourceNode)((Object)object);
        }
        throw new CDOException("Resource node not found: " + path);
    }

    @Override
    public synchronized CDOID getResourceNodeID(String path) {
        if (StringUtil.isEmpty((String)path)) {
            throw new IllegalArgumentException(Messages.getString("CDOViewImpl.1"));
        }
        CDOID folderID = null;
        if (CDOURIUtil.SEGMENT_SEPARATOR.equals(path)) {
            folderID = this.getResourceNodeIDChecked(null, null);
        } else {
            List<String> names = CDOURIUtil.analyzePath(path);
            for (String name : names) {
                folderID = this.getResourceNodeIDChecked(folderID, name);
            }
        }
        return folderID;
    }

    private CDOID getResourceNodeIDChecked(CDOID folderID, String name) {
        if ((folderID = this.getResourceNodeID(folderID, name)) == null) {
            throw new CDOException(MessageFormat.format(Messages.getString("CDOViewImpl.2"), name));
        }
        return folderID;
    }

    protected synchronized CDOResourceNode getResourceNode(CDOID folderID, String name) {
        try {
            CDOID id = this.getResourceNodeID(folderID, name);
            return (CDOResourceNode)((Object)this.getObject(id));
        }
        catch (CDOException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new CDOException((Throwable)ex);
        }
    }

    protected synchronized CDOID getResourceNodeID(CDOID folderID, String name) {
        if (folderID == null) {
            return this.getRootOrTopLevelResourceNodeID(name);
        }
        if (name == null) {
            throw new IllegalArgumentException(Messages.getString("CDOViewImpl.3"));
        }
        InternalCDORevision folderRevision = this.getLocalRevision(folderID);
        EClass resourceFolderClass = EresourcePackage.eINSTANCE.getCDOResourceFolder();
        if (folderRevision.getEClass() != resourceFolderClass) {
            throw new CDOException(MessageFormat.format(Messages.getString("CDOViewImpl.4"), folderID));
        }
        EReference nodesFeature = EresourcePackage.eINSTANCE.getCDOResourceFolder_Nodes();
        EAttribute nameFeature = EresourcePackage.eINSTANCE.getCDOResourceNode_Name();
        int size = folderRevision.data().size((EStructuralFeature)nodesFeature);
        int i = 0;
        while (i < size) {
            Object value = folderRevision.data().get((EStructuralFeature)nodesFeature, i);
            value = this.getStore().resolveProxy(folderRevision, (EStructuralFeature)nodesFeature, i, value);
            InternalCDORevision childRevision = this.getLocalRevision((CDOID)this.convertObjectToID(value));
            if (name.equals(childRevision.data().get((EStructuralFeature)nameFeature, 0))) {
                return childRevision.getID();
            }
            ++i;
        }
        throw new CDOException(MessageFormat.format(Messages.getString("CDOViewImpl.5"), name));
    }

    protected synchronized CDOID getRootOrTopLevelResourceNodeID(String name) {
        CDOQuery resourceQuery = this.createResourcesQuery(null, name, true);
        resourceQuery.setMaxResults(1);
        List<CDOID> ids = resourceQuery.getResult(CDOID.class);
        if (ids.isEmpty()) {
            if (name == null) {
                throw new CDOException(Messages.getString("CDOViewImpl.6"));
            }
            throw new CDOException(MessageFormat.format(Messages.getString("CDOViewImpl.7"), name));
        }
        if (ids.size() > 1) {
            throw new ImplementationError(Messages.getString("CDOViewImpl.8"));
        }
        return ids.get(0);
    }

    private InternalCDORevision getLocalRevision(CDOID id) {
        InternalCDORevision revision = null;
        InternalCDOObject object = this.getObject(id, false);
        if (object != null && object.cdoState() != CDOState.PROXY) {
            revision = object.cdoRevision();
        }
        if (revision == null) {
            revision = this.getRevision(id, true);
        }
        if (revision == null) {
            throw new CDOException(MessageFormat.format(Messages.getString("CDOViewImpl.9"), id));
        }
        return revision;
    }

    public synchronized List<InternalCDOObject> getObjectsList() {
        ArrayList<InternalCDOObject> result = new ArrayList<InternalCDOObject>();
        for (InternalCDOObject value : this.objects.values()) {
            if (value == null) continue;
            result.add(value);
        }
        return result;
    }

    @Override
    public synchronized CDOResource getResource(String path) {
        return this.getResource(path, true);
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public synchronized CDOResource getResource(String path, boolean loadInDemand) {
        this.checkActive();
        uri = CDOURIUtil.createResourceURI(this, path);
        resourceSet = this.getResourceSet();
        this.ensureURIs(resourceSet);
        try {
            return (CDOResource)resourceSet.getResource(uri, loadInDemand);
        }
        catch (RuntimeException ex) {
            resources = resourceSet.getResources();
            i = resources.size() - 1;
            ** while (i >= 0)
        }
lbl-1000:
        // 1 sources

        {
            resource = (Resource)resources.get(i);
            if (uri.equals((Object)resource.getURI())) {
                resources.remove(i);
                break;
            }
            --i;
            continue;
        }
lbl18:
        // 2 sources

        throw ex;
    }

    private void ensureURIs(ResourceSet resourceSet) {
        EList resources = resourceSet.getResources();
        Object[] resourceArr = null;
        int size = 0;
        do {
            int i = size;
            size = resources.size();
            if (size == 0) break;
            if (resourceArr == null || resourceArr.length < size) {
                resourceArr = new Resource[size * 2];
            }
            resourceArr = (Resource[])resources.toArray(resourceArr);
            while (i < size) {
                resourceArr[i].getURI();
                ++i;
            }
        } while (resources.size() > size);
    }

    @Override
    public synchronized List<CDOResourceNode> queryResources(CDOResourceFolder folder, String name, boolean exactMatch) {
        CDOQuery resourceQuery = this.createResourcesQuery(folder, name, exactMatch);
        return resourceQuery.getResult(CDOResourceNode.class);
    }

    @Override
    public synchronized CloseableIterator<CDOResourceNode> queryResourcesAsync(CDOResourceFolder folder, String name, boolean exactMatch) {
        CDOQuery resourceQuery = this.createResourcesQuery(folder, name, exactMatch);
        return resourceQuery.getResultAsync(CDOResourceNode.class);
    }

    private CDOQuery createResourcesQuery(CDOResourceFolder folder, String name, boolean exactMatch) {
        this.checkActive();
        CDOQueryImpl query = this.createQuery("resources", name);
        query.setParameter("folder", folder == null ? null : folder.cdoID());
        query.setParameter("exactMatch", exactMatch);
        return query;
    }

    @Override
    public synchronized List<CDOObjectReference> queryXRefs(CDOObject targetObject, EReference ... sourceReferences) {
        return this.queryXRefs(Collections.singleton(targetObject), sourceReferences);
    }

    @Override
    public synchronized List<CDOObjectReference> queryXRefs(Set<CDOObject> targetObjects, EReference ... sourceReferences) {
        CDOQuery xrefsQuery = this.createXRefsQuery(targetObjects, sourceReferences);
        return xrefsQuery.getResult(CDOObjectReference.class);
    }

    @Override
    public synchronized CloseableIterator<CDOObjectReference> queryXRefsAsync(Set<CDOObject> targetObjects, EReference ... sourceReferences) {
        CDOQuery xrefsQuery = this.createXRefsQuery(targetObjects, sourceReferences);
        return xrefsQuery.getResultAsync(CDOObjectReference.class);
    }

    private CDOQuery createXRefsQuery(Set<CDOObject> targetObjects, EReference ... sourceReferences) {
        this.checkActive();
        String string = this.createXRefsQueryString(targetObjects);
        CDOQueryImpl query = this.createQuery("xrefs", string);
        if (sourceReferences.length != 0) {
            string = this.createXRefsQueryParameter(sourceReferences);
            query.setParameter("sourceReferences", string);
        }
        return query;
    }

    private String createXRefsQueryString(Set<CDOObject> targetObjects) {
        StringBuilder builder = new StringBuilder();
        for (CDOObject target : targetObjects) {
            CDOID id = this.getXRefTargetID(target);
            if (this.isObjectNew(id)) {
                throw new IllegalArgumentException("Cross referencing for uncommitted new objects not supported " + target);
            }
            if (builder.length() != 0) {
                builder.append("|");
            }
            builder.append(id.toURIFragment());
            if (id instanceof CDOClassifierRef.Provider) continue;
            builder.append("|");
            CDOClassifierRef classifierRef = new CDOClassifierRef((EClassifier)target.eClass());
            builder.append(classifierRef.getURI());
        }
        return builder.toString();
    }

    private String createXRefsQueryParameter(EReference[] sourceReferences) {
        StringBuilder builder = new StringBuilder();
        EReference[] eReferenceArray = sourceReferences;
        int n = sourceReferences.length;
        int n2 = 0;
        while (n2 < n) {
            EReference sourceReference = eReferenceArray[n2];
            if (builder.length() != 0) {
                builder.append("|");
            }
            CDOClassifierRef classifierRef = new CDOClassifierRef((EClassifier)sourceReference.getEContainingClass());
            builder.append(classifierRef.getURI());
            builder.append("|");
            builder.append(sourceReference.getName());
            ++n2;
        }
        return builder.toString();
    }

    protected synchronized CDOID getXRefTargetID(CDOObject target) {
        if (FSMUtil.isTransient(target)) {
            throw new IllegalArgumentException("Cross referencing for transient objects not supported " + target);
        }
        return target.cdoID();
    }

    public synchronized CDOResourceImpl getResource(CDOID resourceID) {
        if (CDOIDUtil.isNull((CDOID)resourceID)) {
            throw new IllegalArgumentException("resourceID: " + resourceID);
        }
        return (CDOResourceImpl)this.getObject(resourceID);
    }

    public synchronized InternalCDOObject newInstance(EClass eClass) {
        EObject eObject = EcoreUtil.create((EClass)eClass);
        return FSMUtil.adapt(eObject, this);
    }

    public synchronized InternalCDORevision getRevision(CDOID id) {
        return this.getRevision(id, true);
    }

    @Override
    public synchronized InternalCDOObject getObject(CDOID id) {
        return this.getObject(id, true);
    }

    @Override
    public synchronized InternalCDOObject getObject(CDOID id, boolean loadOnDemand) {
        this.checkActive();
        if (CDOIDUtil.isNull((CDOID)id)) {
            return null;
        }
        if (this.rootResource != null && this.rootResource.cdoID().equals(id)) {
            return this.rootResource;
        }
        if (id.equals(this.lastLookupID)) {
            return this.lastLookupObject;
        }
        this.lastLookupID = null;
        this.lastLookupObject = null;
        InternalCDOObject localLookupObject = null;
        if (id.isExternal()) {
            URI uri = URI.createURI((String)((CDOIDExternal)id).getURI());
            ResourceSet resourceSet = this.getResourceSet();
            localLookupObject = (InternalCDOObject)CDOUtil.getCDOObject(resourceSet.getEObject(uri, loadOnDemand));
            if (localLookupObject == null) {
                if (!loadOnDemand) {
                    return null;
                }
                throw new ObjectNotFoundException(id, (CDOBranchPoint)this);
            }
        } else {
            localLookupObject = this.objects.get(id);
            if (localLookupObject == null) {
                if (!loadOnDemand) {
                    return null;
                }
                this.excludeNewObject(id);
                localLookupObject = this.createObject(id);
                if (!CDOModelUtil.isResource((EClass)localLookupObject.eClass())) {
                    this.registerObject(localLookupObject);
                } else if (id.equals(this.getSession().getRepositoryInfo().getRootResourceID())) {
                    this.setRootResource((CDOResourceImpl)localLookupObject);
                }
            }
        }
        this.lastLookupID = id;
        this.lastLookupObject = localLookupObject;
        return this.lastLookupObject;
    }

    protected synchronized void excludeNewObject(CDOID id) {
        if (this.isObjectNew(id)) {
            throw new ObjectNotFoundException(id, (CDOBranchPoint)this);
        }
    }

    @Override
    public boolean isObjectNew(CDOID id) {
        return id.isTemporary();
    }

    @Override
    public synchronized <T extends EObject> T getObject(T objectFromDifferentView) {
        this.checkActive();
        CDOObject object = CDOUtil.getCDOObject(objectFromDifferentView);
        CDOView view = object.cdoView();
        if (view != this) {
            if (!view.getSession().getRepositoryInfo().getUUID().equals(this.getSession().getRepositoryInfo().getUUID())) {
                throw new IllegalArgumentException(MessageFormat.format(Messages.getString("CDOViewImpl.11"), objectFromDifferentView));
            }
            CDOID id = object.cdoID();
            InternalCDOObject contextified = this.getObject(id, true);
            EObject cast = CDOUtil.getEObject(contextified);
            return (T)cast;
        }
        return objectFromDifferentView;
    }

    @Override
    public synchronized boolean isObjectRegistered(CDOID id) {
        this.checkActive();
        if (CDOIDUtil.isNull((CDOID)id)) {
            return false;
        }
        return this.objects.containsKey(id);
    }

    public synchronized InternalCDOObject removeObject(CDOID id) {
        if (id.equals(this.lastLookupID)) {
            this.lastLookupID = null;
            this.lastLookupObject = null;
        }
        return this.objects.remove(id);
    }

    private InternalCDOObject createObject(CDOID id) {
        InternalCDORevision revision;
        if (TRACER.isEnabled()) {
            TRACER.trace("Creating object for " + id);
        }
        if ((revision = this.getRevision(id, true)) == null) {
            throw new ObjectNotFoundException(id, (CDOBranchPoint)this);
        }
        EClass eClass = revision.getEClass();
        InternalCDOObject object = CDOModelUtil.isResource((EClass)eClass) && !id.equals(this.getSession().getRepositoryInfo().getRootResourceID()) ? (InternalCDOObject)((Object)this.newResourceInstance(revision)) : this.newInstance(eClass);
        this.cleanObject(object, revision);
        return object;
    }

    private CDOResource newResourceInstance(InternalCDORevision revision) {
        String path = this.getResourcePath(revision);
        URI uri = CDOURIUtil.createResourceURI(this, path);
        CDOResource resource1 = (CDOResource)this.getResourceSet().getResource(uri, false);
        String oldName = null;
        if (resource1 != null && !this.isReadOnly()) {
            oldName = resource1.getName();
            resource1.setName(String.valueOf(oldName) + ".renamed");
            OM.LOG.warn("URI clash: resource being instantiated had same URI as a resource already present locally; local resource was renamed from " + oldName + " to " + resource1.getName());
        }
        CDOResource resource2 = this.getResource(path, true);
        return resource2;
    }

    private String getResourcePath(InternalCDORevision revision) {
        EAttribute nameFeature = EresourcePackage.eINSTANCE.getCDOResourceNode_Name();
        CDOID folderID = (CDOID)revision.data().getContainerID();
        String name = (String)revision.data().get((EStructuralFeature)nameFeature, 0);
        if (CDOIDUtil.isNull((CDOID)folderID)) {
            if (name == null) {
                return CDOURIUtil.SEGMENT_SEPARATOR;
            }
            return name;
        }
        InternalCDOObject object = this.getObject(folderID, true);
        if (object instanceof CDOResourceFolder) {
            CDOResourceFolder folder = (CDOResourceFolder)((Object)object);
            String path = folder.getPath();
            return String.valueOf(path) + CDOURIUtil.SEGMENT_SEPARATOR + name;
        }
        throw new ImplementationError(MessageFormat.format(Messages.getString("CDOViewImpl.14"), object));
    }

    protected synchronized void cleanObject(InternalCDOObject object, InternalCDORevision revision) {
        object.cdoInternalSetView(this);
        object.cdoInternalSetRevision((CDORevision)revision);
        object.cdoInternalSetID(revision.getID());
        object.cdoInternalSetState(CDOState.CLEAN);
        object.cdoInternalPostLoad();
    }

    public synchronized CDOID provideCDOID(Object idOrObject) {
        Object shouldBeCDOID = this.convertObjectToID(idOrObject);
        if (shouldBeCDOID instanceof CDOID) {
            CDOID id = (CDOID)shouldBeCDOID;
            if (TRACER.isEnabled() && id != idOrObject) {
                TRACER.format("Converted object to CDOID: {0} --> {1}", new Object[]{idOrObject, id});
            }
            return id;
        }
        if (idOrObject instanceof InternalEObject) {
            InternalCDOObject object;
            InternalEObject eObject = (InternalEObject)idOrObject;
            if (eObject instanceof InternalCDOObject && (object = (InternalCDOObject)idOrObject).cdoView() != null && FSMUtil.isNew(object)) {
                String uri = EcoreUtil.getURI((EObject)eObject).toString();
                if (object.cdoID().isTemporary()) {
                    return CDOIDUtil.createTempObjectExternal((String)uri);
                }
                return CDOIDUtil.createExternal((String)uri);
            }
            Resource eResource = eObject.eResource();
            if (!(eResource == null || eResource instanceof CDOResource && ((CDOResource)eResource).cdoState() == CDOState.TRANSIENT)) {
                String uri = EcoreUtil.getURI((EObject)eObject).toString();
                return CDOIDUtil.createExternal((String)uri);
            }
            throw new DanglingReferenceException((EObject)eObject);
        }
        throw new IllegalStateException(MessageFormat.format(Messages.getString("CDOViewImpl.16"), idOrObject.getClass().getName()));
    }

    @Override
    public synchronized Object convertObjectToID(Object potentialObject) {
        return this.convertObjectToID(potentialObject, false);
    }

    @Override
    public synchronized Object convertObjectToID(Object potentialObject, boolean onlyPersistedID) {
        if (potentialObject instanceof CDOID) {
            return potentialObject;
        }
        if (potentialObject instanceof InternalEObject) {
            if (potentialObject instanceof InternalCDOObject) {
                InternalCDOObject object = (InternalCDOObject)potentialObject;
                CDOID id = this.getID(object, onlyPersistedID);
                if (id != null) {
                    return id;
                }
            } else {
                InternalCDOObject object = (InternalCDOObject)EcoreUtil.getAdapter((List)((InternalEObject)potentialObject).eAdapters(), CDOLegacyAdapter.class);
                if (object != null) {
                    CDOID id = this.getID(object, onlyPersistedID);
                    if (id != null) {
                        return id;
                    }
                    potentialObject = object;
                }
            }
        }
        return potentialObject;
    }

    protected synchronized CDOID getID(InternalCDOObject object, boolean onlyPersistedID) {
        if (onlyPersistedID && (FSMUtil.isTransient(object) || FSMUtil.isNew(object))) {
            return null;
        }
        InternalCDOView view = object.cdoView();
        if (view == this) {
            return object.cdoID();
        }
        if (view != null && view.getSession() == this.getSession()) {
            boolean sameTarget;
            boolean bl = sameTarget = view.getBranch().equals(this.getBranch()) && view.getTimeStamp() == this.getTimeStamp();
            if (sameTarget) {
                return object.cdoID();
            }
            throw new IllegalArgumentException("Object " + object + " is managed by a view with different target: " + view);
        }
        return null;
    }

    @Override
    public synchronized Object convertIDToObject(Object potentialID) {
        if (potentialID instanceof CDOID) {
            if (potentialID == CDOID.NULL) {
                return null;
            }
            CDOID id = (CDOID)potentialID;
            if (id.isExternal()) {
                return this.getResourceSet().getEObject(URI.createURI((String)id.toURIFragment()), true);
            }
            InternalCDOObject result = this.getObject(id, true);
            if (result == null) {
                throw new ImplementationError(MessageFormat.format(Messages.getString("CDOViewImpl.17"), id));
            }
            return result.cdoInternalInstance();
        }
        return potentialID;
    }

    @Override
    public synchronized void attachResource(CDOResourceImpl resource) {
        if (!resource.isExisting()) {
            throw new ReadOnlyException(MessageFormat.format(Messages.getString("CDOViewImpl.18"), this));
        }
        resource.cdoInternalSetView(this);
        resource.cdoInternalSetState(CDOState.PROXY);
    }

    @Override
    public synchronized void registerProxyResource(CDOResourceImpl resource) {
        URI uri = resource.getURI();
        String path = CDOURIUtil.extractResourcePath(uri);
        boolean isRoot = "/".equals(path);
        try {
            CDOID id = isRoot ? this.getSession().getRepositoryInfo().getRootResourceID() : this.getResourceNodeID(path);
            resource.cdoInternalSetID(id);
            this.registerObject(resource);
            if (isRoot) {
                resource.setRoot(true);
                this.rootResource = resource;
            }
        }
        catch (Exception ex) {
            throw new InvalidURIException(uri, ex);
        }
    }

    @Override
    public synchronized void registerObject(InternalCDOObject object) {
        InternalCDOObject old;
        if (TRACER.isEnabled()) {
            TRACER.format("Registering {0}", new Object[]{object});
        }
        if ((old = this.objects.put(object.cdoID(), object)) != null) {
            if (old != object) {
                throw new IllegalStateException(MessageFormat.format(Messages.getString("CDOViewImpl.30"), object.cdoID()));
            }
            if (TRACER.isEnabled()) {
                TRACER.format(Messages.getString("CDOViewImpl.20"), new Object[]{old});
            }
        }
    }

    @Override
    public synchronized void deregisterObject(InternalCDOObject object) {
        if (TRACER.isEnabled()) {
            TRACER.format("Deregistering {0}", new Object[]{object});
        }
        this.removeObject(object.cdoID());
    }

    @Override
    public synchronized void remapObject(CDOID oldID) {
        InternalCDOObject object = this.objects.remove(oldID);
        CDOID newID = object.cdoID();
        this.objects.put(newID, object);
        if (this.lastLookupID == oldID) {
            this.lastLookupID = null;
            this.lastLookupObject = null;
        }
        if (TRACER.isEnabled()) {
            TRACER.format("Remapping {0} --> {1}", new Object[]{oldID, newID});
        }
    }

    @Override
    public void addObjectHandler(CDOObjectHandler handler) {
        this.objectHandlers.add((Object)handler);
    }

    @Override
    public void removeObjectHandler(CDOObjectHandler handler) {
        this.objectHandlers.remove((Object)handler);
    }

    @Override
    public CDOObjectHandler[] getObjectHandlers() {
        return (CDOObjectHandler[])this.objectHandlers.get();
    }

    @Override
    public synchronized void handleObjectStateChanged(InternalCDOObject object, CDOState oldState, CDOState newState) {
        CDOObjectHandler[] handlers = this.getObjectHandlers();
        int i = 0;
        while (i < handlers.length) {
            CDOObjectHandler handler = handlers[i];
            handler.objectStateChanged(this, object, oldState, newState);
            ++i;
        }
    }

    protected Map<CDOObject, Pair<CDORevision, CDORevisionDelta>> invalidate(long lastUpdateTime, List<CDORevisionKey> allChangedObjects, List<CDOIDAndVersion> allDetachedObjects, List<CDORevisionDelta> deltas, Map<CDOObject, CDORevisionDelta> revisionDeltas, Set<CDOObject> detachedObjects) {
        HashMap<InternalCDOObject, Pair> conflicts = null;
        for (CDORevisionKey cDORevisionKey : allChangedObjects) {
            CDOObject changedObject;
            CDORevisionDelta delta = null;
            if (cDORevisionKey instanceof CDORevisionDelta) {
                delta = (CDORevisionDelta)cDORevisionKey;
                if (this instanceof CDOTransaction) {
                    delta = new CDORevisionDeltaImpl(delta, true);
                }
                deltas.add(delta);
            }
            if ((changedObject = (CDOObject)this.objects.get(cDORevisionKey.getID())) == null) continue;
            Pair oldInfo = new Pair((Object)changedObject.cdoRevision(), (Object)delta);
            CDOStateMachine.INSTANCE.invalidate((InternalCDOObject)changedObject, cDORevisionKey, lastUpdateTime);
            revisionDeltas.put(changedObject, delta);
            if (!changedObject.cdoConflict()) continue;
            if (conflicts == null) {
                conflicts = new HashMap();
            }
            conflicts.put((InternalCDOObject)changedObject, oldInfo);
        }
        for (CDOIDAndVersion cDOIDAndVersion : allDetachedObjects) {
            InternalCDOObject detachedObject = this.removeObject(cDOIDAndVersion.getID());
            if (detachedObject == null) continue;
            Pair oldInfo = new Pair((Object)detachedObject.cdoRevision(), (Object)CDORevisionDelta.DETACHED);
            CDOStateMachine.INSTANCE.detachRemote(detachedObject);
            detachedObjects.add(detachedObject);
            if (!detachedObject.cdoConflict()) continue;
            if (conflicts == null) {
                conflicts = new HashMap<InternalCDOObject, Pair>();
            }
            conflicts.put(detachedObject, oldInfo);
        }
        return conflicts;
    }

    protected synchronized void handleConflicts(Map<CDOObject, Pair<CDORevision, CDORevisionDelta>> conflicts, List<CDORevisionDelta> deltas) {
    }

    public void fireAdaptersNotifiedEvent(long timeStamp) {
        this.fireEvent(new AdaptersNotifiedEvent(timeStamp));
    }

    private boolean isLocked(InternalCDOObject object) {
        if (object.cdoWriteLock().isLocked()) {
            return true;
        }
        return object.cdoReadLock().isLocked();
    }

    @Override
    public synchronized int reload(CDOObject ... objects) {
        ArrayList<InternalCDOObject> internalObjects;
        if (objects != null && objects.length != 0) {
            internalObjects = new ArrayList(objects.length);
            CDOObject[] cDOObjectArray = objects;
            int n = objects.length;
            int n2 = 0;
            while (n2 < n) {
                CDOObject object = cDOObjectArray[n2];
                if (object instanceof InternalCDOObject) {
                    internalObjects.add((InternalCDOObject)object);
                }
                ++n2;
            }
        } else {
            internalObjects = new ArrayList<InternalCDOObject>(this.objects.values());
        }
        int result = internalObjects.size();
        if (result != 0) {
            CDOStateMachine.INSTANCE.reload(internalObjects.toArray(new InternalCDOObject[result]));
        }
        return result;
    }

    public void close() {
        LifecycleUtil.deactivate((Object)this, (OMLogger.Level)OMLogger.Level.DEBUG);
    }

    public boolean isClosed() {
        return !this.isActive();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        if (this.isReadOnly()) {
            builder.append("View");
        } else {
            builder.append("Transaction");
        }
        builder.append(" ");
        builder.append(this.getViewID());
        if (this.branchPoint != null) {
            long timeStamp;
            boolean brackets = false;
            if (this.getSession().getRepositoryInfo().isSupportingBranches()) {
                brackets = true;
                builder.append(" [");
                builder.append(this.branchPoint.getBranch().getPathName());
            }
            if ((timeStamp = this.branchPoint.getTimeStamp()) != 0L) {
                if (brackets) {
                    builder.append(", ");
                } else {
                    builder.append(" [");
                    brackets = true;
                }
                builder.append(CDOCommonUtil.formatTimeStamp((long)timeStamp));
            }
            if (brackets) {
                builder.append("]");
            }
        }
        return builder.toString();
    }

    protected String getClassName() {
        return "CDOView";
    }

    public boolean isAdapterForType(Object type) {
        return type instanceof ResourceSet;
    }

    public Notifier getTarget() {
        return this.getResourceSet();
    }

    @Override
    public synchronized void collectViewedRevisions(Map<CDOID, InternalCDORevision> revisions) {
        for (InternalCDOObject object : this.objects.values()) {
            InternalCDORevision revision;
            CDOID id;
            CDOState state = object.cdoState();
            if (state != CDOState.CLEAN && state != CDOState.DIRTY && state != CDOState.CONFLICT || revisions.containsKey(id = object.cdoID()) || (revision = this.getViewedRevision(object)) == null) continue;
            revisions.put(id, revision);
        }
    }

    protected InternalCDORevision getViewedRevision(InternalCDOObject object) {
        return CDOStateMachine.INSTANCE.readNoLoad(object);
    }

    @Override
    public synchronized CDOChangeSetData compareRevisions(CDOBranchPoint source) {
        InternalCDOSession session = this.getSession();
        return session.compareRevisions(source, (CDOBranchPoint)this);
    }

    protected void doDeactivate() throws Exception {
        this.viewSet = null;
        this.objects = null;
        this.store = null;
        this.lastLookupID = null;
        this.lastLookupObject = null;
        super.doDeactivate();
    }

    private final class AdaptersNotifiedEvent
    extends Event
    implements CDOViewAdaptersNotifiedEvent {
        private static final long serialVersionUID = 1L;
        private long timeStamp;

        public AdaptersNotifiedEvent(long timeStamp) {
            this.timeStamp = timeStamp;
        }

        public long getTimeStamp() {
            return this.timeStamp;
        }

        public String toString() {
            return "CDOViewAdaptersNotifiedEvent: " + this.timeStamp;
        }
    }

    protected abstract class Event
    extends org.eclipse.net4j.util.event.Event
    implements CDOViewEvent {
        private static final long serialVersionUID = 1L;

        public Event() {
            super((INotifier)AbstractCDOView.this);
        }

        public AbstractCDOView getSource() {
            return (AbstractCDOView)super.getSource();
        }
    }

    private final class ViewTargetChangedEvent
    extends Event
    implements CDOViewTargetChangedEvent {
        private static final long serialVersionUID = 1L;
        private CDOBranchPoint branchPoint;

        public ViewTargetChangedEvent(CDOBranchPoint branchPoint) {
            this.branchPoint = CDOBranchUtil.copyBranchPoint((CDOBranchPoint)branchPoint);
        }

        public String toString() {
            return MessageFormat.format("CDOViewTargetChangedEvent: {0}", this.branchPoint);
        }

        public CDOBranchPoint getBranchPoint() {
            return this.branchPoint;
        }
    }
}

