/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.internal.cdo.view;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import org.eclipse.emf.cdo.CDOState;
import org.eclipse.emf.cdo.common.util.CDOException;
import org.eclipse.emf.cdo.eresource.CDOResource;
import org.eclipse.emf.cdo.eresource.CDOResourceFactory;
import org.eclipse.emf.cdo.view.CDOView;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.notify.impl.NotificationImpl;
import org.eclipse.emf.common.notify.impl.NotifierImpl;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.internal.cdo.messages.Messages;
import org.eclipse.emf.internal.cdo.view.CDOViewSetPackageRegistryImpl;
import org.eclipse.emf.spi.cdo.InternalCDOObject;
import org.eclipse.emf.spi.cdo.InternalCDOView;
import org.eclipse.emf.spi.cdo.InternalCDOViewSet;
import org.eclipse.net4j.util.WrappedException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CDOViewSetImpl
extends NotifierImpl
implements InternalCDOViewSet {
    private Set<InternalCDOView> views = new HashSet<InternalCDOView>();
    private Map<String, InternalCDOView> mapOfViews = new HashMap<String, InternalCDOView>();
    private CDOResourceFactory resourceFactory = CDOResourceFactory.INSTANCE;
    private CDOViewSetPackageRegistryImpl packageRegistry;
    private ResourceSet resourceSet;
    private ThreadLocal<Boolean> ignoreNotifications = new InheritableThreadLocal<Boolean>();

    @Override
    public ResourceSet getResourceSet() {
        return this.resourceSet;
    }

    @Override
    public EPackage.Registry getPackageRegistry() {
        return this.packageRegistry;
    }

    @Override
    public CDOResourceFactory getResourceFactory() {
        return this.resourceFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CDOView[] getViews() {
        Set<InternalCDOView> set = this.views;
        synchronized (set) {
            return this.views.toArray(new CDOView[this.views.size()]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InternalCDOView resolveView(String repositoryUUID) {
        InternalCDOView view;
        block7: {
            view = null;
            Set<InternalCDOView> set = this.views;
            synchronized (set) {
                block6: {
                    view = this.mapOfViews.get(repositoryUUID);
                    if (view != null) break block7;
                    if (repositoryUUID != null) {
                        throw new IllegalArgumentException(MessageFormat.format(Messages.getString("CDOViewSetImpl.0"), repositoryUUID));
                    }
                    if (this.mapOfViews.size() == 1) {
                        return this.views.iterator().next();
                    }
                    if (this.mapOfViews.size() != 0) break block6;
                    return null;
                }
                throw new IllegalStateException(Messages.getString("CDOViewSetImpl.1"));
            }
        }
        return view;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InternalCDOView getView(String repositoryUUID) {
        Set<InternalCDOView> set = this.views;
        synchronized (set) {
            return this.mapOfViews.get(repositoryUUID);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void add(InternalCDOView view) {
        String repositoryUUID = view.getSession().getRepositoryInfo().getUUID();
        Set<InternalCDOView> set = this.views;
        synchronized (set) {
            CDOView lookupView = this.mapOfViews.get(repositoryUUID);
            if (lookupView != null) {
                throw new RuntimeException(Messages.getString("CDOViewSetImpl.2"));
            }
            this.views.add(view);
            this.mapOfViews.put(repositoryUUID, view);
        }
        if (this.eNotificationRequired()) {
            NotificationImpl notification = new NotificationImpl(3, null, (Object)view);
            this.eNotify((Notification)notification);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void remove(InternalCDOView view) {
        String repositoryUUID = view.getSession().getRepositoryInfo().getUUID();
        ArrayList<Resource> resToRemove = new ArrayList<Resource>();
        Set<InternalCDOView> set = this.views;
        synchronized (set) {
            this.views.remove(view);
            this.mapOfViews.remove(repositoryUUID);
            for (Resource resource : this.getResourceSet().getResources()) {
                CDOResource cdoRes;
                if (!(resource instanceof CDOResource) || (cdoRes = (CDOResource)resource).cdoView() != view) continue;
                resToRemove.add(resource);
            }
        }
        this.getResourceSet().getResources().removeAll(resToRemove);
        if (this.eNotificationRequired()) {
            NotificationImpl notification = new NotificationImpl(4, (Object)view, null);
            this.eNotify((Notification)notification);
        }
    }

    public Notifier getTarget() {
        return this.resourceSet;
    }

    public void setTarget(Notifier newTarget) {
        if (!this.isAdapterForType(newTarget)) {
            throw new IllegalArgumentException(MessageFormat.format(Messages.getString("CDOViewSetImpl.3"), newTarget));
        }
        if (this.resourceSet != null) {
            throw new IllegalStateException(Messages.getString("CDOViewSetImpl.4"));
        }
        this.resourceSet = (ResourceSet)newTarget;
        EPackage.Registry oldPackageRegistry = this.resourceSet.getPackageRegistry();
        this.packageRegistry = new CDOViewSetPackageRegistryImpl(this, oldPackageRegistry);
        this.resourceSet.setPackageRegistry((EPackage.Registry)this.packageRegistry);
        Resource.Factory.Registry registry = this.resourceSet.getResourceFactoryRegistry();
        Map map = registry.getProtocolToFactoryMap();
        map.put("cdo", this.getResourceFactory());
    }

    public boolean isAdapterForType(Object type) {
        return type instanceof ResourceSet;
    }

    @Override
    public synchronized <V> V executeWithoutNotificationHandling(Callable<V> callable) {
        Boolean wasIgnore = this.ignoreNotifications.get();
        try {
            this.ignoreNotifications.set(true);
            V v = callable.call();
            return v;
        }
        catch (Exception ex) {
            throw WrappedException.wrap((Exception)ex);
        }
        finally {
            if (wasIgnore == null) {
                this.ignoreNotifications.remove();
            }
        }
    }

    public void notifyChanged(Notification notification) {
        if (this.ignoreNotifications.get() == null) {
            switch (notification.getEventType()) {
                case 6: {
                    this.deregisterResources((List)notification.getOldValue());
                    break;
                }
                case 4: {
                    this.deregisterResources(Collections.singleton(notification.getOldValue()));
                }
            }
        }
    }

    private void deregisterResources(Collection<?> potentialResources) {
        ArrayList<CDOResource> allDirtyResources = new ArrayList<CDOResource>();
        try {
            Map<CDOView, List<CDOResource>> resourcesPerView = this.getResourcesPerView(potentialResources);
            for (Map.Entry<CDOView, List<CDOResource>> entry : resourcesPerView.entrySet()) {
                List<CDOResource> dirtyResources;
                InternalCDOView view = (InternalCDOView)entry.getKey();
                List<CDOResource> resources = entry.getValue();
                if (view.isDirty() && !(dirtyResources = this.getDirtyResources(resources)).isEmpty()) {
                    allDirtyResources.addAll(dirtyResources);
                    this.resourceSet.getResources().addAll(resources);
                    continue;
                }
                for (CDOResource resource : resources) {
                    InternalCDOObject internalResource = (InternalCDOObject)((Object)resource);
                    view.deregisterObject(internalResource);
                    internalResource.cdoInternalSetState(CDOState.INVALID);
                }
            }
        }
        finally {
            int size = allDirtyResources.size();
            if (size == 1) {
                throw new CDOException("Attempt to remove a dirty resource from a resource set: " + allDirtyResources.get(0));
            }
            if (size > 1) {
                throw new CDOException("Attempt to remove dirty resources from a resource set: " + allDirtyResources);
            }
        }
    }

    private List<CDOResource> getDirtyResources(List<CDOResource> resources) {
        ArrayList<CDOResource> dirtyResources = new ArrayList<CDOResource>();
        for (CDOResource resource : resources) {
            switch (resource.cdoState()) {
                case NEW: 
                case DIRTY: 
                case CONFLICT: 
                case INVALID_CONFLICT: {
                    dirtyResources.addAll(resources);
                }
            }
        }
        return dirtyResources;
    }

    private Map<CDOView, List<CDOResource>> getResourcesPerView(Collection<?> potentialResources) {
        HashMap<CDOView, List<CDOResource>> resourcesPerView = new HashMap<CDOView, List<CDOResource>>();
        for (Object potentialResource : potentialResources) {
            CDOResource resource;
            CDOView view;
            if (!(potentialResource instanceof CDOResource) || !this.views.contains(view = (resource = (CDOResource)potentialResource).cdoView())) continue;
            ArrayList<CDOResource> resources = (ArrayList<CDOResource>)resourcesPerView.get(view);
            if (resources == null) {
                resources = new ArrayList<CDOResource>();
                resourcesPerView.put(view, resources);
            }
            resources.add(resource);
        }
        return resourcesPerView;
    }
}

