/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.spi.cdo;

import java.text.MessageFormat;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.cdo.common.commit.CDOChangeSet;
import org.eclipse.emf.cdo.common.commit.CDOChangeSetData;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.id.CDOIDUtil;
import org.eclipse.emf.cdo.common.revision.CDOIDAndVersion;
import org.eclipse.emf.cdo.common.revision.CDORevision;
import org.eclipse.emf.cdo.common.revision.delta.CDOAddFeatureDelta;
import org.eclipse.emf.cdo.common.revision.delta.CDOFeatureDelta;
import org.eclipse.emf.cdo.common.revision.delta.CDOListFeatureDelta;
import org.eclipse.emf.cdo.common.revision.delta.CDOMoveFeatureDelta;
import org.eclipse.emf.cdo.common.revision.delta.CDORemoveFeatureDelta;
import org.eclipse.emf.cdo.common.revision.delta.CDORevisionDelta;
import org.eclipse.emf.cdo.internal.common.commit.CDOChangeSetDataImpl;
import org.eclipse.emf.cdo.internal.common.revision.delta.CDOListFeatureDeltaImpl;
import org.eclipse.emf.cdo.internal.common.revision.delta.CDORevisionDeltaImpl;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDOFeatureDelta;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDORevisionDelta;
import org.eclipse.emf.cdo.transaction.CDOMerger;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.net4j.util.collection.Pair;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultCDOMerger
implements CDOMerger {
    private CDOChangeSetData result;
    private Map<CDOID, Conflict> conflicts;
    private Map<CDOID, Object> targetMap;
    private Map<CDOID, Object> sourceMap;

    public CDOChangeSetData getResult() {
        return this.result;
    }

    public Map<CDOID, Conflict> getConflicts() {
        return this.conflicts;
    }

    @Override
    public synchronized CDOChangeSetData merge(CDOChangeSet target, CDOChangeSet source) throws CDOMerger.ConflictException {
        CDOID id;
        this.result = new CDOChangeSetDataImpl();
        this.conflicts = new HashMap<CDOID, Conflict>();
        this.targetMap = this.createMap((CDOChangeSetData)target);
        this.sourceMap = this.createMap((CDOChangeSetData)source);
        HashSet<CDOID> taken = new HashSet<CDOID>();
        for (Map.Entry<CDOID, Object> entry : this.targetMap.entrySet()) {
            Object sourceData;
            id = entry.getKey();
            Object targetData = entry.getValue();
            if (!this.merge(targetData, sourceData = this.sourceMap.get(id))) continue;
            taken.add(id);
        }
        for (Map.Entry<CDOID, Object> entry : this.sourceMap.entrySet()) {
            id = entry.getKey();
            if (!taken.add(id)) continue;
            Object sourceData = entry.getValue();
            Object targetData = this.targetMap.get(id);
            this.merge(targetData, sourceData);
        }
        if (!this.conflicts.isEmpty()) {
            throw new CDOMerger.ConflictException("Merger could not resolve all conflicts: " + this.conflicts, this, this.result);
        }
        return this.result;
    }

    protected boolean merge(Object targetData, Object sourceData) {
        Object data = null;
        if (sourceData == null) {
            if (targetData instanceof CDORevision) {
                data = this.addedInTarget((CDORevision)targetData);
            } else if (targetData instanceof CDORevisionDelta) {
                data = this.changedInTarget((CDORevisionDelta)targetData);
            } else if (targetData instanceof CDOID) {
                data = this.detachedInTarget((CDOID)targetData);
            }
        } else if (targetData == null) {
            if (sourceData instanceof CDORevision) {
                data = this.addedInSource((CDORevision)sourceData);
            } else if (sourceData instanceof CDORevisionDelta) {
                data = this.changedInSource((CDORevisionDelta)sourceData);
            } else if (sourceData instanceof CDOID) {
                data = this.detachedInSource((CDOID)sourceData);
            }
        } else if (sourceData instanceof CDOID && targetData instanceof CDOID) {
            data = this.detachedInSourceAndTarget((CDOID)sourceData);
        } else if (sourceData instanceof CDORevisionDelta && targetData instanceof CDORevisionDelta) {
            data = this.changedInSourceAndTarget((CDORevisionDelta)targetData, (CDORevisionDelta)sourceData);
        } else if (sourceData instanceof CDORevision && targetData instanceof CDORevision) {
            data = this.addedInSourceAndTarget((CDORevision)targetData, (CDORevision)sourceData);
        } else if (sourceData instanceof CDORevisionDelta && targetData instanceof CDOID) {
            data = this.changedInSourceAndDetachedInTarget((CDORevisionDelta)sourceData);
        } else if (targetData instanceof CDORevisionDelta && sourceData instanceof CDOID) {
            data = this.changedInTargetAndDetachedInSource((CDORevisionDelta)targetData);
        }
        return this.take(data);
    }

    protected Object addedInTarget(CDORevision revision) {
        return revision;
    }

    protected Object addedInSource(CDORevision revision) {
        return revision;
    }

    protected Object addedInSourceAndTarget(CDORevision targetRevision, CDORevision sourceRevision) {
        return targetRevision;
    }

    protected Object changedInTarget(CDORevisionDelta delta) {
        return delta;
    }

    protected Object detachedInTarget(CDOID id) {
        return id;
    }

    protected Object changedInSource(CDORevisionDelta delta) {
        return delta;
    }

    protected Object detachedInSource(CDOID id) {
        return id;
    }

    protected Object detachedInSourceAndTarget(CDOID id) {
        return id;
    }

    protected Object changedInSourceAndTarget(CDORevisionDelta targetDelta, CDORevisionDelta sourceDelta) {
        return new ChangedInSourceAndTargetConflict(targetDelta, sourceDelta);
    }

    protected Object changedInSourceAndDetachedInTarget(CDORevisionDelta sourceDelta) {
        return new ChangedInSourceAndDetachedInTargetConflict(sourceDelta);
    }

    protected Object changedInTargetAndDetachedInSource(CDORevisionDelta targetDelta) {
        return new ChangedInTargetAndDetachedInSourceConflict(targetDelta);
    }

    protected Map<CDOID, Object> getTargetMap() {
        return this.targetMap;
    }

    protected Map<CDOID, Object> getSourceMap() {
        return this.sourceMap;
    }

    private Map<CDOID, Object> createMap(CDOChangeSetData changeSetData) {
        HashMap<CDOID, Object> map = new HashMap<CDOID, Object>();
        for (CDOIDAndVersion data : changeSetData.getNewObjects()) {
            map.put(data.getID(), data);
        }
        for (CDOIDAndVersion data : changeSetData.getChangedObjects()) {
            map.put(data.getID(), data);
        }
        for (CDOIDAndVersion data : changeSetData.getDetachedObjects()) {
            map.put(data.getID(), data.getID());
        }
        return map;
    }

    private boolean take(Object data) {
        if (data instanceof Pair) {
            Pair pair = (Pair)data;
            boolean taken = this.takeNoPair(pair.getElement1());
            return taken |= this.takeNoPair(pair.getElement2());
        }
        return this.takeNoPair(data);
    }

    private boolean takeNoPair(Object data) {
        if (data instanceof CDORevision) {
            this.result.getNewObjects().add((CDORevision)data);
        } else if (data instanceof CDORevisionDelta) {
            this.result.getChangedObjects().add((CDORevisionDelta)data);
        } else if (data instanceof CDOID) {
            this.result.getDetachedObjects().add(CDOIDUtil.createIDAndVersion((CDOID)((CDOID)data), (int)0));
        } else if (data instanceof Conflict) {
            Conflict conflict = (Conflict)data;
            this.conflicts.put(conflict.getID(), conflict);
        } else {
            if (data != null) {
                throw new IllegalArgumentException("Must be a CDORevision, a CDORevisionDelta, a CDOID, a Conflict or null: " + data);
            }
            return false;
        }
        return true;
    }

    public static class ChangedInSourceAndDetachedInTargetConflict
    extends Conflict {
        private CDORevisionDelta sourceDelta;

        public ChangedInSourceAndDetachedInTargetConflict(CDORevisionDelta sourceDelta) {
            this.sourceDelta = sourceDelta;
        }

        public CDOID getID() {
            return this.sourceDelta.getID();
        }

        public CDORevisionDelta getSourceDelta() {
            return this.sourceDelta;
        }

        public String toString() {
            return MessageFormat.format("ChangedInSourceAndDetachedInTarget[source={1}]", this.sourceDelta);
        }
    }

    public static class ChangedInSourceAndTargetConflict
    extends Conflict {
        private CDORevisionDelta targetDelta;
        private CDORevisionDelta sourceDelta;

        public ChangedInSourceAndTargetConflict(CDORevisionDelta targetDelta, CDORevisionDelta sourceDelta) {
            this.targetDelta = targetDelta;
            this.sourceDelta = sourceDelta;
        }

        public CDOID getID() {
            return this.targetDelta.getID();
        }

        public CDORevisionDelta getTargetDelta() {
            return this.targetDelta;
        }

        public CDORevisionDelta getSourceDelta() {
            return this.sourceDelta;
        }

        public String toString() {
            return MessageFormat.format("ChangedInSourceAndTarget[target={0}, source={1}]", this.targetDelta, this.sourceDelta);
        }
    }

    public static class ChangedInTargetAndDetachedInSourceConflict
    extends Conflict {
        private CDORevisionDelta targetDelta;

        public ChangedInTargetAndDetachedInSourceConflict(CDORevisionDelta targetDelta) {
            this.targetDelta = targetDelta;
        }

        public CDOID getID() {
            return this.targetDelta.getID();
        }

        public CDORevisionDelta getTargetDelta() {
            return this.targetDelta;
        }

        public String toString() {
            return MessageFormat.format("ChangedInTargetAndDetachedInSource[target={0}]", this.targetDelta);
        }
    }

    public static abstract class Conflict {
        public abstract CDOID getID();
    }

    public static class PerFeature
    extends DefaultCDOMerger {
        protected Object changedInSourceAndTarget(CDORevisionDelta targetDelta, CDORevisionDelta sourceDelta) {
            CDOFeatureDelta featureDelta;
            EStructuralFeature feature;
            CDORevisionDeltaImpl result = new CDORevisionDeltaImpl(targetDelta, false);
            ChangedInSourceAndTargetConflict conflict = null;
            Map targetMap = ((InternalCDORevisionDelta)targetDelta).getFeatureDeltaMap();
            Map sourceMap = ((InternalCDORevisionDelta)sourceDelta).getFeatureDeltaMap();
            for (CDOFeatureDelta targetFeatureDelta : targetMap.values()) {
                feature = targetFeatureDelta.getFeature();
                CDOFeatureDelta sourceFeatureDelta = (CDOFeatureDelta)sourceMap.get(feature);
                if (sourceFeatureDelta == null) {
                    featureDelta = this.changedInTarget(targetFeatureDelta);
                    if (featureDelta == null) continue;
                    result.addFeatureDelta(featureDelta);
                    continue;
                }
                featureDelta = this.changedInSourceAndTarget(targetFeatureDelta, sourceFeatureDelta);
                if (featureDelta != null) {
                    result.addFeatureDelta(featureDelta);
                    continue;
                }
                if (conflict == null) {
                    conflict = new ChangedInSourceAndTargetConflict((CDORevisionDelta)new CDORevisionDeltaImpl(targetDelta, false), (CDORevisionDelta)new CDORevisionDeltaImpl(sourceDelta, false));
                }
                ((InternalCDORevisionDelta)conflict.getTargetDelta()).addFeatureDelta(targetFeatureDelta);
                ((InternalCDORevisionDelta)conflict.getSourceDelta()).addFeatureDelta(sourceFeatureDelta);
            }
            for (CDOFeatureDelta sourceFeatureDelta : sourceMap.values()) {
                feature = sourceFeatureDelta.getFeature();
                CDOFeatureDelta targetFeatureDelta = (CDOFeatureDelta)targetMap.get(feature);
                if (targetFeatureDelta != null || (featureDelta = this.changedInSource(sourceFeatureDelta)) == null) continue;
                result.addFeatureDelta(featureDelta);
            }
            if (result.isEmpty()) {
                return conflict;
            }
            if (conflict != null) {
                return new Pair((Object)result, conflict);
            }
            return result;
        }

        protected CDOFeatureDelta changedInTarget(CDOFeatureDelta featureDelta) {
            return featureDelta;
        }

        protected CDOFeatureDelta changedInSource(CDOFeatureDelta featureDelta) {
            return featureDelta;
        }

        protected CDOFeatureDelta changedInSourceAndTarget(CDOFeatureDelta targetFeatureDelta, CDOFeatureDelta sourceFeatureDelta) {
            EStructuralFeature feature = targetFeatureDelta.getFeature();
            if (feature.isMany()) {
                return this.changedInSourceAndTargetManyValued(feature, targetFeatureDelta, sourceFeatureDelta);
            }
            return this.changedInSourceAndTargetSingleValued(feature, targetFeatureDelta, sourceFeatureDelta);
        }

        protected CDOFeatureDelta changedInSourceAndTargetManyValued(EStructuralFeature feature, CDOFeatureDelta targetFeatureDelta, CDOFeatureDelta sourceFeatureDelta) {
            return null;
        }

        protected CDOFeatureDelta changedInSourceAndTargetSingleValued(EStructuralFeature feature, CDOFeatureDelta targetFeatureDelta, CDOFeatureDelta sourceFeatureDelta) {
            if (targetFeatureDelta.isStructurallyEqual((Object)sourceFeatureDelta)) {
                return targetFeatureDelta;
            }
            return null;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static class ManyValued
        extends PerFeature {
            @Override
            protected CDOFeatureDelta changedInSourceAndTargetManyValued(EStructuralFeature feature, CDOFeatureDelta targetFeatureDelta, CDOFeatureDelta sourceFeatureDelta) {
                if (targetFeatureDelta instanceof CDOListFeatureDelta && sourceFeatureDelta instanceof CDOListFeatureDelta) {
                    CDOListFeatureDelta targetListDelta = (CDOListFeatureDelta)targetFeatureDelta.copy();
                    CDOListFeatureDelta sourceListDelta = (CDOListFeatureDelta)sourceFeatureDelta.copy();
                    CDOListFeatureDelta result = this.createResult(feature);
                    List resultChanges = result.getListChanges();
                    List targetChanges = targetListDelta.getListChanges();
                    List sourceChanges = sourceListDelta.getListChanges();
                    this.handleListDelta(resultChanges, targetChanges, sourceChanges);
                    this.handleListDelta(resultChanges, sourceChanges, null);
                    return result;
                }
                return super.changedInSourceAndTargetManyValued(feature, targetFeatureDelta, sourceFeatureDelta);
            }

            protected CDOListFeatureDelta createResult(EStructuralFeature feature) {
                return new CDOListFeatureDeltaImpl(feature);
            }

            protected void handleListDelta(List<CDOFeatureDelta> resultList, List<CDOFeatureDelta> listToHandle, List<CDOFeatureDelta> listToAdjust) {
                for (CDOFeatureDelta deltaToHandle : listToHandle) {
                    if (deltaToHandle instanceof CDOAddFeatureDelta) {
                        if (this.handleListDeltaAdd(resultList, (CDOAddFeatureDelta)deltaToHandle, listToAdjust) || listToAdjust != null) continue;
                        ManyValued.adjustAfterRemoval(listToHandle, 0);
                        continue;
                    }
                    if (deltaToHandle instanceof CDORemoveFeatureDelta) {
                        if (this.handleListDeltaRemove(resultList, (CDORemoveFeatureDelta)deltaToHandle, listToAdjust) || listToAdjust != null) continue;
                        ManyValued.adjustAfterAddition(listToHandle, 0);
                        continue;
                    }
                    if (deltaToHandle instanceof CDOMoveFeatureDelta) {
                        this.handleListDeltaMove(resultList, (CDOMoveFeatureDelta)deltaToHandle, listToAdjust);
                        continue;
                    }
                    throw new UnsupportedOperationException("Unable to handle list feature conflict: " + deltaToHandle);
                }
            }

            protected boolean handleListDeltaAdd(List<CDOFeatureDelta> resultList, CDOAddFeatureDelta addDelta, List<CDOFeatureDelta> listToAdjust) {
                int index = addDelta.getIndex();
                if (listToAdjust == null) {
                    Object value = addDelta.getValue();
                    if (this.getTargetMap().get(value) instanceof CDORevision && this.getSourceMap().get(value) instanceof CDORevision) {
                        return false;
                    }
                }
                resultList.add(addDelta.copy());
                if (listToAdjust != null) {
                    ManyValued.adjustAfterAddition(listToAdjust, index);
                }
                return true;
            }

            protected boolean handleListDeltaRemove(List<CDOFeatureDelta> resultList, CDORemoveFeatureDelta removeDelta, List<CDOFeatureDelta> listToAdjust) {
                int index = removeDelta.getIndex();
                if (listToAdjust == null) {
                    Object value = removeDelta.getValue();
                    if (!this.getTargetMap().containsKey(value) && !this.getSourceMap().containsKey(value)) {
                        return false;
                    }
                }
                resultList.add(removeDelta.copy());
                if (listToAdjust != null) {
                    ManyValued.adjustAfterRemoval(listToAdjust, index);
                }
                return true;
            }

            protected boolean handleListDeltaMove(List<CDOFeatureDelta> resultList, CDOMoveFeatureDelta moveDelta, List<CDOFeatureDelta> listToAdjust) {
                resultList.add(moveDelta.copy());
                if (listToAdjust != null) {
                    int oldPosition = moveDelta.getOldPosition();
                    int newPosition = moveDelta.getNewPosition();
                    ManyValued.adjustAfterMove(listToAdjust, oldPosition, newPosition);
                }
                return true;
            }

            public static void adjustAfterAddition(List<CDOFeatureDelta> list, int index) {
                for (CDOFeatureDelta delta : list) {
                    if (!(delta instanceof InternalCDOFeatureDelta.WithIndex)) continue;
                    InternalCDOFeatureDelta.WithIndex withIndex = (InternalCDOFeatureDelta.WithIndex)delta;
                    withIndex.adjustAfterAddition(index);
                }
            }

            public static void adjustAfterRemoval(List<CDOFeatureDelta> list, int index) {
                for (CDOFeatureDelta delta : list) {
                    if (!(delta instanceof InternalCDOFeatureDelta.WithIndex)) continue;
                    InternalCDOFeatureDelta.WithIndex withIndex = (InternalCDOFeatureDelta.WithIndex)delta;
                    withIndex.adjustAfterRemoval(index);
                }
            }

            public static void adjustAfterMove(List<CDOFeatureDelta> list, int oldPosition, int newPosition) {
                for (CDOFeatureDelta delta : list) {
                    if (!(delta instanceof InternalCDOFeatureDelta.WithIndex)) continue;
                    InternalCDOFeatureDelta.WithIndex withIndex = (InternalCDOFeatureDelta.WithIndex)delta;
                    withIndex.adjustAfterRemoval(oldPosition);
                    withIndex.adjustAfterAddition(newPosition);
                }
            }
        }
    }
}

