/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.spi.cdo;

import java.util.Collection;
import java.util.Iterator;
import org.eclipse.emf.cdo.CDOObject;
import org.eclipse.emf.cdo.CDOState;
import org.eclipse.emf.cdo.util.LegacyModeNotEnabledException;
import org.eclipse.emf.cdo.view.CDOView;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.internal.cdo.CDOObjectImpl;
import org.eclipse.emf.internal.cdo.messages.Messages;
import org.eclipse.emf.internal.cdo.object.CDOLegacyAdapter;
import org.eclipse.emf.spi.cdo.InternalCDOObject;
import org.eclipse.emf.spi.cdo.InternalCDOView;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class FSMUtil {
    private FSMUtil() {
    }

    public static boolean isTransient(CDOObject object) {
        CDOState state = object.cdoState();
        return state == CDOState.TRANSIENT || state == CDOState.PREPARED;
    }

    public static boolean isInvalid(CDOObject object) {
        CDOState state = object.cdoState();
        return state == CDOState.INVALID || state == CDOState.INVALID_CONFLICT;
    }

    public static boolean isConflict(CDOObject object) {
        CDOState state = object.cdoState();
        return state == CDOState.CONFLICT || state == CDOState.INVALID_CONFLICT;
    }

    public static boolean isNew(CDOObject object) {
        CDOState state = object.cdoState();
        return state == CDOState.NEW;
    }

    public static boolean isClean(CDOObject object) {
        CDOState state = object.cdoState();
        return state == CDOState.CLEAN;
    }

    public static boolean isNative(EObject eObject) {
        return eObject instanceof CDOObjectImpl;
    }

    public static InternalCDOObject adapt(Object object, CDOView view) {
        if (view.isClosed()) {
            throw new IllegalStateException(Messages.getString("FSMUtil.0"));
        }
        if (object instanceof InternalCDOObject) {
            return (InternalCDOObject)object;
        }
        if (object == null) {
            throw new IllegalArgumentException(Messages.getString("FSMUtil.1"));
        }
        if (object instanceof InternalEObject) {
            if (!view.isLegacyModeEnabled()) {
                throw new LegacyModeNotEnabledException();
            }
            return FSMUtil.adaptLegacy((InternalEObject)object);
        }
        return null;
    }

    public static InternalCDOObject adaptLegacy(InternalEObject object) {
        EList adapters = object.eAdapters();
        CDOLegacyAdapter adapter = FSMUtil.getLegacyAdapter((EList<Adapter>)adapters);
        if (adapter == null) {
            adapter = new CDOLegacyAdapter(object);
        }
        return adapter;
    }

    private static CDOLegacyAdapter getLegacyAdapter(EList<Adapter> adapters) {
        return (CDOLegacyAdapter)EcoreUtil.getAdapter(adapters, CDOLegacyAdapter.class);
    }

    public static Iterator<InternalCDOObject> iterator(final Iterator<?> delegate, final InternalCDOView view) {
        return new Iterator<InternalCDOObject>(){
            private Object next;

            @Override
            public boolean hasNext() {
                if (delegate.hasNext()) {
                    this.next = FSMUtil.adapt(delegate.next(), view);
                    return true;
                }
                return false;
            }

            @Override
            public InternalCDOObject next() {
                return (InternalCDOObject)this.next;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public static Iterator<InternalCDOObject> iterator(Collection<?> instances, InternalCDOView view) {
        return FSMUtil.iterator(instances.iterator(), view);
    }
}

