/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.diff.internal.engine;

import java.util.Collection;
import java.util.Iterator;
import org.eclipse.emf.compare.diff.engine.IMatchManager;
import org.eclipse.emf.compare.diff.engine.IMatchManager2;
import org.eclipse.emf.compare.match.metamodel.Match2Elements;
import org.eclipse.emf.compare.match.metamodel.Match3Elements;
import org.eclipse.emf.compare.match.metamodel.UnmatchElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;

public class CrossReferencerMatchManager
implements IMatchManager,
IMatchManager2 {
    private EcoreUtil.CrossReferencer crossReferencer;

    public CrossReferencerMatchManager(EcoreUtil.CrossReferencer referencer) {
        this.crossReferencer = referencer;
    }

    public EObject getMatchedEObject(EObject from) {
        EObject matchedEObject = null;
        if (this.crossReferencer != null && from != null) {
            Collection settings = (Collection)this.crossReferencer.get((Object)from);
            if (settings == null) {
                return null;
            }
            for (EStructuralFeature.Setting setting : (Collection)this.crossReferencer.get((Object)from)) {
                if (!(setting.getEObject() instanceof Match2Elements)) continue;
                if (setting.getEStructuralFeature().getFeatureID() == 2) {
                    matchedEObject = ((Match2Elements)setting.getEObject()).getRightElement();
                    continue;
                }
                if (setting.getEStructuralFeature().getFeatureID() != 3) continue;
                matchedEObject = ((Match2Elements)setting.getEObject()).getLeftElement();
            }
        }
        return matchedEObject;
    }

    public EObject getMatchedEObject(EObject from, IMatchManager.MatchSide side) {
        EObject matchedEObject = null;
        if (this.crossReferencer != null && from != null) {
            Collection settings = (Collection)this.crossReferencer.get((Object)from);
            if (settings == null) {
                return null;
            }
            for (EStructuralFeature.Setting setting : settings) {
                if (!(setting.getEObject() instanceof Match2Elements)) continue;
                if (side == IMatchManager.MatchSide.LEFT) {
                    matchedEObject = ((Match2Elements)setting.getEObject()).getLeftElement();
                    continue;
                }
                if (side == IMatchManager.MatchSide.RIGHT) {
                    matchedEObject = ((Match2Elements)setting.getEObject()).getRightElement();
                    continue;
                }
                if (!(setting.getEObject() instanceof Match3Elements)) continue;
                matchedEObject = ((Match3Elements)setting.getEObject()).getOriginElement();
            }
        }
        return matchedEObject;
    }

    public boolean isInScope(EObject eObj) {
        if (this.crossReferencer != null && eObj != null && this.crossReferencer.get((Object)eObj) != null) {
            for (EStructuralFeature.Setting setting : (Collection)this.crossReferencer.get((Object)eObj)) {
                if (!(setting.getEObject() instanceof Match2Elements) && !(setting.getEObject() instanceof UnmatchElement)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isRemoteUnmatched(EObject element) {
        EObject next;
        Iterator it;
        return this.crossReferencer != null && this.crossReferencer.get((Object)element) != null && (it = ((Collection)this.crossReferencer.get((Object)element)).iterator()).hasNext() && (next = ((EStructuralFeature.Setting)it.next()).getEObject()) instanceof UnmatchElement && ((UnmatchElement)next).isRemote();
    }

    public boolean isUnmatched(EObject element) {
        Iterator it;
        return this.crossReferencer != null && this.crossReferencer.get((Object)element) != null && (it = ((Collection)this.crossReferencer.get((Object)element)).iterator()).hasNext() && ((EStructuralFeature.Setting)it.next()).getEObject() instanceof UnmatchElement;
    }
}

