/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.diff.internal.merge.impl;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.compare.diff.merge.DefaultMerger;
import org.eclipse.emf.compare.diff.metamodel.AttributeOrderChange;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EEnumLiteral;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.FeatureMap;

public class AttributeOrderChangeMerger
extends DefaultMerger {
    public void doApplyInOrigin() {
        int j;
        AttributeOrderChange theDiff = (AttributeOrderChange)this.diff;
        EAttribute attribute = theDiff.getAttribute();
        EObject leftElement = theDiff.getLeftElement();
        EObject rightElement = theDiff.getRightElement();
        List leftList = (List)leftElement.eGet((EStructuralFeature)attribute);
        List rightList = (List)rightElement.eGet((EStructuralFeature)attribute);
        ArrayList leftCopy = new ArrayList(leftList);
        ArrayList result = new ArrayList(leftList.size());
        int i = 0;
        while (i < leftList.size()) {
            Object left = leftList.get(i);
            boolean hasMatch = false;
            j = 0;
            while (!hasMatch && j < rightList.size()) {
                hasMatch = !AttributeOrderChangeMerger.areDistinctValues(left, rightList.get(j));
                ++j;
            }
            if (!hasMatch) {
                leftCopy.remove(left);
                result.add(left);
            }
            ++i;
        }
        i = 0;
        while (i < rightList.size()) {
            Object right = rightList.get(i);
            Object leftMatch = null;
            j = 0;
            while (leftMatch == null && j < leftCopy.size()) {
                if (!AttributeOrderChangeMerger.areDistinctValues(right, leftCopy.get(j))) {
                    leftMatch = leftCopy.get(j);
                }
                ++j;
            }
            if (leftMatch != null) {
                leftCopy.remove(leftMatch);
                result.add(leftMatch);
            }
            ++i;
        }
        leftElement.eSet((EStructuralFeature)attribute, result);
    }

    public void doUndoInTarget() {
        int j;
        AttributeOrderChange theDiff = (AttributeOrderChange)this.diff;
        EAttribute attribute = theDiff.getAttribute();
        EObject leftElement = theDiff.getLeftElement();
        EObject rightElement = theDiff.getRightElement();
        List leftList = (List)leftElement.eGet((EStructuralFeature)attribute);
        List rightList = (List)rightElement.eGet((EStructuralFeature)attribute);
        ArrayList rightCopy = new ArrayList(rightList);
        ArrayList result = new ArrayList(rightList.size());
        int i = 0;
        while (i < rightList.size()) {
            Object right = rightList.get(i);
            boolean hasMatch = false;
            j = 0;
            while (!hasMatch && j < leftList.size()) {
                hasMatch = !AttributeOrderChangeMerger.areDistinctValues(right, leftList.get(j));
                ++j;
            }
            if (!hasMatch) {
                rightCopy.remove(right);
                result.add(right);
            }
            ++i;
        }
        i = 0;
        while (i < leftList.size()) {
            Object left = leftList.get(i);
            Object rightMatch = null;
            j = 0;
            while (rightMatch == null && j < rightCopy.size()) {
                if (!AttributeOrderChangeMerger.areDistinctValues(left, rightCopy.get(j))) {
                    rightMatch = rightCopy.get(j);
                }
                ++j;
            }
            if (rightMatch != null) {
                rightCopy.remove(rightMatch);
                result.add(rightMatch);
            }
            ++i;
        }
        rightElement.eSet((EStructuralFeature)attribute, result);
    }

    private static boolean areDistinctValues(Object left, Object right) {
        boolean distinct;
        if (left instanceof EEnumLiteral && right instanceof EEnumLiteral) {
            StringBuilder value1 = new StringBuilder();
            value1.append(((EEnumLiteral)left).getLiteral()).append(((EEnumLiteral)left).getValue());
            StringBuilder value2 = new StringBuilder();
            value2.append(((EEnumLiteral)right).getLiteral()).append(((EEnumLiteral)right).getValue());
            distinct = !value1.toString().equals(value2.toString());
        } else {
            distinct = left != null && left.getClass().isArray() ? AttributeOrderChangeMerger.areDistinctArrays(left, right) : (left instanceof FeatureMap.Entry || right instanceof FeatureMap.Entry ? AttributeOrderChangeMerger.areDistinctEntries(left, right) : left != null && !left.equals(right) || left == null && left != right);
        }
        return distinct;
    }

    private static boolean areDistinctEntries(Object left, Object right) {
        boolean distinct = left instanceof FeatureMap.Entry && right instanceof FeatureMap.Entry ? AttributeOrderChangeMerger.areDistinctValues(((FeatureMap.Entry)left).getValue(), ((FeatureMap.Entry)right).getValue()) : (left instanceof FeatureMap.Entry ? AttributeOrderChangeMerger.areDistinctValues(((FeatureMap.Entry)left).getValue(), right) : AttributeOrderChangeMerger.areDistinctValues(left, ((FeatureMap.Entry)right).getValue()));
        return distinct;
    }

    private static boolean areDistinctArrays(Object left, Object right) {
        boolean distinct = false;
        if (right == null || !right.getClass().isArray()) {
            distinct = true;
        } else {
            int rightLength;
            int leftLength = Array.getLength(left);
            if (leftLength != (rightLength = Array.getLength(right))) {
                distinct = true;
            } else {
                int i = 0;
                while (i < leftLength) {
                    Object rightElement;
                    Object leftElement = Array.get(left, i);
                    if (AttributeOrderChangeMerger.areDistinctValues(leftElement, rightElement = Array.get(right, i))) {
                        distinct = true;
                        break;
                    }
                    ++i;
                }
            }
        }
        return distinct;
    }
}

