/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.ui.viewer.filter;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.compare.ui.EMFCompareUIMessages;
import org.eclipse.emf.compare.ui.EMFCompareUIPlugin;
import org.eclipse.emf.compare.ui.viewer.AbstractOrderingMenu;
import org.eclipse.emf.compare.ui.viewer.filter.DifferenceFilterDescriptor;
import org.eclipse.emf.compare.ui.viewer.filter.DifferenceFilterRegistry;
import org.eclipse.emf.compare.ui.viewer.filter.FilteringAction;
import org.eclipse.emf.compare.ui.viewer.filter.IDifferenceFilter;
import org.eclipse.emf.compare.ui.viewer.structure.ParameterizedStructureMergeViewer;
import org.eclipse.jface.action.IAction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FiltersMenu
extends AbstractOrderingMenu {
    private ParameterizedStructureMergeViewer mViewer;
    private List<IDifferenceFilter> selectedFilters = new ArrayList<IDifferenceFilter>();

    public FiltersMenu(ParameterizedStructureMergeViewer viewer) {
        super(EMFCompareUIMessages.getString("ModelStructureMergeViewer.filtering.tooltip"));
        this.mViewer = viewer;
    }

    public List<IDifferenceFilter> getSelectedFilters() {
        return this.selectedFilters;
    }

    @Override
    protected void doGetMenu() {
        for (DifferenceFilterDescriptor desc : DifferenceFilterRegistry.INSTANCE.getDescriptors()) {
            String preferenceValue = EMFCompareUIPlugin.getDefault().getPreferenceStore().getString("emfcompare.default.filters");
            List<DifferenceFilterDescriptor> defaultDescriptors = DifferenceFilterRegistry.INSTANCE.getDescriptors(preferenceValue);
            boolean hasToBeChecked = defaultDescriptors.contains(desc);
            if (hasToBeChecked) {
                this.selectedFilters.add(desc.getExtension());
            }
            this.addItemToMenu(desc, hasToBeChecked);
        }
    }

    protected void addItemToMenu(DifferenceFilterDescriptor desc) {
        FilteringAction action = new FilteringAction(desc, this.mViewer, this);
        this.addContribution((IAction)action);
    }

    protected void addItemToMenu(DifferenceFilterDescriptor desc, boolean checked) {
        FilteringAction action = new FilteringAction(desc, this.mViewer, checked, this);
        this.addContribution((IAction)action);
    }
}

