/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.util;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.compare.EMFCompareMessages;
import org.eclipse.emf.compare.util.EMFCompareMap;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.xmi.XMLResource;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceFactoryImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ModelUtils {
    private static final String ENCODING_PROPERTY = "file.encoding";

    private ModelUtils() {
    }

    public static Resource attachResource(URI resourceURI, EObject root) {
        if (root == null) {
            throw new NullPointerException(EMFCompareMessages.getString("ModelUtils.NullRoot"));
        }
        Resource newResource = ModelUtils.createResource(resourceURI);
        newResource.getContents().add((Object)root);
        return newResource;
    }

    public static Resource attachResource(URI resourceURI, ResourceSet resourceSet, EObject root) {
        if (root == null) {
            throw new NullPointerException(EMFCompareMessages.getString("ModelUtils.NullRoot"));
        }
        Resource newResource = ModelUtils.createResource(resourceURI, resourceSet);
        newResource.getContents().add((Object)root);
        return newResource;
    }

    public static Resource createResource(URI modelURI) {
        return ModelUtils.createResource(modelURI, (ResourceSet)new ResourceSetImpl());
    }

    public static Resource createResource(URI modelURI, ResourceSet resourceSet) {
        Resource.Factory.Registry registry;
        Object resourceFactory;
        String fileExtension = modelURI.fileExtension();
        if (fileExtension == null || fileExtension.length() == 0) {
            fileExtension = "*";
        }
        if ((resourceFactory = (registry = resourceSet.getResourceFactoryRegistry()).getExtensionToFactoryMap().get(fileExtension)) == null) {
            registry = Resource.Factory.Registry.INSTANCE;
            resourceFactory = registry.getExtensionToFactoryMap().get(fileExtension);
            if (resourceFactory != null) {
                resourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap().put(fileExtension, resourceFactory);
            } else {
                resourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap().put(fileExtension, new XMIResourceFactoryImpl());
            }
        }
        return resourceSet.createResource(modelURI);
    }

    public static String getCommonExtension(URI ... uris) {
        String extension = null;
        int i = 0;
        while (i < uris.length) {
            if (uris[i] != null) {
                if (extension == null) {
                    extension = uris[i].fileExtension();
                } else if (uris[i].fileExtension() != null && !extension.equals(uris[i].fileExtension())) {
                    return null;
                }
            }
            ++i;
        }
        return extension;
    }

    public static String getCommonNamespace(Resource ... resources) {
        String namespace = null;
        int i = 0;
        while (i < resources.length) {
            EObject rootContainer;
            if (resources[i] != null && !resources[i].getContents().isEmpty() && (rootContainer = EcoreUtil.getRootContainer((EObject)((EObject)resources[i].getContents().get(0)).eClass())) instanceof EPackage) {
                if (namespace == null) {
                    namespace = ((EPackage)rootContainer).getNsURI();
                } else if (!namespace.equals(((EPackage)rootContainer).getNsURI())) {
                    return null;
                }
            }
            ++i;
        }
        return namespace;
    }

    public static List<EObject> getModelsFrom(File directory, ResourceSet resourceSet) throws IOException {
        return ModelUtils.getModelsFrom(directory, null, resourceSet);
    }

    public static List<EObject> getModelsFrom(File directory, String extension, ResourceSet resourceSet) throws IOException {
        ArrayList<EObject> models = new ArrayList<EObject>();
        String fileExtension = extension != null ? extension : "";
        Object theResourceSet = resourceSet == null ? new ResourceSetImpl() : resourceSet;
        if (directory.exists() && directory.isDirectory() && directory.listFiles() != null) {
            File[] files = directory.listFiles();
            int i = 0;
            while (i < files.length) {
                File aFile = files[i];
                if (!aFile.isDirectory() && aFile.getName().matches("[^.].*?\\Q" + fileExtension + "\\E")) {
                    models.add(ModelUtils.load(aFile, theResourceSet));
                }
                ++i;
            }
        }
        return models;
    }

    public static EObject load(File file, ResourceSet resourceSet) throws IOException {
        return ModelUtils.load(URI.createFileURI((String)file.getPath()), resourceSet);
    }

    public static EObject load(InputStream stream, String fileName, ResourceSet resourceSet) throws IOException {
        if (stream == null) {
            throw new NullPointerException(EMFCompareMessages.getString("ModelUtils.NullInputStream"));
        }
        EObject result = null;
        Resource modelResource = ModelUtils.createResource(URI.createURI((String)fileName), resourceSet);
        modelResource.load(stream, Collections.emptyMap());
        if (modelResource.getContents().size() > 0) {
            result = (EObject)modelResource.getContents().get(0);
        }
        return result;
    }

    public static EObject load(String path, ResourceSet resourceSet) throws IOException {
        EObject result;
        if (path == null || "".equals(path)) {
            throw new IllegalArgumentException(EMFCompareMessages.getString("ModelUtils.NullPath"));
        }
        if (path.startsWith("platform")) {
            result = ModelUtils.load(URI.createURI((String)path), resourceSet);
        } else {
            EObject temp = null;
            try {
                temp = ModelUtils.load(URI.createPlatformPluginURI((String)path, (boolean)true), resourceSet);
            }
            catch (IOException iOException) {
                try {
                    temp = ModelUtils.load(URI.createPlatformResourceURI((String)path, (boolean)true), resourceSet);
                }
                catch (IOException iOException2) {}
            }
            result = temp;
        }
        if (result == null) {
            throw new IOException(EMFCompareMessages.getString("ModelUtils.LoadFailure", path));
        }
        return result;
    }

    public static EObject load(URI modelURI, ResourceSet resourceSet) throws IOException {
        EObject result = null;
        Resource modelResource = ModelUtils.createResource(modelURI, resourceSet);
        modelResource.load(Collections.emptyMap());
        if (modelResource.getContents().size() > 0) {
            result = (EObject)modelResource.getContents().get(0);
        }
        return result;
    }

    public static void save(EObject root, String path) throws IOException {
        if (root == null) {
            throw new NullPointerException(EMFCompareMessages.getString("ModelUtils.NullSaveRoot"));
        }
        Resource newModelResource = ModelUtils.createResource(URI.createFileURI((String)path));
        newModelResource.getContents().add((Object)root);
        EMFCompareMap<String, String> options = new EMFCompareMap<String, String>();
        options.put("ENCODING", System.getProperty(ENCODING_PROPERTY));
        newModelResource.save(options);
    }

    public static String serialize(EObject root) throws IOException {
        if (root == null) {
            throw new NullPointerException(EMFCompareMessages.getString("ModelUtils.NullSaveRoot"));
        }
        EObject copyRoot = EcoreUtil.copy((EObject)root);
        ModelUtils.attachResource(URI.createFileURI((String)"resource.xml"), copyRoot);
        StringWriter writer = new StringWriter();
        EMFCompareMap<String, String> options = new EMFCompareMap<String, String>();
        options.put("ENCODING", System.getProperty(ENCODING_PROPERTY));
        ((XMLResource)copyRoot.eResource()).save((Writer)writer, options);
        String result = writer.toString();
        writer.flush();
        return result;
    }

    public static boolean contains(Resource resource, EObject eObject) {
        if (eObject.eResource() != null) {
            TreeIterator contentsIterator = resource.getAllContents();
            while (contentsIterator.hasNext()) {
                if (contentsIterator.next() != eObject) continue;
                return true;
            }
        }
        return false;
    }
}

