/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecore.xcore.ui.refactoring;

import com.google.common.collect.Lists;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.emf.codegen.ecore.genmodel.GenBase;
import org.eclipse.emf.codegen.ecore.genmodel.GenClass;
import org.eclipse.emf.codegen.ecore.genmodel.GenDataType;
import org.eclipse.emf.codegen.ecore.genmodel.GenEnumLiteral;
import org.eclipse.emf.codegen.ecore.genmodel.GenFeature;
import org.eclipse.emf.codegen.ecore.genmodel.GenOperation;
import org.eclipse.emf.codegen.ecore.genmodel.GenPackage;
import org.eclipse.emf.codegen.ecore.genmodel.GenParameter;
import org.eclipse.emf.codegen.ecore.genmodel.GenTypeParameter;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.xcore.XClass;
import org.eclipse.emf.ecore.xcore.XDataType;
import org.eclipse.emf.ecore.xcore.XEnumLiteral;
import org.eclipse.emf.ecore.xcore.XOperation;
import org.eclipse.emf.ecore.xcore.XPackage;
import org.eclipse.emf.ecore.xcore.XParameter;
import org.eclipse.emf.ecore.xcore.XStructuralFeature;
import org.eclipse.emf.ecore.xcore.XTypeParameter;
import org.eclipse.emf.ecore.xcore.mappings.XClassMapping;
import org.eclipse.emf.ecore.xcore.mappings.XDataTypeMapping;
import org.eclipse.emf.ecore.xcore.mappings.XEnumLiteralMapping;
import org.eclipse.emf.ecore.xcore.mappings.XFeatureMapping;
import org.eclipse.emf.ecore.xcore.mappings.XOperationMapping;
import org.eclipse.emf.ecore.xcore.mappings.XPackageMapping;
import org.eclipse.emf.ecore.xcore.mappings.XParameterMapping;
import org.eclipse.emf.ecore.xcore.mappings.XTypeParameterMapping;
import org.eclipse.emf.ecore.xcore.mappings.XcoreMapper;
import org.eclipse.emf.ecore.xcore.util.XcoreJvmInferrer;
import org.eclipse.emf.ecore.xcore.util.XcoreSwitch;
import org.eclipse.xtext.common.types.JvmIdentifiableElement;
import org.eclipse.xtext.ui.refactoring.impl.DefaultDependentElementsCalculator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XcoreDependentElementsCalculator
extends DefaultDependentElementsCalculator {
    @Inject
    private XcoreMapper mapper;

    public List<URI> getDependentElementURIs(EObject eObject, final IProgressMonitor monitor) {
        final List result = super.getDependentElementURIs(eObject, monitor);
        new XcoreSwitch<Boolean>(){

            public Boolean caseXPackage(XPackage xPackage) {
                XPackageMapping mapping = XcoreDependentElementsCalculator.this.mapper.getMapping(xPackage);
                GenPackage genPackage = mapping.getGenPackage();
                result.addAll(XcoreDependentElementsCalculator.this.doGetDependentElementURIs((EObject)genPackage, monitor));
                result.addAll(XcoreDependentElementsCalculator.this.doGetDependentElementURIs((EObject)mapping.getEPackage(), monitor));
                for (JvmIdentifiableElement jvmIdentifiableElement : XcoreJvmInferrer.getInferredElements((GenBase)genPackage)) {
                    result.addAll(XcoreDependentElementsCalculator.this.doGetDependentElementURIs((EObject)jvmIdentifiableElement, monitor));
                }
                return Boolean.FALSE;
            }

            public Boolean caseXClass(XClass xClass) {
                XClassMapping mapping = XcoreDependentElementsCalculator.this.mapper.getMapping(xClass);
                GenClass genClass = mapping.getGenClass();
                result.addAll(XcoreDependentElementsCalculator.this.doGetDependentElementURIs((EObject)genClass, monitor));
                result.addAll(XcoreDependentElementsCalculator.this.doGetDependentElementURIs((EObject)mapping.getEClass(), monitor));
                for (JvmIdentifiableElement jvmIdentifiableElement : XcoreJvmInferrer.getInferredElements((GenBase)genClass)) {
                    result.addAll(XcoreDependentElementsCalculator.this.doGetDependentElementURIs((EObject)jvmIdentifiableElement, monitor));
                }
                return Boolean.FALSE;
            }

            public Boolean caseXDataType(XDataType xDataType) {
                XDataTypeMapping mapping = XcoreDependentElementsCalculator.this.mapper.getMapping(xDataType);
                GenDataType genDataType = mapping.getGenDataType();
                result.addAll(XcoreDependentElementsCalculator.this.doGetDependentElementURIs((EObject)genDataType, monitor));
                result.addAll(XcoreDependentElementsCalculator.this.doGetDependentElementURIs((EObject)mapping.getEDataType(), monitor));
                for (JvmIdentifiableElement jvmIdentifiableElement : XcoreJvmInferrer.getInferredElements((GenBase)genDataType)) {
                    result.addAll(XcoreDependentElementsCalculator.this.doGetDependentElementURIs((EObject)jvmIdentifiableElement, monitor));
                }
                return Boolean.FALSE;
            }

            public Boolean caseXEnumLiteral(XEnumLiteral xEnumLiteral) {
                XEnumLiteralMapping mapping = XcoreDependentElementsCalculator.this.mapper.getMapping(xEnumLiteral);
                GenEnumLiteral genEnumLiteral = mapping.getGenEnumLiteral();
                result.addAll(XcoreDependentElementsCalculator.this.doGetDependentElementURIs((EObject)genEnumLiteral, monitor));
                result.addAll(XcoreDependentElementsCalculator.this.doGetDependentElementURIs((EObject)mapping.getEEnumLiteral(), monitor));
                for (JvmIdentifiableElement jvmIdentifiableElement : XcoreJvmInferrer.getInferredElements((GenBase)genEnumLiteral)) {
                    result.addAll(XcoreDependentElementsCalculator.this.doGetDependentElementURIs((EObject)jvmIdentifiableElement, monitor));
                }
                return Boolean.FALSE;
            }

            public Boolean caseXStructuralFeature(XStructuralFeature xStructuralFeature) {
                XFeatureMapping mapping = XcoreDependentElementsCalculator.this.mapper.getMapping(xStructuralFeature);
                GenFeature genFeature = mapping.getGenFeature();
                result.addAll(XcoreDependentElementsCalculator.this.doGetDependentElementURIs((EObject)genFeature, monitor));
                result.addAll(XcoreDependentElementsCalculator.this.doGetDependentElementURIs((EObject)mapping.getEStructuralFeature(), monitor));
                for (JvmIdentifiableElement jvmIdentifiableElement : XcoreJvmInferrer.getInferredElements((GenBase)genFeature)) {
                    result.addAll(XcoreDependentElementsCalculator.this.doGetDependentElementURIs((EObject)jvmIdentifiableElement, monitor));
                }
                return Boolean.FALSE;
            }

            public Boolean caseXOperation(XOperation xOperation) {
                XOperationMapping mapping = XcoreDependentElementsCalculator.this.mapper.getMapping(xOperation);
                GenOperation genOperation = mapping.getGenOperation();
                result.addAll(XcoreDependentElementsCalculator.this.doGetDependentElementURIs((EObject)genOperation, monitor));
                result.addAll(XcoreDependentElementsCalculator.this.doGetDependentElementURIs((EObject)mapping.getEOperation(), monitor));
                for (JvmIdentifiableElement jvmIdentifiableElement : XcoreJvmInferrer.getInferredElements((GenBase)genOperation)) {
                    result.addAll(XcoreDependentElementsCalculator.this.doGetDependentElementURIs((EObject)jvmIdentifiableElement, monitor));
                }
                return Boolean.FALSE;
            }

            public Boolean caseXParameter(XParameter xParameter) {
                XParameterMapping mapping = XcoreDependentElementsCalculator.this.mapper.getMapping(xParameter);
                GenParameter genParameter = mapping.getGenParameter();
                result.addAll(XcoreDependentElementsCalculator.this.doGetDependentElementURIs((EObject)genParameter, monitor));
                result.addAll(XcoreDependentElementsCalculator.this.doGetDependentElementURIs((EObject)mapping.getEParameter(), monitor));
                for (JvmIdentifiableElement jvmIdentifiableElement : XcoreJvmInferrer.getInferredElements((GenBase)genParameter)) {
                    result.addAll(XcoreDependentElementsCalculator.this.doGetDependentElementURIs((EObject)jvmIdentifiableElement, monitor));
                }
                return Boolean.FALSE;
            }

            public Boolean caseXTypeParameter(XTypeParameter xTypeParameter) {
                XTypeParameterMapping mapping = XcoreDependentElementsCalculator.this.mapper.getMapping(xTypeParameter);
                GenTypeParameter genTypeParameter = mapping.getGenTypeParameter();
                result.addAll(XcoreDependentElementsCalculator.this.doGetDependentElementURIs((EObject)genTypeParameter, monitor));
                result.addAll(XcoreDependentElementsCalculator.this.doGetDependentElementURIs((EObject)mapping.getETypeParameter(), monitor));
                for (JvmIdentifiableElement jvmIdentifiableElement : XcoreJvmInferrer.getInferredElements((GenBase)genTypeParameter)) {
                    result.addAll(XcoreDependentElementsCalculator.this.doGetDependentElementURIs((EObject)jvmIdentifiableElement, monitor));
                }
                return Boolean.FALSE;
            }
        }.doSwitch(eObject);
        return result;
    }

    protected List<URI> doGetDependentElementURIs(EObject eObject, IProgressMonitor monitor) {
        ArrayList result = Lists.newArrayList();
        if (eObject != null) {
            SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)10);
            TreeIterator i = EcoreUtil.getAllProperContents(Collections.singleton(eObject), (boolean)false);
            while (!progress.isCanceled() && i.hasNext()) {
                EObject childElement = (EObject)i.next();
                URI childURI = EcoreUtil.getURI((EObject)childElement);
                if (childURI == null) continue;
                result.add(childURI);
            }
            progress.worked(1);
            progress.setWorkRemaining(10);
        }
        return result;
    }
}

