/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.facet.efacet.core.internal.query;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.facet.efacet.core.IDerivedTypedElementManager;
import org.eclipse.emf.facet.efacet.core.exception.DerivedTypedElementException;
import org.eclipse.emf.facet.efacet.core.internal.Activator;
import org.eclipse.emf.facet.efacet.core.internal.query.QueryUtils;
import org.eclipse.emf.facet.efacet.core.query.IDerivedTypedElementImplementation;
import org.eclipse.emf.facet.efacet.core.query.IDerivedTypedElementImplementationFactory;
import org.eclipse.emf.facet.efacet.metamodel.v0_2_0.efacet.extensible.Query;
import org.eclipse.emf.facet.util.core.Logger;
import org.eclipse.emf.facet.util.emf.core.ICatalogSetManagerFactory;
import org.osgi.framework.Bundle;

@Deprecated
public class DerivedTypedElementImplementationFactoryRegistry {
    private static final String DERIVED_TYPED_ELEMENT_IMPLEMENTATION_REGISTRATION_ID = "org.eclipse.emf.facet.efacet.core.derivedTypedElementImplementationRegistration";
    private static final String CLASS = "class";
    public static final DerivedTypedElementImplementationFactoryRegistry INSTANCE = new DerivedTypedElementImplementationFactoryRegistry();
    private final List<IDerivedTypedElementImplementationFactory> derivedTypedElementImplementationFactories = new ArrayList<IDerivedTypedElementImplementationFactory>();

    public DerivedTypedElementImplementationFactoryRegistry() {
        this.initRegisteredEntries();
    }

    private void initRegisteredEntries() {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint extPoint = registry.getExtensionPoint(DERIVED_TYPED_ELEMENT_IMPLEMENTATION_REGISTRATION_ID);
        if (extPoint != null) {
            IExtension[] iExtensionArray = extPoint.getExtensions();
            int n = iExtensionArray.length;
            int n2 = 0;
            while (n2 < n) {
                IExtension ext = iExtensionArray[n2];
                IConfigurationElement[] iConfigurationElementArray = ext.getConfigurationElements();
                int n3 = iConfigurationElementArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    IConfigurationElement configElt = iConfigurationElementArray[n4];
                    try {
                        IDerivedTypedElementImplementationFactory derivedTypedElementImplementationFactory = (IDerivedTypedElementImplementationFactory)configElt.createExecutableExtension(CLASS);
                        this.derivedTypedElementImplementationFactories.add(derivedTypedElementImplementationFactory);
                    }
                    catch (CoreException e) {
                        Logger.logError((Throwable)e, (Plugin)Activator.getDefault());
                    }
                    ++n4;
                }
                ++n2;
            }
        }
    }

    public IDerivedTypedElementImplementation getEvaluatorFor(Query query, IDerivedTypedElementManager derivedTEManager) throws DerivedTypedElementException {
        if (query == null) {
            throw new IllegalArgumentException("query cannot be null");
        }
        IDerivedTypedElementImplementation derivedTypedElementImplementation = null;
        boolean factoryFound = false;
        for (IDerivedTypedElementImplementationFactory derivedTypedElementImplementationFactory : this.derivedTypedElementImplementationFactories) {
            boolean bl = factoryFound = derivedTypedElementImplementationFactory.getManagedQueryType() == query.eClass();
            if (!factoryFound) continue;
            Resource queryResource = query.eResource();
            Bundle bundle = queryResource != null ? ICatalogSetManagerFactory.DEFAULT.createICatalogSetManager(query.eResource().getResourceSet()).getBundleByResource(queryResource) : null;
            derivedTypedElementImplementation = derivedTypedElementImplementationFactory.create(query, bundle, derivedTEManager);
            break;
        }
        if (!factoryFound) {
            StringBuffer sb = new StringBuffer();
            sb.append("No factory implementation found for ");
            sb.append(QueryUtils.getQueryDescription(query));
            sb.append(".\nA factory should be registered through the org.eclipse.emf.facet.efacet.core.derivedTypedElementImplementationRegistration extension point.");
            sb.append("\nAvailable Query types are: ");
            int i = 0;
            while (i < this.derivedTypedElementImplementationFactories.size()) {
                if (i > 0) {
                    sb.append(", ");
                }
                IDerivedTypedElementImplementationFactory queryEvaluatorFactory = this.derivedTypedElementImplementationFactories.get(i);
                sb.append(queryEvaluatorFactory.getManagedQueryType().getName());
                ++i;
            }
            throw new DerivedTypedElementException(sb.toString());
        }
        return derivedTypedElementImplementation;
    }
}

