/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.facet.efacet.examples.library.core.internal;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceFactoryImpl;
import org.eclipse.emf.facet.efacet.examples.library.metamodel.library.Book;
import org.eclipse.emf.facet.efacet.examples.library.metamodel.library.Library;
import org.eclipse.emf.facet.efacet.examples.library.metamodel.library.LibraryFactory;
import org.eclipse.emf.facet.efacet.examples.library.metamodel.library.Writer;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class RDFToLibraryTransformation
extends DefaultHandler {
    private static final String LANGUAGE_FILTER = "fr";
    private static final String RDF_VALUE = "rdf:value";
    private static final String DC_LANGUAGE = "dc:language";
    private static final String DC_CREATOR = "dc:creator";
    private static final String DC_TITLE = "dc:title";
    private static final String LIBRARY_FILE_EXTENSION = "library";
    private static final String PGTERMS_ETEXT = "pgterms:etext";
    private static final String ENTITY_EXPANSION_LIMIT_KEY = "entityExpansionLimit";
    private static final String ENTITY_EXPANSION_LIMIT_VALUE = "1000000";
    private final File inputFile;
    private Library library;
    private Book currentBook;
    private StringBuilder lastText;
    private final Map<String, Writer> writers = new HashMap<String, Writer>();
    private boolean inLanguage;
    private String language;
    private String writerName;

    public RDFToLibraryTransformation(File rdfFile) {
        this.inputFile = rdfFile;
        if (!rdfFile.exists()) {
            throw new IllegalArgumentException("the given file doesn't exist: " + rdfFile.toString());
        }
    }

    public void transform(String outputPath) throws ParserConfigurationException, SAXException, IOException {
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        Resource.Factory.Registry.INSTANCE.getExtensionToFactoryMap().put(LIBRARY_FILE_EXTENSION, new XMIResourceFactoryImpl());
        Resource resource = resourceSet.createResource(URI.createFileURI((String)outputPath));
        if (resource == null) {
            throw new RuntimeException("Couldn't create the model resource");
        }
        this.library = LibraryFactory.eINSTANCE.createLibrary();
        resource.getContents().add((Object)this.library);
        SAXParserFactory parserFactory = SAXParserFactory.newInstance();
        SAXParser parser = parserFactory.newSAXParser();
        parser.parse(this.inputFile, (DefaultHandler)this);
        resource.save(null);
    }

    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        this.lastText = null;
        if (DC_LANGUAGE.equals(qName)) {
            this.inLanguage = true;
        }
        if (PGTERMS_ETEXT.equals(qName)) {
            this.currentBook = LibraryFactory.eINSTANCE.createBook();
        }
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.lastText == null) {
            this.lastText = new StringBuilder();
        }
        this.lastText.append(new String(ch, start, length));
    }

    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (DC_TITLE.equals(qName)) {
            this.currentBook.setName(this.lastText.toString());
        } else if (DC_CREATOR.equals(qName)) {
            this.writerName = this.lastText.toString();
        } else if (DC_LANGUAGE.equals(qName)) {
            this.inLanguage = false;
        } else if (RDF_VALUE.equals(qName)) {
            if (this.inLanguage) {
                this.language = this.lastText.toString();
            }
        } else if (PGTERMS_ETEXT.equals(qName)) {
            if (this.currentBook.getName() != null && LANGUAGE_FILTER.equals(this.language)) {
                Writer writer = this.writers.get(this.writerName);
                if (writer == null) {
                    writer = LibraryFactory.eINSTANCE.createWriter();
                    writer.setName(this.writerName);
                    this.library.getWriters().add((Object)writer);
                    this.writers.put(this.writerName, writer);
                }
                this.currentBook.setWriter(writer);
                this.library.getBooks().add((Object)this.currentBook);
            }
            this.currentBook = null;
            this.language = null;
        }
    }

    public static void main(String[] args) throws Exception {
        if (args.length != 2) {
            System.out.println("usage: java " + RDFToLibraryTransformation.class.getName() + " <rdfFile> <outputFile>");
            return;
        }
        System.setProperty(ENTITY_EXPANSION_LIMIT_KEY, ENTITY_EXPANSION_LIMIT_VALUE);
        File file = new File(args[0]);
        RDFToLibraryTransformation transformation = new RDFToLibraryTransformation(file);
        transformation.transform(args[1]);
        System.out.println("done");
    }
}

