/**
 * Copyright (c) 2010 CEA LIST.
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *   Gregoire Dupe (Mia-Software) - Bug 340571 - To be able have more than one localCustomization
 *   Gregoire Dupe (Mia-Software) - Bug 340572 - Wrong multiplicity in TableInstance.facets
 *   Nicolas Guyomar (Mia-Software) - Bug 340941 - Need new row and column types in the table
 *   Gregoire Dupe (Mia-Software) - Bug 345730 - Deleting an element in the model breaks the table
 */
package org.eclipse.emf.facet.widgets.nattable.instance.tableinstance2.provider;

import java.util.ArrayList;
import java.util.Collection;

import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.edit.provider.ChangeNotifier;
import org.eclipse.emf.edit.provider.ComposeableAdapterFactory;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.IChangeNotifier;
import org.eclipse.emf.edit.provider.IDisposable;
import org.eclipse.emf.edit.provider.IEditingDomainItemProvider;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.emf.edit.provider.INotifyChangedListener;
import org.eclipse.emf.edit.provider.IStructuredItemContentProvider;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;
import org.eclipse.emf.facet.widgets.nattable.instance.tableinstance2.util.Tableinstance2AdapterFactory;

/**
 * This is the factory that is used to provide the interfaces needed to support
 * Viewers. The adapters generated by this factory convert EMF adapter
 * notifications into calls to {@link #fireNotifyChanged fireNotifyChanged}. The
 * adapters also support Eclipse property sheets. Note that most of the adapters
 * are shared among multiple instances. <!-- begin-user-doc --> <!--
 * end-user-doc -->
 * 
 * @generated
 * @deprecated cf. https://bugs.eclipse.org/bugs/show_bug.cgi?id=374120
 */
@Deprecated
public class Tableinstance2ItemProviderAdapterFactory extends Tableinstance2AdapterFactory implements ComposeableAdapterFactory, IChangeNotifier, IDisposable {
	/**
	 * This keeps track of the root adapter factory that delegates to this adapter factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ComposedAdapterFactory parentAdapterFactory;

	/**
	 * This is used to implement {@link org.eclipse.emf.edit.provider.IChangeNotifier}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected IChangeNotifier changeNotifier = new ChangeNotifier();

	/**
	 * This keeps track of all the supported types checked by {@link #isFactoryForType isFactoryForType}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Collection<Object> supportedTypes = new ArrayList<Object>();

	/**
	 * This constructs an instance.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Tableinstance2ItemProviderAdapterFactory() {
		supportedTypes.add(IEditingDomainItemProvider.class);
		supportedTypes.add(IStructuredItemContentProvider.class);
		supportedTypes.add(ITreeItemContentProvider.class);
		supportedTypes.add(IItemLabelProvider.class);
		supportedTypes.add(IItemPropertySource.class);
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.emf.facet.widgets.nattable.instance.tableinstance2.TableInstance2} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected TableInstance2ItemProvider tableInstance2ItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.emf.facet.widgets.nattable.instance.tableinstance2.TableInstance2}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createTableInstance2Adapter() {
		if (tableInstance2ItemProvider == null) {
			tableInstance2ItemProvider = new TableInstance2ItemProvider(this);
		}

		return tableInstance2ItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.emf.facet.widgets.nattable.instance.tableinstance2.PrimitiveTypeQueryRow} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected PrimitiveTypeQueryRowItemProvider primitiveTypeQueryRowItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.emf.facet.widgets.nattable.instance.tableinstance2.PrimitiveTypeQueryRow}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createPrimitiveTypeQueryRowAdapter() {
		if (primitiveTypeQueryRowItemProvider == null) {
			primitiveTypeQueryRowItemProvider = new PrimitiveTypeQueryRowItemProvider(this);
		}

		return primitiveTypeQueryRowItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.emf.facet.widgets.nattable.instance.tableinstance2.EObjectQueryRow} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected EObjectQueryRowItemProvider eObjectQueryRowItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.emf.facet.widgets.nattable.instance.tableinstance2.EObjectQueryRow}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createEObjectQueryRowAdapter() {
		if (eObjectQueryRowItemProvider == null) {
			eObjectQueryRowItemProvider = new EObjectQueryRowItemProvider(this);
		}

		return eObjectQueryRowItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.emf.facet.widgets.nattable.instance.tableinstance2.ValueColumn} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ValueColumnItemProvider valueColumnItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.emf.facet.widgets.nattable.instance.tableinstance2.ValueColumn}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createValueColumnAdapter() {
		if (valueColumnItemProvider == null) {
			valueColumnItemProvider = new ValueColumnItemProvider(this);
		}

		return valueColumnItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.emf.facet.widgets.nattable.instance.tableinstance2.QueryTableInstance2} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected QueryTableInstance2ItemProvider queryTableInstance2ItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.emf.facet.widgets.nattable.instance.tableinstance2.QueryTableInstance2}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createQueryTableInstance2Adapter() {
		if (queryTableInstance2ItemProvider == null) {
			queryTableInstance2ItemProvider = new QueryTableInstance2ItemProvider(this);
		}

		return queryTableInstance2ItemProvider;
	}

	/**
	 * This returns the root adapter factory that contains this factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ComposeableAdapterFactory getRootAdapterFactory() {
		return parentAdapterFactory == null ? this : parentAdapterFactory.getRootAdapterFactory();
	}

	/**
	 * This sets the composed adapter factory that contains this factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setParentAdapterFactory(final ComposedAdapterFactory parentAdapterFactory) {
		this.parentAdapterFactory = parentAdapterFactory;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean isFactoryForType(final Object type) {
		return supportedTypes.contains(type) || super.isFactoryForType(type);
	}

	/**
	 * This implementation substitutes the factory itself as the key for the adapter.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter adapt(final Notifier notifier, final Object type) {
		return super.adapt(notifier, this);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object adapt(final Object object, final Object type) {
		if (isFactoryForType(type)) {
			Object adapter = super.adapt(object, type);
			if (!(type instanceof Class<?>) || (((Class<?>)type).isInstance(adapter))) {
				return adapter;
			}
		}

		return null;
	}

	/**
	 * This adds a listener.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void addListener(final INotifyChangedListener notifyChangedListener) {
		changeNotifier.addListener(notifyChangedListener);
	}

	/**
	 * This removes a listener.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void removeListener(final INotifyChangedListener notifyChangedListener) {
		changeNotifier.removeListener(notifyChangedListener);
	}

	/**
	 * This delegates to {@link #changeNotifier} and to {@link #parentAdapterFactory}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void fireNotifyChanged(final Notification notification) {
		changeNotifier.fireNotifyChanged(notification);

		if (parentAdapterFactory != null) {
			parentAdapterFactory.fireNotifyChanged(notification);
		}
	}

	/**
	 * This disposes all of the item providers created by this factory. 
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void dispose() {
		if (tableInstance2ItemProvider != null) tableInstance2ItemProvider.dispose();
		if (primitiveTypeQueryRowItemProvider != null) primitiveTypeQueryRowItemProvider.dispose();
		if (eObjectQueryRowItemProvider != null) eObjectQueryRowItemProvider.dispose();
		if (valueColumnItemProvider != null) valueColumnItemProvider.dispose();
		if (queryTableInstance2ItemProvider != null) queryTableInstance2ItemProvider.dispose();
	}

}
