/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.weaving.hooks;

import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.equinox.service.weaving.ISupplementerRegistry;
import org.eclipse.equinox.weaving.adaptors.Debug;
import org.eclipse.equinox.weaving.adaptors.IWeavingAdaptor;
import org.eclipse.equinox.weaving.adaptors.WeavingAdaptor;
import org.eclipse.equinox.weaving.adaptors.WeavingAdaptorFactory;
import org.eclipse.equinox.weaving.hooks.AbstractWeavingHook;
import org.eclipse.equinox.weaving.hooks.BaseWeavingBundleFile;
import org.eclipse.equinox.weaving.hooks.BundleAdaptorProvider;
import org.eclipse.equinox.weaving.hooks.SupplementBundleListener;
import org.eclipse.equinox.weaving.hooks.WeavingBundleEntry;
import org.eclipse.equinox.weaving.hooks.WeavingBundleFile;
import org.eclipse.osgi.baseadaptor.BaseData;
import org.eclipse.osgi.baseadaptor.bundlefile.BundleEntry;
import org.eclipse.osgi.baseadaptor.bundlefile.BundleFile;
import org.eclipse.osgi.baseadaptor.loader.BaseClassLoader;
import org.eclipse.osgi.baseadaptor.loader.ClasspathEntry;
import org.eclipse.osgi.baseadaptor.loader.ClasspathManager;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.BundleListener;
import org.osgi.framework.ServiceReference;
import org.osgi.service.packageadmin.PackageAdmin;

public class WeavingHook
extends AbstractWeavingHook {
    private final WeavingAdaptorFactory adaptorFactory;
    private final Map<Long, IWeavingAdaptor> adaptors;
    private BundleContext bundleContext;

    public WeavingHook() {
        if (Debug.DEBUG_GENERAL) {
            Debug.println("- AspectJHook.<init>()");
        }
        this.adaptorFactory = new WeavingAdaptorFactory();
        this.adaptors = new HashMap<Long, IWeavingAdaptor>();
    }

    public void frameworkStart(BundleContext context) throws BundleException {
        this.initialize(context);
    }

    public void frameworkStop(BundleContext context) throws BundleException {
        this.adaptorFactory.dispose(context);
    }

    public IWeavingAdaptor getAdaptor(long bundleID) {
        return this.adaptors.get(bundleID);
    }

    public IWeavingAdaptor getHostBundleAdaptor(long bundleID) {
        Bundle host;
        Bundle bundle = this.bundleContext.getBundle(bundleID);
        if (bundle != null && (host = this.adaptorFactory.getHost(bundle)) != null) {
            long hostBundleID = host.getBundleId();
            return this.adaptors.get(hostBundleID);
        }
        return null;
    }

    public void initializedClassLoader(BaseClassLoader baseClassLoader, BaseData data) {
        if (Debug.DEBUG_GENERAL) {
            Debug.println("> AspectJHook.initializedClassLoader() bundle=" + data.getSymbolicName() + ", loader=" + baseClassLoader + ", data=" + data + ", bundleFile=" + data.getBundleFile());
        }
        IWeavingAdaptor adaptor = this.createAspectJAdaptor(data);
        adaptor.setBaseClassLoader(baseClassLoader);
        adaptor.initialize();
        this.adaptors.put(data.getBundleID(), adaptor);
        if (Debug.DEBUG_GENERAL) {
            Debug.println("< AspectJHook.initializedClassLoader() adaptor=" + adaptor);
        }
    }

    public byte[] processClass(String name, byte[] classbytes, ClasspathEntry classpathEntry, BundleEntry entry, ClasspathManager manager) {
        WeavingBundleEntry ajBundleEntry;
        byte[] newClassytes = null;
        if (entry instanceof WeavingBundleEntry && !(ajBundleEntry = (WeavingBundleEntry)entry).dontWeave()) {
            IWeavingAdaptor adaptor = ajBundleEntry.getAdaptor();
            newClassytes = adaptor.weaveClass(name, classbytes);
        }
        return newClassytes;
    }

    public void recordClassDefine(String name, Class clazz, byte[] classbytes, ClasspathEntry classpathEntry, BundleEntry entry, ClasspathManager manager) {
        WeavingBundleEntry ajBundleEntry;
        if (clazz == null) {
            if (Debug.DEBUG_GENERAL) {
                Debug.println("Error in defining class: " + name);
            }
            return;
        }
        if (entry instanceof WeavingBundleEntry && !(ajBundleEntry = (WeavingBundleEntry)entry).dontWeave()) {
            IWeavingAdaptor adaptor = ajBundleEntry.getAdaptor();
            URL sourceFileURL = ajBundleEntry.getBundleFileURL();
            adaptor.storeClass(name, sourceFileURL, clazz, classbytes);
        }
    }

    public void resetAdaptor(long bundleID) {
        this.adaptors.remove(bundleID);
    }

    public BundleFile wrapBundleFile(BundleFile bundleFile, Object content, BaseData data, boolean base) throws IOException {
        WeavingBundleFile wrapped = null;
        if (Debug.DEBUG_BUNDLE) {
            Debug.println("> AspectJBundleFileWrapperFactoryHook.wrapBundleFile() bundle=" + data.getSymbolicName() + " bundleFile=" + bundleFile + ", content=" + content + ", data=" + data + ", base=" + base + ", baseFile=" + bundleFile.getBaseFile());
        }
        wrapped = base ? new BaseWeavingBundleFile(new BundleAdaptorProvider(data, this), bundleFile) : new WeavingBundleFile(new BundleAdaptorProvider(data, this), bundleFile);
        if (Debug.DEBUG_BUNDLE) {
            Debug.println("< AspectJBundleFileWrapperFactoryHook.wrapBundleFile() wrapped=" + (Object)((Object)wrapped));
        }
        return wrapped;
    }

    private IWeavingAdaptor createAspectJAdaptor(BaseData baseData) {
        if (Debug.DEBUG_GENERAL) {
            Debug.println("> AspectJHook.createAspectJAdaptor() location=" + baseData.getLocation());
        }
        WeavingAdaptor adaptor = null;
        if (this.adaptorFactory != null) {
            adaptor = new WeavingAdaptor(baseData, this.adaptorFactory, null, null, null);
        } else if (Debug.DEBUG_GENERAL) {
            Debug.println("- AspectJHook.createAspectJAdaptor() factory=" + this.adaptorFactory);
        }
        if (Debug.DEBUG_GENERAL) {
            Debug.println("< AspectJHook.createAspectJAdaptor() adaptor=" + adaptor);
        }
        return adaptor;
    }

    private void initialize(BundleContext context) {
        if (Debug.DEBUG_GENERAL) {
            Debug.println("> AspectJHook.initialize() context=" + context);
        }
        this.bundleContext = context;
        ISupplementerRegistry supplementerRegistry = this.getSupplementerRegistry();
        this.adaptorFactory.initialize(context, supplementerRegistry);
        ServiceReference serviceReference = context.getServiceReference(PackageAdmin.class.getName());
        PackageAdmin packageAdmin = (PackageAdmin)context.getService(serviceReference);
        supplementerRegistry.setBundleContext(context);
        supplementerRegistry.setPackageAdmin(packageAdmin);
        context.addBundleListener((BundleListener)new SupplementBundleListener(supplementerRegistry));
        Bundle[] installedBundles = context.getBundles();
        int i = 0;
        while (i < installedBundles.length) {
            supplementerRegistry.addSupplementer(installedBundles[i], false);
            ++i;
        }
        i = 0;
        while (i < installedBundles.length) {
            supplementerRegistry.addSupplementedBundle(installedBundles[i]);
            ++i;
        }
        if (Debug.DEBUG_GENERAL) {
            Debug.println("< AspectJHook.initialize() adaptorFactory=" + this.adaptorFactory);
        }
    }
}

