/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.examples.logicdesigner.model.commands;

import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.examples.logicdesigner.LogicMessages;
import org.eclipse.gef.examples.logicdesigner.model.Circuit;
import org.eclipse.gef.examples.logicdesigner.model.LED;
import org.eclipse.gef.examples.logicdesigner.model.LogicDiagram;
import org.eclipse.gef.examples.logicdesigner.model.LogicSubpart;

public class CreateCommand
extends Command {
    private LogicSubpart child;
    private Rectangle rect;
    private LogicDiagram parent;
    private int index = -1;

    public CreateCommand() {
        super(LogicMessages.CreateCommand_Label);
    }

    public boolean canExecute() {
        return this.child != null && this.parent != null;
    }

    public void execute() {
        if (this.rect != null) {
            Insets expansion = this.getInsets();
            if (!this.rect.isEmpty()) {
                this.rect.expand(expansion);
            } else {
                this.rect.x -= expansion.left;
                this.rect.y -= expansion.top;
            }
            this.child.setLocation(this.rect.getLocation());
            if (!this.rect.isEmpty()) {
                this.child.setSize(this.rect.getSize());
            }
        }
        this.redo();
    }

    private Insets getInsets() {
        if (this.child instanceof LED || this.child instanceof Circuit) {
            return new Insets(2, 0, 2, 0);
        }
        return new Insets();
    }

    public void redo() {
        this.parent.addChild(this.child, this.index);
    }

    public void setChild(LogicSubpart subpart) {
        this.child = subpart;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    public void setLocation(Rectangle r) {
        this.rect = r;
    }

    public void setParent(LogicDiagram newParent) {
        this.parent = newParent;
    }

    public void undo() {
        this.parent.removeChild(this.child);
    }
}

