/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmt.modisco.infra.facet.validation;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.validation.AbstractModelConstraint;
import org.eclipse.emf.validation.EMFEventType;
import org.eclipse.emf.validation.IValidationContext;
import org.eclipse.gmt.modisco.infra.common.core.logging.MoDiscoLogger;
import org.eclipse.gmt.modisco.infra.facet.Facet;
import org.eclipse.gmt.modisco.infra.facet.FacetSet;
import org.eclipse.gmt.modisco.infra.facet.plugin.FacetPlugin;

public class ExtendedClassValidation
extends AbstractModelConstraint {
    public IStatus validate(IValidationContext ctx) {
        EObject eObject = ctx.getTarget();
        EMFEventType eType = ctx.getEventType();
        try {
            IStatus result = ctx.createSuccessStatus();
            if (eType == EMFEventType.NULL) {
                Facet facet = (Facet)eObject;
                EList superTypes = facet.getESuperTypes();
                for (EClass superType : superTypes) {
                    boolean found = superType.getEPackage().getNsURI().equals(EcorePackage.eINSTANCE.getNsURI());
                    EPackage ePackage = ((FacetSet)facet.getEPackage()).getExtendedPackage();
                    if (ePackage.getEClassifiers().contains((Object)superType)) {
                        found = true;
                    }
                    if (found) {
                        result = ctx.createSuccessStatus();
                        continue;
                    }
                    result = ctx.createFailureStatus(new Object[]{superType.getName(), facet.getName()});
                    break;
                }
            } else {
                result = ctx.createSuccessStatus();
            }
            return result;
        }
        catch (NullPointerException e) {
            String message = "Unexpected null value in " + eObject.eResource().getURI().toString();
            MoDiscoLogger.logWarning((Throwable)e, (String)message, (Plugin)FacetPlugin.getDefault());
            return ctx.createSuccessStatus();
        }
    }
}

