/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.graphiti.internal.datatypes.impl;

import org.eclipse.graphiti.datatypes.IAdvancedDimension;
import org.eclipse.graphiti.datatypes.IDimension;

public class DimensionImpl
implements IAdvancedDimension {
    private int width;
    private int height;

    public DimensionImpl(int width, int height) {
        this.setWidth(width);
        this.setHeight(height);
    }

    public DimensionImpl(IDimension dimension) {
        this(dimension.getWidth(), dimension.getHeight());
    }

    public int getHeight() {
        return this.height;
    }

    public int getWidth() {
        return this.width;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof DimensionImpl) {
            DimensionImpl d = (DimensionImpl)o;
            return d.width == this.width && d.height == this.height;
        }
        return false;
    }

    public int hashCode() {
        return this.width * this.height ^ this.width + this.height;
    }

    public String toString() {
        return "Dimension(" + this.width + ", " + this.height + ")";
    }

    public IDimension getDimensionCopy() {
        return new DimensionImpl(this);
    }

    public IDimension setDimension(int width, int height) {
        this.width = width;
        this.height = height;
        return this;
    }

    public IDimension setDimension(IDimension dimension) {
        return this.setDimension(dimension.getWidth(), dimension.getHeight());
    }

    public void scale(double amount) {
        this.width = (int)Math.floor((double)this.width * amount);
        this.height = (int)Math.floor((double)this.height * amount);
    }

    public IDimension expand(int dw, int dh) {
        this.width += dw;
        this.height += dh;
        return this;
    }
}

