/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.admin.ui.internal.servlets;

import java.io.IOException;
import java.io.PrintWriter;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.text.StrBuilder;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.IPreferencesService;
import org.eclipse.gyrex.admin.ui.internal.AdminUiActivator;
import org.osgi.service.prefs.Preferences;

public class PreferencesServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        IPreferencesService preferencesService = (IPreferencesService)AdminUiActivator.getInstance().getService(IPreferencesService.class);
        IEclipsePreferences node = preferencesService.getRootNode();
        Preferences preferencesNode = node.node(StringUtils.trimToEmpty((String)req.getPathInfo()));
        resp.setCharacterEncoding("UTF-8");
        resp.setContentType("text/plain");
        try {
            this.dumpTree(0, preferencesNode, resp.getWriter());
        }
        catch (Exception e) {
            throw new ServletException((Throwable)e);
        }
        resp.flushBuffer();
    }

    private void dumpTree(int indent, Preferences node, PrintWriter writer) throws Exception {
        String[] children;
        this.printNodeInfo(indent, node, writer);
        String[] stringArray = children = node.childrenNames();
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            String child = stringArray[n2];
            this.dumpTree(indent + 1, node.node(child), writer);
            ++n2;
        }
    }

    private void printNodeInfo(int indent, Preferences node, PrintWriter writer) throws Exception {
        StrBuilder spaces = new StrBuilder();
        int i = 0;
        while (i < indent) {
            spaces.append(" ");
            ++i;
        }
        writer.println(spaces.append(node.name()).append(" (").append(node.toString()).append(")").toString());
    }
}

