/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.common.console;

import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.apache.commons.lang.text.StrBuilder;
import org.eclipse.gyrex.common.console.Command;
import org.eclipse.gyrex.common.console.CommandUtil;

public abstract class SubCommand
extends Command {
    String parentCommandName;
    boolean printErrorDetails;
    final Map<String, Class<? extends Command>> commands = new TreeMap<String, Class<? extends Command>>();
    private final String name;

    public SubCommand(String name) {
        super("<cmd> [args]");
        this.name = name;
        if (StringUtils.isBlank((String)name)) {
            throw new IllegalArgumentException("command name must not be null");
        }
    }

    @Override
    protected final void doExecute() throws Exception {
        String command = this.ci.nextArgument();
        if (StringUtils.isBlank((String)command)) {
            this.ci.println((Object)"ERROR: Missing command name!");
            this.ci.println((Object)this.getHelp());
            return;
        }
        if (CommandUtil.isHelpOption(command)) {
            this.ci.println((Object)this.getHelp());
            return;
        }
        Class<? extends Command> cmdClass = this.commands.get(command);
        if (cmdClass == null) {
            this.ci.println((Object)"ERROR: Command not found!");
            this.ci.println((Object)this.getHelp());
            return;
        }
        CommandUtil.executeCommand(this.ci, cmdClass, command, this.parentCommandName != null ? String.format("%s %s", this.parentCommandName, this.getCommandName()) : this.getCommandName(), this.printErrorDetails);
    }

    protected final String getCommandName() {
        return this.name;
    }

    public String getHelp() {
        StrBuilder help = new StrBuilder(512);
        if (this.parentCommandName == null) {
            help.append("---").append(this.getClass().getSimpleName()).appendln("---");
            help.append("\t").append(this.getCommandName()).appendln(" <cmd> [args]");
        } else {
            help.append("\t").append(this.parentCommandName).append(' ').append(this.getCommandName()).appendln(" <cmd> [args]");
        }
        for (String name : this.commands.keySet()) {
            try {
                help.append("\t\t").append(name);
                Command command = this.commands.get(name).newInstance();
                String description = command.getDescription();
                if (!StringUtils.contains((String)description, (String)" - ")) {
                    help.append(" - ");
                } else if (!StringUtils.startsWith((String)description, (String)" ")) {
                    help.append(' ');
                }
                help.appendln(description);
            }
            catch (Exception e) {
                help.append("\t\t").append(name).append(" - ").appendln(ExceptionUtils.getRootCauseMessage((Throwable)e));
            }
        }
        return help.toString();
    }

    protected final void registerCommand(Class<? extends SubCommand> commandClass) {
        try {
            this.commands.put(commandClass.newInstance().getCommandName(), commandClass);
        }
        catch (Exception e) {
            throw new IllegalStateException(String.format("Unable to register command class '%s'. %s", commandClass.getSimpleName(), e.getMessage()), e);
        }
    }

    protected final void registerCommand(String name, Class<? extends Command> commandClass) {
        this.commands.put(name, commandClass);
    }

    protected final void unregisterCommand(String name) {
        this.commands.remove(name);
    }
}

