/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.context.tests.internal.injection;

import junit.framework.Assert;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.gyrex.context.internal.di.GyrexContextObjectSupplier;
import org.eclipse.gyrex.context.tests.internal.Activator;
import org.eclipse.gyrex.context.tests.internal.BaseContextTest;
import org.eclipse.gyrex.context.tests.internal.injection.ConstructorInjection;
import org.eclipse.gyrex.context.tests.internal.injection.ConstructorInjectionSingleton;
import org.eclipse.gyrex.context.tests.internal.injection.ConstructorInjectionWithOsgiService;
import org.eclipse.gyrex.context.tests.internal.injection.DynamicFieldInjection;
import org.eclipse.gyrex.context.tests.internal.injection.ISampleService;
import org.eclipse.gyrex.context.tests.internal.injection.SampleServiceImpl;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.osgi.framework.ServiceRegistration;

public class ContextInjectionTests
extends BaseContextTest {
    private static final String STRING_1 = "HELLO1_" + System.nanoTime();
    private static final String STRING_2 = "HELLO2_" + System.nanoTime();
    private ServiceRegistration<ISampleService> serviceRegistration;
    private SampleServiceImpl service;

    @Override
    protected IPath getPrimaryTestContextPath() {
        return Path.ROOT;
    }

    @Before
    public void registerService() {
        this.service = new SampleServiceImpl(STRING_1);
        this.serviceRegistration = Activator.getActivator().getServiceHelper().registerService(ISampleService.class, (Object)this.service, null, null, null, null);
    }

    @Test
    public void test001MakeStaticObjects() throws Exception {
        ConstructorInjection object = (ConstructorInjection)this.getContext().getInjector().make(ConstructorInjection.class);
        Assert.assertNotNull((String)"no object created", (Object)object);
        Assert.assertNotSame((String)"object is not a singleton", (Object)object, (Object)this.getContext().getInjector().make(ConstructorInjection.class));
        ConstructorInjectionWithOsgiService object2 = (ConstructorInjectionWithOsgiService)this.getContext().getInjector().make(ConstructorInjectionWithOsgiService.class);
        Assert.assertNotNull((String)"object with osgi service not created", (Object)object2);
        Assert.assertNotSame((String)"object is not a singleton", (Object)object2, (Object)this.getContext().getInjector().make(ConstructorInjectionWithOsgiService.class));
        Assert.assertSame((String)"wrong service response", (Object)STRING_1, (Object)object2.service.getString());
        ConstructorInjectionSingleton singleton = (ConstructorInjectionSingleton)this.getContext().getInjector().make(ConstructorInjectionSingleton.class);
        Assert.assertNotNull((String)"no singleton object created", (Object)singleton);
        Assert.assertSame((String)"singleton expected", (Object)singleton, (Object)this.getContext().getInjector().make(ConstructorInjectionSingleton.class));
        Assert.assertSame((String)"singleton expected", (Object)singleton, (Object)this.getContext().getInjector().make(ConstructorInjectionSingleton.class));
        Assert.assertSame((String)"wrong service response", (Object)STRING_1, (Object)singleton.service.getString());
    }

    @Test
    public void test002MakeDynamicObjects() throws Exception {
        DynamicFieldInjection object = (DynamicFieldInjection)this.getContext().getInjector().make(DynamicFieldInjection.class);
        Assert.assertNotNull((String)"no object created", (Object)object);
        object.assertInjected();
        Assert.assertSame((String)"wrong service response", (Object)STRING_1, (Object)object.service.getString());
        if (GyrexContextObjectSupplier.dynamicInjectionEnabled) {
            Assert.assertSame((String)"real service expected instead of proxy for dynamic injection", (Object)this.service, (Object)object.service);
        }
        ServiceRegistration sr2 = Activator.getActivator().getServiceHelper().registerService(ISampleService.class, (Object)new SampleServiceImpl(STRING_2), null, null, null, Integer.valueOf(Integer.MAX_VALUE));
        Thread.sleep(750L);
        Assert.assertTrue((String)"collection should have two services now", (object.services.size() == 2 ? 1 : 0) != 0);
        Assert.assertSame((String)"wrong service response; service should have changed", (Object)STRING_2, (Object)object.service.getString());
        sr2.unregister();
        Thread.sleep(750L);
        Assert.assertTrue((String)"collection should be down to one services now", (object.services.size() == 1 ? 1 : 0) != 0);
        Assert.assertSame((String)"wrong service response; service should have changed", (Object)STRING_1, (Object)object.service.getString());
        this.serviceRegistration.unregister();
    }

    @After
    public void unregisterService() {
        try {
            this.serviceRegistration.unregister();
        }
        catch (IllegalStateException illegalStateException) {}
        this.serviceRegistration = null;
        this.service = null;
    }
}

