/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.http.registry.internal;

import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.gyrex.common.runtime.BaseBundleActivator;
import org.eclipse.gyrex.context.registry.IRuntimeContextRegistry;
import org.eclipse.gyrex.http.application.provider.ApplicationProvider;
import org.eclipse.gyrex.http.registry.internal.ApplicationManagerServiceTracker;
import org.eclipse.gyrex.http.registry.internal.HttpRegistryDebug;
import org.eclipse.gyrex.http.registry.internal.RegistryApplicationProvider;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.packageadmin.PackageAdmin;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

public class HttpRegistryActivator
extends BaseBundleActivator
implements ServiceTrackerCustomizer {
    public static final String SYMBOLIC_NAME = "org.eclipse.gyrex.http.registry";
    private ServiceTracker packageAdminTracker;
    private ServiceTracker extensionRegistryTracker;
    private ServiceTracker contextRegistryTracker;
    private ServiceTracker applicationManagerServiceTracker;
    private volatile PackageAdmin packageAdmin;
    private volatile IExtensionRegistry extensionRegistry;
    private volatile IRuntimeContextRegistry contextRegistry;
    private volatile BundleContext context;

    public HttpRegistryActivator() {
        super(SYMBOLIC_NAME);
    }

    public Object addingService(ServiceReference reference) {
        Object service = this.context.getService(reference);
        if (service instanceof PackageAdmin && this.packageAdmin == null) {
            this.packageAdmin = (PackageAdmin)service;
        }
        if (service instanceof IExtensionRegistry && this.extensionRegistry == null) {
            this.extensionRegistry = (IExtensionRegistry)service;
        }
        if (service instanceof IRuntimeContextRegistry && this.contextRegistry == null) {
            this.contextRegistry = (IRuntimeContextRegistry)service;
        }
        if (this.packageAdmin != null && this.extensionRegistry != null && this.contextRegistry != null) {
            this.applicationManagerServiceTracker = new ApplicationManagerServiceTracker(this.context, this.packageAdmin, this.extensionRegistry, this.contextRegistry);
            this.applicationManagerServiceTracker.open();
        }
        return service;
    }

    protected void doStart(BundleContext context) throws Exception {
        this.context = context;
        this.getServiceHelper().registerService(ApplicationProvider.class.getName(), (Object)RegistryApplicationProvider.getInstance(), "Eclipse.org", "Registry Web Application Provider", null, null);
        this.packageAdminTracker = new ServiceTracker(context, PackageAdmin.class.getName(), (ServiceTrackerCustomizer)this);
        this.packageAdminTracker.open();
        this.extensionRegistryTracker = new ServiceTracker(context, IExtensionRegistry.class.getName(), (ServiceTrackerCustomizer)this);
        this.extensionRegistryTracker.open();
        this.contextRegistryTracker = new ServiceTracker(context, IRuntimeContextRegistry.class.getName(), (ServiceTrackerCustomizer)this);
        this.contextRegistryTracker.open();
    }

    protected void doStop(BundleContext context) throws Exception {
        this.packageAdminTracker.close();
        this.packageAdminTracker = null;
        this.extensionRegistryTracker.close();
        this.extensionRegistryTracker = null;
        this.context = null;
    }

    protected Class getDebugOptions() {
        return HttpRegistryDebug.class;
    }

    public void modifiedService(ServiceReference reference, Object service) {
    }

    public void removedService(ServiceReference reference, Object service) {
        if (service == this.packageAdmin) {
            this.packageAdmin = null;
        }
        if (service == this.extensionRegistry) {
            this.extensionRegistry = null;
        }
        if (service == this.contextRegistry) {
            this.contextRegistry = null;
        }
        if ((this.packageAdmin == null || this.extensionRegistry == null || this.contextRegistry == null) && this.applicationManagerServiceTracker != null) {
            this.applicationManagerServiceTracker.close();
            this.applicationManagerServiceTracker = null;
        }
        this.context.ungetService(reference);
    }
}

